/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.WritePropertyConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.test.TestWriteConfig;

public final class TestWriteConfigImpl
implements TestWriteConfig {
    private int maxIterations;
    private boolean throwInCompute;
    private List<String> relationshipTypes;
    private List<String> nodeLabels;
    @Nullable
    private String usernameOverride;
    private boolean sudo;
    private int concurrency;
    private int writeConcurrency;
    private String writeProperty;

    public TestWriteConfigImpl(@NotNull CypherMapWrapper config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.maxIterations = config.getInt("maxIterations", TestWriteConfig.super.maxIterations());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.throwInCompute = config.getBool("throwInCompute", TestWriteConfig.super.throwInCompute());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipTypes = (List)CypherMapWrapper.failOnNull((String)"relationshipTypes", (Object)((List)config.getChecked("relationshipTypes", (Object)TestWriteConfig.super.relationshipTypes(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.nodeLabels = (List)CypherMapWrapper.failOnNull((String)"nodeLabels", (Object)((List)config.getChecked("nodeLabels", (Object)TestWriteConfig.super.nodeLabels(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.usernameOverride = StringUtils.trimToNull((String)config.getString("username", TestWriteConfig.super.usernameOverride()));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sudo = config.getBool("sudo", TestWriteConfig.super.sudo());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.concurrency = config.getInt("concurrency", TestWriteConfig.super.concurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.writeConcurrency = config.getInt("writeConcurrency", TestWriteConfig.super.writeConcurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.writeProperty = (String)CypherMapWrapper.failOnNull((String)"writeProperty", (Object)WritePropertyConfig.validatePropertyName((String)config.requireString("writeProperty")));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validateConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.validateWriteConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public int maxIterations() {
        return this.maxIterations;
    }

    @Override
    public boolean throwInCompute() {
        return this.throwInCompute;
    }

    public List<String> relationshipTypes() {
        return this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        return this.nodeLabels;
    }

    public void graphStoreValidation(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
    }

    @Nullable
    public String usernameOverride() {
        return this.usernameOverride;
    }

    public boolean sudo() {
        return this.sudo;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("maxIterations", "throwInCompute", "relationshipTypes", "nodeLabels", "username", "sudo", "concurrency", "writeConcurrency", "writeProperty");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("maxIterations", this.maxIterations());
        map.put("throwInCompute", this.throwInCompute());
        map.put("relationshipTypes", this.relationshipTypes());
        map.put("nodeLabels", this.nodeLabels());
        map.put("username", this.usernameOverride());
        map.put("sudo", this.sudo());
        map.put("concurrency", this.concurrency());
        map.put("writeConcurrency", this.writeConcurrency());
        map.put("writeProperty", this.writeProperty());
        return map;
    }

    public int concurrency() {
        return this.concurrency;
    }

    public int writeConcurrency() {
        return this.writeConcurrency;
    }

    public String writeProperty() {
        return this.writeProperty;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();

        public Builder maxIterations(int maxIterations) {
            this.config.put("maxIterations", maxIterations);
            return this;
        }

        public Builder throwInCompute(boolean throwInCompute) {
            this.config.put("throwInCompute", throwInCompute);
            return this;
        }

        public Builder relationshipTypes(List<String> relationshipTypes) {
            this.config.put("relationshipTypes", relationshipTypes);
            return this;
        }

        public Builder nodeLabels(List<String> nodeLabels) {
            this.config.put("nodeLabels", nodeLabels);
            return this;
        }

        public Builder usernameOverride(String usernameOverride) {
            this.config.put("username", usernameOverride);
            return this;
        }

        public Builder sudo(boolean sudo) {
            this.config.put("sudo", sudo);
            return this;
        }

        public Builder concurrency(int concurrency) {
            this.config.put("concurrency", concurrency);
            return this;
        }

        public Builder writeConcurrency(int writeConcurrency) {
            this.config.put("writeConcurrency", writeConcurrency);
            return this;
        }

        public Builder writeProperty(String writeProperty) {
            this.config.put("writeProperty", writeProperty);
            return this;
        }

        public TestWriteConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new TestWriteConfigImpl(config);
        }
    }
}

