/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.closeness;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.RelationshipIterator;
import org.neo4j.gds.beta.closeness.CentralityComputer;
import org.neo4j.gds.beta.closeness.ClosenessCentralityConfig;
import org.neo4j.gds.beta.closeness.ClosenessCentralityResult;
import org.neo4j.gds.beta.closeness.DefaultCentralityComputer;
import org.neo4j.gds.beta.closeness.ImmutableClosenessCentralityResult;
import org.neo4j.gds.beta.closeness.WassermanFaustCentralityComputer;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.paged.PagedAtomicIntegerArray;
import org.neo4j.gds.core.utils.partition.PartitionUtils;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.msbfs.BfsConsumer;
import org.neo4j.gds.msbfs.MultiSourceBFS;

public final class ClosenessCentrality
extends Algorithm<ClosenessCentralityResult> {
    private final Graph graph;
    private final long nodeCount;
    private final int concurrency;
    private final ExecutorService executorService;
    private final PagedAtomicIntegerArray farness;
    private final PagedAtomicIntegerArray component;
    private final CentralityComputer centralityComputer;

    public static ClosenessCentrality of(Graph graph, ClosenessCentralityConfig config, ExecutorService executorService, ProgressTracker progressTracker) {
        long nodeCount = graph.nodeCount();
        CentralityComputer centralityComputer = config.useWassermanFaust() ? new WassermanFaustCentralityComputer(nodeCount) : new DefaultCentralityComputer();
        return new ClosenessCentrality(graph, nodeCount, config.concurrency(), centralityComputer, PagedAtomicIntegerArray.newArray((long)nodeCount), PagedAtomicIntegerArray.newArray((long)nodeCount), executorService, progressTracker);
    }

    private ClosenessCentrality(Graph graph, long nodeCount, int concurrency, CentralityComputer centralityComputer, PagedAtomicIntegerArray farness, PagedAtomicIntegerArray component, ExecutorService executorService, ProgressTracker progressTracker) {
        super(progressTracker);
        this.graph = graph;
        this.nodeCount = nodeCount;
        this.concurrency = concurrency;
        this.executorService = executorService;
        this.centralityComputer = centralityComputer;
        this.farness = farness;
        this.component = component;
    }

    public ClosenessCentralityResult compute() {
        this.progressTracker.beginSubTask();
        this.computeFarness();
        HugeDoubleArray centralities = this.computeCloseness();
        this.progressTracker.endSubTask();
        return ImmutableClosenessCentralityResult.of(centralities);
    }

    public void release() {
    }

    private void computeFarness() {
        this.progressTracker.beginSubTask();
        BfsConsumer consumer = (nodeId, depth, sourceNodeIds) -> {
            int len = sourceNodeIds.size();
            this.farness.add(nodeId, len * depth);
            this.component.add(nodeId, len);
            this.progressTracker.logProgress();
        };
        MultiSourceBFS.aggregatedNeighborProcessing(this.nodeCount, (RelationshipIterator)this.graph, consumer, new long[0]).run(this.concurrency, this.executorService);
        this.progressTracker.endSubTask();
    }

    private HugeDoubleArray computeCloseness() {
        this.progressTracker.beginSubTask();
        HugeDoubleArray closeness = HugeDoubleArray.newArray((long)this.nodeCount);
        List tasks = PartitionUtils.rangePartition((int)this.concurrency, (long)this.nodeCount, partition -> () -> {
            partition.consume(nodeId -> closeness.set(nodeId, this.centralityComputer.centrality(this.farness.get(nodeId), this.component.get(nodeId))));
            this.progressTracker.logProgress(partition.nodeCount());
        }, Optional.empty());
        ParallelUtil.run((Collection)tasks, (ExecutorService)this.executorService);
        this.progressTracker.endSubTask();
        return closeness;
    }
}

