/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.k1coloring;

import com.carrotsearch.hppc.BitSet;
import org.neo4j.gds.api.RelationshipIterator;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.partition.Partition;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;

final class ValidationStep
implements Runnable {
    private final RelationshipIterator graph;
    private final HugeLongArray colors;
    private final BitSet currentNodesToColor;
    private final BitSet nextNodesToColor;
    private final Partition partition;
    private final ProgressTracker progressTracker;

    ValidationStep(RelationshipIterator graph, HugeLongArray colors, BitSet currentNodesToColor, BitSet nextNodesToColor, Partition partition, ProgressTracker progressTracker) {
        this.graph = graph;
        this.colors = colors;
        this.currentNodesToColor = currentNodesToColor;
        this.nextNodesToColor = nextNodesToColor;
        this.partition = partition;
        this.progressTracker = progressTracker;
    }

    @Override
    public void run() {
        this.partition.consume(nodeId -> {
            if (this.currentNodesToColor.get(nodeId)) {
                this.graph.forEachRelationship(nodeId, (source, target) -> {
                    if (source != target && this.colors.get(source) == this.colors.get(target) && !this.nextNodesToColor.get(target)) {
                        this.nextNodesToColor.set(source);
                        return false;
                    }
                    return true;
                });
                this.progressTracker.logProgress();
            }
        });
    }
}

