/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.beta.modularity;

import com.carrotsearch.hppc.LongDoubleHashMap;
import com.carrotsearch.hppc.LongDoubleMap;
import com.carrotsearch.hppc.cursors.LongDoubleCursor;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.utils.paged.HugeAtomicDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.partition.Partition;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;

final class ModularityOptimizationTask
implements Runnable {
    private final Graph localGraph;
    private final Partition partition;
    private final long color;
    private final double totalNodeWeight;
    private final HugeLongArray colors;
    private final ProgressTracker progressTracker;
    private final HugeLongArray currentCommunities;
    private final HugeLongArray nextCommunities;
    private final HugeDoubleArray cumulativeNodeWeights;
    private final HugeDoubleArray nodeCommunityInfluences;
    private final HugeAtomicDoubleArray communityWeights;
    private final HugeAtomicDoubleArray communityWeightUpdates;

    ModularityOptimizationTask(Graph graph, Partition partition, long color, double totalNodeWeight, HugeLongArray colors, HugeLongArray currentCommunities, HugeLongArray nextCommunities, HugeDoubleArray cumulativeNodeWeights, HugeDoubleArray nodeCommunityInfluences, HugeAtomicDoubleArray communityWeights, HugeAtomicDoubleArray communityWeightUpdates, ProgressTracker progressTracker) {
        this.partition = partition;
        this.color = color;
        this.localGraph = graph.concurrentCopy();
        this.currentCommunities = currentCommunities;
        this.nextCommunities = nextCommunities;
        this.communityWeights = communityWeights;
        this.communityWeightUpdates = communityWeightUpdates;
        this.totalNodeWeight = totalNodeWeight;
        this.cumulativeNodeWeights = cumulativeNodeWeights;
        this.nodeCommunityInfluences = nodeCommunityInfluences;
        this.colors = colors;
        this.progressTracker = progressTracker;
    }

    @Override
    public void run() {
        LongDoubleHashMap reuseCommunityInfluences = new LongDoubleHashMap(50);
        this.partition.consume(arg_0 -> this.lambda$run$3((LongDoubleMap)reuseCommunityInfluences, arg_0));
    }

    private /* synthetic */ void lambda$run$3(LongDoubleMap reuseCommunityInfluences, long nodeId) {
        LongDoubleMap communityInfluences;
        if (this.colors.get(nodeId) != this.color) {
            return;
        }
        long currentCommunity = this.currentCommunities.get(nodeId);
        int degree = this.localGraph.degree(nodeId);
        if (degree < 50) {
            reuseCommunityInfluences.clear();
            communityInfluences = reuseCommunityInfluences;
        } else {
            communityInfluences = new LongDoubleHashMap(degree);
        }
        MutableDouble selfWeight = new MutableDouble(0.0);
        this.localGraph.forEachRelationship(nodeId, 1.0, (s, t, w) -> {
            if (s == t) {
                selfWeight.add(w);
            }
            long targetCommunity = this.currentCommunities.get(t);
            communityInfluences.addTo(targetCommunity, w);
            return true;
        });
        long nextCommunity = currentCommunity;
        double maxGain = 0.0;
        double eix = communityInfluences.get(currentCommunity) - selfWeight.doubleValue();
        double cumulativeNodeWeight = this.cumulativeNodeWeights.get(nodeId);
        double ax = this.communityWeights.get(currentCommunity) - cumulativeNodeWeight;
        for (LongDoubleCursor cursor : communityInfluences) {
            double ay;
            double eiy;
            double currentGain;
            long communityCandidate = cursor.key;
            if (currentCommunity == communityCandidate || !((currentGain = ((eiy = cursor.value) - eix) / this.totalNodeWeight + (2.0 * cumulativeNodeWeight * ax - 2.0 * cumulativeNodeWeight * (ay = this.communityWeights.get(communityCandidate))) / Math.pow(2.0 * this.totalNodeWeight, 2.0)) > maxGain) && (currentGain != maxGain || currentGain == 0.0 || nextCommunity <= communityCandidate)) continue;
            maxGain = currentGain;
            nextCommunity = communityCandidate;
        }
        this.nodeCommunityInfluences.set(nodeId, communityInfluences.get(nextCommunity));
        this.nextCommunities.set(nodeId, nextCommunity);
        this.communityWeightUpdates.update(currentCommunity, agg -> agg - cumulativeNodeWeight);
        this.communityWeightUpdates.update(nextCommunity, agg -> agg + cumulativeNodeWeight);
        this.progressTracker.logProgress((long)degree);
    }
}

