/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.betweenness;

import com.carrotsearch.hppc.LongArrayList;
import com.carrotsearch.hppc.cursors.LongCursor;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.RelationshipConsumer;
import org.neo4j.gds.api.RelationshipIterator;
import org.neo4j.gds.betweenness.SelectionStrategy;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.utils.paged.HugeAtomicDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeCursor;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeIntArray;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.paged.HugeLongArrayQueue;
import org.neo4j.gds.core.utils.paged.HugeLongArrayStack;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;

public class BetweennessCentrality
extends Algorithm<HugeAtomicDoubleArray> {
    private final Graph graph;
    private final AtomicLong nodeQueue = new AtomicLong();
    private final long nodeCount;
    private final double divisor;
    private HugeAtomicDoubleArray centrality;
    private SelectionStrategy selectionStrategy;
    private final ExecutorService executorService;
    private final int concurrency;

    public BetweennessCentrality(Graph graph, SelectionStrategy selectionStrategy, ExecutorService executorService, int concurrency, ProgressTracker progressTracker) {
        super(progressTracker);
        this.graph = graph;
        this.executorService = executorService;
        this.concurrency = concurrency;
        this.nodeCount = graph.nodeCount();
        this.centrality = HugeAtomicDoubleArray.newArray((long)this.nodeCount);
        this.selectionStrategy = selectionStrategy;
        this.selectionStrategy.init(graph, executorService, concurrency);
        this.divisor = graph.isUndirected() ? 2.0 : 1.0;
    }

    public HugeAtomicDoubleArray compute() {
        this.progressTracker.beginSubTask();
        this.nodeQueue.set(0L);
        ParallelUtil.run((Collection)ParallelUtil.tasks((int)this.concurrency, () -> new BCTask()), (ExecutorService)this.executorService);
        this.progressTracker.endSubTask();
        return this.centrality;
    }

    public void release() {
        this.centrality = null;
        this.selectionStrategy = null;
    }

    final class BCTask
    implements Runnable {
        private final RelationshipIterator localRelationshipIterator;
        private final HugeObjectArray<LongArrayList> predecessors;
        private final HugeCursor<LongArrayList[]> predecessorsCursor;
        private final HugeLongArrayQueue forwardNodes;
        private final HugeLongArrayStack backwardNodes;
        private final HugeDoubleArray delta;
        private final HugeLongArray sigma;
        private final HugeIntArray distance;

        private BCTask() {
            this.localRelationshipIterator = BetweennessCentrality.this.graph.concurrentCopy();
            this.predecessors = HugeObjectArray.newArray(LongArrayList.class, (long)BetweennessCentrality.this.nodeCount);
            this.predecessorsCursor = this.predecessors.newCursor();
            this.backwardNodes = HugeLongArrayStack.newStack((long)BetweennessCentrality.this.nodeCount);
            this.forwardNodes = HugeLongArrayQueue.newQueue((long)BetweennessCentrality.this.nodeCount);
            this.sigma = HugeLongArray.newArray((long)BetweennessCentrality.this.nodeCount);
            this.delta = HugeDoubleArray.newArray((long)BetweennessCentrality.this.nodeCount);
            this.distance = HugeIntArray.newArray((long)BetweennessCentrality.this.nodeCount);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block0: while (true) {
                if ((startNodeId = BetweennessCentrality.this.nodeQueue.getAndIncrement()) >= BetweennessCentrality.this.nodeCount || !BetweennessCentrality.this.running()) {
                    return;
                }
                if (!BetweennessCentrality.this.selectionStrategy.select(startNodeId)) continue;
                BetweennessCentrality.this.getProgressTracker().logProgress();
                this.clear();
                this.sigma.addTo(startNodeId, 1L);
                this.distance.set(startNodeId, 0);
                this.forwardNodes.add(startNodeId);
                while (!this.forwardNodes.isEmpty()) {
                    node = this.forwardNodes.remove();
                    this.backwardNodes.push(node);
                    distanceNode = this.distance.get(node);
                    this.localRelationshipIterator.forEachRelationship(node, (RelationshipConsumer)LambdaMetafactory.metafactory(null, null, null, (JJ)Z, lambda$run$0(int long long ), (JJ)Z)((BCTask)this, (int)distanceNode));
                }
                while (true) {
                    if (!this.backwardNodes.isEmpty()) ** break;
                    continue block0;
                    node = this.backwardNodes.pop();
                    predecessors = (LongArrayList)this.predecessors.get(node);
                    dependencyNode = this.delta.get(node);
                    sigmaNode = this.sigma.get(node);
                    if (null != predecessors) {
                        predecessors.forEach((Consumer<LongCursor>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$run$1(double double com.carrotsearch.hppc.cursors.LongCursor ), (Lcom/carrotsearch/hppc/cursors/LongCursor;)V)((BCTask)this, (double)sigmaNode, (double)dependencyNode));
                    }
                    if (node == startNodeId) continue;
                    while (!BetweennessCentrality.this.centrality.compareAndSet(node, current = BetweennessCentrality.this.centrality.get(node), current + dependencyNode / BetweennessCentrality.this.divisor)) {
                    }
                }
                break;
            }
        }

        private void append(long target, long node) {
            LongArrayList targetPredecessors = (LongArrayList)this.predecessors.get(target);
            if (null == targetPredecessors) {
                targetPredecessors = new LongArrayList();
                this.predecessors.set(target, (Object)targetPredecessors);
            }
            targetPredecessors.add(node);
        }

        private void clear() {
            this.distance.fill(-1);
            this.sigma.fill(0L);
            this.delta.fill(0.0);
            this.predecessors.initCursor(this.predecessorsCursor);
            while (this.predecessorsCursor.next()) {
                for (int i = this.predecessorsCursor.offset; i < this.predecessorsCursor.limit; ++i) {
                    if (((LongArrayList[])this.predecessorsCursor.array)[i] == null) continue;
                    ((LongArrayList[])this.predecessorsCursor.array)[i].elementsCount = 0;
                }
            }
        }

        private /* synthetic */ void lambda$run$1(double sigmaNode, double dependencyNode, LongCursor predecessor) {
            double sigmaPredecessor = this.sigma.get(predecessor.value);
            double dependency = sigmaPredecessor / sigmaNode * (dependencyNode + 1.0);
            this.delta.addTo(predecessor.value, dependency);
        }

        private /* synthetic */ boolean lambda$run$0(int distanceNode, long source, long target) {
            if (this.distance.get(target) < 0) {
                this.forwardNodes.add(target);
                this.distance.set(target, distanceNode + 1);
            }
            if (this.distance.get(target) == distanceNode + 1) {
                this.sigma.addTo(target, this.sigma.get(source));
                this.append(target, source);
            }
            return true;
        }
    }
}

