/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.betweenness;

import java.util.Optional;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.betweenness.BetweennessCentrality;
import org.neo4j.gds.betweenness.BetweennessCentralityBaseConfig;
import org.neo4j.gds.betweenness.SelectionStrategy;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.paged.HugeAtomicDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeIntArray;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;
import org.neo4j.gds.mem.MemoryUsage;

public class BetweennessCentralityFactory<CONFIG extends BetweennessCentralityBaseConfig>
extends GraphAlgorithmFactory<BetweennessCentrality, CONFIG> {
    public String taskName() {
        return "BetweennessCentrality";
    }

    public BetweennessCentrality build(Graph graph, CONFIG configuration, ProgressTracker progressTracker) {
        Optional<Long> samplingSize = configuration.samplingSize();
        Optional<Long> samplingSeed = configuration.samplingSeed();
        SelectionStrategy strategy = samplingSize.isPresent() && samplingSize.get() < graph.nodeCount() ? new SelectionStrategy.RandomDegree(samplingSize.get(), samplingSeed) : SelectionStrategy.ALL;
        return new BetweennessCentrality(graph, strategy, Pools.DEFAULT, configuration.concurrency(), progressTracker);
    }

    public MemoryEstimation memoryEstimation(CONFIG configuration) {
        return MemoryEstimations.builder(BetweennessCentrality.class).perNode("centrality scores", HugeAtomicDoubleArray::memoryEstimation).perThread("compute task", MemoryEstimations.builder(BetweennessCentrality.BCTask.class).add("predecessors", MemoryEstimations.setup((String)"", (dimensions, concurrency) -> {
            long averagePredecessorSize = MemoryUsage.sizeOfLongArray((long)dimensions.averageDegree());
            return MemoryEstimations.builder(HugeObjectArray.class).perNode("array", nodeCount -> nodeCount * averagePredecessorSize).build();
        })).perNode("forwardNodes", HugeLongArray::memoryEstimation).perNode("backwardNodes", HugeLongArray::memoryEstimation).perNode("deltas", HugeDoubleArray::memoryEstimation).perNode("sigmas", HugeLongArray::memoryEstimation).perNode("distances", HugeIntArray::memoryEstimation).build()).build();
    }

    public Task progressTask(Graph graph, CONFIG config) {
        return Tasks.leaf((String)this.taskName(), (long)graph.nodeCount());
    }
}

