/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.betweenness;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.betweenness.BetweennessCentralityWriteConfig;
import org.neo4j.gds.config.WritePropertyConfig;
import org.neo4j.gds.core.CypherMapWrapper;

public final class BetweennessCentralityWriteConfigImpl
implements BetweennessCentralityWriteConfig {
    private Optional<Long> samplingSize;
    private Optional<Long> samplingSeed;
    private List<String> relationshipTypes;
    private List<String> nodeLabels;
    @Nullable
    private String usernameOverride;
    private boolean sudo;
    private int concurrency;
    private String writeProperty;
    private int writeConcurrency;

    public BetweennessCentralityWriteConfigImpl(@NotNull CypherMapWrapper config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.samplingSize = (Optional)CypherMapWrapper.failOnNull((String)"samplingSize", (Object)config.getOptional("samplingSize", Long.class));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.samplingSeed = (Optional)CypherMapWrapper.failOnNull((String)"samplingSeed", (Object)config.getOptional("samplingSeed", Long.class));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipTypes = (List)CypherMapWrapper.failOnNull((String)"relationshipTypes", (Object)((List)config.getChecked("relationshipTypes", (Object)BetweennessCentralityWriteConfig.super.relationshipTypes(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.nodeLabels = (List)CypherMapWrapper.failOnNull((String)"nodeLabels", (Object)((List)config.getChecked("nodeLabels", (Object)BetweennessCentralityWriteConfig.super.nodeLabels(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.usernameOverride = StringUtils.trimToNull((String)config.getString("username", BetweennessCentralityWriteConfig.super.usernameOverride()));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sudo = config.getBool("sudo", BetweennessCentralityWriteConfig.super.sudo());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.concurrency = config.getInt("concurrency", BetweennessCentralityWriteConfig.super.concurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.writeProperty = (String)CypherMapWrapper.failOnNull((String)"writeProperty", (Object)WritePropertyConfig.validatePropertyName((String)config.requireString("writeProperty")));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.writeConcurrency = config.getInt("writeConcurrency", BetweennessCentralityWriteConfig.super.writeConcurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validate();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.validateConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.validateWriteConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public Optional<Long> samplingSize() {
        return this.samplingSize;
    }

    @Override
    public Optional<Long> samplingSeed() {
        return this.samplingSeed;
    }

    public List<String> relationshipTypes() {
        return this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        return this.nodeLabels;
    }

    public void graphStoreValidation(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
    }

    @Nullable
    public String usernameOverride() {
        return this.usernameOverride;
    }

    public boolean sudo() {
        return this.sudo;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("samplingSize", "samplingSeed", "relationshipTypes", "nodeLabels", "username", "sudo", "concurrency", "writeProperty", "writeConcurrency");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        this.samplingSize().ifPresent(samplingSize -> map.put("samplingSize", samplingSize));
        this.samplingSeed().ifPresent(samplingSeed -> map.put("samplingSeed", samplingSeed));
        map.put("relationshipTypes", this.relationshipTypes());
        map.put("nodeLabels", this.nodeLabels());
        map.put("username", this.usernameOverride());
        map.put("sudo", this.sudo());
        map.put("concurrency", this.concurrency());
        map.put("writeProperty", this.writeProperty());
        map.put("writeConcurrency", this.writeConcurrency());
        return map;
    }

    public int concurrency() {
        return this.concurrency;
    }

    public String writeProperty() {
        return this.writeProperty;
    }

    public int writeConcurrency() {
        return this.writeConcurrency;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();

        public Builder samplingSize(Long samplingSize) {
            this.config.put("samplingSize", samplingSize);
            return this;
        }

        public Builder samplingSize(Optional<Long> samplingSize) {
            samplingSize.ifPresent(actualsamplingSize -> this.config.put("samplingSize", actualsamplingSize));
            return this;
        }

        public Builder samplingSeed(Long samplingSeed) {
            this.config.put("samplingSeed", samplingSeed);
            return this;
        }

        public Builder samplingSeed(Optional<Long> samplingSeed) {
            samplingSeed.ifPresent(actualsamplingSeed -> this.config.put("samplingSeed", actualsamplingSeed));
            return this;
        }

        public Builder relationshipTypes(List<String> relationshipTypes) {
            this.config.put("relationshipTypes", relationshipTypes);
            return this;
        }

        public Builder nodeLabels(List<String> nodeLabels) {
            this.config.put("nodeLabels", nodeLabels);
            return this;
        }

        public Builder usernameOverride(String usernameOverride) {
            this.config.put("username", usernameOverride);
            return this;
        }

        public Builder sudo(boolean sudo) {
            this.config.put("sudo", sudo);
            return this;
        }

        public Builder concurrency(int concurrency) {
            this.config.put("concurrency", concurrency);
            return this;
        }

        public Builder writeProperty(String writeProperty) {
            this.config.put("writeProperty", writeProperty);
            return this;
        }

        public Builder writeConcurrency(int writeConcurrency) {
            this.config.put("writeConcurrency", writeConcurrency);
            return this;
        }

        public BetweennessCentralityWriteConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new BetweennessCentralityWriteConfigImpl(config);
        }
    }
}

