/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.betweenness;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.betweenness.BetweennessCentralityBaseConfig;
import org.neo4j.gds.betweenness.BetweennessCentralityStatsConfig;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ConcurrencyConfig;

@Generated(from="BetweennessCentralityStatsConfig", generator="Immutables")
public final class ImmutableBetweennessCentralityStatsConfig
implements BetweennessCentralityStatsConfig {
    @Nullable
    private final String usernameOverride;
    private final boolean sudo;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    private final int concurrency;
    private final int minBatchSize;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    private final Long samplingSize;
    private final Long samplingSeed;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBetweennessCentralityStatsConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, Optional<Long> samplingSize, Optional<Long> samplingSeed) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableBetweennessCentralityStatsConfig.createUnmodifiableList(false, ImmutableBetweennessCentralityStatsConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableBetweennessCentralityStatsConfig.createUnmodifiableList(false, ImmutableBetweennessCentralityStatsConfig.createSafeList(nodeLabels, true, false)));
        this.samplingSize = samplingSize.orElse(null);
        this.samplingSeed = samplingSeed.orElse(null);
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.initShim = null;
    }

    private ImmutableBetweennessCentralityStatsConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, Long samplingSize, Long samplingSeed) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableBetweennessCentralityStatsConfig.createUnmodifiableList(false, ImmutableBetweennessCentralityStatsConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableBetweennessCentralityStatsConfig.createUnmodifiableList(false, ImmutableBetweennessCentralityStatsConfig.createSafeList(nodeLabels, true, false)));
        this.samplingSize = samplingSize;
        this.samplingSeed = samplingSeed;
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.initShim = null;
    }

    private ImmutableBetweennessCentralityStatsConfig(Builder builder) {
        this.samplingSize = builder.samplingSize;
        this.samplingSeed = builder.samplingSeed;
        if (builder.usernameOverrideIsSet()) {
            this.initShim.usernameOverride(builder.usernameOverride);
        }
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.minBatchSizeIsSet()) {
            this.initShim.minBatchSize(builder.minBatchSize);
        }
        if (builder.relationshipTypesIsSet()) {
            this.initShim.relationshipTypes(builder.relationshipTypes == null ? Collections.emptyList() : ImmutableBetweennessCentralityStatsConfig.createUnmodifiableList(true, builder.relationshipTypes));
        }
        if (builder.nodeLabelsIsSet()) {
            this.initShim.nodeLabels(builder.nodeLabels == null ? Collections.emptyList() : ImmutableBetweennessCentralityStatsConfig.createUnmodifiableList(true, builder.nodeLabels));
        }
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.initShim = null;
    }

    private ImmutableBetweennessCentralityStatsConfig(@Nullable String usernameOverride, boolean sudo, Collection<String> configKeys, int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, Long samplingSize, Long samplingSeed) {
        this.initShim.usernameOverride(usernameOverride);
        this.initShim.sudo(sudo);
        this.initShim.configKeys(configKeys);
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(relationshipTypes);
        this.initShim.nodeLabels(nodeLabels);
        this.samplingSize = samplingSize;
        this.samplingSeed = samplingSeed;
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.initShim = null;
    }

    @Nullable
    private String usernameOverrideInitialize() {
        return BetweennessCentralityStatsConfig.super.usernameOverride();
    }

    private boolean sudoInitialize() {
        return BetweennessCentralityStatsConfig.super.sudo();
    }

    private Collection<String> configKeysInitialize() {
        return BetweennessCentralityStatsConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return BetweennessCentralityStatsConfig.super.toMap();
    }

    private int concurrencyInitialize() {
        return BetweennessCentralityStatsConfig.super.concurrency();
    }

    private int minBatchSizeInitialize() {
        return BetweennessCentralityStatsConfig.super.minBatchSize();
    }

    private List<String> relationshipTypesInitialize() {
        return BetweennessCentralityStatsConfig.super.relationshipTypes();
    }

    private List<String> nodeLabelsInitialize() {
        return BetweennessCentralityStatsConfig.super.nodeLabels();
    }

    @Nullable
    public String usernameOverride() {
        InitShim shim = this.initShim;
        return shim != null ? shim.usernameOverride() : this.usernameOverride;
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    public int minBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minBatchSize() : this.minBatchSize;
    }

    public List<String> relationshipTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipTypes() : this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeLabels() : this.nodeLabels;
    }

    @Override
    public Optional<Long> samplingSize() {
        return Optional.ofNullable(this.samplingSize);
    }

    @Override
    public Optional<Long> samplingSeed() {
        return Optional.ofNullable(this.samplingSeed);
    }

    public final ImmutableBetweennessCentralityStatsConfig withUsernameOverride(@Nullable String value) {
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return ImmutableBetweennessCentralityStatsConfig.validate(new ImmutableBetweennessCentralityStatsConfig(value, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.samplingSize, this.samplingSeed));
    }

    public final ImmutableBetweennessCentralityStatsConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutableBetweennessCentralityStatsConfig.validate(new ImmutableBetweennessCentralityStatsConfig(this.usernameOverride, value, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.samplingSize, this.samplingSeed));
    }

    public final ImmutableBetweennessCentralityStatsConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutableBetweennessCentralityStatsConfig.validate(new ImmutableBetweennessCentralityStatsConfig(this.usernameOverride, this.sudo, newValue, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.samplingSize, this.samplingSeed));
    }

    public final ImmutableBetweennessCentralityStatsConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutableBetweennessCentralityStatsConfig.validate(new ImmutableBetweennessCentralityStatsConfig(this.usernameOverride, this.sudo, this.configKeys, value, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.samplingSize, this.samplingSeed));
    }

    public final ImmutableBetweennessCentralityStatsConfig withMinBatchSize(int value) {
        if (this.minBatchSize == value) {
            return this;
        }
        return ImmutableBetweennessCentralityStatsConfig.validate(new ImmutableBetweennessCentralityStatsConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, value, this.relationshipTypes, this.nodeLabels, this.samplingSize, this.samplingSeed));
    }

    public final ImmutableBetweennessCentralityStatsConfig withRelationshipTypes(String ... elements) {
        List<String> newValue = ImmutableBetweennessCentralityStatsConfig.createUnmodifiableList(false, ImmutableBetweennessCentralityStatsConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableBetweennessCentralityStatsConfig.validate(new ImmutableBetweennessCentralityStatsConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.nodeLabels, this.samplingSize, this.samplingSeed));
    }

    public final ImmutableBetweennessCentralityStatsConfig withRelationshipTypes(Iterable<String> elements) {
        if (this.relationshipTypes == elements) {
            return this;
        }
        List<String> newValue = ImmutableBetweennessCentralityStatsConfig.createUnmodifiableList(false, ImmutableBetweennessCentralityStatsConfig.createSafeList(elements, true, false));
        return ImmutableBetweennessCentralityStatsConfig.validate(new ImmutableBetweennessCentralityStatsConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.nodeLabels, this.samplingSize, this.samplingSeed));
    }

    public final ImmutableBetweennessCentralityStatsConfig withNodeLabels(String ... elements) {
        List<String> newValue = ImmutableBetweennessCentralityStatsConfig.createUnmodifiableList(false, ImmutableBetweennessCentralityStatsConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableBetweennessCentralityStatsConfig.validate(new ImmutableBetweennessCentralityStatsConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, newValue, this.samplingSize, this.samplingSeed));
    }

    public final ImmutableBetweennessCentralityStatsConfig withNodeLabels(Iterable<String> elements) {
        if (this.nodeLabels == elements) {
            return this;
        }
        List<String> newValue = ImmutableBetweennessCentralityStatsConfig.createUnmodifiableList(false, ImmutableBetweennessCentralityStatsConfig.createSafeList(elements, true, false));
        return ImmutableBetweennessCentralityStatsConfig.validate(new ImmutableBetweennessCentralityStatsConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, newValue, this.samplingSize, this.samplingSeed));
    }

    public final ImmutableBetweennessCentralityStatsConfig withSamplingSize(Long value) {
        Long newValue = value;
        if (Objects.equals(this.samplingSize, newValue)) {
            return this;
        }
        return ImmutableBetweennessCentralityStatsConfig.validate(new ImmutableBetweennessCentralityStatsConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, newValue, this.samplingSeed));
    }

    public final ImmutableBetweennessCentralityStatsConfig withSamplingSize(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.samplingSize, value)) {
            return this;
        }
        return ImmutableBetweennessCentralityStatsConfig.validate(new ImmutableBetweennessCentralityStatsConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, value, this.samplingSeed));
    }

    public final ImmutableBetweennessCentralityStatsConfig withSamplingSeed(Long value) {
        Long newValue = value;
        if (Objects.equals(this.samplingSeed, newValue)) {
            return this;
        }
        return ImmutableBetweennessCentralityStatsConfig.validate(new ImmutableBetweennessCentralityStatsConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.samplingSize, newValue));
    }

    public final ImmutableBetweennessCentralityStatsConfig withSamplingSeed(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.samplingSeed, value)) {
            return this;
        }
        return ImmutableBetweennessCentralityStatsConfig.validate(new ImmutableBetweennessCentralityStatsConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.samplingSize, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBetweennessCentralityStatsConfig && this.equalTo((ImmutableBetweennessCentralityStatsConfig)another);
    }

    private boolean equalTo(ImmutableBetweennessCentralityStatsConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && this.concurrency == another.concurrency && this.minBatchSize == another.minBatchSize && this.relationshipTypes.equals(another.relationshipTypes) && this.nodeLabels.equals(another.nodeLabels) && Objects.equals(this.samplingSize, another.samplingSize) && Objects.equals(this.samplingSeed, another.samplingSeed);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + this.concurrency;
        h += (h << 5) + this.minBatchSize;
        h += (h << 5) + this.relationshipTypes.hashCode();
        h += (h << 5) + this.nodeLabels.hashCode();
        h += (h << 5) + Objects.hashCode(this.samplingSize);
        h += (h << 5) + Objects.hashCode(this.samplingSeed);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("BetweennessCentralityStatsConfig{");
        if (this.usernameOverride != null) {
            builder.append("usernameOverride=").append(this.usernameOverride);
        }
        if (builder.length() > 33) {
            builder.append(", ");
        }
        builder.append("sudo=").append(this.sudo);
        builder.append(", ");
        builder.append("concurrency=").append(this.concurrency);
        builder.append(", ");
        builder.append("minBatchSize=").append(this.minBatchSize);
        builder.append(", ");
        builder.append("relationshipTypes=").append(this.relationshipTypes);
        builder.append(", ");
        builder.append("nodeLabels=").append(this.nodeLabels);
        if (this.samplingSize != null) {
            builder.append(", ");
            builder.append("samplingSize=").append(this.samplingSize);
        }
        if (this.samplingSeed != null) {
            builder.append(", ");
            builder.append("samplingSeed=").append(this.samplingSeed);
        }
        return builder.append("}").toString();
    }

    public static BetweennessCentralityStatsConfig of(int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, Optional<Long> samplingSize, Optional<Long> samplingSeed) {
        return ImmutableBetweennessCentralityStatsConfig.of(concurrency, minBatchSize, relationshipTypes, nodeLabels, samplingSize, samplingSeed);
    }

    public static BetweennessCentralityStatsConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, Optional<Long> samplingSize, Optional<Long> samplingSeed) {
        return ImmutableBetweennessCentralityStatsConfig.validate(new ImmutableBetweennessCentralityStatsConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, samplingSize, samplingSeed));
    }

    public static BetweennessCentralityStatsConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, Long samplingSize, Long samplingSeed) {
        return ImmutableBetweennessCentralityStatsConfig.validate(new ImmutableBetweennessCentralityStatsConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, samplingSize, samplingSeed));
    }

    private static ImmutableBetweennessCentralityStatsConfig validate(ImmutableBetweennessCentralityStatsConfig instance) {
        instance.validate();
        instance.validateConcurrency();
        return instance;
    }

    public static BetweennessCentralityStatsConfig copyOf(BetweennessCentralityStatsConfig instance) {
        if (instance instanceof ImmutableBetweennessCentralityStatsConfig) {
            return (ImmutableBetweennessCentralityStatsConfig)instance;
        }
        return ImmutableBetweennessCentralityStatsConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="BetweennessCentralityStatsConfig", generator="Immutables")
    public static final class Builder {
        private static final long OPT_BIT_USERNAME_OVERRIDE = 1L;
        private static final long OPT_BIT_SUDO = 2L;
        private static final long OPT_BIT_CONCURRENCY = 4L;
        private static final long OPT_BIT_MIN_BATCH_SIZE = 8L;
        private static final long OPT_BIT_RELATIONSHIP_TYPES = 16L;
        private static final long OPT_BIT_NODE_LABELS = 32L;
        private long optBits;
        private String usernameOverride;
        private boolean sudo;
        private Collection<String> configKeys;
        private int concurrency;
        private int minBatchSize;
        private List<String> relationshipTypes = null;
        private List<String> nodeLabels = null;
        private Long samplingSize;
        private Long samplingSeed;

        private Builder() {
        }

        public final Builder from(ConcurrencyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BetweennessCentralityBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AlgoBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BetweennessCentralityStatsConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            if (object instanceof ConcurrencyConfig) {
                instance = (ConcurrencyConfig)object;
                this.minBatchSize(instance.minBatchSize());
                this.concurrency(instance.concurrency());
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                @Nullable String usernameOverrideValue = instance.usernameOverride();
                if (usernameOverrideValue != null) {
                    this.usernameOverride(usernameOverrideValue);
                }
                this.configKeys(instance.configKeys());
                this.sudo(instance.sudo());
            }
            if (object instanceof BetweennessCentralityBaseConfig) {
                Optional<Long> samplingSeedOptional;
                instance = (BetweennessCentralityBaseConfig)object;
                Optional<Long> samplingSizeOptional = instance.samplingSize();
                if (samplingSizeOptional.isPresent()) {
                    this.samplingSize(samplingSizeOptional);
                }
                if ((samplingSeedOptional = instance.samplingSeed()).isPresent()) {
                    this.samplingSeed(samplingSeedOptional);
                }
            }
            if (object instanceof AlgoBaseConfig) {
                instance = (AlgoBaseConfig)object;
                this.addAllRelationshipTypes(instance.relationshipTypes());
                this.addAllNodeLabels(instance.nodeLabels());
            }
        }

        public final Builder usernameOverride(@Nullable String usernameOverride) {
            this.usernameOverride = usernameOverride;
            this.optBits |= 1L;
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 2L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 4L;
            return this;
        }

        public final Builder minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.optBits |= 8L;
            return this;
        }

        public final Builder addRelationshipType(String element) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addRelationshipTypes(String ... elements) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder relationshipTypes(Iterable<String> elements) {
            this.relationshipTypes = new ArrayList<String>();
            return this.addAllRelationshipTypes(elements);
        }

        public final Builder addAllRelationshipTypes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "relationshipTypes element");
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addNodeLabel(String element) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder addNodeLabels(String ... elements) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder nodeLabels(Iterable<String> elements) {
            this.nodeLabels = new ArrayList<String>();
            return this.addAllNodeLabels(elements);
        }

        public final Builder addAllNodeLabels(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeLabels element");
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder samplingSize(Long samplingSize) {
            this.samplingSize = samplingSize;
            return this;
        }

        public final Builder samplingSize(Optional<Long> samplingSize) {
            this.samplingSize = samplingSize.orElse(null);
            return this;
        }

        public final Builder samplingSeed(Long samplingSeed) {
            this.samplingSeed = samplingSeed;
            return this;
        }

        public final Builder samplingSeed(Optional<Long> samplingSeed) {
            this.samplingSeed = samplingSeed.orElse(null);
            return this;
        }

        public Builder clear() {
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.configKeys = null;
            this.concurrency = 0;
            this.minBatchSize = 0;
            if (this.relationshipTypes != null) {
                this.relationshipTypes.clear();
            }
            if (this.nodeLabels != null) {
                this.nodeLabels.clear();
            }
            this.samplingSize = null;
            this.samplingSeed = null;
            return this;
        }

        public BetweennessCentralityStatsConfig build() {
            return ImmutableBetweennessCentralityStatsConfig.validate(new ImmutableBetweennessCentralityStatsConfig(this));
        }

        private boolean usernameOverrideIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean sudoIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean minBatchSizeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean relationshipTypesIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean nodeLabelsIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }
    }

    @Generated(from="BetweennessCentralityStatsConfig", generator="Immutables")
    private final class InitShim {
        private byte usernameOverrideBuildStage = 0;
        private String usernameOverride;
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte concurrencyBuildStage = 0;
        private int concurrency;
        private byte minBatchSizeBuildStage = 0;
        private int minBatchSize;
        private byte relationshipTypesBuildStage = 0;
        private List<String> relationshipTypes;
        private byte nodeLabelsBuildStage = 0;
        private List<String> nodeLabels;

        private InitShim() {
        }

        String usernameOverride() {
            if (this.usernameOverrideBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usernameOverrideBuildStage == 0) {
                this.usernameOverrideBuildStage = (byte)-1;
                this.usernameOverride = ImmutableBetweennessCentralityStatsConfig.this.usernameOverrideInitialize();
                this.usernameOverrideBuildStage = 1;
            }
            return this.usernameOverride;
        }

        void usernameOverride(String usernameOverride) {
            this.usernameOverride = usernameOverride;
            this.usernameOverrideBuildStage = 1;
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableBetweennessCentralityStatsConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableBetweennessCentralityStatsConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableBetweennessCentralityStatsConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutableBetweennessCentralityStatsConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        int minBatchSize() {
            if (this.minBatchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minBatchSizeBuildStage == 0) {
                this.minBatchSizeBuildStage = (byte)-1;
                this.minBatchSize = ImmutableBetweennessCentralityStatsConfig.this.minBatchSizeInitialize();
                this.minBatchSizeBuildStage = 1;
            }
            return this.minBatchSize;
        }

        void minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.minBatchSizeBuildStage = 1;
        }

        List<String> relationshipTypes() {
            if (this.relationshipTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipTypesBuildStage == 0) {
                this.relationshipTypesBuildStage = (byte)-1;
                this.relationshipTypes = ImmutableBetweennessCentralityStatsConfig.createUnmodifiableList(false, ImmutableBetweennessCentralityStatsConfig.createSafeList(ImmutableBetweennessCentralityStatsConfig.this.relationshipTypesInitialize(), true, false));
                this.relationshipTypesBuildStage = 1;
            }
            return this.relationshipTypes;
        }

        void relationshipTypes(List<String> relationshipTypes) {
            this.relationshipTypes = relationshipTypes;
            this.relationshipTypesBuildStage = 1;
        }

        List<String> nodeLabels() {
            if (this.nodeLabelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeLabelsBuildStage == 0) {
                this.nodeLabelsBuildStage = (byte)-1;
                this.nodeLabels = ImmutableBetweennessCentralityStatsConfig.createUnmodifiableList(false, ImmutableBetweennessCentralityStatsConfig.createSafeList(ImmutableBetweennessCentralityStatsConfig.this.nodeLabelsInitialize(), true, false));
                this.nodeLabelsBuildStage = 1;
            }
            return this.nodeLabels;
        }

        void nodeLabels(List<String> nodeLabels) {
            this.nodeLabels = nodeLabels;
            this.nodeLabelsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.usernameOverrideBuildStage == -1) {
                attributes.add("usernameOverride");
            }
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.minBatchSizeBuildStage == -1) {
                attributes.add("minBatchSize");
            }
            if (this.relationshipTypesBuildStage == -1) {
                attributes.add("relationshipTypes");
            }
            if (this.nodeLabelsBuildStage == -1) {
                attributes.add("nodeLabels");
            }
            return "Cannot build BetweennessCentralityStatsConfig, attribute initializers form cycle " + attributes;
        }
    }
}

