/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.degree;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.RelationshipIterator;
import org.neo4j.gds.api.RelationshipWithPropertyConsumer;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.utils.paged.HugeAtomicDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.partition.Partition;
import org.neo4j.gds.core.utils.partition.PartitionUtils;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.degree.DegreeCentralityConfig;
import org.neo4j.gds.utils.StringFormatting;

public class DegreeCentrality
extends Algorithm<DegreeFunction> {
    private static final double DEFAULT_WEIGHT = 0.0;
    private Graph graph;
    private final ExecutorService executor;
    private final DegreeCentralityConfig config;

    public DegreeCentrality(Graph graph, ExecutorService executor, DegreeCentralityConfig config, ProgressTracker progressTracker) {
        super(progressTracker);
        this.graph = graph;
        this.executor = executor;
        this.config = config;
    }

    public DegreeFunction compute() {
        this.progressTracker.beginSubTask();
        DegreeFunction result = this.config.hasRelationshipWeightProperty() ? this.computeWeighted() : this.computeUnweighted();
        this.progressTracker.endSubTask();
        return result;
    }

    private DegreeFunction computeUnweighted() {
        switch (this.config.orientation()) {
            case NATURAL: {
                this.progressTracker.logProgress(this.graph.nodeCount());
                return arg_0 -> ((Graph)this.graph).degree(arg_0);
            }
            case REVERSE: {
                return this.computeDegreeAtomic((partition, degrees) -> new ReverseDegreeTask(this.graph.concurrentCopy(), partition, this.progressTracker, (sourceNodeId, targetNodeId, weight) -> {
                    degrees.getAndAdd(targetNodeId, 1.0);
                    return true;
                }));
            }
            case UNDIRECTED: {
                return this.computeDegreeAtomic((partition, degrees) -> new UndirectedDegreeTask(this.graph.concurrentCopy(), partition, degrees, this.progressTracker));
            }
        }
        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Orientation %s is not supported", (Object[])new Object[]{this.config.orientation()}));
    }

    private DegreeFunction computeWeighted() {
        switch (this.config.orientation()) {
            case NATURAL: {
                return this.computeDegree((partition, degrees) -> new NaturalWeightedDegreeTask((RelationshipIterator)this.graph.concurrentCopy(), degrees, partition, this.progressTracker));
            }
            case REVERSE: {
                return this.computeDegreeAtomic((partition, degrees) -> new ReverseDegreeTask(this.graph.concurrentCopy(), partition, this.progressTracker, (sourceNodeId, targetNodeId, weight) -> {
                    if (weight > 0.0) {
                        degrees.getAndAdd(targetNodeId, weight);
                    }
                    return true;
                }));
            }
            case UNDIRECTED: {
                return this.computeDegreeAtomic((partition, degrees) -> new UndirectedWeightedDegreeTask(this.graph.concurrentCopy(), partition, degrees, this.progressTracker));
            }
        }
        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Orientation %s is not supported", (Object[])new Object[]{this.config.orientation()}));
    }

    private DegreeFunction computeDegree(TaskFunction taskFunction) {
        HugeDoubleArray degrees = HugeDoubleArray.newArray((long)this.graph.nodeCount());
        List tasks = PartitionUtils.degreePartition((Graph)this.graph, (int)this.config.concurrency(), partition -> taskFunction.apply((Partition)partition, degrees), Optional.of(this.config.minBatchSize()));
        ParallelUtil.runWithConcurrency((int)this.config.concurrency(), (Iterable)tasks, (ExecutorService)this.executor);
        return arg_0 -> ((HugeDoubleArray)degrees).get(arg_0);
    }

    private DegreeFunction computeDegreeAtomic(TaskFunctionAtomic taskFunction) {
        HugeAtomicDoubleArray degrees = HugeAtomicDoubleArray.newArray((long)this.graph.nodeCount());
        List tasks = PartitionUtils.degreePartition((Graph)this.graph, (int)this.config.concurrency(), partition -> taskFunction.apply((Partition)partition, degrees), Optional.of(this.config.minBatchSize()));
        ParallelUtil.runWithConcurrency((int)this.config.concurrency(), (Iterable)tasks, (ExecutorService)this.executor);
        return arg_0 -> ((HugeAtomicDoubleArray)degrees).get(arg_0);
    }

    public void release() {
        this.graph = null;
    }

    private static class UndirectedWeightedDegreeTask
    implements Runnable {
        private final Graph graph;
        private final Partition partition;
        private final HugeAtomicDoubleArray degrees;
        private final ProgressTracker progressTracker;

        UndirectedWeightedDegreeTask(Graph graph, Partition partition, HugeAtomicDoubleArray degrees, ProgressTracker progressTracker) {
            this.graph = graph;
            this.partition = partition;
            this.degrees = degrees;
            this.progressTracker = progressTracker;
        }

        @Override
        public void run() {
            MutableDouble nodeWeight = new MutableDouble();
            this.partition.consume(node -> {
                nodeWeight.setValue(0.0);
                this.graph.forEachRelationship(node, 0.0, (sourceNodeId, targetNodeId, weight) -> {
                    if (weight > 0.0) {
                        nodeWeight.add(weight);
                        this.degrees.getAndAdd(targetNodeId, weight);
                    }
                    return true;
                });
                this.degrees.getAndAdd(node, nodeWeight.doubleValue());
            });
            this.progressTracker.logProgress(this.partition.nodeCount());
        }
    }

    private static class UndirectedDegreeTask
    implements Runnable {
        private final Graph graph;
        private final Partition partition;
        private final HugeAtomicDoubleArray degrees;
        private final ProgressTracker progressTracker;

        UndirectedDegreeTask(Graph graph, Partition partition, HugeAtomicDoubleArray degrees, ProgressTracker progressTracker) {
            this.graph = graph;
            this.partition = partition;
            this.degrees = degrees;
            this.progressTracker = progressTracker;
        }

        @Override
        public void run() {
            Function<Long, Integer> degreeFn = arg_0 -> ((Graph)this.graph).degree(arg_0);
            this.partition.consume(node -> {
                this.degrees.getAndAdd(node, (double)((Integer)degreeFn.apply(node)).intValue());
                this.graph.forEachRelationship(node, (sourceNodeId, targetNodeId) -> {
                    this.degrees.getAndAdd(targetNodeId, 1.0);
                    return true;
                });
            });
            this.progressTracker.logProgress(this.partition.nodeCount());
        }
    }

    private static class ReverseDegreeTask
    implements Runnable {
        private final Graph graph;
        private final Partition partition;
        private final ProgressTracker progressTracker;
        private final RelationshipWithPropertyConsumer consumer;

        ReverseDegreeTask(Graph graph, Partition partition, ProgressTracker progressTracker, RelationshipWithPropertyConsumer consumer) {
            this.graph = graph;
            this.partition = partition;
            this.progressTracker = progressTracker;
            this.consumer = consumer;
        }

        @Override
        public void run() {
            this.partition.consume(node -> this.graph.forEachRelationship(node, 0.0, this.consumer));
            this.progressTracker.logProgress(this.partition.nodeCount());
        }
    }

    private static class NaturalWeightedDegreeTask
    implements Runnable {
        private final HugeDoubleArray result;
        private final RelationshipIterator relationshipIterator;
        private final Partition partition;
        private final ProgressTracker progressTracker;

        NaturalWeightedDegreeTask(RelationshipIterator relationshipIterator, HugeDoubleArray result, Partition partition, ProgressTracker progressTracker) {
            this.relationshipIterator = relationshipIterator;
            this.result = result;
            this.partition = partition;
            this.progressTracker = progressTracker;
        }

        @Override
        public void run() {
            MutableDouble nodeWeight = new MutableDouble();
            this.partition.consume(nodeId -> {
                nodeWeight.setValue(0.0);
                this.relationshipIterator.forEachRelationship(nodeId, 0.0, (sourceNodeId, targetNodeId, weight) -> {
                    if (weight > 0.0) {
                        nodeWeight.add(weight);
                    }
                    return true;
                });
                this.result.set(nodeId, nodeWeight.doubleValue());
            });
            this.progressTracker.logProgress(this.partition.nodeCount());
        }
    }

    @FunctionalInterface
    static interface TaskFunctionAtomic {
        public Runnable apply(Partition var1, HugeAtomicDoubleArray var2);
    }

    @FunctionalInterface
    static interface TaskFunction {
        public Runnable apply(Partition var1, HugeDoubleArray var2);
    }

    public static interface DegreeFunction {
        public double get(long var1);
    }
}

