/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.fastrp;

import java.util.List;
import org.immutables.value.Value;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.EmbeddingDimensionConfig;
import org.neo4j.gds.config.FeaturePropertiesConfig;
import org.neo4j.gds.config.RandomSeedConfig;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.embeddings.fastrp.ImmutableFastRPBaseConfig;
import org.neo4j.gds.utils.StringFormatting;

@ValueClass
public interface FastRPBaseConfig
extends AlgoBaseConfig,
EmbeddingDimensionConfig,
RelationshipWeightConfig,
FeaturePropertiesConfig,
RandomSeedConfig {
    public static final List<Number> DEFAULT_ITERATION_WEIGHTS = List.of(Double.valueOf(0.0), Double.valueOf(1.0), Double.valueOf(1.0));

    @Value.Derived
    @Configuration.Ignore
    default public int propertyDimension() {
        return (int)((double)this.embeddingDimension() * this.propertyRatio());
    }

    @Value.Default
    @Configuration.DoubleRange(min=0.0, max=1.0)
    default public double propertyRatio() {
        return 0.0;
    }

    @Value.Default
    default public List<Number> iterationWeights() {
        return DEFAULT_ITERATION_WEIGHTS;
    }

    @Value.Default
    default public Number nodeSelfInfluence() {
        return 0;
    }

    @Configuration.Ignore
    @Value.Derived
    default public int iterations() {
        return this.iterationWeights().size();
    }

    @Value.Default
    default public float normalizationStrength() {
        return 0.0f;
    }

    @Value.Check
    default public void validate() {
        if (this.nodeSelfInfluence().floatValue() < 0.0f) {
            throw new IllegalArgumentException("The value of `nodeSelfInfluence` may not be negative.");
        }
        if (this.iterationWeights().isEmpty() && Float.compare(this.nodeSelfInfluence().floatValue(), 0.0f) == 0) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"The value of `%s` must not be empty if `nodeSelfInfluence` is zero.", (Object[])new Object[]{"iterationWeights"}));
        }
        if (this.propertyRatio() > 0.0 && this.featureProperties().isEmpty()) {
            throw new IllegalArgumentException("When `propertyRatio` is non-zero, `featureProperties` may not be empty.");
        }
        for (Number weight : this.iterationWeights()) {
            if (weight instanceof Number) continue;
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Iteration weights must be numbers, but found `%s` of type `%s`", (Object[])new Object[]{weight, weight == null ? "null" : weight.getClass().getSimpleName()}));
        }
    }

    @Configuration.Ignore
    public static ImmutableFastRPBaseConfig.Builder builder() {
        return ImmutableFastRPBaseConfig.builder();
    }
}

