/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.fastrp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.embeddings.fastrp.FastRPStatsConfig;

public final class FastRPStatsConfigImpl
implements FastRPStatsConfig {
    private double propertyRatio;
    private List<Number> iterationWeights;
    private Number nodeSelfInfluence;
    private float normalizationStrength;
    private List<String> relationshipTypes;
    private List<String> nodeLabels;
    @Nullable
    private String usernameOverride;
    private boolean sudo;
    private int concurrency;
    private int embeddingDimension;
    @Nullable
    private String relationshipWeightProperty;
    private List<String> featureProperties;
    private Optional<Long> randomSeed;

    public FastRPStatsConfigImpl(@NotNull CypherMapWrapper config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.propertyRatio = config.getDouble("propertyRatio", FastRPStatsConfig.super.propertyRatio());
            CypherMapWrapper.validateDoubleRange((String)"propertyRatio", (double)this.propertyRatio, (double)0.0, (double)1.0, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.iterationWeights = (List)CypherMapWrapper.failOnNull((String)"iterationWeights", (Object)((List)config.getChecked("iterationWeights", FastRPStatsConfig.super.iterationWeights(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.nodeSelfInfluence = (Number)CypherMapWrapper.failOnNull((String)"nodeSelfInfluence", (Object)config.getNumber("nodeSelfInfluence", FastRPStatsConfig.super.nodeSelfInfluence()));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.normalizationStrength = config.getNumber("normalizationStrength", (Number)Float.valueOf(FastRPStatsConfig.super.normalizationStrength())).floatValue();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipTypes = (List)CypherMapWrapper.failOnNull((String)"relationshipTypes", (Object)((List)config.getChecked("relationshipTypes", (Object)FastRPStatsConfig.super.relationshipTypes(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.nodeLabels = (List)CypherMapWrapper.failOnNull((String)"nodeLabels", (Object)((List)config.getChecked("nodeLabels", (Object)FastRPStatsConfig.super.nodeLabels(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.usernameOverride = StringUtils.trimToNull((String)config.getString("username", FastRPStatsConfig.super.usernameOverride()));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sudo = config.getBool("sudo", FastRPStatsConfig.super.sudo());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.concurrency = config.getInt("concurrency", FastRPStatsConfig.super.concurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.embeddingDimension = config.requireInt("embeddingDimension");
            CypherMapWrapper.validateIntegerRange((String)"embeddingDimension", (int)this.embeddingDimension, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipWeightProperty = RelationshipWeightConfig.validatePropertyName((String)config.getString("relationshipWeightProperty", FastRPStatsConfig.super.relationshipWeightProperty()));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.featureProperties = (List)CypherMapWrapper.failOnNull((String)"featureProperties", (Object)((List)config.getChecked("featureProperties", (Object)FastRPStatsConfig.super.featureProperties(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.randomSeed = (Optional)CypherMapWrapper.failOnNull((String)"randomSeed", (Object)config.getOptional("randomSeed", Long.class));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validate();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.validateConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public double propertyRatio() {
        return this.propertyRatio;
    }

    @Override
    public List<Number> iterationWeights() {
        return this.iterationWeights;
    }

    @Override
    public Number nodeSelfInfluence() {
        return this.nodeSelfInfluence;
    }

    @Override
    public float normalizationStrength() {
        return this.normalizationStrength;
    }

    public List<String> relationshipTypes() {
        return this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        return this.nodeLabels;
    }

    public void graphStoreValidation(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        this.relationshipWeightValidation(graphStore, selectedLabels, selectedRelationshipTypes);
    }

    @Nullable
    public String usernameOverride() {
        return this.usernameOverride;
    }

    public boolean sudo() {
        return this.sudo;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("propertyRatio", "iterationWeights", "nodeSelfInfluence", "normalizationStrength", "relationshipTypes", "nodeLabels", "username", "sudo", "concurrency", "embeddingDimension", "relationshipWeightProperty", "featureProperties", "randomSeed");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("propertyRatio", this.propertyRatio());
        map.put("iterationWeights", this.iterationWeights());
        map.put("nodeSelfInfluence", this.nodeSelfInfluence());
        map.put("normalizationStrength", Float.valueOf(this.normalizationStrength()));
        map.put("relationshipTypes", this.relationshipTypes());
        map.put("nodeLabels", this.nodeLabels());
        map.put("username", this.usernameOverride());
        map.put("sudo", this.sudo());
        map.put("concurrency", this.concurrency());
        map.put("embeddingDimension", this.embeddingDimension());
        map.put("relationshipWeightProperty", this.relationshipWeightProperty());
        map.put("featureProperties", this.featureProperties());
        this.randomSeed().ifPresent(randomSeed -> map.put("randomSeed", randomSeed));
        return map;
    }

    public int concurrency() {
        return this.concurrency;
    }

    public int embeddingDimension() {
        return this.embeddingDimension;
    }

    @Nullable
    public String relationshipWeightProperty() {
        return this.relationshipWeightProperty;
    }

    public List<String> featureProperties() {
        return this.featureProperties;
    }

    public Optional<Long> randomSeed() {
        return this.randomSeed;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();

        public Builder propertyRatio(double propertyRatio) {
            this.config.put("propertyRatio", propertyRatio);
            return this;
        }

        public Builder iterationWeights(List<Number> iterationWeights) {
            this.config.put("iterationWeights", iterationWeights);
            return this;
        }

        public Builder nodeSelfInfluence(Number nodeSelfInfluence) {
            this.config.put("nodeSelfInfluence", nodeSelfInfluence);
            return this;
        }

        public Builder normalizationStrength(float normalizationStrength) {
            this.config.put("normalizationStrength", Float.valueOf(normalizationStrength));
            return this;
        }

        public Builder relationshipTypes(List<String> relationshipTypes) {
            this.config.put("relationshipTypes", relationshipTypes);
            return this;
        }

        public Builder nodeLabels(List<String> nodeLabels) {
            this.config.put("nodeLabels", nodeLabels);
            return this;
        }

        public Builder usernameOverride(String usernameOverride) {
            this.config.put("username", usernameOverride);
            return this;
        }

        public Builder sudo(boolean sudo) {
            this.config.put("sudo", sudo);
            return this;
        }

        public Builder concurrency(int concurrency) {
            this.config.put("concurrency", concurrency);
            return this;
        }

        public Builder embeddingDimension(int embeddingDimension) {
            this.config.put("embeddingDimension", embeddingDimension);
            return this;
        }

        public Builder relationshipWeightProperty(String relationshipWeightProperty) {
            this.config.put("relationshipWeightProperty", relationshipWeightProperty);
            return this;
        }

        public Builder featureProperties(List<String> featureProperties) {
            this.config.put("featureProperties", featureProperties);
            return this;
        }

        public Builder randomSeed(Long randomSeed) {
            this.config.put("randomSeed", randomSeed);
            return this;
        }

        public Builder randomSeed(Optional<Long> randomSeed) {
            randomSeed.ifPresent(actualrandomSeed -> this.config.put("randomSeed", actualrandomSeed));
            return this;
        }

        public FastRPStatsConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new FastRPStatsConfigImpl(config);
        }
    }
}

