/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.fastrp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.config.EmbeddingDimensionConfig;
import org.neo4j.gds.config.FeaturePropertiesConfig;
import org.neo4j.gds.config.RandomSeedConfig;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.config.WriteConfig;
import org.neo4j.gds.config.WritePropertyConfig;
import org.neo4j.gds.embeddings.fastrp.FastRPBaseConfig;
import org.neo4j.gds.embeddings.fastrp.FastRPWriteConfig;

@Generated(from="FastRPWriteConfig", generator="Immutables")
public final class ImmutableFastRPWriteConfig
implements FastRPWriteConfig {
    @Nullable
    private final String usernameOverride;
    private final boolean sudo;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    private final int concurrency;
    private final int minBatchSize;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    private final int embeddingDimension;
    @Nullable
    private final String relationshipWeightProperty;
    private final transient boolean hasRelationshipWeightProperty;
    private final List<String> featureProperties;
    private final Long randomSeed;
    private final transient int propertyDimension;
    private final double propertyRatio;
    private final List<Number> iterationWeights;
    private final Number nodeSelfInfluence;
    private final transient int iterations;
    private final float normalizationStrength;
    private final int writeConcurrency;
    private final String writeProperty;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableFastRPWriteConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, int embeddingDimension, @Nullable String relationshipWeightProperty, Iterable<String> featureProperties, Optional<Long> randomSeed, double propertyRatio, Iterable<? extends Number> iterationWeights, Number nodeSelfInfluence, float normalizationStrength, int writeConcurrency, String writeProperty) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableFastRPWriteConfig.createUnmodifiableList(false, ImmutableFastRPWriteConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableFastRPWriteConfig.createUnmodifiableList(false, ImmutableFastRPWriteConfig.createSafeList(nodeLabels, true, false)));
        this.embeddingDimension = embeddingDimension;
        this.initShim.relationshipWeightProperty(relationshipWeightProperty);
        this.initShim.featureProperties(ImmutableFastRPWriteConfig.createUnmodifiableList(false, ImmutableFastRPWriteConfig.createSafeList(featureProperties, true, false)));
        this.randomSeed = randomSeed.orElse(null);
        this.initShim.propertyRatio(propertyRatio);
        this.initShim.iterationWeights(ImmutableFastRPWriteConfig.createUnmodifiableList(false, ImmutableFastRPWriteConfig.createSafeList(iterationWeights, true, false)));
        this.initShim.nodeSelfInfluence(Objects.requireNonNull(nodeSelfInfluence, "nodeSelfInfluence"));
        this.initShim.normalizationStrength(normalizationStrength);
        this.initShim.writeConcurrency(writeConcurrency);
        this.writeProperty = Objects.requireNonNull(writeProperty, "writeProperty");
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.featureProperties = this.initShim.featureProperties();
        this.propertyDimension = this.initShim.propertyDimension();
        this.propertyRatio = this.initShim.propertyRatio();
        this.iterationWeights = this.initShim.iterationWeights();
        this.nodeSelfInfluence = this.initShim.nodeSelfInfluence();
        this.iterations = this.initShim.iterations();
        this.normalizationStrength = this.initShim.normalizationStrength();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.initShim = null;
    }

    private ImmutableFastRPWriteConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, int embeddingDimension, @Nullable String relationshipWeightProperty, Iterable<String> featureProperties, Long randomSeed, double propertyRatio, Iterable<? extends Number> iterationWeights, Number nodeSelfInfluence, float normalizationStrength, int writeConcurrency, String writeProperty) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableFastRPWriteConfig.createUnmodifiableList(false, ImmutableFastRPWriteConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableFastRPWriteConfig.createUnmodifiableList(false, ImmutableFastRPWriteConfig.createSafeList(nodeLabels, true, false)));
        this.embeddingDimension = embeddingDimension;
        this.initShim.relationshipWeightProperty(relationshipWeightProperty);
        this.initShim.featureProperties(ImmutableFastRPWriteConfig.createUnmodifiableList(false, ImmutableFastRPWriteConfig.createSafeList(featureProperties, true, false)));
        this.randomSeed = randomSeed;
        this.initShim.propertyRatio(propertyRatio);
        this.initShim.iterationWeights(ImmutableFastRPWriteConfig.createUnmodifiableList(false, ImmutableFastRPWriteConfig.createSafeList(iterationWeights, true, false)));
        this.initShim.nodeSelfInfluence(Objects.requireNonNull(nodeSelfInfluence, "nodeSelfInfluence"));
        this.initShim.normalizationStrength(normalizationStrength);
        this.initShim.writeConcurrency(writeConcurrency);
        this.writeProperty = Objects.requireNonNull(writeProperty, "writeProperty");
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.featureProperties = this.initShim.featureProperties();
        this.propertyDimension = this.initShim.propertyDimension();
        this.propertyRatio = this.initShim.propertyRatio();
        this.iterationWeights = this.initShim.iterationWeights();
        this.nodeSelfInfluence = this.initShim.nodeSelfInfluence();
        this.iterations = this.initShim.iterations();
        this.normalizationStrength = this.initShim.normalizationStrength();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.initShim = null;
    }

    private ImmutableFastRPWriteConfig(Builder builder) {
        this.embeddingDimension = builder.embeddingDimension;
        this.randomSeed = builder.randomSeed;
        this.writeProperty = builder.writeProperty;
        if (builder.usernameOverrideIsSet()) {
            this.initShim.usernameOverride(builder.usernameOverride);
        }
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.minBatchSizeIsSet()) {
            this.initShim.minBatchSize(builder.minBatchSize);
        }
        if (builder.relationshipTypesIsSet()) {
            this.initShim.relationshipTypes(builder.relationshipTypes == null ? Collections.emptyList() : ImmutableFastRPWriteConfig.createUnmodifiableList(true, builder.relationshipTypes));
        }
        if (builder.nodeLabelsIsSet()) {
            this.initShim.nodeLabels(builder.nodeLabels == null ? Collections.emptyList() : ImmutableFastRPWriteConfig.createUnmodifiableList(true, builder.nodeLabels));
        }
        if (builder.relationshipWeightPropertyIsSet()) {
            this.initShim.relationshipWeightProperty(builder.relationshipWeightProperty);
        }
        if (builder.featurePropertiesIsSet()) {
            this.initShim.featureProperties(builder.featureProperties == null ? Collections.emptyList() : ImmutableFastRPWriteConfig.createUnmodifiableList(true, builder.featureProperties));
        }
        if (builder.propertyRatioIsSet()) {
            this.initShim.propertyRatio(builder.propertyRatio);
        }
        if (builder.iterationWeightsIsSet()) {
            this.initShim.iterationWeights(builder.iterationWeights == null ? Collections.emptyList() : ImmutableFastRPWriteConfig.createUnmodifiableList(true, builder.iterationWeights));
        }
        if (builder.nodeSelfInfluence != null) {
            this.initShim.nodeSelfInfluence(builder.nodeSelfInfluence);
        }
        if (builder.normalizationStrengthIsSet()) {
            this.initShim.normalizationStrength(builder.normalizationStrength);
        }
        if (builder.writeConcurrencyIsSet()) {
            this.initShim.writeConcurrency(builder.writeConcurrency);
        }
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.featureProperties = this.initShim.featureProperties();
        this.propertyDimension = this.initShim.propertyDimension();
        this.propertyRatio = this.initShim.propertyRatio();
        this.iterationWeights = this.initShim.iterationWeights();
        this.nodeSelfInfluence = this.initShim.nodeSelfInfluence();
        this.iterations = this.initShim.iterations();
        this.normalizationStrength = this.initShim.normalizationStrength();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.initShim = null;
    }

    private ImmutableFastRPWriteConfig(@Nullable String usernameOverride, boolean sudo, Collection<String> configKeys, int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, int embeddingDimension, @Nullable String relationshipWeightProperty, List<String> featureProperties, Long randomSeed, double propertyRatio, List<Number> iterationWeights, Number nodeSelfInfluence, float normalizationStrength, int writeConcurrency, String writeProperty) {
        this.initShim.usernameOverride(usernameOverride);
        this.initShim.sudo(sudo);
        this.initShim.configKeys(configKeys);
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(relationshipTypes);
        this.initShim.nodeLabels(nodeLabels);
        this.embeddingDimension = embeddingDimension;
        this.initShim.relationshipWeightProperty(relationshipWeightProperty);
        this.initShim.featureProperties(featureProperties);
        this.randomSeed = randomSeed;
        this.initShim.propertyRatio(propertyRatio);
        this.initShim.iterationWeights(iterationWeights);
        this.initShim.nodeSelfInfluence(nodeSelfInfluence);
        this.initShim.normalizationStrength(normalizationStrength);
        this.initShim.writeConcurrency(writeConcurrency);
        this.writeProperty = writeProperty;
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.featureProperties = this.initShim.featureProperties();
        this.propertyDimension = this.initShim.propertyDimension();
        this.propertyRatio = this.initShim.propertyRatio();
        this.iterationWeights = this.initShim.iterationWeights();
        this.nodeSelfInfluence = this.initShim.nodeSelfInfluence();
        this.iterations = this.initShim.iterations();
        this.normalizationStrength = this.initShim.normalizationStrength();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.initShim = null;
    }

    @Nullable
    private String usernameOverrideInitialize() {
        return FastRPWriteConfig.super.usernameOverride();
    }

    private boolean sudoInitialize() {
        return FastRPWriteConfig.super.sudo();
    }

    private Collection<String> configKeysInitialize() {
        return FastRPWriteConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return FastRPWriteConfig.super.toMap();
    }

    private int concurrencyInitialize() {
        return FastRPWriteConfig.super.concurrency();
    }

    private int minBatchSizeInitialize() {
        return FastRPWriteConfig.super.minBatchSize();
    }

    private List<String> relationshipTypesInitialize() {
        return FastRPWriteConfig.super.relationshipTypes();
    }

    private List<String> nodeLabelsInitialize() {
        return FastRPWriteConfig.super.nodeLabels();
    }

    @Nullable
    private String relationshipWeightPropertyInitialize() {
        return FastRPWriteConfig.super.relationshipWeightProperty();
    }

    private boolean hasRelationshipWeightPropertyInitialize() {
        return FastRPWriteConfig.super.hasRelationshipWeightProperty();
    }

    private List<String> featurePropertiesInitialize() {
        return FastRPWriteConfig.super.featureProperties();
    }

    private int propertyDimensionInitialize() {
        return FastRPWriteConfig.super.propertyDimension();
    }

    private double propertyRatioInitialize() {
        return FastRPWriteConfig.super.propertyRatio();
    }

    private List<Number> iterationWeightsInitialize() {
        return FastRPWriteConfig.super.iterationWeights();
    }

    private Number nodeSelfInfluenceInitialize() {
        return FastRPWriteConfig.super.nodeSelfInfluence();
    }

    private int iterationsInitialize() {
        return FastRPWriteConfig.super.iterations();
    }

    private float normalizationStrengthInitialize() {
        return FastRPWriteConfig.super.normalizationStrength();
    }

    private int writeConcurrencyInitialize() {
        return FastRPWriteConfig.super.writeConcurrency();
    }

    @Nullable
    public String usernameOverride() {
        InitShim shim = this.initShim;
        return shim != null ? shim.usernameOverride() : this.usernameOverride;
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    public int minBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minBatchSize() : this.minBatchSize;
    }

    public List<String> relationshipTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipTypes() : this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeLabels() : this.nodeLabels;
    }

    public int embeddingDimension() {
        return this.embeddingDimension;
    }

    @Nullable
    public String relationshipWeightProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipWeightProperty() : this.relationshipWeightProperty;
    }

    public boolean hasRelationshipWeightProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasRelationshipWeightProperty() : this.hasRelationshipWeightProperty;
    }

    public List<String> featureProperties() {
        InitShim shim = this.initShim;
        return shim != null ? shim.featureProperties() : this.featureProperties;
    }

    public Optional<Long> randomSeed() {
        return Optional.ofNullable(this.randomSeed);
    }

    @Override
    public int propertyDimension() {
        InitShim shim = this.initShim;
        return shim != null ? shim.propertyDimension() : this.propertyDimension;
    }

    @Override
    public double propertyRatio() {
        InitShim shim = this.initShim;
        return shim != null ? shim.propertyRatio() : this.propertyRatio;
    }

    @Override
    public List<Number> iterationWeights() {
        InitShim shim = this.initShim;
        return shim != null ? shim.iterationWeights() : this.iterationWeights;
    }

    @Override
    public Number nodeSelfInfluence() {
        InitShim shim = this.initShim;
        return shim != null ? (Number)shim.nodeSelfInfluence() : (Number)this.nodeSelfInfluence;
    }

    @Override
    public int iterations() {
        InitShim shim = this.initShim;
        return shim != null ? shim.iterations() : this.iterations;
    }

    @Override
    public float normalizationStrength() {
        InitShim shim = this.initShim;
        return shim != null ? shim.normalizationStrength() : this.normalizationStrength;
    }

    public int writeConcurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.writeConcurrency() : this.writeConcurrency;
    }

    public String writeProperty() {
        return this.writeProperty;
    }

    public final ImmutableFastRPWriteConfig withUsernameOverride(@Nullable String value) {
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return ImmutableFastRPWriteConfig.validate(new ImmutableFastRPWriteConfig(value, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.embeddingDimension, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.propertyRatio, this.iterationWeights, this.nodeSelfInfluence, this.normalizationStrength, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableFastRPWriteConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutableFastRPWriteConfig.validate(new ImmutableFastRPWriteConfig(this.usernameOverride, value, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.embeddingDimension, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.propertyRatio, this.iterationWeights, this.nodeSelfInfluence, this.normalizationStrength, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableFastRPWriteConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutableFastRPWriteConfig.validate(new ImmutableFastRPWriteConfig(this.usernameOverride, this.sudo, newValue, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.embeddingDimension, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.propertyRatio, this.iterationWeights, this.nodeSelfInfluence, this.normalizationStrength, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableFastRPWriteConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutableFastRPWriteConfig.validate(new ImmutableFastRPWriteConfig(this.usernameOverride, this.sudo, this.configKeys, value, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.embeddingDimension, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.propertyRatio, this.iterationWeights, this.nodeSelfInfluence, this.normalizationStrength, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableFastRPWriteConfig withMinBatchSize(int value) {
        if (this.minBatchSize == value) {
            return this;
        }
        return ImmutableFastRPWriteConfig.validate(new ImmutableFastRPWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, value, this.relationshipTypes, this.nodeLabels, this.embeddingDimension, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.propertyRatio, this.iterationWeights, this.nodeSelfInfluence, this.normalizationStrength, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableFastRPWriteConfig withRelationshipTypes(String ... elements) {
        List<String> newValue = ImmutableFastRPWriteConfig.createUnmodifiableList(false, ImmutableFastRPWriteConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableFastRPWriteConfig.validate(new ImmutableFastRPWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.nodeLabels, this.embeddingDimension, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.propertyRatio, this.iterationWeights, this.nodeSelfInfluence, this.normalizationStrength, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableFastRPWriteConfig withRelationshipTypes(Iterable<String> elements) {
        if (this.relationshipTypes == elements) {
            return this;
        }
        List<String> newValue = ImmutableFastRPWriteConfig.createUnmodifiableList(false, ImmutableFastRPWriteConfig.createSafeList(elements, true, false));
        return ImmutableFastRPWriteConfig.validate(new ImmutableFastRPWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.nodeLabels, this.embeddingDimension, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.propertyRatio, this.iterationWeights, this.nodeSelfInfluence, this.normalizationStrength, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableFastRPWriteConfig withNodeLabels(String ... elements) {
        List<String> newValue = ImmutableFastRPWriteConfig.createUnmodifiableList(false, ImmutableFastRPWriteConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableFastRPWriteConfig.validate(new ImmutableFastRPWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, newValue, this.embeddingDimension, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.propertyRatio, this.iterationWeights, this.nodeSelfInfluence, this.normalizationStrength, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableFastRPWriteConfig withNodeLabels(Iterable<String> elements) {
        if (this.nodeLabels == elements) {
            return this;
        }
        List<String> newValue = ImmutableFastRPWriteConfig.createUnmodifiableList(false, ImmutableFastRPWriteConfig.createSafeList(elements, true, false));
        return ImmutableFastRPWriteConfig.validate(new ImmutableFastRPWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, newValue, this.embeddingDimension, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.propertyRatio, this.iterationWeights, this.nodeSelfInfluence, this.normalizationStrength, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableFastRPWriteConfig withEmbeddingDimension(int value) {
        if (this.embeddingDimension == value) {
            return this;
        }
        return ImmutableFastRPWriteConfig.validate(new ImmutableFastRPWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, value, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.propertyRatio, this.iterationWeights, this.nodeSelfInfluence, this.normalizationStrength, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableFastRPWriteConfig withRelationshipWeightProperty(@Nullable String value) {
        if (Objects.equals(this.relationshipWeightProperty, value)) {
            return this;
        }
        return ImmutableFastRPWriteConfig.validate(new ImmutableFastRPWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.embeddingDimension, value, this.featureProperties, this.randomSeed, this.propertyRatio, this.iterationWeights, this.nodeSelfInfluence, this.normalizationStrength, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableFastRPWriteConfig withFeatureProperties(String ... elements) {
        List<String> newValue = ImmutableFastRPWriteConfig.createUnmodifiableList(false, ImmutableFastRPWriteConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableFastRPWriteConfig.validate(new ImmutableFastRPWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.embeddingDimension, this.relationshipWeightProperty, newValue, this.randomSeed, this.propertyRatio, this.iterationWeights, this.nodeSelfInfluence, this.normalizationStrength, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableFastRPWriteConfig withFeatureProperties(Iterable<String> elements) {
        if (this.featureProperties == elements) {
            return this;
        }
        List<String> newValue = ImmutableFastRPWriteConfig.createUnmodifiableList(false, ImmutableFastRPWriteConfig.createSafeList(elements, true, false));
        return ImmutableFastRPWriteConfig.validate(new ImmutableFastRPWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.embeddingDimension, this.relationshipWeightProperty, newValue, this.randomSeed, this.propertyRatio, this.iterationWeights, this.nodeSelfInfluence, this.normalizationStrength, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableFastRPWriteConfig withRandomSeed(Long value) {
        Long newValue = value;
        if (Objects.equals(this.randomSeed, newValue)) {
            return this;
        }
        return ImmutableFastRPWriteConfig.validate(new ImmutableFastRPWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.embeddingDimension, this.relationshipWeightProperty, this.featureProperties, newValue, this.propertyRatio, this.iterationWeights, this.nodeSelfInfluence, this.normalizationStrength, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableFastRPWriteConfig withRandomSeed(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.randomSeed, value)) {
            return this;
        }
        return ImmutableFastRPWriteConfig.validate(new ImmutableFastRPWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.embeddingDimension, this.relationshipWeightProperty, this.featureProperties, value, this.propertyRatio, this.iterationWeights, this.nodeSelfInfluence, this.normalizationStrength, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableFastRPWriteConfig withPropertyRatio(double value) {
        if (Double.doubleToLongBits(this.propertyRatio) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutableFastRPWriteConfig.validate(new ImmutableFastRPWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.embeddingDimension, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, value, this.iterationWeights, this.nodeSelfInfluence, this.normalizationStrength, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableFastRPWriteConfig withIterationWeights(Number ... elements) {
        List<Number> newValue = ImmutableFastRPWriteConfig.createUnmodifiableList(false, ImmutableFastRPWriteConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableFastRPWriteConfig.validate(new ImmutableFastRPWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.embeddingDimension, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.propertyRatio, newValue, this.nodeSelfInfluence, this.normalizationStrength, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableFastRPWriteConfig withIterationWeights(Iterable<? extends Number> elements) {
        if (this.iterationWeights == elements) {
            return this;
        }
        List<Number> newValue = ImmutableFastRPWriteConfig.createUnmodifiableList(false, ImmutableFastRPWriteConfig.createSafeList(elements, true, false));
        return ImmutableFastRPWriteConfig.validate(new ImmutableFastRPWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.embeddingDimension, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.propertyRatio, newValue, this.nodeSelfInfluence, this.normalizationStrength, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableFastRPWriteConfig withNodeSelfInfluence(Number value) {
        if (this.nodeSelfInfluence == value) {
            return this;
        }
        Number newValue = Objects.requireNonNull(value, "nodeSelfInfluence");
        return ImmutableFastRPWriteConfig.validate(new ImmutableFastRPWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.embeddingDimension, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.propertyRatio, this.iterationWeights, newValue, this.normalizationStrength, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableFastRPWriteConfig withNormalizationStrength(float value) {
        if (Float.floatToIntBits(this.normalizationStrength) == Float.floatToIntBits(value)) {
            return this;
        }
        return ImmutableFastRPWriteConfig.validate(new ImmutableFastRPWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.embeddingDimension, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.propertyRatio, this.iterationWeights, this.nodeSelfInfluence, value, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutableFastRPWriteConfig withWriteConcurrency(int value) {
        if (this.writeConcurrency == value) {
            return this;
        }
        return ImmutableFastRPWriteConfig.validate(new ImmutableFastRPWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.embeddingDimension, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.propertyRatio, this.iterationWeights, this.nodeSelfInfluence, this.normalizationStrength, value, this.writeProperty));
    }

    public final ImmutableFastRPWriteConfig withWriteProperty(String value) {
        String newValue = Objects.requireNonNull(value, "writeProperty");
        if (this.writeProperty.equals(newValue)) {
            return this;
        }
        return ImmutableFastRPWriteConfig.validate(new ImmutableFastRPWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.embeddingDimension, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.propertyRatio, this.iterationWeights, this.nodeSelfInfluence, this.normalizationStrength, this.writeConcurrency, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFastRPWriteConfig && this.equalTo((ImmutableFastRPWriteConfig)another);
    }

    private boolean equalTo(ImmutableFastRPWriteConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && this.concurrency == another.concurrency && this.minBatchSize == another.minBatchSize && this.relationshipTypes.equals(another.relationshipTypes) && this.nodeLabels.equals(another.nodeLabels) && this.embeddingDimension == another.embeddingDimension && Objects.equals(this.relationshipWeightProperty, another.relationshipWeightProperty) && this.hasRelationshipWeightProperty == another.hasRelationshipWeightProperty && this.featureProperties.equals(another.featureProperties) && Objects.equals(this.randomSeed, another.randomSeed) && this.propertyDimension == another.propertyDimension && Double.doubleToLongBits(this.propertyRatio) == Double.doubleToLongBits(another.propertyRatio) && this.iterationWeights.equals(another.iterationWeights) && this.nodeSelfInfluence.equals(another.nodeSelfInfluence) && this.iterations == another.iterations && Float.floatToIntBits(this.normalizationStrength) == Float.floatToIntBits(another.normalizationStrength) && this.writeConcurrency == another.writeConcurrency && this.writeProperty.equals(another.writeProperty);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + this.concurrency;
        h += (h << 5) + this.minBatchSize;
        h += (h << 5) + this.relationshipTypes.hashCode();
        h += (h << 5) + this.nodeLabels.hashCode();
        h += (h << 5) + this.embeddingDimension;
        h += (h << 5) + Objects.hashCode(this.relationshipWeightProperty);
        h += (h << 5) + Boolean.hashCode(this.hasRelationshipWeightProperty);
        h += (h << 5) + this.featureProperties.hashCode();
        h += (h << 5) + Objects.hashCode(this.randomSeed);
        h += (h << 5) + this.propertyDimension;
        h += (h << 5) + Double.hashCode(this.propertyRatio);
        h += (h << 5) + this.iterationWeights.hashCode();
        h += (h << 5) + this.nodeSelfInfluence.hashCode();
        h += (h << 5) + this.iterations;
        h += (h << 5) + Float.hashCode(this.normalizationStrength);
        h += (h << 5) + this.writeConcurrency;
        h += (h << 5) + this.writeProperty.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("FastRPWriteConfig{");
        if (this.usernameOverride != null) {
            builder.append("usernameOverride=").append(this.usernameOverride);
        }
        if (builder.length() > 18) {
            builder.append(", ");
        }
        builder.append("sudo=").append(this.sudo);
        builder.append(", ");
        builder.append("concurrency=").append(this.concurrency);
        builder.append(", ");
        builder.append("minBatchSize=").append(this.minBatchSize);
        builder.append(", ");
        builder.append("relationshipTypes=").append(this.relationshipTypes);
        builder.append(", ");
        builder.append("nodeLabels=").append(this.nodeLabels);
        builder.append(", ");
        builder.append("embeddingDimension=").append(this.embeddingDimension);
        if (this.relationshipWeightProperty != null) {
            builder.append(", ");
            builder.append("relationshipWeightProperty=").append(this.relationshipWeightProperty);
        }
        builder.append(", ");
        builder.append("hasRelationshipWeightProperty=").append(this.hasRelationshipWeightProperty);
        builder.append(", ");
        builder.append("featureProperties=").append(this.featureProperties);
        if (this.randomSeed != null) {
            builder.append(", ");
            builder.append("randomSeed=").append(this.randomSeed);
        }
        builder.append(", ");
        builder.append("propertyDimension=").append(this.propertyDimension);
        builder.append(", ");
        builder.append("propertyRatio=").append(this.propertyRatio);
        builder.append(", ");
        builder.append("iterationWeights=").append(this.iterationWeights);
        builder.append(", ");
        builder.append("nodeSelfInfluence=").append(this.nodeSelfInfluence);
        builder.append(", ");
        builder.append("iterations=").append(this.iterations);
        builder.append(", ");
        builder.append("normalizationStrength=").append(this.normalizationStrength);
        builder.append(", ");
        builder.append("writeConcurrency=").append(this.writeConcurrency);
        builder.append(", ");
        builder.append("writeProperty=").append(this.writeProperty);
        return builder.append("}").toString();
    }

    public static FastRPWriteConfig of(int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, int embeddingDimension, @Nullable String relationshipWeightProperty, List<String> featureProperties, Optional<Long> randomSeed, double propertyRatio, List<Number> iterationWeights, Number nodeSelfInfluence, float normalizationStrength, int writeConcurrency, String writeProperty) {
        return ImmutableFastRPWriteConfig.of(concurrency, minBatchSize, relationshipTypes, nodeLabels, embeddingDimension, relationshipWeightProperty, featureProperties, randomSeed, propertyRatio, iterationWeights, nodeSelfInfluence, normalizationStrength, writeConcurrency, writeProperty);
    }

    public static FastRPWriteConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, int embeddingDimension, @Nullable String relationshipWeightProperty, Iterable<String> featureProperties, Optional<Long> randomSeed, double propertyRatio, Iterable<? extends Number> iterationWeights, Number nodeSelfInfluence, float normalizationStrength, int writeConcurrency, String writeProperty) {
        return ImmutableFastRPWriteConfig.validate(new ImmutableFastRPWriteConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, embeddingDimension, relationshipWeightProperty, featureProperties, randomSeed, propertyRatio, iterationWeights, nodeSelfInfluence, normalizationStrength, writeConcurrency, writeProperty));
    }

    public static FastRPWriteConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, int embeddingDimension, @Nullable String relationshipWeightProperty, Iterable<String> featureProperties, Long randomSeed, double propertyRatio, Iterable<? extends Number> iterationWeights, Number nodeSelfInfluence, float normalizationStrength, int writeConcurrency, String writeProperty) {
        return ImmutableFastRPWriteConfig.validate(new ImmutableFastRPWriteConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, embeddingDimension, relationshipWeightProperty, featureProperties, randomSeed, propertyRatio, iterationWeights, nodeSelfInfluence, normalizationStrength, writeConcurrency, writeProperty));
    }

    private static ImmutableFastRPWriteConfig validate(ImmutableFastRPWriteConfig instance) {
        instance.validateWriteConcurrency();
        instance.validate();
        instance.validateConcurrency();
        return instance;
    }

    public static FastRPWriteConfig copyOf(FastRPWriteConfig instance) {
        if (instance instanceof ImmutableFastRPWriteConfig) {
            return (ImmutableFastRPWriteConfig)instance;
        }
        return ImmutableFastRPWriteConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="FastRPWriteConfig", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_EMBEDDING_DIMENSION = 1L;
        private static final long INIT_BIT_WRITE_PROPERTY = 2L;
        private static final long OPT_BIT_USERNAME_OVERRIDE = 1L;
        private static final long OPT_BIT_SUDO = 2L;
        private static final long OPT_BIT_CONCURRENCY = 4L;
        private static final long OPT_BIT_MIN_BATCH_SIZE = 8L;
        private static final long OPT_BIT_RELATIONSHIP_TYPES = 16L;
        private static final long OPT_BIT_NODE_LABELS = 32L;
        private static final long OPT_BIT_RELATIONSHIP_WEIGHT_PROPERTY = 64L;
        private static final long OPT_BIT_FEATURE_PROPERTIES = 128L;
        private static final long OPT_BIT_PROPERTY_RATIO = 256L;
        private static final long OPT_BIT_ITERATION_WEIGHTS = 512L;
        private static final long OPT_BIT_NORMALIZATION_STRENGTH = 1024L;
        private static final long OPT_BIT_WRITE_CONCURRENCY = 2048L;
        private long initBits = 3L;
        private long optBits;
        private String usernameOverride;
        private boolean sudo;
        private Collection<String> configKeys;
        private int concurrency;
        private int minBatchSize;
        private List<String> relationshipTypes = null;
        private List<String> nodeLabels = null;
        private int embeddingDimension;
        private String relationshipWeightProperty;
        private List<String> featureProperties = null;
        private Long randomSeed;
        private double propertyRatio;
        private List<Number> iterationWeights = null;
        private Number nodeSelfInfluence;
        private float normalizationStrength;
        private int writeConcurrency;
        private String writeProperty;

        private Builder() {
        }

        public final Builder from(RelationshipWeightConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(WriteConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(WritePropertyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(FastRPBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ConcurrencyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RandomSeedConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(FeaturePropertiesConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AlgoBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EmbeddingDimensionConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(FastRPWriteConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional randomSeedOptional;
            RelationshipWeightConfig instance;
            String relationshipWeightPropertyValue;
            if (object instanceof RelationshipWeightConfig && (relationshipWeightPropertyValue = (instance = (RelationshipWeightConfig)object).relationshipWeightProperty()) != null) {
                this.relationshipWeightProperty(relationshipWeightPropertyValue);
            }
            if (object instanceof WriteConfig) {
                instance = (WriteConfig)object;
                this.writeConcurrency(instance.writeConcurrency());
            }
            if (object instanceof WritePropertyConfig) {
                instance = (WritePropertyConfig)object;
                this.writeProperty(instance.writeProperty());
            }
            if (object instanceof FastRPBaseConfig) {
                instance = (FastRPBaseConfig)object;
                this.addAllIterationWeights(instance.iterationWeights());
                this.nodeSelfInfluence(instance.nodeSelfInfluence());
                this.propertyRatio(instance.propertyRatio());
                this.normalizationStrength(instance.normalizationStrength());
            }
            if (object instanceof ConcurrencyConfig) {
                instance = (ConcurrencyConfig)object;
                this.minBatchSize(instance.minBatchSize());
                this.concurrency(instance.concurrency());
            }
            if (object instanceof RandomSeedConfig && (randomSeedOptional = (instance = (RandomSeedConfig)object).randomSeed()).isPresent()) {
                this.randomSeed(randomSeedOptional);
            }
            if (object instanceof FeaturePropertiesConfig) {
                instance = (FeaturePropertiesConfig)object;
                this.addAllFeatureProperties(instance.featureProperties());
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                @Nullable String usernameOverrideValue = instance.usernameOverride();
                if (usernameOverrideValue != null) {
                    this.usernameOverride(usernameOverrideValue);
                }
                this.configKeys(instance.configKeys());
                this.sudo(instance.sudo());
            }
            if (object instanceof AlgoBaseConfig) {
                instance = (AlgoBaseConfig)object;
                this.addAllRelationshipTypes(instance.relationshipTypes());
                this.addAllNodeLabels(instance.nodeLabels());
            }
            if (object instanceof EmbeddingDimensionConfig) {
                instance = (EmbeddingDimensionConfig)object;
                this.embeddingDimension(instance.embeddingDimension());
            }
        }

        public final Builder usernameOverride(@Nullable String usernameOverride) {
            this.usernameOverride = usernameOverride;
            this.optBits |= 1L;
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 2L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 4L;
            return this;
        }

        public final Builder minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.optBits |= 8L;
            return this;
        }

        public final Builder addRelationshipType(String element) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addRelationshipTypes(String ... elements) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder relationshipTypes(Iterable<String> elements) {
            this.relationshipTypes = new ArrayList<String>();
            return this.addAllRelationshipTypes(elements);
        }

        public final Builder addAllRelationshipTypes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "relationshipTypes element");
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addNodeLabel(String element) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder addNodeLabels(String ... elements) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder nodeLabels(Iterable<String> elements) {
            this.nodeLabels = new ArrayList<String>();
            return this.addAllNodeLabels(elements);
        }

        public final Builder addAllNodeLabels(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeLabels element");
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder embeddingDimension(int embeddingDimension) {
            this.embeddingDimension = embeddingDimension;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder relationshipWeightProperty(@Nullable String relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder addFeatureProperty(String element) {
            if (this.featureProperties == null) {
                this.featureProperties = new ArrayList<String>();
            }
            this.featureProperties.add(Objects.requireNonNull(element, "featureProperties element"));
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder addFeatureProperties(String ... elements) {
            if (this.featureProperties == null) {
                this.featureProperties = new ArrayList<String>();
            }
            for (String element : elements) {
                this.featureProperties.add(Objects.requireNonNull(element, "featureProperties element"));
            }
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder featureProperties(Iterable<String> elements) {
            this.featureProperties = new ArrayList<String>();
            return this.addAllFeatureProperties(elements);
        }

        public final Builder addAllFeatureProperties(Iterable<String> elements) {
            Objects.requireNonNull(elements, "featureProperties element");
            if (this.featureProperties == null) {
                this.featureProperties = new ArrayList<String>();
            }
            for (String element : elements) {
                this.featureProperties.add(Objects.requireNonNull(element, "featureProperties element"));
            }
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder randomSeed(Long randomSeed) {
            this.randomSeed = randomSeed;
            return this;
        }

        public final Builder randomSeed(Optional<Long> randomSeed) {
            this.randomSeed = randomSeed.orElse(null);
            return this;
        }

        public final Builder propertyRatio(double propertyRatio) {
            this.propertyRatio = propertyRatio;
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder addIterationWeight(Number element) {
            if (this.iterationWeights == null) {
                this.iterationWeights = new ArrayList<Number>();
            }
            this.iterationWeights.add(Objects.requireNonNull(element, "iterationWeights element"));
            this.optBits |= 0x200L;
            return this;
        }

        public final Builder addIterationWeights(Number ... elements) {
            if (this.iterationWeights == null) {
                this.iterationWeights = new ArrayList<Number>();
            }
            for (Number element : elements) {
                this.iterationWeights.add(Objects.requireNonNull(element, "iterationWeights element"));
            }
            this.optBits |= 0x200L;
            return this;
        }

        public final Builder iterationWeights(Iterable<? extends Number> elements) {
            this.iterationWeights = new ArrayList<Number>();
            return this.addAllIterationWeights(elements);
        }

        public final Builder addAllIterationWeights(Iterable<? extends Number> elements) {
            Objects.requireNonNull(elements, "iterationWeights element");
            if (this.iterationWeights == null) {
                this.iterationWeights = new ArrayList<Number>();
            }
            for (Number number : elements) {
                this.iterationWeights.add(Objects.requireNonNull(number, "iterationWeights element"));
            }
            this.optBits |= 0x200L;
            return this;
        }

        public final Builder nodeSelfInfluence(Number nodeSelfInfluence) {
            this.nodeSelfInfluence = Objects.requireNonNull(nodeSelfInfluence, "nodeSelfInfluence");
            return this;
        }

        public final Builder normalizationStrength(float normalizationStrength) {
            this.normalizationStrength = normalizationStrength;
            this.optBits |= 0x400L;
            return this;
        }

        public final Builder writeConcurrency(int writeConcurrency) {
            this.writeConcurrency = writeConcurrency;
            this.optBits |= 0x800L;
            return this;
        }

        public final Builder writeProperty(String writeProperty) {
            this.writeProperty = Objects.requireNonNull(writeProperty, "writeProperty");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.configKeys = null;
            this.concurrency = 0;
            this.minBatchSize = 0;
            if (this.relationshipTypes != null) {
                this.relationshipTypes.clear();
            }
            if (this.nodeLabels != null) {
                this.nodeLabels.clear();
            }
            this.embeddingDimension = 0;
            this.relationshipWeightProperty = null;
            if (this.featureProperties != null) {
                this.featureProperties.clear();
            }
            this.randomSeed = null;
            this.propertyRatio = 0.0;
            if (this.iterationWeights != null) {
                this.iterationWeights.clear();
            }
            this.nodeSelfInfluence = null;
            this.normalizationStrength = 0.0f;
            this.writeConcurrency = 0;
            this.writeProperty = null;
            return this;
        }

        public FastRPWriteConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableFastRPWriteConfig.validate(new ImmutableFastRPWriteConfig(this));
        }

        private boolean usernameOverrideIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean sudoIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean minBatchSizeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean relationshipTypesIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean nodeLabelsIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean relationshipWeightPropertyIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean featurePropertiesIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean propertyRatioIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean iterationWeightsIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private boolean normalizationStrengthIsSet() {
            return (this.optBits & 0x400L) != 0L;
        }

        private boolean writeConcurrencyIsSet() {
            return (this.optBits & 0x800L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("embeddingDimension");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("writeProperty");
            }
            return "Cannot build FastRPWriteConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="FastRPWriteConfig", generator="Immutables")
    private final class InitShim {
        private byte usernameOverrideBuildStage = 0;
        private String usernameOverride;
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte concurrencyBuildStage = 0;
        private int concurrency;
        private byte minBatchSizeBuildStage = 0;
        private int minBatchSize;
        private byte relationshipTypesBuildStage = 0;
        private List<String> relationshipTypes;
        private byte nodeLabelsBuildStage = 0;
        private List<String> nodeLabels;
        private byte relationshipWeightPropertyBuildStage = 0;
        private String relationshipWeightProperty;
        private byte hasRelationshipWeightPropertyBuildStage = 0;
        private boolean hasRelationshipWeightProperty;
        private byte featurePropertiesBuildStage = 0;
        private List<String> featureProperties;
        private byte propertyDimensionBuildStage = 0;
        private int propertyDimension;
        private byte propertyRatioBuildStage = 0;
        private double propertyRatio;
        private byte iterationWeightsBuildStage = 0;
        private List<Number> iterationWeights;
        private byte nodeSelfInfluenceBuildStage = 0;
        private Number nodeSelfInfluence;
        private byte iterationsBuildStage = 0;
        private int iterations;
        private byte normalizationStrengthBuildStage = 0;
        private float normalizationStrength;
        private byte writeConcurrencyBuildStage = 0;
        private int writeConcurrency;

        private InitShim() {
        }

        String usernameOverride() {
            if (this.usernameOverrideBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usernameOverrideBuildStage == 0) {
                this.usernameOverrideBuildStage = (byte)-1;
                this.usernameOverride = ImmutableFastRPWriteConfig.this.usernameOverrideInitialize();
                this.usernameOverrideBuildStage = 1;
            }
            return this.usernameOverride;
        }

        void usernameOverride(String usernameOverride) {
            this.usernameOverride = usernameOverride;
            this.usernameOverrideBuildStage = 1;
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableFastRPWriteConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableFastRPWriteConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableFastRPWriteConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutableFastRPWriteConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        int minBatchSize() {
            if (this.minBatchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minBatchSizeBuildStage == 0) {
                this.minBatchSizeBuildStage = (byte)-1;
                this.minBatchSize = ImmutableFastRPWriteConfig.this.minBatchSizeInitialize();
                this.minBatchSizeBuildStage = 1;
            }
            return this.minBatchSize;
        }

        void minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.minBatchSizeBuildStage = 1;
        }

        List<String> relationshipTypes() {
            if (this.relationshipTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipTypesBuildStage == 0) {
                this.relationshipTypesBuildStage = (byte)-1;
                this.relationshipTypes = ImmutableFastRPWriteConfig.createUnmodifiableList(false, ImmutableFastRPWriteConfig.createSafeList(ImmutableFastRPWriteConfig.this.relationshipTypesInitialize(), true, false));
                this.relationshipTypesBuildStage = 1;
            }
            return this.relationshipTypes;
        }

        void relationshipTypes(List<String> relationshipTypes) {
            this.relationshipTypes = relationshipTypes;
            this.relationshipTypesBuildStage = 1;
        }

        List<String> nodeLabels() {
            if (this.nodeLabelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeLabelsBuildStage == 0) {
                this.nodeLabelsBuildStage = (byte)-1;
                this.nodeLabels = ImmutableFastRPWriteConfig.createUnmodifiableList(false, ImmutableFastRPWriteConfig.createSafeList(ImmutableFastRPWriteConfig.this.nodeLabelsInitialize(), true, false));
                this.nodeLabelsBuildStage = 1;
            }
            return this.nodeLabels;
        }

        void nodeLabels(List<String> nodeLabels) {
            this.nodeLabels = nodeLabels;
            this.nodeLabelsBuildStage = 1;
        }

        String relationshipWeightProperty() {
            if (this.relationshipWeightPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipWeightPropertyBuildStage == 0) {
                this.relationshipWeightPropertyBuildStage = (byte)-1;
                this.relationshipWeightProperty = ImmutableFastRPWriteConfig.this.relationshipWeightPropertyInitialize();
                this.relationshipWeightPropertyBuildStage = 1;
            }
            return this.relationshipWeightProperty;
        }

        void relationshipWeightProperty(String relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty;
            this.relationshipWeightPropertyBuildStage = 1;
        }

        boolean hasRelationshipWeightProperty() {
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasRelationshipWeightPropertyBuildStage == 0) {
                this.hasRelationshipWeightPropertyBuildStage = (byte)-1;
                this.hasRelationshipWeightProperty = ImmutableFastRPWriteConfig.this.hasRelationshipWeightPropertyInitialize();
                this.hasRelationshipWeightPropertyBuildStage = 1;
            }
            return this.hasRelationshipWeightProperty;
        }

        List<String> featureProperties() {
            if (this.featurePropertiesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.featurePropertiesBuildStage == 0) {
                this.featurePropertiesBuildStage = (byte)-1;
                this.featureProperties = ImmutableFastRPWriteConfig.createUnmodifiableList(false, ImmutableFastRPWriteConfig.createSafeList(ImmutableFastRPWriteConfig.this.featurePropertiesInitialize(), true, false));
                this.featurePropertiesBuildStage = 1;
            }
            return this.featureProperties;
        }

        void featureProperties(List<String> featureProperties) {
            this.featureProperties = featureProperties;
            this.featurePropertiesBuildStage = 1;
        }

        int propertyDimension() {
            if (this.propertyDimensionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.propertyDimensionBuildStage == 0) {
                this.propertyDimensionBuildStage = (byte)-1;
                this.propertyDimension = ImmutableFastRPWriteConfig.this.propertyDimensionInitialize();
                this.propertyDimensionBuildStage = 1;
            }
            return this.propertyDimension;
        }

        double propertyRatio() {
            if (this.propertyRatioBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.propertyRatioBuildStage == 0) {
                this.propertyRatioBuildStage = (byte)-1;
                this.propertyRatio = ImmutableFastRPWriteConfig.this.propertyRatioInitialize();
                this.propertyRatioBuildStage = 1;
            }
            return this.propertyRatio;
        }

        void propertyRatio(double propertyRatio) {
            this.propertyRatio = propertyRatio;
            this.propertyRatioBuildStage = 1;
        }

        List<Number> iterationWeights() {
            if (this.iterationWeightsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.iterationWeightsBuildStage == 0) {
                this.iterationWeightsBuildStage = (byte)-1;
                this.iterationWeights = ImmutableFastRPWriteConfig.createUnmodifiableList(false, ImmutableFastRPWriteConfig.createSafeList(ImmutableFastRPWriteConfig.this.iterationWeightsInitialize(), true, false));
                this.iterationWeightsBuildStage = 1;
            }
            return this.iterationWeights;
        }

        void iterationWeights(List<Number> iterationWeights) {
            this.iterationWeights = iterationWeights;
            this.iterationWeightsBuildStage = 1;
        }

        Number nodeSelfInfluence() {
            if (this.nodeSelfInfluenceBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeSelfInfluenceBuildStage == 0) {
                this.nodeSelfInfluenceBuildStage = (byte)-1;
                this.nodeSelfInfluence = Objects.requireNonNull(ImmutableFastRPWriteConfig.this.nodeSelfInfluenceInitialize(), "nodeSelfInfluence");
                this.nodeSelfInfluenceBuildStage = 1;
            }
            return this.nodeSelfInfluence;
        }

        void nodeSelfInfluence(Number nodeSelfInfluence) {
            this.nodeSelfInfluence = nodeSelfInfluence;
            this.nodeSelfInfluenceBuildStage = 1;
        }

        int iterations() {
            if (this.iterationsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.iterationsBuildStage == 0) {
                this.iterationsBuildStage = (byte)-1;
                this.iterations = ImmutableFastRPWriteConfig.this.iterationsInitialize();
                this.iterationsBuildStage = 1;
            }
            return this.iterations;
        }

        float normalizationStrength() {
            if (this.normalizationStrengthBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.normalizationStrengthBuildStage == 0) {
                this.normalizationStrengthBuildStage = (byte)-1;
                this.normalizationStrength = ImmutableFastRPWriteConfig.this.normalizationStrengthInitialize();
                this.normalizationStrengthBuildStage = 1;
            }
            return this.normalizationStrength;
        }

        void normalizationStrength(float normalizationStrength) {
            this.normalizationStrength = normalizationStrength;
            this.normalizationStrengthBuildStage = 1;
        }

        int writeConcurrency() {
            if (this.writeConcurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.writeConcurrencyBuildStage == 0) {
                this.writeConcurrencyBuildStage = (byte)-1;
                this.writeConcurrency = ImmutableFastRPWriteConfig.this.writeConcurrencyInitialize();
                this.writeConcurrencyBuildStage = 1;
            }
            return this.writeConcurrency;
        }

        void writeConcurrency(int writeConcurrency) {
            this.writeConcurrency = writeConcurrency;
            this.writeConcurrencyBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.usernameOverrideBuildStage == -1) {
                attributes.add("usernameOverride");
            }
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.minBatchSizeBuildStage == -1) {
                attributes.add("minBatchSize");
            }
            if (this.relationshipTypesBuildStage == -1) {
                attributes.add("relationshipTypes");
            }
            if (this.nodeLabelsBuildStage == -1) {
                attributes.add("nodeLabels");
            }
            if (this.relationshipWeightPropertyBuildStage == -1) {
                attributes.add("relationshipWeightProperty");
            }
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                attributes.add("hasRelationshipWeightProperty");
            }
            if (this.featurePropertiesBuildStage == -1) {
                attributes.add("featureProperties");
            }
            if (this.propertyDimensionBuildStage == -1) {
                attributes.add("propertyDimension");
            }
            if (this.propertyRatioBuildStage == -1) {
                attributes.add("propertyRatio");
            }
            if (this.iterationWeightsBuildStage == -1) {
                attributes.add("iterationWeights");
            }
            if (this.nodeSelfInfluenceBuildStage == -1) {
                attributes.add("nodeSelfInfluence");
            }
            if (this.iterationsBuildStage == -1) {
                attributes.add("iterations");
            }
            if (this.normalizationStrengthBuildStage == -1) {
                attributes.add("normalizationStrength");
            }
            if (this.writeConcurrencyBuildStage == -1) {
                attributes.add("writeConcurrency");
            }
            return "Cannot build FastRPWriteConfig, attribute initializers form cycle " + attributes;
        }
    }
}

