/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.graphsage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.embeddings.graphsage.GraphSageModelTrainer;

@Generated(from="GraphSageModelTrainer.GraphSageTrainMetrics", generator="Immutables")
public final class ImmutableGraphSageTrainMetrics
implements GraphSageModelTrainer.GraphSageTrainMetrics {
    private final List<Double> epochLosses;
    private final boolean didConverge;
    private final transient int ranEpochs;
    private final transient Map<String, Object> toMap;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGraphSageTrainMetrics(Iterable<Double> epochLosses, boolean didConverge) {
        this.epochLosses = ImmutableGraphSageTrainMetrics.createUnmodifiableList(false, ImmutableGraphSageTrainMetrics.createSafeList(epochLosses, true, false));
        this.didConverge = didConverge;
        this.ranEpochs = this.initShim.ranEpochs();
        this.toMap = this.initShim.toMap();
        this.initShim = null;
    }

    private ImmutableGraphSageTrainMetrics(ImmutableGraphSageTrainMetrics original, List<Double> epochLosses, boolean didConverge) {
        this.epochLosses = epochLosses;
        this.didConverge = didConverge;
        this.ranEpochs = this.initShim.ranEpochs();
        this.toMap = this.initShim.toMap();
        this.initShim = null;
    }

    private int ranEpochsInitialize() {
        return GraphSageModelTrainer.GraphSageTrainMetrics.super.ranEpochs();
    }

    private Map<String, Object> toMapInitialize() {
        return GraphSageModelTrainer.GraphSageTrainMetrics.super.toMap();
    }

    @Override
    public List<Double> epochLosses() {
        return this.epochLosses;
    }

    @Override
    public boolean didConverge() {
        return this.didConverge;
    }

    @Override
    public int ranEpochs() {
        InitShim shim = this.initShim;
        return shim != null ? shim.ranEpochs() : this.ranEpochs;
    }

    @Override
    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public final ImmutableGraphSageTrainMetrics withEpochLosses(double ... elements) {
        ArrayList<Double> wrappedList = new ArrayList<Double>(elements.length);
        for (double element : elements) {
            wrappedList.add(element);
        }
        List<Double> newValue = ImmutableGraphSageTrainMetrics.createUnmodifiableList(false, wrappedList);
        return new ImmutableGraphSageTrainMetrics(this, newValue, this.didConverge);
    }

    public final ImmutableGraphSageTrainMetrics withEpochLosses(Iterable<Double> elements) {
        if (this.epochLosses == elements) {
            return this;
        }
        List<Double> newValue = ImmutableGraphSageTrainMetrics.createUnmodifiableList(false, ImmutableGraphSageTrainMetrics.createSafeList(elements, true, false));
        return new ImmutableGraphSageTrainMetrics(this, newValue, this.didConverge);
    }

    public final ImmutableGraphSageTrainMetrics withDidConverge(boolean value) {
        if (this.didConverge == value) {
            return this;
        }
        return new ImmutableGraphSageTrainMetrics(this, this.epochLosses, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGraphSageTrainMetrics && this.equalTo((ImmutableGraphSageTrainMetrics)another);
    }

    private boolean equalTo(ImmutableGraphSageTrainMetrics another) {
        return this.epochLosses.equals(another.epochLosses) && this.didConverge == another.didConverge && this.ranEpochs == another.ranEpochs;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.epochLosses.hashCode();
        h += (h << 5) + Boolean.hashCode(this.didConverge);
        h += (h << 5) + this.ranEpochs;
        return h;
    }

    public String toString() {
        return "GraphSageTrainMetrics{epochLosses=" + this.epochLosses + ", didConverge=" + this.didConverge + ", ranEpochs=" + this.ranEpochs + "}";
    }

    public static GraphSageModelTrainer.GraphSageTrainMetrics of(List<Double> epochLosses, boolean didConverge) {
        return ImmutableGraphSageTrainMetrics.of(epochLosses, didConverge);
    }

    public static GraphSageModelTrainer.GraphSageTrainMetrics of(Iterable<Double> epochLosses, boolean didConverge) {
        return new ImmutableGraphSageTrainMetrics(epochLosses, didConverge);
    }

    public static GraphSageModelTrainer.GraphSageTrainMetrics copyOf(GraphSageModelTrainer.GraphSageTrainMetrics instance) {
        if (instance instanceof ImmutableGraphSageTrainMetrics) {
            return (ImmutableGraphSageTrainMetrics)instance;
        }
        return ImmutableGraphSageTrainMetrics.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="GraphSageModelTrainer.GraphSageTrainMetrics", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_DID_CONVERGE = 1L;
        private long initBits = 1L;
        private List<Double> epochLosses = null;
        private boolean didConverge;

        private Builder() {
        }

        public final Builder from(GraphSageModelTrainer.GraphSageTrainMetrics instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllEpochLosses(instance.epochLosses());
            this.didConverge(instance.didConverge());
            return this;
        }

        public final Builder addEpochLosse(double element) {
            if (this.epochLosses == null) {
                this.epochLosses = new ArrayList<Double>();
            }
            this.epochLosses.add(element);
            return this;
        }

        public final Builder addEpochLosses(double ... elements) {
            if (this.epochLosses == null) {
                this.epochLosses = new ArrayList<Double>();
            }
            for (double element : elements) {
                this.epochLosses.add(element);
            }
            return this;
        }

        public final Builder epochLosses(Iterable<Double> elements) {
            this.epochLosses = new ArrayList<Double>();
            return this.addAllEpochLosses(elements);
        }

        public final Builder addAllEpochLosses(Iterable<Double> elements) {
            Objects.requireNonNull(elements, "epochLosses element");
            if (this.epochLosses == null) {
                this.epochLosses = new ArrayList<Double>();
            }
            for (double element : elements) {
                this.epochLosses.add(Objects.requireNonNull(Double.valueOf(element), "epochLosses element"));
            }
            return this;
        }

        public final Builder didConverge(boolean didConverge) {
            this.didConverge = didConverge;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder clear() {
            this.initBits = 1L;
            if (this.epochLosses != null) {
                this.epochLosses.clear();
            }
            this.didConverge = false;
            return this;
        }

        public GraphSageModelTrainer.GraphSageTrainMetrics build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGraphSageTrainMetrics(null, this.epochLosses == null ? Collections.emptyList() : ImmutableGraphSageTrainMetrics.createUnmodifiableList(true, this.epochLosses), this.didConverge);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("didConverge");
            }
            return "Cannot build GraphSageTrainMetrics, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="GraphSageModelTrainer.GraphSageTrainMetrics", generator="Immutables")
    private final class InitShim {
        private byte ranEpochsBuildStage = 0;
        private int ranEpochs;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;

        private InitShim() {
        }

        int ranEpochs() {
            if (this.ranEpochsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.ranEpochsBuildStage == 0) {
                this.ranEpochsBuildStage = (byte)-1;
                this.ranEpochs = ImmutableGraphSageTrainMetrics.this.ranEpochsInitialize();
                this.ranEpochsBuildStage = 1;
            }
            return this.ranEpochs;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableGraphSageTrainMetrics.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.ranEpochsBuildStage == -1) {
                attributes.add("ranEpochs");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            return "Cannot build GraphSageTrainMetrics, attribute initializers form cycle " + attributes;
        }
    }
}

