/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.graphsage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.embeddings.graphsage.FeatureFunction;
import org.neo4j.gds.embeddings.graphsage.Layer;
import org.neo4j.gds.embeddings.graphsage.ModelData;

@Generated(from="ModelData", generator="Immutables")
public final class ImmutableModelData
implements ModelData {
    private final Layer[] layers;
    private final FeatureFunction featureFunction;

    private ImmutableModelData(Layer[] layers, FeatureFunction featureFunction) {
        this.layers = (Layer[])layers.clone();
        this.featureFunction = Objects.requireNonNull(featureFunction, "featureFunction");
    }

    private ImmutableModelData(ImmutableModelData original, Layer[] layers, FeatureFunction featureFunction) {
        this.layers = layers;
        this.featureFunction = featureFunction;
    }

    @Override
    public Layer[] layers() {
        return (Layer[])this.layers.clone();
    }

    @Override
    public FeatureFunction featureFunction() {
        return this.featureFunction;
    }

    public final ImmutableModelData withLayers(Layer ... elements) {
        Layer[] newValue = (Layer[])elements.clone();
        return new ImmutableModelData(this, newValue, this.featureFunction);
    }

    public final ImmutableModelData withFeatureFunction(FeatureFunction value) {
        if (this.featureFunction == value) {
            return this;
        }
        FeatureFunction newValue = Objects.requireNonNull(value, "featureFunction");
        return new ImmutableModelData(this, this.layers, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableModelData && this.equalTo((ImmutableModelData)another);
    }

    private boolean equalTo(ImmutableModelData another) {
        return Arrays.equals(this.layers, another.layers) && this.featureFunction.equals(another.featureFunction);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Arrays.hashCode(this.layers);
        h += (h << 5) + this.featureFunction.hashCode();
        return h;
    }

    public String toString() {
        return "ModelData{layers=" + Arrays.toString(this.layers) + ", featureFunction=" + this.featureFunction + "}";
    }

    public static ModelData of(Layer[] layers, FeatureFunction featureFunction) {
        return new ImmutableModelData(layers, featureFunction);
    }

    public static ModelData copyOf(ModelData instance) {
        if (instance instanceof ImmutableModelData) {
            return (ImmutableModelData)instance;
        }
        return ImmutableModelData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ModelData", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_LAYERS = 1L;
        private static final long INIT_BIT_FEATURE_FUNCTION = 2L;
        private long initBits = 3L;
        private Layer[] layers;
        private FeatureFunction featureFunction;

        private Builder() {
        }

        public final Builder from(ModelData instance) {
            Objects.requireNonNull(instance, "instance");
            this.layers(instance.layers());
            this.featureFunction(instance.featureFunction());
            return this;
        }

        public final Builder layers(Layer ... layers) {
            this.layers = (Layer[])layers.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder featureFunction(FeatureFunction featureFunction) {
            this.featureFunction = Objects.requireNonNull(featureFunction, "featureFunction");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.layers = null;
            this.featureFunction = null;
            return this;
        }

        public ModelData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableModelData(null, this.layers, this.featureFunction);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("layers");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("featureFunction");
            }
            return "Cannot build ModelData, some of required attributes are not set " + attributes;
        }
    }
}

