/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.graphsage.algo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.embeddings.graphsage.ActivationFunction;
import org.neo4j.gds.embeddings.graphsage.Aggregator;
import org.neo4j.gds.embeddings.graphsage.algo.GraphSageTrainConfig;
import org.neo4j.gds.model.ModelConfig;

public final class GraphSageTrainConfigImpl
implements GraphSageTrainConfig {
    private int embeddingDimension;
    private List<Integer> sampleSizes;
    private Aggregator.AggregatorType aggregator;
    private ActivationFunction activationFunction;
    private double tolerance;
    private double learningRate;
    private int epochs;
    private int maxIterations;
    private int searchDepth;
    private int negativeSampleWeight;
    private Optional<Integer> projectedFeatureDimension;
    private List<String> relationshipTypes;
    private List<String> nodeLabels;
    @Nullable
    private String usernameOverride;
    private boolean sudo;
    private int concurrency;
    private String modelName;
    private String username;
    private int batchSize;
    @Nullable
    private String relationshipWeightProperty;
    private List<String> featureProperties;
    private Optional<Long> randomSeed;

    public GraphSageTrainConfigImpl(@NotNull String username, @NotNull CypherMapWrapper config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.embeddingDimension = config.getInt("embeddingDimension", GraphSageTrainConfig.super.embeddingDimension());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sampleSizes = (List)CypherMapWrapper.failOnNull((String)"sampleSizes", GraphSageTrainConfig.convertToIntSamples((List)config.getChecked("sampleSizes", GraphSageTrainConfig.super.sampleSizes(), List.class)));
            this.sampleSizes.forEach(sampleSizes -> CypherMapWrapper.validateIntegerRange((String)"sampleSizes", (int)sampleSizes, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.aggregator = (Aggregator.AggregatorType)((Object)CypherMapWrapper.failOnNull((String)"aggregator", (Object)((Object)Aggregator.AggregatorType.parse(config.getChecked("aggregator", (Object)GraphSageTrainConfig.super.aggregator(), Object.class)))));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.activationFunction = (ActivationFunction)((Object)CypherMapWrapper.failOnNull((String)"activationFunction", (Object)((Object)ActivationFunction.parse(config.getChecked("activationFunction", (Object)GraphSageTrainConfig.super.activationFunction(), Object.class)))));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.tolerance = config.getDouble("tolerance", GraphSageTrainConfig.super.tolerance());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.learningRate = config.getDouble("learningRate", GraphSageTrainConfig.super.learningRate());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.epochs = config.getInt("epochs", GraphSageTrainConfig.super.epochs());
            CypherMapWrapper.validateIntegerRange((String)"epochs", (int)this.epochs, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.maxIterations = config.getInt("maxIterations", GraphSageTrainConfig.super.maxIterations());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.searchDepth = config.getInt("searchDepth", GraphSageTrainConfig.super.searchDepth());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.negativeSampleWeight = config.getInt("negativeSampleWeight", GraphSageTrainConfig.super.negativeSampleWeight());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.projectedFeatureDimension = (Optional)CypherMapWrapper.failOnNull((String)"projectedFeatureDimension", (Object)config.getOptional("projectedFeatureDimension", Integer.class));
            this.projectedFeatureDimension.ifPresent(projectedFeatureDimension -> CypherMapWrapper.validateIntegerRange((String)"projectedFeatureDimension", (int)projectedFeatureDimension, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipTypes = (List)CypherMapWrapper.failOnNull((String)"relationshipTypes", (Object)((List)config.getChecked("relationshipTypes", (Object)GraphSageTrainConfig.super.relationshipTypes(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.nodeLabels = (List)CypherMapWrapper.failOnNull((String)"nodeLabels", (Object)((List)config.getChecked("nodeLabels", (Object)GraphSageTrainConfig.super.nodeLabels(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.usernameOverride = StringUtils.trimToNull((String)config.getString("username", GraphSageTrainConfig.super.usernameOverride()));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sudo = config.getBool("sudo", GraphSageTrainConfig.super.sudo());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.concurrency = config.getInt("concurrency", GraphSageTrainConfig.super.concurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.modelName = (String)CypherMapWrapper.failOnNull((String)"modelName", (Object)ModelConfig.validateName((String)config.requireString("modelName")));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.username = (String)CypherMapWrapper.failOnNull((String)"username", (Object)username);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.batchSize = config.getInt("batchSize", GraphSageTrainConfig.super.batchSize());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipWeightProperty = RelationshipWeightConfig.validatePropertyName((String)config.getString("relationshipWeightProperty", GraphSageTrainConfig.super.relationshipWeightProperty()));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.featureProperties = (List)CypherMapWrapper.failOnNull((String)"featureProperties", (Object)((List)config.getChecked("featureProperties", (Object)GraphSageTrainConfig.super.featureProperties(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.randomSeed = (Optional)CypherMapWrapper.failOnNull((String)"randomSeed", (Object)config.getOptional("randomSeed", Long.class));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validate();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.validateConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public int embeddingDimension() {
        return this.embeddingDimension;
    }

    @Override
    public List<Integer> sampleSizes() {
        return this.sampleSizes;
    }

    @Override
    public Aggregator.AggregatorType aggregator() {
        return this.aggregator;
    }

    @Override
    public ActivationFunction activationFunction() {
        return this.activationFunction;
    }

    @Override
    public double tolerance() {
        return this.tolerance;
    }

    @Override
    public double learningRate() {
        return this.learningRate;
    }

    @Override
    public int epochs() {
        return this.epochs;
    }

    @Override
    public int maxIterations() {
        return this.maxIterations;
    }

    @Override
    public int searchDepth() {
        return this.searchDepth;
    }

    @Override
    public int negativeSampleWeight() {
        return this.negativeSampleWeight;
    }

    @Override
    public Optional<Integer> projectedFeatureDimension() {
        return this.projectedFeatureDimension;
    }

    public List<String> relationshipTypes() {
        return this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        return this.nodeLabels;
    }

    public void graphStoreValidation(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        this.relationshipWeightValidation(graphStore, selectedLabels, selectedRelationshipTypes);
    }

    @Nullable
    public String usernameOverride() {
        return this.usernameOverride;
    }

    public boolean sudo() {
        return this.sudo;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("embeddingDimension", "sampleSizes", "aggregator", "activationFunction", "tolerance", "learningRate", "epochs", "maxIterations", "searchDepth", "negativeSampleWeight", "projectedFeatureDimension", "relationshipTypes", "nodeLabels", "username", "sudo", "concurrency", "modelName", "batchSize", "relationshipWeightProperty", "featureProperties", "randomSeed");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embeddingDimension", this.embeddingDimension());
        map.put("sampleSizes", this.sampleSizes());
        map.put("aggregator", Aggregator.AggregatorType.toString(this.aggregator()));
        map.put("activationFunction", ActivationFunction.toString(this.activationFunction()));
        map.put("tolerance", this.tolerance());
        map.put("learningRate", this.learningRate());
        map.put("epochs", this.epochs());
        map.put("maxIterations", this.maxIterations());
        map.put("searchDepth", this.searchDepth());
        map.put("negativeSampleWeight", this.negativeSampleWeight());
        this.projectedFeatureDimension().ifPresent(projectedFeatureDimension -> map.put("projectedFeatureDimension", projectedFeatureDimension));
        map.put("relationshipTypes", this.relationshipTypes());
        map.put("nodeLabels", this.nodeLabels());
        map.put("username", this.usernameOverride());
        map.put("sudo", this.sudo());
        map.put("concurrency", this.concurrency());
        map.put("modelName", this.modelName());
        map.put("batchSize", this.batchSize());
        map.put("relationshipWeightProperty", this.relationshipWeightProperty());
        map.put("featureProperties", this.featureProperties());
        this.randomSeed().ifPresent(randomSeed -> map.put("randomSeed", randomSeed));
        return map;
    }

    public int concurrency() {
        return this.concurrency;
    }

    public String modelName() {
        return this.modelName;
    }

    public String username() {
        return this.username;
    }

    public int batchSize() {
        return this.batchSize;
    }

    @Nullable
    public String relationshipWeightProperty() {
        return this.relationshipWeightProperty;
    }

    public List<String> featureProperties() {
        return this.featureProperties;
    }

    public Optional<Long> randomSeed() {
        return this.randomSeed;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();
        @NotNull
        private String username;

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder embeddingDimension(int embeddingDimension) {
            this.config.put("embeddingDimension", embeddingDimension);
            return this;
        }

        public Builder sampleSizes(List<Number> sampleSizes) {
            this.config.put("sampleSizes", sampleSizes);
            return this;
        }

        public Builder aggregator(Object aggregator) {
            this.config.put("aggregator", aggregator);
            return this;
        }

        public Builder activationFunction(Object activationFunction) {
            this.config.put("activationFunction", activationFunction);
            return this;
        }

        public Builder tolerance(double tolerance) {
            this.config.put("tolerance", tolerance);
            return this;
        }

        public Builder learningRate(double learningRate) {
            this.config.put("learningRate", learningRate);
            return this;
        }

        public Builder epochs(int epochs) {
            this.config.put("epochs", epochs);
            return this;
        }

        public Builder maxIterations(int maxIterations) {
            this.config.put("maxIterations", maxIterations);
            return this;
        }

        public Builder searchDepth(int searchDepth) {
            this.config.put("searchDepth", searchDepth);
            return this;
        }

        public Builder negativeSampleWeight(int negativeSampleWeight) {
            this.config.put("negativeSampleWeight", negativeSampleWeight);
            return this;
        }

        public Builder projectedFeatureDimension(Integer projectedFeatureDimension) {
            this.config.put("projectedFeatureDimension", projectedFeatureDimension);
            return this;
        }

        public Builder projectedFeatureDimension(Optional<Integer> projectedFeatureDimension) {
            projectedFeatureDimension.ifPresent(actualprojectedFeatureDimension -> this.config.put("projectedFeatureDimension", actualprojectedFeatureDimension));
            return this;
        }

        public Builder relationshipTypes(List<String> relationshipTypes) {
            this.config.put("relationshipTypes", relationshipTypes);
            return this;
        }

        public Builder nodeLabels(List<String> nodeLabels) {
            this.config.put("nodeLabels", nodeLabels);
            return this;
        }

        public Builder usernameOverride(String usernameOverride) {
            this.config.put("username", usernameOverride);
            return this;
        }

        public Builder sudo(boolean sudo) {
            this.config.put("sudo", sudo);
            return this;
        }

        public Builder concurrency(int concurrency) {
            this.config.put("concurrency", concurrency);
            return this;
        }

        public Builder modelName(String modelName) {
            this.config.put("modelName", modelName);
            return this;
        }

        public Builder batchSize(int batchSize) {
            this.config.put("batchSize", batchSize);
            return this;
        }

        public Builder relationshipWeightProperty(String relationshipWeightProperty) {
            this.config.put("relationshipWeightProperty", relationshipWeightProperty);
            return this;
        }

        public Builder featureProperties(List<String> featureProperties) {
            this.config.put("featureProperties", featureProperties);
            return this;
        }

        public Builder randomSeed(Long randomSeed) {
            this.config.put("randomSeed", randomSeed);
            return this;
        }

        public Builder randomSeed(Optional<Long> randomSeed) {
            randomSeed.ifPresent(actualrandomSeed -> this.config.put("randomSeed", actualrandomSeed));
            return this;
        }

        public GraphSageTrainConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new GraphSageTrainConfigImpl(this.username, config);
        }
    }
}

