/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.graphsage.algo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.config.WritePropertyConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.embeddings.graphsage.algo.GraphSageWriteConfig;
import org.neo4j.gds.model.ModelConfig;

public final class GraphSageWriteConfigImpl
implements GraphSageWriteConfig {
    private List<String> relationshipTypes;
    private List<String> nodeLabels;
    @Nullable
    private String usernameOverride;
    private boolean sudo;
    private int concurrency;
    private int batchSize;
    private String modelName;
    private String username;
    @Nullable
    private String relationshipWeightProperty;
    private String writeProperty;
    private int writeConcurrency;

    public GraphSageWriteConfigImpl(@NotNull String username, @NotNull CypherMapWrapper config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.relationshipTypes = (List)CypherMapWrapper.failOnNull((String)"relationshipTypes", (Object)((List)config.getChecked("relationshipTypes", (Object)GraphSageWriteConfig.super.relationshipTypes(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.nodeLabels = (List)CypherMapWrapper.failOnNull((String)"nodeLabels", (Object)((List)config.getChecked("nodeLabels", (Object)GraphSageWriteConfig.super.nodeLabels(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.usernameOverride = StringUtils.trimToNull((String)config.getString("username", GraphSageWriteConfig.super.usernameOverride()));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sudo = config.getBool("sudo", GraphSageWriteConfig.super.sudo());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.concurrency = config.getInt("concurrency", GraphSageWriteConfig.super.concurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.batchSize = config.getInt("batchSize", GraphSageWriteConfig.super.batchSize());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.modelName = (String)CypherMapWrapper.failOnNull((String)"modelName", (Object)ModelConfig.validateName((String)config.requireString("modelName")));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.username = (String)CypherMapWrapper.failOnNull((String)"username", (Object)username);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipWeightProperty = RelationshipWeightConfig.validatePropertyName((String)config.getString("relationshipWeightProperty", GraphSageWriteConfig.super.relationshipWeightProperty()));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.writeProperty = (String)CypherMapWrapper.failOnNull((String)"writeProperty", (Object)WritePropertyConfig.validatePropertyName((String)config.requireString("writeProperty")));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.writeConcurrency = config.getInt("writeConcurrency", GraphSageWriteConfig.super.writeConcurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validateConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.validateWriteConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    public List<String> relationshipTypes() {
        return this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        return this.nodeLabels;
    }

    public void graphStoreValidation(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        this.relationshipWeightValidation(graphStore, selectedLabels, selectedRelationshipTypes);
    }

    @Nullable
    public String usernameOverride() {
        return this.usernameOverride;
    }

    public boolean sudo() {
        return this.sudo;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("relationshipTypes", "nodeLabels", "username", "sudo", "concurrency", "batchSize", "modelName", "relationshipWeightProperty", "writeProperty", "writeConcurrency");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("relationshipTypes", this.relationshipTypes());
        map.put("nodeLabels", this.nodeLabels());
        map.put("username", this.usernameOverride());
        map.put("sudo", this.sudo());
        map.put("concurrency", this.concurrency());
        map.put("batchSize", this.batchSize());
        map.put("modelName", this.modelName());
        map.put("relationshipWeightProperty", this.relationshipWeightProperty());
        map.put("writeProperty", this.writeProperty());
        map.put("writeConcurrency", this.writeConcurrency());
        return map;
    }

    public int concurrency() {
        return this.concurrency;
    }

    public int batchSize() {
        return this.batchSize;
    }

    public String modelName() {
        return this.modelName;
    }

    public String username() {
        return this.username;
    }

    @Nullable
    public String relationshipWeightProperty() {
        return this.relationshipWeightProperty;
    }

    public String writeProperty() {
        return this.writeProperty;
    }

    public int writeConcurrency() {
        return this.writeConcurrency;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();
        @NotNull
        private String username;

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder relationshipTypes(List<String> relationshipTypes) {
            this.config.put("relationshipTypes", relationshipTypes);
            return this;
        }

        public Builder nodeLabels(List<String> nodeLabels) {
            this.config.put("nodeLabels", nodeLabels);
            return this;
        }

        public Builder usernameOverride(String usernameOverride) {
            this.config.put("username", usernameOverride);
            return this;
        }

        public Builder sudo(boolean sudo) {
            this.config.put("sudo", sudo);
            return this;
        }

        public Builder concurrency(int concurrency) {
            this.config.put("concurrency", concurrency);
            return this;
        }

        public Builder batchSize(int batchSize) {
            this.config.put("batchSize", batchSize);
            return this;
        }

        public Builder modelName(String modelName) {
            this.config.put("modelName", modelName);
            return this;
        }

        public Builder relationshipWeightProperty(String relationshipWeightProperty) {
            this.config.put("relationshipWeightProperty", relationshipWeightProperty);
            return this;
        }

        public Builder writeProperty(String writeProperty) {
            this.config.put("writeProperty", writeProperty);
            return this;
        }

        public Builder writeConcurrency(int writeConcurrency) {
            this.config.put("writeConcurrency", writeConcurrency);
            return this;
        }

        public GraphSageWriteConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new GraphSageWriteConfigImpl(this.username, config);
        }
    }
}

