/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.graphsage.algo;

import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.BatchSizeConfig;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.config.EmbeddingDimensionConfig;
import org.neo4j.gds.config.FeaturePropertiesConfig;
import org.neo4j.gds.config.IterationsConfig;
import org.neo4j.gds.config.RandomSeedConfig;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.config.ToleranceConfig;
import org.neo4j.gds.embeddings.graphsage.ActivationFunction;
import org.neo4j.gds.embeddings.graphsage.Aggregator;
import org.neo4j.gds.embeddings.graphsage.algo.GraphSageTrainConfig;
import org.neo4j.gds.model.ModelConfig;

@Generated(from="GraphSageTrainConfig", generator="Immutables")
public final class ImmutableGraphSageTrainConfig
implements GraphSageTrainConfig {
    @Nullable
    private final String usernameOverride;
    private final boolean sudo;
    private final Collection<String> configKeys;
    private final Map<String, Object> toMap;
    private final int concurrency;
    private final int minBatchSize;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    private final String modelName;
    private final String username;
    private final int batchSize;
    @Nullable
    private final String relationshipWeightProperty;
    private final boolean hasRelationshipWeightProperty;
    private final List<String> featureProperties;
    private final Long randomSeed;
    private final int embeddingDimension;
    private final List<Integer> sampleSizes;
    private final Aggregator.AggregatorType aggregator;
    private final ActivationFunction activationFunction;
    private final double tolerance;
    private final double learningRate;
    private final int epochs;
    private final int maxIterations;
    private final int searchDepth;
    private final int negativeSampleWeight;
    private final Integer projectedFeatureDimension;
    private final boolean isWeighted;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final long serialVersionUID = 66L;

    private ImmutableGraphSageTrainConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, String modelName, String username, int batchSize, @Nullable String relationshipWeightProperty, Iterable<String> featureProperties, Optional<Long> randomSeed, int embeddingDimension, Iterable<Integer> sampleSizes, Aggregator.AggregatorType aggregator, ActivationFunction activationFunction, double tolerance, double learningRate, int epochs, int maxIterations, int searchDepth, int negativeSampleWeight, Optional<Integer> projectedFeatureDimension) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableGraphSageTrainConfig.createUnmodifiableList(false, ImmutableGraphSageTrainConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableGraphSageTrainConfig.createUnmodifiableList(false, ImmutableGraphSageTrainConfig.createSafeList(nodeLabels, true, false)));
        this.modelName = Objects.requireNonNull(modelName, "modelName");
        this.initShim.username(Objects.requireNonNull(username, "username"));
        this.initShim.batchSize(batchSize);
        this.initShim.relationshipWeightProperty(relationshipWeightProperty);
        this.initShim.featureProperties(ImmutableGraphSageTrainConfig.createUnmodifiableList(false, ImmutableGraphSageTrainConfig.createSafeList(featureProperties, true, false)));
        this.randomSeed = randomSeed.orElse(null);
        this.initShim.embeddingDimension(embeddingDimension);
        this.initShim.sampleSizes(ImmutableGraphSageTrainConfig.createUnmodifiableList(false, ImmutableGraphSageTrainConfig.createSafeList(sampleSizes, true, false)));
        this.initShim.aggregator(Objects.requireNonNull(aggregator, "aggregator"));
        this.initShim.activationFunction(Objects.requireNonNull(activationFunction, "activationFunction"));
        this.initShim.tolerance(tolerance);
        this.initShim.learningRate(learningRate);
        this.initShim.epochs(epochs);
        this.initShim.maxIterations(maxIterations);
        this.initShim.searchDepth(searchDepth);
        this.initShim.negativeSampleWeight(negativeSampleWeight);
        this.projectedFeatureDimension = projectedFeatureDimension.orElse(null);
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.username = this.initShim.username();
        this.batchSize = this.initShim.batchSize();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.featureProperties = this.initShim.featureProperties();
        this.embeddingDimension = this.initShim.embeddingDimension();
        this.sampleSizes = this.initShim.sampleSizes();
        this.aggregator = this.initShim.aggregator();
        this.activationFunction = this.initShim.activationFunction();
        this.tolerance = this.initShim.tolerance();
        this.learningRate = this.initShim.learningRate();
        this.epochs = this.initShim.epochs();
        this.maxIterations = this.initShim.maxIterations();
        this.searchDepth = this.initShim.searchDepth();
        this.negativeSampleWeight = this.initShim.negativeSampleWeight();
        this.isWeighted = this.initShim.isWeighted();
        this.initShim = null;
    }

    private ImmutableGraphSageTrainConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, String modelName, String username, int batchSize, @Nullable String relationshipWeightProperty, Iterable<String> featureProperties, Long randomSeed, int embeddingDimension, Iterable<Integer> sampleSizes, Aggregator.AggregatorType aggregator, ActivationFunction activationFunction, double tolerance, double learningRate, int epochs, int maxIterations, int searchDepth, int negativeSampleWeight, Integer projectedFeatureDimension) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableGraphSageTrainConfig.createUnmodifiableList(false, ImmutableGraphSageTrainConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableGraphSageTrainConfig.createUnmodifiableList(false, ImmutableGraphSageTrainConfig.createSafeList(nodeLabels, true, false)));
        this.modelName = Objects.requireNonNull(modelName, "modelName");
        this.initShim.username(Objects.requireNonNull(username, "username"));
        this.initShim.batchSize(batchSize);
        this.initShim.relationshipWeightProperty(relationshipWeightProperty);
        this.initShim.featureProperties(ImmutableGraphSageTrainConfig.createUnmodifiableList(false, ImmutableGraphSageTrainConfig.createSafeList(featureProperties, true, false)));
        this.randomSeed = randomSeed;
        this.initShim.embeddingDimension(embeddingDimension);
        this.initShim.sampleSizes(ImmutableGraphSageTrainConfig.createUnmodifiableList(false, ImmutableGraphSageTrainConfig.createSafeList(sampleSizes, true, false)));
        this.initShim.aggregator(Objects.requireNonNull(aggregator, "aggregator"));
        this.initShim.activationFunction(Objects.requireNonNull(activationFunction, "activationFunction"));
        this.initShim.tolerance(tolerance);
        this.initShim.learningRate(learningRate);
        this.initShim.epochs(epochs);
        this.initShim.maxIterations(maxIterations);
        this.initShim.searchDepth(searchDepth);
        this.initShim.negativeSampleWeight(negativeSampleWeight);
        this.projectedFeatureDimension = projectedFeatureDimension;
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.username = this.initShim.username();
        this.batchSize = this.initShim.batchSize();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.featureProperties = this.initShim.featureProperties();
        this.embeddingDimension = this.initShim.embeddingDimension();
        this.sampleSizes = this.initShim.sampleSizes();
        this.aggregator = this.initShim.aggregator();
        this.activationFunction = this.initShim.activationFunction();
        this.tolerance = this.initShim.tolerance();
        this.learningRate = this.initShim.learningRate();
        this.epochs = this.initShim.epochs();
        this.maxIterations = this.initShim.maxIterations();
        this.searchDepth = this.initShim.searchDepth();
        this.negativeSampleWeight = this.initShim.negativeSampleWeight();
        this.isWeighted = this.initShim.isWeighted();
        this.initShim = null;
    }

    private ImmutableGraphSageTrainConfig(Builder builder) {
        this.modelName = builder.modelName;
        this.randomSeed = builder.randomSeed;
        this.projectedFeatureDimension = builder.projectedFeatureDimension;
        if (builder.usernameOverrideIsSet()) {
            this.initShim.usernameOverride(builder.usernameOverride);
        }
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.minBatchSizeIsSet()) {
            this.initShim.minBatchSize(builder.minBatchSize);
        }
        if (builder.relationshipTypesIsSet()) {
            this.initShim.relationshipTypes(builder.relationshipTypes == null ? Collections.emptyList() : ImmutableGraphSageTrainConfig.createUnmodifiableList(true, builder.relationshipTypes));
        }
        if (builder.nodeLabelsIsSet()) {
            this.initShim.nodeLabels(builder.nodeLabels == null ? Collections.emptyList() : ImmutableGraphSageTrainConfig.createUnmodifiableList(true, builder.nodeLabels));
        }
        if (builder.username != null) {
            this.initShim.username(builder.username);
        }
        if (builder.batchSizeIsSet()) {
            this.initShim.batchSize(builder.batchSize);
        }
        if (builder.relationshipWeightPropertyIsSet()) {
            this.initShim.relationshipWeightProperty(builder.relationshipWeightProperty);
        }
        if (builder.featurePropertiesIsSet()) {
            this.initShim.featureProperties(builder.featureProperties == null ? Collections.emptyList() : ImmutableGraphSageTrainConfig.createUnmodifiableList(true, builder.featureProperties));
        }
        if (builder.embeddingDimensionIsSet()) {
            this.initShim.embeddingDimension(builder.embeddingDimension);
        }
        if (builder.sampleSizesIsSet()) {
            this.initShim.sampleSizes(builder.sampleSizes == null ? Collections.emptyList() : ImmutableGraphSageTrainConfig.createUnmodifiableList(true, builder.sampleSizes));
        }
        if (builder.aggregator != null) {
            this.initShim.aggregator(builder.aggregator);
        }
        if (builder.activationFunction != null) {
            this.initShim.activationFunction(builder.activationFunction);
        }
        if (builder.toleranceIsSet()) {
            this.initShim.tolerance(builder.tolerance);
        }
        if (builder.learningRateIsSet()) {
            this.initShim.learningRate(builder.learningRate);
        }
        if (builder.epochsIsSet()) {
            this.initShim.epochs(builder.epochs);
        }
        if (builder.maxIterationsIsSet()) {
            this.initShim.maxIterations(builder.maxIterations);
        }
        if (builder.searchDepthIsSet()) {
            this.initShim.searchDepth(builder.searchDepth);
        }
        if (builder.negativeSampleWeightIsSet()) {
            this.initShim.negativeSampleWeight(builder.negativeSampleWeight);
        }
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.username = this.initShim.username();
        this.batchSize = this.initShim.batchSize();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.featureProperties = this.initShim.featureProperties();
        this.embeddingDimension = this.initShim.embeddingDimension();
        this.sampleSizes = this.initShim.sampleSizes();
        this.aggregator = this.initShim.aggregator();
        this.activationFunction = this.initShim.activationFunction();
        this.tolerance = this.initShim.tolerance();
        this.learningRate = this.initShim.learningRate();
        this.epochs = this.initShim.epochs();
        this.maxIterations = this.initShim.maxIterations();
        this.searchDepth = this.initShim.searchDepth();
        this.negativeSampleWeight = this.initShim.negativeSampleWeight();
        this.isWeighted = this.initShim.isWeighted();
        this.initShim = null;
    }

    private ImmutableGraphSageTrainConfig(@Nullable String usernameOverride, boolean sudo, Collection<String> configKeys, int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, String modelName, String username, int batchSize, @Nullable String relationshipWeightProperty, List<String> featureProperties, Long randomSeed, int embeddingDimension, List<Integer> sampleSizes, Aggregator.AggregatorType aggregator, ActivationFunction activationFunction, double tolerance, double learningRate, int epochs, int maxIterations, int searchDepth, int negativeSampleWeight, Integer projectedFeatureDimension) {
        this.initShim.usernameOverride(usernameOverride);
        this.initShim.sudo(sudo);
        this.initShim.configKeys(configKeys);
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(relationshipTypes);
        this.initShim.nodeLabels(nodeLabels);
        this.modelName = modelName;
        this.initShim.username(username);
        this.initShim.batchSize(batchSize);
        this.initShim.relationshipWeightProperty(relationshipWeightProperty);
        this.initShim.featureProperties(featureProperties);
        this.randomSeed = randomSeed;
        this.initShim.embeddingDimension(embeddingDimension);
        this.initShim.sampleSizes(sampleSizes);
        this.initShim.aggregator(aggregator);
        this.initShim.activationFunction(activationFunction);
        this.initShim.tolerance(tolerance);
        this.initShim.learningRate(learningRate);
        this.initShim.epochs(epochs);
        this.initShim.maxIterations(maxIterations);
        this.initShim.searchDepth(searchDepth);
        this.initShim.negativeSampleWeight(negativeSampleWeight);
        this.projectedFeatureDimension = projectedFeatureDimension;
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.username = this.initShim.username();
        this.batchSize = this.initShim.batchSize();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.featureProperties = this.initShim.featureProperties();
        this.embeddingDimension = this.initShim.embeddingDimension();
        this.sampleSizes = this.initShim.sampleSizes();
        this.aggregator = this.initShim.aggregator();
        this.activationFunction = this.initShim.activationFunction();
        this.tolerance = this.initShim.tolerance();
        this.learningRate = this.initShim.learningRate();
        this.epochs = this.initShim.epochs();
        this.maxIterations = this.initShim.maxIterations();
        this.searchDepth = this.initShim.searchDepth();
        this.negativeSampleWeight = this.initShim.negativeSampleWeight();
        this.isWeighted = this.initShim.isWeighted();
        this.initShim = null;
    }

    @Nullable
    private String usernameOverrideInitialize() {
        return GraphSageTrainConfig.super.usernameOverride();
    }

    private boolean sudoInitialize() {
        return GraphSageTrainConfig.super.sudo();
    }

    private Collection<String> configKeysInitialize() {
        return GraphSageTrainConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return GraphSageTrainConfig.super.toMap();
    }

    private int concurrencyInitialize() {
        return GraphSageTrainConfig.super.concurrency();
    }

    private int minBatchSizeInitialize() {
        return GraphSageTrainConfig.super.minBatchSize();
    }

    private List<String> relationshipTypesInitialize() {
        return GraphSageTrainConfig.super.relationshipTypes();
    }

    private List<String> nodeLabelsInitialize() {
        return GraphSageTrainConfig.super.nodeLabels();
    }

    private String usernameInitialize() {
        return GraphSageTrainConfig.super.username();
    }

    private int batchSizeInitialize() {
        return GraphSageTrainConfig.super.batchSize();
    }

    @Nullable
    private String relationshipWeightPropertyInitialize() {
        return GraphSageTrainConfig.super.relationshipWeightProperty();
    }

    private boolean hasRelationshipWeightPropertyInitialize() {
        return GraphSageTrainConfig.super.hasRelationshipWeightProperty();
    }

    private List<String> featurePropertiesInitialize() {
        return GraphSageTrainConfig.super.featureProperties();
    }

    private int embeddingDimensionInitialize() {
        return GraphSageTrainConfig.super.embeddingDimension();
    }

    private List<Integer> sampleSizesInitialize() {
        return GraphSageTrainConfig.super.sampleSizes();
    }

    private Aggregator.AggregatorType aggregatorInitialize() {
        return GraphSageTrainConfig.super.aggregator();
    }

    private ActivationFunction activationFunctionInitialize() {
        return GraphSageTrainConfig.super.activationFunction();
    }

    private double toleranceInitialize() {
        return GraphSageTrainConfig.super.tolerance();
    }

    private double learningRateInitialize() {
        return GraphSageTrainConfig.super.learningRate();
    }

    private int epochsInitialize() {
        return GraphSageTrainConfig.super.epochs();
    }

    private int maxIterationsInitialize() {
        return GraphSageTrainConfig.super.maxIterations();
    }

    private int searchDepthInitialize() {
        return GraphSageTrainConfig.super.searchDepth();
    }

    private int negativeSampleWeightInitialize() {
        return GraphSageTrainConfig.super.negativeSampleWeight();
    }

    private boolean isWeightedInitialize() {
        return GraphSageTrainConfig.super.isWeighted();
    }

    @Nullable
    public String usernameOverride() {
        InitShim shim = this.initShim;
        return shim != null ? shim.usernameOverride() : this.usernameOverride;
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    public int minBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minBatchSize() : this.minBatchSize;
    }

    public List<String> relationshipTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipTypes() : this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeLabels() : this.nodeLabels;
    }

    public String modelName() {
        return this.modelName;
    }

    public String username() {
        InitShim shim = this.initShim;
        return shim != null ? shim.username() : this.username;
    }

    public int batchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.batchSize() : this.batchSize;
    }

    @Nullable
    public String relationshipWeightProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipWeightProperty() : this.relationshipWeightProperty;
    }

    public boolean hasRelationshipWeightProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasRelationshipWeightProperty() : this.hasRelationshipWeightProperty;
    }

    public List<String> featureProperties() {
        InitShim shim = this.initShim;
        return shim != null ? shim.featureProperties() : this.featureProperties;
    }

    public Optional<Long> randomSeed() {
        return Optional.ofNullable(this.randomSeed);
    }

    @Override
    public int embeddingDimension() {
        InitShim shim = this.initShim;
        return shim != null ? shim.embeddingDimension() : this.embeddingDimension;
    }

    @Override
    public List<Integer> sampleSizes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sampleSizes() : this.sampleSizes;
    }

    @Override
    public Aggregator.AggregatorType aggregator() {
        InitShim shim = this.initShim;
        return shim != null ? shim.aggregator() : this.aggregator;
    }

    @Override
    public ActivationFunction activationFunction() {
        InitShim shim = this.initShim;
        return shim != null ? shim.activationFunction() : this.activationFunction;
    }

    @Override
    public double tolerance() {
        InitShim shim = this.initShim;
        return shim != null ? shim.tolerance() : this.tolerance;
    }

    @Override
    public double learningRate() {
        InitShim shim = this.initShim;
        return shim != null ? shim.learningRate() : this.learningRate;
    }

    @Override
    public int epochs() {
        InitShim shim = this.initShim;
        return shim != null ? shim.epochs() : this.epochs;
    }

    @Override
    public int maxIterations() {
        InitShim shim = this.initShim;
        return shim != null ? shim.maxIterations() : this.maxIterations;
    }

    @Override
    public int searchDepth() {
        InitShim shim = this.initShim;
        return shim != null ? shim.searchDepth() : this.searchDepth;
    }

    @Override
    public int negativeSampleWeight() {
        InitShim shim = this.initShim;
        return shim != null ? shim.negativeSampleWeight() : this.negativeSampleWeight;
    }

    @Override
    public Optional<Integer> projectedFeatureDimension() {
        return Optional.ofNullable(this.projectedFeatureDimension);
    }

    @Override
    public boolean isWeighted() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isWeighted() : this.isWeighted;
    }

    public final ImmutableGraphSageTrainConfig withUsernameOverride(@Nullable String value) {
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(value, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.modelName, this.username, this.batchSize, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, value, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.modelName, this.username, this.batchSize, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, newValue, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.modelName, this.username, this.batchSize, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.configKeys, value, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.modelName, this.username, this.batchSize, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withMinBatchSize(int value) {
        if (this.minBatchSize == value) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, value, this.relationshipTypes, this.nodeLabels, this.modelName, this.username, this.batchSize, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withRelationshipTypes(String ... elements) {
        List<String> newValue = ImmutableGraphSageTrainConfig.createUnmodifiableList(false, ImmutableGraphSageTrainConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.nodeLabels, this.modelName, this.username, this.batchSize, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withRelationshipTypes(Iterable<String> elements) {
        if (this.relationshipTypes == elements) {
            return this;
        }
        List<String> newValue = ImmutableGraphSageTrainConfig.createUnmodifiableList(false, ImmutableGraphSageTrainConfig.createSafeList(elements, true, false));
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.nodeLabels, this.modelName, this.username, this.batchSize, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withNodeLabels(String ... elements) {
        List<String> newValue = ImmutableGraphSageTrainConfig.createUnmodifiableList(false, ImmutableGraphSageTrainConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, newValue, this.modelName, this.username, this.batchSize, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withNodeLabels(Iterable<String> elements) {
        if (this.nodeLabels == elements) {
            return this;
        }
        List<String> newValue = ImmutableGraphSageTrainConfig.createUnmodifiableList(false, ImmutableGraphSageTrainConfig.createSafeList(elements, true, false));
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, newValue, this.modelName, this.username, this.batchSize, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withModelName(String value) {
        String newValue = Objects.requireNonNull(value, "modelName");
        if (this.modelName.equals(newValue)) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, newValue, this.username, this.batchSize, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (this.username.equals(newValue)) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.modelName, newValue, this.batchSize, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withBatchSize(int value) {
        if (this.batchSize == value) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.modelName, this.username, value, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withRelationshipWeightProperty(@Nullable String value) {
        if (Objects.equals(this.relationshipWeightProperty, value)) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.modelName, this.username, this.batchSize, value, this.featureProperties, this.randomSeed, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withFeatureProperties(String ... elements) {
        List<String> newValue = ImmutableGraphSageTrainConfig.createUnmodifiableList(false, ImmutableGraphSageTrainConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.modelName, this.username, this.batchSize, this.relationshipWeightProperty, newValue, this.randomSeed, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withFeatureProperties(Iterable<String> elements) {
        if (this.featureProperties == elements) {
            return this;
        }
        List<String> newValue = ImmutableGraphSageTrainConfig.createUnmodifiableList(false, ImmutableGraphSageTrainConfig.createSafeList(elements, true, false));
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.modelName, this.username, this.batchSize, this.relationshipWeightProperty, newValue, this.randomSeed, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withRandomSeed(Long value) {
        Long newValue = value;
        if (Objects.equals(this.randomSeed, newValue)) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.modelName, this.username, this.batchSize, this.relationshipWeightProperty, this.featureProperties, newValue, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withRandomSeed(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.randomSeed, value)) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.modelName, this.username, this.batchSize, this.relationshipWeightProperty, this.featureProperties, value, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withEmbeddingDimension(int value) {
        if (this.embeddingDimension == value) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.modelName, this.username, this.batchSize, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, value, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withSampleSizes(int ... elements) {
        ArrayList<Integer> wrappedList = new ArrayList<Integer>(elements.length);
        for (int element : elements) {
            wrappedList.add(element);
        }
        List<Integer> newValue = ImmutableGraphSageTrainConfig.createUnmodifiableList(false, wrappedList);
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.modelName, this.username, this.batchSize, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.embeddingDimension, newValue, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withSampleSizes(Iterable<Integer> elements) {
        if (this.sampleSizes == elements) {
            return this;
        }
        List<Integer> newValue = ImmutableGraphSageTrainConfig.createUnmodifiableList(false, ImmutableGraphSageTrainConfig.createSafeList(elements, true, false));
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.modelName, this.username, this.batchSize, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.embeddingDimension, newValue, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withAggregator(Aggregator.AggregatorType value) {
        if (this.aggregator == value) {
            return this;
        }
        Aggregator.AggregatorType newValue = Objects.requireNonNull(value, "aggregator");
        if (this.aggregator.equals((Object)newValue)) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.modelName, this.username, this.batchSize, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.embeddingDimension, this.sampleSizes, newValue, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withActivationFunction(ActivationFunction value) {
        if (this.activationFunction == value) {
            return this;
        }
        ActivationFunction newValue = Objects.requireNonNull(value, "activationFunction");
        if (this.activationFunction.equals((Object)newValue)) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.modelName, this.username, this.batchSize, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.embeddingDimension, this.sampleSizes, this.aggregator, newValue, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withTolerance(double value) {
        if (Double.doubleToLongBits(this.tolerance) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.modelName, this.username, this.batchSize, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, value, this.learningRate, this.epochs, this.maxIterations, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withLearningRate(double value) {
        if (Double.doubleToLongBits(this.learningRate) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.modelName, this.username, this.batchSize, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, value, this.epochs, this.maxIterations, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withEpochs(int value) {
        if (this.epochs == value) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.modelName, this.username, this.batchSize, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, value, this.maxIterations, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withMaxIterations(int value) {
        if (this.maxIterations == value) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.modelName, this.username, this.batchSize, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, value, this.searchDepth, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withSearchDepth(int value) {
        if (this.searchDepth == value) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.modelName, this.username, this.batchSize, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, value, this.negativeSampleWeight, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withNegativeSampleWeight(int value) {
        if (this.negativeSampleWeight == value) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.modelName, this.username, this.batchSize, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.searchDepth, value, this.projectedFeatureDimension));
    }

    public final ImmutableGraphSageTrainConfig withProjectedFeatureDimension(Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.projectedFeatureDimension, newValue)) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.modelName, this.username, this.batchSize, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.searchDepth, this.negativeSampleWeight, newValue));
    }

    public final ImmutableGraphSageTrainConfig withProjectedFeatureDimension(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.projectedFeatureDimension, value)) {
            return this;
        }
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.modelName, this.username, this.batchSize, this.relationshipWeightProperty, this.featureProperties, this.randomSeed, this.embeddingDimension, this.sampleSizes, this.aggregator, this.activationFunction, this.tolerance, this.learningRate, this.epochs, this.maxIterations, this.searchDepth, this.negativeSampleWeight, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGraphSageTrainConfig && this.equalTo((ImmutableGraphSageTrainConfig)another);
    }

    private boolean equalTo(ImmutableGraphSageTrainConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && this.concurrency == another.concurrency && this.minBatchSize == another.minBatchSize && this.relationshipTypes.equals(another.relationshipTypes) && this.nodeLabels.equals(another.nodeLabels) && this.modelName.equals(another.modelName) && this.username.equals(another.username) && this.batchSize == another.batchSize && Objects.equals(this.relationshipWeightProperty, another.relationshipWeightProperty) && this.hasRelationshipWeightProperty == another.hasRelationshipWeightProperty && this.featureProperties.equals(another.featureProperties) && Objects.equals(this.randomSeed, another.randomSeed) && this.embeddingDimension == another.embeddingDimension && this.sampleSizes.equals(another.sampleSizes) && this.aggregator.equals((Object)another.aggregator) && this.activationFunction.equals((Object)another.activationFunction) && Double.doubleToLongBits(this.tolerance) == Double.doubleToLongBits(another.tolerance) && Double.doubleToLongBits(this.learningRate) == Double.doubleToLongBits(another.learningRate) && this.epochs == another.epochs && this.maxIterations == another.maxIterations && this.searchDepth == another.searchDepth && this.negativeSampleWeight == another.negativeSampleWeight && Objects.equals(this.projectedFeatureDimension, another.projectedFeatureDimension) && this.isWeighted == another.isWeighted;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + this.concurrency;
        h += (h << 5) + this.minBatchSize;
        h += (h << 5) + this.relationshipTypes.hashCode();
        h += (h << 5) + this.nodeLabels.hashCode();
        h += (h << 5) + this.modelName.hashCode();
        h += (h << 5) + this.username.hashCode();
        h += (h << 5) + this.batchSize;
        h += (h << 5) + Objects.hashCode(this.relationshipWeightProperty);
        h += (h << 5) + Boolean.hashCode(this.hasRelationshipWeightProperty);
        h += (h << 5) + this.featureProperties.hashCode();
        h += (h << 5) + Objects.hashCode(this.randomSeed);
        h += (h << 5) + this.embeddingDimension;
        h += (h << 5) + this.sampleSizes.hashCode();
        h += (h << 5) + this.aggregator.hashCode();
        h += (h << 5) + this.activationFunction.hashCode();
        h += (h << 5) + Double.hashCode(this.tolerance);
        h += (h << 5) + Double.hashCode(this.learningRate);
        h += (h << 5) + this.epochs;
        h += (h << 5) + this.maxIterations;
        h += (h << 5) + this.searchDepth;
        h += (h << 5) + this.negativeSampleWeight;
        h += (h << 5) + Objects.hashCode(this.projectedFeatureDimension);
        h += (h << 5) + Boolean.hashCode(this.isWeighted);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("GraphSageTrainConfig{");
        if (this.usernameOverride != null) {
            builder.append("usernameOverride=").append(this.usernameOverride);
        }
        if (builder.length() > 21) {
            builder.append(", ");
        }
        builder.append("sudo=").append(this.sudo);
        builder.append(", ");
        builder.append("concurrency=").append(this.concurrency);
        builder.append(", ");
        builder.append("minBatchSize=").append(this.minBatchSize);
        builder.append(", ");
        builder.append("relationshipTypes=").append(this.relationshipTypes);
        builder.append(", ");
        builder.append("nodeLabels=").append(this.nodeLabels);
        builder.append(", ");
        builder.append("modelName=").append(this.modelName);
        builder.append(", ");
        builder.append("username=").append(this.username);
        builder.append(", ");
        builder.append("batchSize=").append(this.batchSize);
        if (this.relationshipWeightProperty != null) {
            builder.append(", ");
            builder.append("relationshipWeightProperty=").append(this.relationshipWeightProperty);
        }
        builder.append(", ");
        builder.append("hasRelationshipWeightProperty=").append(this.hasRelationshipWeightProperty);
        builder.append(", ");
        builder.append("featureProperties=").append(this.featureProperties);
        if (this.randomSeed != null) {
            builder.append(", ");
            builder.append("randomSeed=").append(this.randomSeed);
        }
        builder.append(", ");
        builder.append("embeddingDimension=").append(this.embeddingDimension);
        builder.append(", ");
        builder.append("sampleSizes=").append(this.sampleSizes);
        builder.append(", ");
        builder.append("aggregator=").append((Object)this.aggregator);
        builder.append(", ");
        builder.append("activationFunction=").append((Object)this.activationFunction);
        builder.append(", ");
        builder.append("tolerance=").append(this.tolerance);
        builder.append(", ");
        builder.append("learningRate=").append(this.learningRate);
        builder.append(", ");
        builder.append("epochs=").append(this.epochs);
        builder.append(", ");
        builder.append("maxIterations=").append(this.maxIterations);
        builder.append(", ");
        builder.append("searchDepth=").append(this.searchDepth);
        builder.append(", ");
        builder.append("negativeSampleWeight=").append(this.negativeSampleWeight);
        if (this.projectedFeatureDimension != null) {
            builder.append(", ");
            builder.append("projectedFeatureDimension=").append(this.projectedFeatureDimension);
        }
        builder.append(", ");
        builder.append("isWeighted=").append(this.isWeighted);
        return builder.append("}").toString();
    }

    public static GraphSageTrainConfig of(int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, String modelName, String username, int batchSize, @Nullable String relationshipWeightProperty, List<String> featureProperties, Optional<Long> randomSeed, int embeddingDimension, List<Integer> sampleSizes, Aggregator.AggregatorType aggregator, ActivationFunction activationFunction, double tolerance, double learningRate, int epochs, int maxIterations, int searchDepth, int negativeSampleWeight, Optional<Integer> projectedFeatureDimension) {
        return ImmutableGraphSageTrainConfig.of(concurrency, minBatchSize, relationshipTypes, nodeLabels, modelName, username, batchSize, relationshipWeightProperty, featureProperties, randomSeed, embeddingDimension, sampleSizes, aggregator, activationFunction, tolerance, learningRate, epochs, maxIterations, searchDepth, negativeSampleWeight, projectedFeatureDimension);
    }

    public static GraphSageTrainConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, String modelName, String username, int batchSize, @Nullable String relationshipWeightProperty, Iterable<String> featureProperties, Optional<Long> randomSeed, int embeddingDimension, Iterable<Integer> sampleSizes, Aggregator.AggregatorType aggregator, ActivationFunction activationFunction, double tolerance, double learningRate, int epochs, int maxIterations, int searchDepth, int negativeSampleWeight, Optional<Integer> projectedFeatureDimension) {
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, modelName, username, batchSize, relationshipWeightProperty, featureProperties, randomSeed, embeddingDimension, sampleSizes, aggregator, activationFunction, tolerance, learningRate, epochs, maxIterations, searchDepth, negativeSampleWeight, projectedFeatureDimension));
    }

    public static GraphSageTrainConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, String modelName, String username, int batchSize, @Nullable String relationshipWeightProperty, Iterable<String> featureProperties, Long randomSeed, int embeddingDimension, Iterable<Integer> sampleSizes, Aggregator.AggregatorType aggregator, ActivationFunction activationFunction, double tolerance, double learningRate, int epochs, int maxIterations, int searchDepth, int negativeSampleWeight, Integer projectedFeatureDimension) {
        return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, modelName, username, batchSize, relationshipWeightProperty, featureProperties, randomSeed, embeddingDimension, sampleSizes, aggregator, activationFunction, tolerance, learningRate, epochs, maxIterations, searchDepth, negativeSampleWeight, projectedFeatureDimension));
    }

    private static ImmutableGraphSageTrainConfig validate(ImmutableGraphSageTrainConfig instance) {
        instance.validate();
        instance.validateConcurrency();
        return instance;
    }

    public static GraphSageTrainConfig copyOf(GraphSageTrainConfig instance) {
        if (instance instanceof ImmutableGraphSageTrainConfig) {
            return (ImmutableGraphSageTrainConfig)instance;
        }
        return ImmutableGraphSageTrainConfig.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return ImmutableGraphSageTrainConfig.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="GraphSageTrainConfig", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_MODEL_NAME = 1L;
        private static final long OPT_BIT_USERNAME_OVERRIDE = 1L;
        private static final long OPT_BIT_SUDO = 2L;
        private static final long OPT_BIT_CONCURRENCY = 4L;
        private static final long OPT_BIT_MIN_BATCH_SIZE = 8L;
        private static final long OPT_BIT_RELATIONSHIP_TYPES = 16L;
        private static final long OPT_BIT_NODE_LABELS = 32L;
        private static final long OPT_BIT_BATCH_SIZE = 64L;
        private static final long OPT_BIT_RELATIONSHIP_WEIGHT_PROPERTY = 128L;
        private static final long OPT_BIT_FEATURE_PROPERTIES = 256L;
        private static final long OPT_BIT_EMBEDDING_DIMENSION = 512L;
        private static final long OPT_BIT_SAMPLE_SIZES = 1024L;
        private static final long OPT_BIT_TOLERANCE = 2048L;
        private static final long OPT_BIT_LEARNING_RATE = 4096L;
        private static final long OPT_BIT_EPOCHS = 8192L;
        private static final long OPT_BIT_MAX_ITERATIONS = 16384L;
        private static final long OPT_BIT_SEARCH_DEPTH = 32768L;
        private static final long OPT_BIT_NEGATIVE_SAMPLE_WEIGHT = 65536L;
        private long initBits = 1L;
        private long optBits;
        private String usernameOverride;
        private boolean sudo;
        private Collection<String> configKeys;
        private int concurrency;
        private int minBatchSize;
        private List<String> relationshipTypes = null;
        private List<String> nodeLabels = null;
        private String modelName;
        private String username;
        private int batchSize;
        private String relationshipWeightProperty;
        private List<String> featureProperties = null;
        private Long randomSeed;
        private int embeddingDimension;
        private List<Integer> sampleSizes = null;
        private Aggregator.AggregatorType aggregator;
        private ActivationFunction activationFunction;
        private double tolerance;
        private double learningRate;
        private int epochs;
        private int maxIterations;
        private int searchDepth;
        private int negativeSampleWeight;
        private Integer projectedFeatureDimension;

        private Builder() {
        }

        public final Builder from(RelationshipWeightConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ModelConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ConcurrencyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ToleranceConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GraphSageTrainConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RandomSeedConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(FeaturePropertiesConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AlgoBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BatchSizeConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(IterationsConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EmbeddingDimensionConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional randomSeedOptional;
            RelationshipWeightConfig instance;
            String relationshipWeightPropertyValue;
            long bits = 0L;
            if (object instanceof RelationshipWeightConfig && (relationshipWeightPropertyValue = (instance = (RelationshipWeightConfig)object).relationshipWeightProperty()) != null) {
                this.relationshipWeightProperty(relationshipWeightPropertyValue);
            }
            if (object instanceof ModelConfig) {
                instance = (ModelConfig)object;
                this.modelName(instance.modelName());
                this.username(instance.username());
            }
            if (object instanceof ConcurrencyConfig) {
                instance = (ConcurrencyConfig)object;
                this.minBatchSize(instance.minBatchSize());
                this.concurrency(instance.concurrency());
            }
            if (object instanceof ToleranceConfig) {
                instance = (ToleranceConfig)object;
                if ((bits & 4L) == 0L) {
                    this.tolerance(instance.tolerance());
                    bits |= 4L;
                }
            }
            if (object instanceof GraphSageTrainConfig) {
                instance = (GraphSageTrainConfig)object;
                if ((bits & 1L) == 0L) {
                    this.maxIterations(instance.maxIterations());
                    bits |= 1L;
                }
                this.negativeSampleWeight(instance.negativeSampleWeight());
                this.searchDepth(instance.searchDepth());
                Optional<Integer> projectedFeatureDimensionOptional = instance.projectedFeatureDimension();
                if (projectedFeatureDimensionOptional.isPresent()) {
                    this.projectedFeatureDimension(projectedFeatureDimensionOptional);
                }
                this.aggregator(instance.aggregator());
                if ((bits & 2L) == 0L) {
                    this.embeddingDimension(instance.embeddingDimension());
                    bits |= 2L;
                }
                this.activationFunction(instance.activationFunction());
                this.addAllSampleSizes(instance.sampleSizes());
                this.epochs(instance.epochs());
                this.learningRate(instance.learningRate());
                if ((bits & 4L) == 0L) {
                    this.tolerance(instance.tolerance());
                    bits |= 4L;
                }
            }
            if (object instanceof RandomSeedConfig && (randomSeedOptional = (instance = (RandomSeedConfig)object).randomSeed()).isPresent()) {
                this.randomSeed(randomSeedOptional);
            }
            if (object instanceof FeaturePropertiesConfig) {
                instance = (FeaturePropertiesConfig)object;
                this.addAllFeatureProperties(instance.featureProperties());
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                @Nullable String usernameOverrideValue = instance.usernameOverride();
                if (usernameOverrideValue != null) {
                    this.usernameOverride(usernameOverrideValue);
                }
                this.configKeys(instance.configKeys());
                this.sudo(instance.sudo());
            }
            if (object instanceof AlgoBaseConfig) {
                instance = (AlgoBaseConfig)object;
                this.addAllRelationshipTypes(instance.relationshipTypes());
                this.addAllNodeLabels(instance.nodeLabels());
            }
            if (object instanceof BatchSizeConfig) {
                instance = (BatchSizeConfig)object;
                this.batchSize(instance.batchSize());
            }
            if (object instanceof IterationsConfig) {
                instance = (IterationsConfig)object;
                if ((bits & 1L) == 0L) {
                    this.maxIterations(instance.maxIterations());
                    bits |= 1L;
                }
            }
            if (object instanceof EmbeddingDimensionConfig) {
                instance = (EmbeddingDimensionConfig)object;
                if ((bits & 2L) == 0L) {
                    this.embeddingDimension(instance.embeddingDimension());
                    bits |= 2L;
                }
            }
        }

        public final Builder usernameOverride(@Nullable String usernameOverride) {
            this.usernameOverride = usernameOverride;
            this.optBits |= 1L;
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 2L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 4L;
            return this;
        }

        public final Builder minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.optBits |= 8L;
            return this;
        }

        public final Builder addRelationshipType(String element) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addRelationshipTypes(String ... elements) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder relationshipTypes(Iterable<String> elements) {
            this.relationshipTypes = new ArrayList<String>();
            return this.addAllRelationshipTypes(elements);
        }

        public final Builder addAllRelationshipTypes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "relationshipTypes element");
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addNodeLabel(String element) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder addNodeLabels(String ... elements) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder nodeLabels(Iterable<String> elements) {
            this.nodeLabels = new ArrayList<String>();
            return this.addAllNodeLabels(elements);
        }

        public final Builder addAllNodeLabels(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeLabels element");
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder modelName(String modelName) {
            this.modelName = Objects.requireNonNull(modelName, "modelName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            return this;
        }

        public final Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder relationshipWeightProperty(@Nullable String relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder addFeatureProperty(String element) {
            if (this.featureProperties == null) {
                this.featureProperties = new ArrayList<String>();
            }
            this.featureProperties.add(Objects.requireNonNull(element, "featureProperties element"));
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder addFeatureProperties(String ... elements) {
            if (this.featureProperties == null) {
                this.featureProperties = new ArrayList<String>();
            }
            for (String element : elements) {
                this.featureProperties.add(Objects.requireNonNull(element, "featureProperties element"));
            }
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder featureProperties(Iterable<String> elements) {
            this.featureProperties = new ArrayList<String>();
            return this.addAllFeatureProperties(elements);
        }

        public final Builder addAllFeatureProperties(Iterable<String> elements) {
            Objects.requireNonNull(elements, "featureProperties element");
            if (this.featureProperties == null) {
                this.featureProperties = new ArrayList<String>();
            }
            for (String element : elements) {
                this.featureProperties.add(Objects.requireNonNull(element, "featureProperties element"));
            }
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder randomSeed(Long randomSeed) {
            this.randomSeed = randomSeed;
            return this;
        }

        public final Builder randomSeed(Optional<Long> randomSeed) {
            this.randomSeed = randomSeed.orElse(null);
            return this;
        }

        public final Builder embeddingDimension(int embeddingDimension) {
            this.embeddingDimension = embeddingDimension;
            this.optBits |= 0x200L;
            return this;
        }

        public final Builder addSampleSize(int element) {
            if (this.sampleSizes == null) {
                this.sampleSizes = new ArrayList<Integer>();
            }
            this.sampleSizes.add(element);
            this.optBits |= 0x400L;
            return this;
        }

        public final Builder addSampleSizes(int ... elements) {
            if (this.sampleSizes == null) {
                this.sampleSizes = new ArrayList<Integer>();
            }
            for (int element : elements) {
                this.sampleSizes.add(element);
            }
            this.optBits |= 0x400L;
            return this;
        }

        public final Builder sampleSizes(Iterable<Integer> elements) {
            this.sampleSizes = new ArrayList<Integer>();
            return this.addAllSampleSizes(elements);
        }

        public final Builder addAllSampleSizes(Iterable<Integer> elements) {
            Objects.requireNonNull(elements, "sampleSizes element");
            if (this.sampleSizes == null) {
                this.sampleSizes = new ArrayList<Integer>();
            }
            for (int element : elements) {
                this.sampleSizes.add(Objects.requireNonNull(Integer.valueOf(element), "sampleSizes element"));
            }
            this.optBits |= 0x400L;
            return this;
        }

        public final Builder aggregator(Aggregator.AggregatorType aggregator) {
            this.aggregator = Objects.requireNonNull(aggregator, "aggregator");
            return this;
        }

        public final Builder activationFunction(ActivationFunction activationFunction) {
            this.activationFunction = Objects.requireNonNull(activationFunction, "activationFunction");
            return this;
        }

        public final Builder tolerance(double tolerance) {
            this.tolerance = tolerance;
            this.optBits |= 0x800L;
            return this;
        }

        public final Builder learningRate(double learningRate) {
            this.learningRate = learningRate;
            this.optBits |= 0x1000L;
            return this;
        }

        public final Builder epochs(int epochs) {
            this.epochs = epochs;
            this.optBits |= 0x2000L;
            return this;
        }

        public final Builder maxIterations(int maxIterations) {
            this.maxIterations = maxIterations;
            this.optBits |= 0x4000L;
            return this;
        }

        public final Builder searchDepth(int searchDepth) {
            this.searchDepth = searchDepth;
            this.optBits |= 0x8000L;
            return this;
        }

        public final Builder negativeSampleWeight(int negativeSampleWeight) {
            this.negativeSampleWeight = negativeSampleWeight;
            this.optBits |= 0x10000L;
            return this;
        }

        public final Builder projectedFeatureDimension(Integer projectedFeatureDimension) {
            this.projectedFeatureDimension = projectedFeatureDimension;
            return this;
        }

        public final Builder projectedFeatureDimension(Optional<Integer> projectedFeatureDimension) {
            this.projectedFeatureDimension = projectedFeatureDimension.orElse(null);
            return this;
        }

        public Builder clear() {
            this.initBits = 1L;
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.configKeys = null;
            this.concurrency = 0;
            this.minBatchSize = 0;
            if (this.relationshipTypes != null) {
                this.relationshipTypes.clear();
            }
            if (this.nodeLabels != null) {
                this.nodeLabels.clear();
            }
            this.modelName = null;
            this.username = null;
            this.batchSize = 0;
            this.relationshipWeightProperty = null;
            if (this.featureProperties != null) {
                this.featureProperties.clear();
            }
            this.randomSeed = null;
            this.embeddingDimension = 0;
            if (this.sampleSizes != null) {
                this.sampleSizes.clear();
            }
            this.aggregator = null;
            this.activationFunction = null;
            this.tolerance = 0.0;
            this.learningRate = 0.0;
            this.epochs = 0;
            this.maxIterations = 0;
            this.searchDepth = 0;
            this.negativeSampleWeight = 0;
            this.projectedFeatureDimension = null;
            return this;
        }

        public GraphSageTrainConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableGraphSageTrainConfig.validate(new ImmutableGraphSageTrainConfig(this));
        }

        private boolean usernameOverrideIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean sudoIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean minBatchSizeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean relationshipTypesIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean nodeLabelsIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean batchSizeIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean relationshipWeightPropertyIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean featurePropertiesIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean embeddingDimensionIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private boolean sampleSizesIsSet() {
            return (this.optBits & 0x400L) != 0L;
        }

        private boolean toleranceIsSet() {
            return (this.optBits & 0x800L) != 0L;
        }

        private boolean learningRateIsSet() {
            return (this.optBits & 0x1000L) != 0L;
        }

        private boolean epochsIsSet() {
            return (this.optBits & 0x2000L) != 0L;
        }

        private boolean maxIterationsIsSet() {
            return (this.optBits & 0x4000L) != 0L;
        }

        private boolean searchDepthIsSet() {
            return (this.optBits & 0x8000L) != 0L;
        }

        private boolean negativeSampleWeightIsSet() {
            return (this.optBits & 0x10000L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("modelName");
            }
            return "Cannot build GraphSageTrainConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="GraphSageTrainConfig", generator="Immutables")
    private final class InitShim {
        private byte usernameOverrideBuildStage = 0;
        private String usernameOverride;
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte concurrencyBuildStage = 0;
        private int concurrency;
        private byte minBatchSizeBuildStage = 0;
        private int minBatchSize;
        private byte relationshipTypesBuildStage = 0;
        private List<String> relationshipTypes;
        private byte nodeLabelsBuildStage = 0;
        private List<String> nodeLabels;
        private byte usernameBuildStage = 0;
        private String username;
        private byte batchSizeBuildStage = 0;
        private int batchSize;
        private byte relationshipWeightPropertyBuildStage = 0;
        private String relationshipWeightProperty;
        private byte hasRelationshipWeightPropertyBuildStage = 0;
        private boolean hasRelationshipWeightProperty;
        private byte featurePropertiesBuildStage = 0;
        private List<String> featureProperties;
        private byte embeddingDimensionBuildStage = 0;
        private int embeddingDimension;
        private byte sampleSizesBuildStage = 0;
        private List<Integer> sampleSizes;
        private byte aggregatorBuildStage = 0;
        private Aggregator.AggregatorType aggregator;
        private byte activationFunctionBuildStage = 0;
        private ActivationFunction activationFunction;
        private byte toleranceBuildStage = 0;
        private double tolerance;
        private byte learningRateBuildStage = 0;
        private double learningRate;
        private byte epochsBuildStage = 0;
        private int epochs;
        private byte maxIterationsBuildStage = 0;
        private int maxIterations;
        private byte searchDepthBuildStage = 0;
        private int searchDepth;
        private byte negativeSampleWeightBuildStage = 0;
        private int negativeSampleWeight;
        private byte isWeightedBuildStage = 0;
        private boolean isWeighted;

        private InitShim() {
        }

        String usernameOverride() {
            if (this.usernameOverrideBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usernameOverrideBuildStage == 0) {
                this.usernameOverrideBuildStage = (byte)-1;
                this.usernameOverride = ImmutableGraphSageTrainConfig.this.usernameOverrideInitialize();
                this.usernameOverrideBuildStage = 1;
            }
            return this.usernameOverride;
        }

        void usernameOverride(String usernameOverride) {
            this.usernameOverride = usernameOverride;
            this.usernameOverrideBuildStage = 1;
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableGraphSageTrainConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableGraphSageTrainConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableGraphSageTrainConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutableGraphSageTrainConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        int minBatchSize() {
            if (this.minBatchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minBatchSizeBuildStage == 0) {
                this.minBatchSizeBuildStage = (byte)-1;
                this.minBatchSize = ImmutableGraphSageTrainConfig.this.minBatchSizeInitialize();
                this.minBatchSizeBuildStage = 1;
            }
            return this.minBatchSize;
        }

        void minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.minBatchSizeBuildStage = 1;
        }

        List<String> relationshipTypes() {
            if (this.relationshipTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipTypesBuildStage == 0) {
                this.relationshipTypesBuildStage = (byte)-1;
                this.relationshipTypes = ImmutableGraphSageTrainConfig.createUnmodifiableList(false, ImmutableGraphSageTrainConfig.createSafeList(ImmutableGraphSageTrainConfig.this.relationshipTypesInitialize(), true, false));
                this.relationshipTypesBuildStage = 1;
            }
            return this.relationshipTypes;
        }

        void relationshipTypes(List<String> relationshipTypes) {
            this.relationshipTypes = relationshipTypes;
            this.relationshipTypesBuildStage = 1;
        }

        List<String> nodeLabels() {
            if (this.nodeLabelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeLabelsBuildStage == 0) {
                this.nodeLabelsBuildStage = (byte)-1;
                this.nodeLabels = ImmutableGraphSageTrainConfig.createUnmodifiableList(false, ImmutableGraphSageTrainConfig.createSafeList(ImmutableGraphSageTrainConfig.this.nodeLabelsInitialize(), true, false));
                this.nodeLabelsBuildStage = 1;
            }
            return this.nodeLabels;
        }

        void nodeLabels(List<String> nodeLabels) {
            this.nodeLabels = nodeLabels;
            this.nodeLabelsBuildStage = 1;
        }

        String username() {
            if (this.usernameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usernameBuildStage == 0) {
                this.usernameBuildStage = (byte)-1;
                this.username = Objects.requireNonNull(ImmutableGraphSageTrainConfig.this.usernameInitialize(), "username");
                this.usernameBuildStage = 1;
            }
            return this.username;
        }

        void username(String username) {
            this.username = username;
            this.usernameBuildStage = 1;
        }

        int batchSize() {
            if (this.batchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.batchSizeBuildStage == 0) {
                this.batchSizeBuildStage = (byte)-1;
                this.batchSize = ImmutableGraphSageTrainConfig.this.batchSizeInitialize();
                this.batchSizeBuildStage = 1;
            }
            return this.batchSize;
        }

        void batchSize(int batchSize) {
            this.batchSize = batchSize;
            this.batchSizeBuildStage = 1;
        }

        String relationshipWeightProperty() {
            if (this.relationshipWeightPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipWeightPropertyBuildStage == 0) {
                this.relationshipWeightPropertyBuildStage = (byte)-1;
                this.relationshipWeightProperty = ImmutableGraphSageTrainConfig.this.relationshipWeightPropertyInitialize();
                this.relationshipWeightPropertyBuildStage = 1;
            }
            return this.relationshipWeightProperty;
        }

        void relationshipWeightProperty(String relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty;
            this.relationshipWeightPropertyBuildStage = 1;
        }

        boolean hasRelationshipWeightProperty() {
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasRelationshipWeightPropertyBuildStage == 0) {
                this.hasRelationshipWeightPropertyBuildStage = (byte)-1;
                this.hasRelationshipWeightProperty = ImmutableGraphSageTrainConfig.this.hasRelationshipWeightPropertyInitialize();
                this.hasRelationshipWeightPropertyBuildStage = 1;
            }
            return this.hasRelationshipWeightProperty;
        }

        List<String> featureProperties() {
            if (this.featurePropertiesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.featurePropertiesBuildStage == 0) {
                this.featurePropertiesBuildStage = (byte)-1;
                this.featureProperties = ImmutableGraphSageTrainConfig.createUnmodifiableList(false, ImmutableGraphSageTrainConfig.createSafeList(ImmutableGraphSageTrainConfig.this.featurePropertiesInitialize(), true, false));
                this.featurePropertiesBuildStage = 1;
            }
            return this.featureProperties;
        }

        void featureProperties(List<String> featureProperties) {
            this.featureProperties = featureProperties;
            this.featurePropertiesBuildStage = 1;
        }

        int embeddingDimension() {
            if (this.embeddingDimensionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.embeddingDimensionBuildStage == 0) {
                this.embeddingDimensionBuildStage = (byte)-1;
                this.embeddingDimension = ImmutableGraphSageTrainConfig.this.embeddingDimensionInitialize();
                this.embeddingDimensionBuildStage = 1;
            }
            return this.embeddingDimension;
        }

        void embeddingDimension(int embeddingDimension) {
            this.embeddingDimension = embeddingDimension;
            this.embeddingDimensionBuildStage = 1;
        }

        List<Integer> sampleSizes() {
            if (this.sampleSizesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sampleSizesBuildStage == 0) {
                this.sampleSizesBuildStage = (byte)-1;
                this.sampleSizes = ImmutableGraphSageTrainConfig.createUnmodifiableList(false, ImmutableGraphSageTrainConfig.createSafeList(ImmutableGraphSageTrainConfig.this.sampleSizesInitialize(), true, false));
                this.sampleSizesBuildStage = 1;
            }
            return this.sampleSizes;
        }

        void sampleSizes(List<Integer> sampleSizes) {
            this.sampleSizes = sampleSizes;
            this.sampleSizesBuildStage = 1;
        }

        Aggregator.AggregatorType aggregator() {
            if (this.aggregatorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.aggregatorBuildStage == 0) {
                this.aggregatorBuildStage = (byte)-1;
                this.aggregator = Objects.requireNonNull(ImmutableGraphSageTrainConfig.this.aggregatorInitialize(), "aggregator");
                this.aggregatorBuildStage = 1;
            }
            return this.aggregator;
        }

        void aggregator(Aggregator.AggregatorType aggregator) {
            this.aggregator = aggregator;
            this.aggregatorBuildStage = 1;
        }

        ActivationFunction activationFunction() {
            if (this.activationFunctionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.activationFunctionBuildStage == 0) {
                this.activationFunctionBuildStage = (byte)-1;
                this.activationFunction = Objects.requireNonNull(ImmutableGraphSageTrainConfig.this.activationFunctionInitialize(), "activationFunction");
                this.activationFunctionBuildStage = 1;
            }
            return this.activationFunction;
        }

        void activationFunction(ActivationFunction activationFunction) {
            this.activationFunction = activationFunction;
            this.activationFunctionBuildStage = 1;
        }

        double tolerance() {
            if (this.toleranceBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toleranceBuildStage == 0) {
                this.toleranceBuildStage = (byte)-1;
                this.tolerance = ImmutableGraphSageTrainConfig.this.toleranceInitialize();
                this.toleranceBuildStage = 1;
            }
            return this.tolerance;
        }

        void tolerance(double tolerance) {
            this.tolerance = tolerance;
            this.toleranceBuildStage = 1;
        }

        double learningRate() {
            if (this.learningRateBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.learningRateBuildStage == 0) {
                this.learningRateBuildStage = (byte)-1;
                this.learningRate = ImmutableGraphSageTrainConfig.this.learningRateInitialize();
                this.learningRateBuildStage = 1;
            }
            return this.learningRate;
        }

        void learningRate(double learningRate) {
            this.learningRate = learningRate;
            this.learningRateBuildStage = 1;
        }

        int epochs() {
            if (this.epochsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.epochsBuildStage == 0) {
                this.epochsBuildStage = (byte)-1;
                this.epochs = ImmutableGraphSageTrainConfig.this.epochsInitialize();
                this.epochsBuildStage = 1;
            }
            return this.epochs;
        }

        void epochs(int epochs) {
            this.epochs = epochs;
            this.epochsBuildStage = 1;
        }

        int maxIterations() {
            if (this.maxIterationsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.maxIterationsBuildStage == 0) {
                this.maxIterationsBuildStage = (byte)-1;
                this.maxIterations = ImmutableGraphSageTrainConfig.this.maxIterationsInitialize();
                this.maxIterationsBuildStage = 1;
            }
            return this.maxIterations;
        }

        void maxIterations(int maxIterations) {
            this.maxIterations = maxIterations;
            this.maxIterationsBuildStage = 1;
        }

        int searchDepth() {
            if (this.searchDepthBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.searchDepthBuildStage == 0) {
                this.searchDepthBuildStage = (byte)-1;
                this.searchDepth = ImmutableGraphSageTrainConfig.this.searchDepthInitialize();
                this.searchDepthBuildStage = 1;
            }
            return this.searchDepth;
        }

        void searchDepth(int searchDepth) {
            this.searchDepth = searchDepth;
            this.searchDepthBuildStage = 1;
        }

        int negativeSampleWeight() {
            if (this.negativeSampleWeightBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.negativeSampleWeightBuildStage == 0) {
                this.negativeSampleWeightBuildStage = (byte)-1;
                this.negativeSampleWeight = ImmutableGraphSageTrainConfig.this.negativeSampleWeightInitialize();
                this.negativeSampleWeightBuildStage = 1;
            }
            return this.negativeSampleWeight;
        }

        void negativeSampleWeight(int negativeSampleWeight) {
            this.negativeSampleWeight = negativeSampleWeight;
            this.negativeSampleWeightBuildStage = 1;
        }

        boolean isWeighted() {
            if (this.isWeightedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isWeightedBuildStage == 0) {
                this.isWeightedBuildStage = (byte)-1;
                this.isWeighted = ImmutableGraphSageTrainConfig.this.isWeightedInitialize();
                this.isWeightedBuildStage = 1;
            }
            return this.isWeighted;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.usernameOverrideBuildStage == -1) {
                attributes.add("usernameOverride");
            }
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.minBatchSizeBuildStage == -1) {
                attributes.add("minBatchSize");
            }
            if (this.relationshipTypesBuildStage == -1) {
                attributes.add("relationshipTypes");
            }
            if (this.nodeLabelsBuildStage == -1) {
                attributes.add("nodeLabels");
            }
            if (this.usernameBuildStage == -1) {
                attributes.add("username");
            }
            if (this.batchSizeBuildStage == -1) {
                attributes.add("batchSize");
            }
            if (this.relationshipWeightPropertyBuildStage == -1) {
                attributes.add("relationshipWeightProperty");
            }
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                attributes.add("hasRelationshipWeightProperty");
            }
            if (this.featurePropertiesBuildStage == -1) {
                attributes.add("featureProperties");
            }
            if (this.embeddingDimensionBuildStage == -1) {
                attributes.add("embeddingDimension");
            }
            if (this.sampleSizesBuildStage == -1) {
                attributes.add("sampleSizes");
            }
            if (this.aggregatorBuildStage == -1) {
                attributes.add("aggregator");
            }
            if (this.activationFunctionBuildStage == -1) {
                attributes.add("activationFunction");
            }
            if (this.toleranceBuildStage == -1) {
                attributes.add("tolerance");
            }
            if (this.learningRateBuildStage == -1) {
                attributes.add("learningRate");
            }
            if (this.epochsBuildStage == -1) {
                attributes.add("epochs");
            }
            if (this.maxIterationsBuildStage == -1) {
                attributes.add("maxIterations");
            }
            if (this.searchDepthBuildStage == -1) {
                attributes.add("searchDepth");
            }
            if (this.negativeSampleWeightBuildStage == -1) {
                attributes.add("negativeSampleWeight");
            }
            if (this.isWeightedBuildStage == -1) {
                attributes.add("isWeighted");
            }
            return "Cannot build GraphSageTrainConfig, attribute initializers form cycle " + attributes;
        }
    }
}

