/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.node2vec;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.config.EmbeddingDimensionConfig;
import org.neo4j.gds.config.RandomSeedConfig;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.config.SourceNodesConfig;
import org.neo4j.gds.embeddings.node2vec.Node2VecBaseConfig;
import org.neo4j.gds.embeddings.node2vec.Node2VecStreamConfig;
import org.neo4j.gds.traversal.RandomWalkBaseConfig;

@Generated(from="Node2VecStreamConfig", generator="Immutables")
public final class ImmutableNode2VecStreamConfig
implements Node2VecStreamConfig {
    @Nullable
    private final String usernameOverride;
    private final boolean sudo;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    private final int concurrency;
    private final int minBatchSize;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    @Nullable
    private final String relationshipWeightProperty;
    private final transient boolean hasRelationshipWeightProperty;
    private final Long randomSeed;
    private final int walkLength;
    private final int walksPerNode;
    private final int walkBufferSize;
    private final double inOutFactor;
    private final double returnFactor;
    private final int windowSize;
    private final int negativeSamplingRate;
    private final double positiveSamplingFactor;
    private final double negativeSamplingExponent;
    private final int embeddingDimension;
    private final double initialLearningRate;
    private final double minLearningRate;
    private final int iterations;
    private final List<Long> sourceNodes;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableNode2VecStreamConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, @Nullable String relationshipWeightProperty, Optional<Long> randomSeed, int walkLength, int walksPerNode, int walkBufferSize, double inOutFactor, double returnFactor, int windowSize, int negativeSamplingRate, double positiveSamplingFactor, double negativeSamplingExponent, int embeddingDimension, double initialLearningRate, double minLearningRate, int iterations, Iterable<Long> sourceNodes) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableNode2VecStreamConfig.createUnmodifiableList(false, ImmutableNode2VecStreamConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableNode2VecStreamConfig.createUnmodifiableList(false, ImmutableNode2VecStreamConfig.createSafeList(nodeLabels, true, false)));
        this.initShim.relationshipWeightProperty(relationshipWeightProperty);
        this.randomSeed = randomSeed.orElse(null);
        this.initShim.walkLength(walkLength);
        this.initShim.walksPerNode(walksPerNode);
        this.initShim.walkBufferSize(walkBufferSize);
        this.initShim.inOutFactor(inOutFactor);
        this.initShim.returnFactor(returnFactor);
        this.initShim.windowSize(windowSize);
        this.initShim.negativeSamplingRate(negativeSamplingRate);
        this.initShim.positiveSamplingFactor(positiveSamplingFactor);
        this.initShim.negativeSamplingExponent(negativeSamplingExponent);
        this.initShim.embeddingDimension(embeddingDimension);
        this.initShim.initialLearningRate(initialLearningRate);
        this.initShim.minLearningRate(minLearningRate);
        this.initShim.iterations(iterations);
        this.initShim.sourceNodes(ImmutableNode2VecStreamConfig.createUnmodifiableList(false, ImmutableNode2VecStreamConfig.createSafeList(sourceNodes, true, false)));
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.walkLength = this.initShim.walkLength();
        this.walksPerNode = this.initShim.walksPerNode();
        this.walkBufferSize = this.initShim.walkBufferSize();
        this.inOutFactor = this.initShim.inOutFactor();
        this.returnFactor = this.initShim.returnFactor();
        this.windowSize = this.initShim.windowSize();
        this.negativeSamplingRate = this.initShim.negativeSamplingRate();
        this.positiveSamplingFactor = this.initShim.positiveSamplingFactor();
        this.negativeSamplingExponent = this.initShim.negativeSamplingExponent();
        this.embeddingDimension = this.initShim.embeddingDimension();
        this.initialLearningRate = this.initShim.initialLearningRate();
        this.minLearningRate = this.initShim.minLearningRate();
        this.iterations = this.initShim.iterations();
        this.sourceNodes = this.initShim.sourceNodes();
        this.initShim = null;
    }

    private ImmutableNode2VecStreamConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, @Nullable String relationshipWeightProperty, Long randomSeed, int walkLength, int walksPerNode, int walkBufferSize, double inOutFactor, double returnFactor, int windowSize, int negativeSamplingRate, double positiveSamplingFactor, double negativeSamplingExponent, int embeddingDimension, double initialLearningRate, double minLearningRate, int iterations, Iterable<Long> sourceNodes) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableNode2VecStreamConfig.createUnmodifiableList(false, ImmutableNode2VecStreamConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableNode2VecStreamConfig.createUnmodifiableList(false, ImmutableNode2VecStreamConfig.createSafeList(nodeLabels, true, false)));
        this.initShim.relationshipWeightProperty(relationshipWeightProperty);
        this.randomSeed = randomSeed;
        this.initShim.walkLength(walkLength);
        this.initShim.walksPerNode(walksPerNode);
        this.initShim.walkBufferSize(walkBufferSize);
        this.initShim.inOutFactor(inOutFactor);
        this.initShim.returnFactor(returnFactor);
        this.initShim.windowSize(windowSize);
        this.initShim.negativeSamplingRate(negativeSamplingRate);
        this.initShim.positiveSamplingFactor(positiveSamplingFactor);
        this.initShim.negativeSamplingExponent(negativeSamplingExponent);
        this.initShim.embeddingDimension(embeddingDimension);
        this.initShim.initialLearningRate(initialLearningRate);
        this.initShim.minLearningRate(minLearningRate);
        this.initShim.iterations(iterations);
        this.initShim.sourceNodes(ImmutableNode2VecStreamConfig.createUnmodifiableList(false, ImmutableNode2VecStreamConfig.createSafeList(sourceNodes, true, false)));
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.walkLength = this.initShim.walkLength();
        this.walksPerNode = this.initShim.walksPerNode();
        this.walkBufferSize = this.initShim.walkBufferSize();
        this.inOutFactor = this.initShim.inOutFactor();
        this.returnFactor = this.initShim.returnFactor();
        this.windowSize = this.initShim.windowSize();
        this.negativeSamplingRate = this.initShim.negativeSamplingRate();
        this.positiveSamplingFactor = this.initShim.positiveSamplingFactor();
        this.negativeSamplingExponent = this.initShim.negativeSamplingExponent();
        this.embeddingDimension = this.initShim.embeddingDimension();
        this.initialLearningRate = this.initShim.initialLearningRate();
        this.minLearningRate = this.initShim.minLearningRate();
        this.iterations = this.initShim.iterations();
        this.sourceNodes = this.initShim.sourceNodes();
        this.initShim = null;
    }

    private ImmutableNode2VecStreamConfig(Builder builder) {
        this.randomSeed = builder.randomSeed;
        if (builder.usernameOverrideIsSet()) {
            this.initShim.usernameOverride(builder.usernameOverride);
        }
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.minBatchSizeIsSet()) {
            this.initShim.minBatchSize(builder.minBatchSize);
        }
        if (builder.relationshipTypesIsSet()) {
            this.initShim.relationshipTypes(builder.relationshipTypes == null ? Collections.emptyList() : ImmutableNode2VecStreamConfig.createUnmodifiableList(true, builder.relationshipTypes));
        }
        if (builder.nodeLabelsIsSet()) {
            this.initShim.nodeLabels(builder.nodeLabels == null ? Collections.emptyList() : ImmutableNode2VecStreamConfig.createUnmodifiableList(true, builder.nodeLabels));
        }
        if (builder.relationshipWeightPropertyIsSet()) {
            this.initShim.relationshipWeightProperty(builder.relationshipWeightProperty);
        }
        if (builder.walkLengthIsSet()) {
            this.initShim.walkLength(builder.walkLength);
        }
        if (builder.walksPerNodeIsSet()) {
            this.initShim.walksPerNode(builder.walksPerNode);
        }
        if (builder.walkBufferSizeIsSet()) {
            this.initShim.walkBufferSize(builder.walkBufferSize);
        }
        if (builder.inOutFactorIsSet()) {
            this.initShim.inOutFactor(builder.inOutFactor);
        }
        if (builder.returnFactorIsSet()) {
            this.initShim.returnFactor(builder.returnFactor);
        }
        if (builder.windowSizeIsSet()) {
            this.initShim.windowSize(builder.windowSize);
        }
        if (builder.negativeSamplingRateIsSet()) {
            this.initShim.negativeSamplingRate(builder.negativeSamplingRate);
        }
        if (builder.positiveSamplingFactorIsSet()) {
            this.initShim.positiveSamplingFactor(builder.positiveSamplingFactor);
        }
        if (builder.negativeSamplingExponentIsSet()) {
            this.initShim.negativeSamplingExponent(builder.negativeSamplingExponent);
        }
        if (builder.embeddingDimensionIsSet()) {
            this.initShim.embeddingDimension(builder.embeddingDimension);
        }
        if (builder.initialLearningRateIsSet()) {
            this.initShim.initialLearningRate(builder.initialLearningRate);
        }
        if (builder.minLearningRateIsSet()) {
            this.initShim.minLearningRate(builder.minLearningRate);
        }
        if (builder.iterationsIsSet()) {
            this.initShim.iterations(builder.iterations);
        }
        if (builder.sourceNodesIsSet()) {
            this.initShim.sourceNodes(builder.sourceNodes == null ? Collections.emptyList() : ImmutableNode2VecStreamConfig.createUnmodifiableList(true, builder.sourceNodes));
        }
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.walkLength = this.initShim.walkLength();
        this.walksPerNode = this.initShim.walksPerNode();
        this.walkBufferSize = this.initShim.walkBufferSize();
        this.inOutFactor = this.initShim.inOutFactor();
        this.returnFactor = this.initShim.returnFactor();
        this.windowSize = this.initShim.windowSize();
        this.negativeSamplingRate = this.initShim.negativeSamplingRate();
        this.positiveSamplingFactor = this.initShim.positiveSamplingFactor();
        this.negativeSamplingExponent = this.initShim.negativeSamplingExponent();
        this.embeddingDimension = this.initShim.embeddingDimension();
        this.initialLearningRate = this.initShim.initialLearningRate();
        this.minLearningRate = this.initShim.minLearningRate();
        this.iterations = this.initShim.iterations();
        this.sourceNodes = this.initShim.sourceNodes();
        this.initShim = null;
    }

    private ImmutableNode2VecStreamConfig(@Nullable String usernameOverride, boolean sudo, Collection<String> configKeys, int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, @Nullable String relationshipWeightProperty, Long randomSeed, int walkLength, int walksPerNode, int walkBufferSize, double inOutFactor, double returnFactor, int windowSize, int negativeSamplingRate, double positiveSamplingFactor, double negativeSamplingExponent, int embeddingDimension, double initialLearningRate, double minLearningRate, int iterations, List<Long> sourceNodes) {
        this.initShim.usernameOverride(usernameOverride);
        this.initShim.sudo(sudo);
        this.initShim.configKeys(configKeys);
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(relationshipTypes);
        this.initShim.nodeLabels(nodeLabels);
        this.initShim.relationshipWeightProperty(relationshipWeightProperty);
        this.randomSeed = randomSeed;
        this.initShim.walkLength(walkLength);
        this.initShim.walksPerNode(walksPerNode);
        this.initShim.walkBufferSize(walkBufferSize);
        this.initShim.inOutFactor(inOutFactor);
        this.initShim.returnFactor(returnFactor);
        this.initShim.windowSize(windowSize);
        this.initShim.negativeSamplingRate(negativeSamplingRate);
        this.initShim.positiveSamplingFactor(positiveSamplingFactor);
        this.initShim.negativeSamplingExponent(negativeSamplingExponent);
        this.initShim.embeddingDimension(embeddingDimension);
        this.initShim.initialLearningRate(initialLearningRate);
        this.initShim.minLearningRate(minLearningRate);
        this.initShim.iterations(iterations);
        this.initShim.sourceNodes(sourceNodes);
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.walkLength = this.initShim.walkLength();
        this.walksPerNode = this.initShim.walksPerNode();
        this.walkBufferSize = this.initShim.walkBufferSize();
        this.inOutFactor = this.initShim.inOutFactor();
        this.returnFactor = this.initShim.returnFactor();
        this.windowSize = this.initShim.windowSize();
        this.negativeSamplingRate = this.initShim.negativeSamplingRate();
        this.positiveSamplingFactor = this.initShim.positiveSamplingFactor();
        this.negativeSamplingExponent = this.initShim.negativeSamplingExponent();
        this.embeddingDimension = this.initShim.embeddingDimension();
        this.initialLearningRate = this.initShim.initialLearningRate();
        this.minLearningRate = this.initShim.minLearningRate();
        this.iterations = this.initShim.iterations();
        this.sourceNodes = this.initShim.sourceNodes();
        this.initShim = null;
    }

    @Nullable
    private String usernameOverrideInitialize() {
        return Node2VecStreamConfig.super.usernameOverride();
    }

    private boolean sudoInitialize() {
        return Node2VecStreamConfig.super.sudo();
    }

    private Collection<String> configKeysInitialize() {
        return Node2VecStreamConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return Node2VecStreamConfig.super.toMap();
    }

    private int concurrencyInitialize() {
        return Node2VecStreamConfig.super.concurrency();
    }

    private int minBatchSizeInitialize() {
        return Node2VecStreamConfig.super.minBatchSize();
    }

    private List<String> relationshipTypesInitialize() {
        return Node2VecStreamConfig.super.relationshipTypes();
    }

    private List<String> nodeLabelsInitialize() {
        return Node2VecStreamConfig.super.nodeLabels();
    }

    @Nullable
    private String relationshipWeightPropertyInitialize() {
        return Node2VecStreamConfig.super.relationshipWeightProperty();
    }

    private boolean hasRelationshipWeightPropertyInitialize() {
        return Node2VecStreamConfig.super.hasRelationshipWeightProperty();
    }

    private int walkLengthInitialize() {
        return Node2VecStreamConfig.super.walkLength();
    }

    private int walksPerNodeInitialize() {
        return Node2VecStreamConfig.super.walksPerNode();
    }

    private int walkBufferSizeInitialize() {
        return Node2VecStreamConfig.super.walkBufferSize();
    }

    private double inOutFactorInitialize() {
        return Node2VecStreamConfig.super.inOutFactor();
    }

    private double returnFactorInitialize() {
        return Node2VecStreamConfig.super.returnFactor();
    }

    private int windowSizeInitialize() {
        return Node2VecStreamConfig.super.windowSize();
    }

    private int negativeSamplingRateInitialize() {
        return Node2VecStreamConfig.super.negativeSamplingRate();
    }

    private double positiveSamplingFactorInitialize() {
        return Node2VecStreamConfig.super.positiveSamplingFactor();
    }

    private double negativeSamplingExponentInitialize() {
        return Node2VecStreamConfig.super.negativeSamplingExponent();
    }

    private int embeddingDimensionInitialize() {
        return Node2VecStreamConfig.super.embeddingDimension();
    }

    private double initialLearningRateInitialize() {
        return Node2VecStreamConfig.super.initialLearningRate();
    }

    private double minLearningRateInitialize() {
        return Node2VecStreamConfig.super.minLearningRate();
    }

    private int iterationsInitialize() {
        return Node2VecStreamConfig.super.iterations();
    }

    private List<Long> sourceNodesInitialize() {
        return Node2VecStreamConfig.super.sourceNodes();
    }

    @Nullable
    public String usernameOverride() {
        InitShim shim = this.initShim;
        return shim != null ? shim.usernameOverride() : this.usernameOverride;
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    public int minBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minBatchSize() : this.minBatchSize;
    }

    public List<String> relationshipTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipTypes() : this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeLabels() : this.nodeLabels;
    }

    @Nullable
    public String relationshipWeightProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipWeightProperty() : this.relationshipWeightProperty;
    }

    public boolean hasRelationshipWeightProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasRelationshipWeightProperty() : this.hasRelationshipWeightProperty;
    }

    public Optional<Long> randomSeed() {
        return Optional.ofNullable(this.randomSeed);
    }

    @Override
    public int walkLength() {
        InitShim shim = this.initShim;
        return shim != null ? shim.walkLength() : this.walkLength;
    }

    @Override
    public int walksPerNode() {
        InitShim shim = this.initShim;
        return shim != null ? shim.walksPerNode() : this.walksPerNode;
    }

    @Override
    public int walkBufferSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.walkBufferSize() : this.walkBufferSize;
    }

    @Override
    public double inOutFactor() {
        InitShim shim = this.initShim;
        return shim != null ? shim.inOutFactor() : this.inOutFactor;
    }

    @Override
    public double returnFactor() {
        InitShim shim = this.initShim;
        return shim != null ? shim.returnFactor() : this.returnFactor;
    }

    @Override
    public int windowSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.windowSize() : this.windowSize;
    }

    @Override
    public int negativeSamplingRate() {
        InitShim shim = this.initShim;
        return shim != null ? shim.negativeSamplingRate() : this.negativeSamplingRate;
    }

    @Override
    public double positiveSamplingFactor() {
        InitShim shim = this.initShim;
        return shim != null ? shim.positiveSamplingFactor() : this.positiveSamplingFactor;
    }

    @Override
    public double negativeSamplingExponent() {
        InitShim shim = this.initShim;
        return shim != null ? shim.negativeSamplingExponent() : this.negativeSamplingExponent;
    }

    @Override
    public int embeddingDimension() {
        InitShim shim = this.initShim;
        return shim != null ? shim.embeddingDimension() : this.embeddingDimension;
    }

    @Override
    public double initialLearningRate() {
        InitShim shim = this.initShim;
        return shim != null ? shim.initialLearningRate() : this.initialLearningRate;
    }

    @Override
    public double minLearningRate() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minLearningRate() : this.minLearningRate;
    }

    @Override
    public int iterations() {
        InitShim shim = this.initShim;
        return shim != null ? shim.iterations() : this.iterations;
    }

    @Override
    public List<Long> sourceNodes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sourceNodes() : this.sourceNodes;
    }

    public final ImmutableNode2VecStreamConfig withUsernameOverride(@Nullable String value) {
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return ImmutableNode2VecStreamConfig.validate(new ImmutableNode2VecStreamConfig(value, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes));
    }

    public final ImmutableNode2VecStreamConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutableNode2VecStreamConfig.validate(new ImmutableNode2VecStreamConfig(this.usernameOverride, value, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes));
    }

    public final ImmutableNode2VecStreamConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutableNode2VecStreamConfig.validate(new ImmutableNode2VecStreamConfig(this.usernameOverride, this.sudo, newValue, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes));
    }

    public final ImmutableNode2VecStreamConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutableNode2VecStreamConfig.validate(new ImmutableNode2VecStreamConfig(this.usernameOverride, this.sudo, this.configKeys, value, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes));
    }

    public final ImmutableNode2VecStreamConfig withMinBatchSize(int value) {
        if (this.minBatchSize == value) {
            return this;
        }
        return ImmutableNode2VecStreamConfig.validate(new ImmutableNode2VecStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, value, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes));
    }

    public final ImmutableNode2VecStreamConfig withRelationshipTypes(String ... elements) {
        List<String> newValue = ImmutableNode2VecStreamConfig.createUnmodifiableList(false, ImmutableNode2VecStreamConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableNode2VecStreamConfig.validate(new ImmutableNode2VecStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes));
    }

    public final ImmutableNode2VecStreamConfig withRelationshipTypes(Iterable<String> elements) {
        if (this.relationshipTypes == elements) {
            return this;
        }
        List<String> newValue = ImmutableNode2VecStreamConfig.createUnmodifiableList(false, ImmutableNode2VecStreamConfig.createSafeList(elements, true, false));
        return ImmutableNode2VecStreamConfig.validate(new ImmutableNode2VecStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes));
    }

    public final ImmutableNode2VecStreamConfig withNodeLabels(String ... elements) {
        List<String> newValue = ImmutableNode2VecStreamConfig.createUnmodifiableList(false, ImmutableNode2VecStreamConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableNode2VecStreamConfig.validate(new ImmutableNode2VecStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, newValue, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes));
    }

    public final ImmutableNode2VecStreamConfig withNodeLabels(Iterable<String> elements) {
        if (this.nodeLabels == elements) {
            return this;
        }
        List<String> newValue = ImmutableNode2VecStreamConfig.createUnmodifiableList(false, ImmutableNode2VecStreamConfig.createSafeList(elements, true, false));
        return ImmutableNode2VecStreamConfig.validate(new ImmutableNode2VecStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, newValue, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes));
    }

    public final ImmutableNode2VecStreamConfig withRelationshipWeightProperty(@Nullable String value) {
        if (Objects.equals(this.relationshipWeightProperty, value)) {
            return this;
        }
        return ImmutableNode2VecStreamConfig.validate(new ImmutableNode2VecStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, value, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes));
    }

    public final ImmutableNode2VecStreamConfig withRandomSeed(Long value) {
        Long newValue = value;
        if (Objects.equals(this.randomSeed, newValue)) {
            return this;
        }
        return ImmutableNode2VecStreamConfig.validate(new ImmutableNode2VecStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, newValue, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes));
    }

    public final ImmutableNode2VecStreamConfig withRandomSeed(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.randomSeed, value)) {
            return this;
        }
        return ImmutableNode2VecStreamConfig.validate(new ImmutableNode2VecStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, value, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes));
    }

    public final ImmutableNode2VecStreamConfig withWalkLength(int value) {
        if (this.walkLength == value) {
            return this;
        }
        return ImmutableNode2VecStreamConfig.validate(new ImmutableNode2VecStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, value, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes));
    }

    public final ImmutableNode2VecStreamConfig withWalksPerNode(int value) {
        if (this.walksPerNode == value) {
            return this;
        }
        return ImmutableNode2VecStreamConfig.validate(new ImmutableNode2VecStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, value, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes));
    }

    public final ImmutableNode2VecStreamConfig withWalkBufferSize(int value) {
        if (this.walkBufferSize == value) {
            return this;
        }
        return ImmutableNode2VecStreamConfig.validate(new ImmutableNode2VecStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, value, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes));
    }

    public final ImmutableNode2VecStreamConfig withInOutFactor(double value) {
        if (Double.doubleToLongBits(this.inOutFactor) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutableNode2VecStreamConfig.validate(new ImmutableNode2VecStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, value, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes));
    }

    public final ImmutableNode2VecStreamConfig withReturnFactor(double value) {
        if (Double.doubleToLongBits(this.returnFactor) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutableNode2VecStreamConfig.validate(new ImmutableNode2VecStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, value, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes));
    }

    public final ImmutableNode2VecStreamConfig withWindowSize(int value) {
        if (this.windowSize == value) {
            return this;
        }
        return ImmutableNode2VecStreamConfig.validate(new ImmutableNode2VecStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, value, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes));
    }

    public final ImmutableNode2VecStreamConfig withNegativeSamplingRate(int value) {
        if (this.negativeSamplingRate == value) {
            return this;
        }
        return ImmutableNode2VecStreamConfig.validate(new ImmutableNode2VecStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, value, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes));
    }

    public final ImmutableNode2VecStreamConfig withPositiveSamplingFactor(double value) {
        if (Double.doubleToLongBits(this.positiveSamplingFactor) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutableNode2VecStreamConfig.validate(new ImmutableNode2VecStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, value, this.negativeSamplingExponent, this.embeddingDimension, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes));
    }

    public final ImmutableNode2VecStreamConfig withNegativeSamplingExponent(double value) {
        if (Double.doubleToLongBits(this.negativeSamplingExponent) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutableNode2VecStreamConfig.validate(new ImmutableNode2VecStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, value, this.embeddingDimension, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes));
    }

    public final ImmutableNode2VecStreamConfig withEmbeddingDimension(int value) {
        if (this.embeddingDimension == value) {
            return this;
        }
        return ImmutableNode2VecStreamConfig.validate(new ImmutableNode2VecStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, value, this.initialLearningRate, this.minLearningRate, this.iterations, this.sourceNodes));
    }

    public final ImmutableNode2VecStreamConfig withInitialLearningRate(double value) {
        if (Double.doubleToLongBits(this.initialLearningRate) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutableNode2VecStreamConfig.validate(new ImmutableNode2VecStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, value, this.minLearningRate, this.iterations, this.sourceNodes));
    }

    public final ImmutableNode2VecStreamConfig withMinLearningRate(double value) {
        if (Double.doubleToLongBits(this.minLearningRate) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutableNode2VecStreamConfig.validate(new ImmutableNode2VecStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.initialLearningRate, value, this.iterations, this.sourceNodes));
    }

    public final ImmutableNode2VecStreamConfig withIterations(int value) {
        if (this.iterations == value) {
            return this;
        }
        return ImmutableNode2VecStreamConfig.validate(new ImmutableNode2VecStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.initialLearningRate, this.minLearningRate, value, this.sourceNodes));
    }

    public final ImmutableNode2VecStreamConfig withSourceNodes(long ... elements) {
        ArrayList<Long> wrappedList = new ArrayList<Long>(elements.length);
        for (long element : elements) {
            wrappedList.add(element);
        }
        List<Long> newValue = ImmutableNode2VecStreamConfig.createUnmodifiableList(false, wrappedList);
        return ImmutableNode2VecStreamConfig.validate(new ImmutableNode2VecStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.initialLearningRate, this.minLearningRate, this.iterations, newValue));
    }

    public final ImmutableNode2VecStreamConfig withSourceNodes(Iterable<Long> elements) {
        if (this.sourceNodes == elements) {
            return this;
        }
        List<Long> newValue = ImmutableNode2VecStreamConfig.createUnmodifiableList(false, ImmutableNode2VecStreamConfig.createSafeList(elements, true, false));
        return ImmutableNode2VecStreamConfig.validate(new ImmutableNode2VecStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor, this.windowSize, this.negativeSamplingRate, this.positiveSamplingFactor, this.negativeSamplingExponent, this.embeddingDimension, this.initialLearningRate, this.minLearningRate, this.iterations, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNode2VecStreamConfig && this.equalTo((ImmutableNode2VecStreamConfig)another);
    }

    private boolean equalTo(ImmutableNode2VecStreamConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && this.concurrency == another.concurrency && this.minBatchSize == another.minBatchSize && this.relationshipTypes.equals(another.relationshipTypes) && this.nodeLabels.equals(another.nodeLabels) && Objects.equals(this.relationshipWeightProperty, another.relationshipWeightProperty) && this.hasRelationshipWeightProperty == another.hasRelationshipWeightProperty && Objects.equals(this.randomSeed, another.randomSeed) && this.walkLength == another.walkLength && this.walksPerNode == another.walksPerNode && this.walkBufferSize == another.walkBufferSize && Double.doubleToLongBits(this.inOutFactor) == Double.doubleToLongBits(another.inOutFactor) && Double.doubleToLongBits(this.returnFactor) == Double.doubleToLongBits(another.returnFactor) && this.windowSize == another.windowSize && this.negativeSamplingRate == another.negativeSamplingRate && Double.doubleToLongBits(this.positiveSamplingFactor) == Double.doubleToLongBits(another.positiveSamplingFactor) && Double.doubleToLongBits(this.negativeSamplingExponent) == Double.doubleToLongBits(another.negativeSamplingExponent) && this.embeddingDimension == another.embeddingDimension && Double.doubleToLongBits(this.initialLearningRate) == Double.doubleToLongBits(another.initialLearningRate) && Double.doubleToLongBits(this.minLearningRate) == Double.doubleToLongBits(another.minLearningRate) && this.iterations == another.iterations && this.sourceNodes.equals(another.sourceNodes);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + this.concurrency;
        h += (h << 5) + this.minBatchSize;
        h += (h << 5) + this.relationshipTypes.hashCode();
        h += (h << 5) + this.nodeLabels.hashCode();
        h += (h << 5) + Objects.hashCode(this.relationshipWeightProperty);
        h += (h << 5) + Boolean.hashCode(this.hasRelationshipWeightProperty);
        h += (h << 5) + Objects.hashCode(this.randomSeed);
        h += (h << 5) + this.walkLength;
        h += (h << 5) + this.walksPerNode;
        h += (h << 5) + this.walkBufferSize;
        h += (h << 5) + Double.hashCode(this.inOutFactor);
        h += (h << 5) + Double.hashCode(this.returnFactor);
        h += (h << 5) + this.windowSize;
        h += (h << 5) + this.negativeSamplingRate;
        h += (h << 5) + Double.hashCode(this.positiveSamplingFactor);
        h += (h << 5) + Double.hashCode(this.negativeSamplingExponent);
        h += (h << 5) + this.embeddingDimension;
        h += (h << 5) + Double.hashCode(this.initialLearningRate);
        h += (h << 5) + Double.hashCode(this.minLearningRate);
        h += (h << 5) + this.iterations;
        h += (h << 5) + this.sourceNodes.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Node2VecStreamConfig{");
        if (this.usernameOverride != null) {
            builder.append("usernameOverride=").append(this.usernameOverride);
        }
        if (builder.length() > 21) {
            builder.append(", ");
        }
        builder.append("sudo=").append(this.sudo);
        builder.append(", ");
        builder.append("concurrency=").append(this.concurrency);
        builder.append(", ");
        builder.append("minBatchSize=").append(this.minBatchSize);
        builder.append(", ");
        builder.append("relationshipTypes=").append(this.relationshipTypes);
        builder.append(", ");
        builder.append("nodeLabels=").append(this.nodeLabels);
        if (this.relationshipWeightProperty != null) {
            builder.append(", ");
            builder.append("relationshipWeightProperty=").append(this.relationshipWeightProperty);
        }
        builder.append(", ");
        builder.append("hasRelationshipWeightProperty=").append(this.hasRelationshipWeightProperty);
        if (this.randomSeed != null) {
            builder.append(", ");
            builder.append("randomSeed=").append(this.randomSeed);
        }
        builder.append(", ");
        builder.append("walkLength=").append(this.walkLength);
        builder.append(", ");
        builder.append("walksPerNode=").append(this.walksPerNode);
        builder.append(", ");
        builder.append("walkBufferSize=").append(this.walkBufferSize);
        builder.append(", ");
        builder.append("inOutFactor=").append(this.inOutFactor);
        builder.append(", ");
        builder.append("returnFactor=").append(this.returnFactor);
        builder.append(", ");
        builder.append("windowSize=").append(this.windowSize);
        builder.append(", ");
        builder.append("negativeSamplingRate=").append(this.negativeSamplingRate);
        builder.append(", ");
        builder.append("positiveSamplingFactor=").append(this.positiveSamplingFactor);
        builder.append(", ");
        builder.append("negativeSamplingExponent=").append(this.negativeSamplingExponent);
        builder.append(", ");
        builder.append("embeddingDimension=").append(this.embeddingDimension);
        builder.append(", ");
        builder.append("initialLearningRate=").append(this.initialLearningRate);
        builder.append(", ");
        builder.append("minLearningRate=").append(this.minLearningRate);
        builder.append(", ");
        builder.append("iterations=").append(this.iterations);
        builder.append(", ");
        builder.append("sourceNodes=").append(this.sourceNodes);
        return builder.append("}").toString();
    }

    public static Node2VecStreamConfig of(int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, @Nullable String relationshipWeightProperty, Optional<Long> randomSeed, int walkLength, int walksPerNode, int walkBufferSize, double inOutFactor, double returnFactor, int windowSize, int negativeSamplingRate, double positiveSamplingFactor, double negativeSamplingExponent, int embeddingDimension, double initialLearningRate, double minLearningRate, int iterations, List<Long> sourceNodes) {
        return ImmutableNode2VecStreamConfig.of(concurrency, minBatchSize, relationshipTypes, nodeLabels, relationshipWeightProperty, randomSeed, walkLength, walksPerNode, walkBufferSize, inOutFactor, returnFactor, windowSize, negativeSamplingRate, positiveSamplingFactor, negativeSamplingExponent, embeddingDimension, initialLearningRate, minLearningRate, iterations, sourceNodes);
    }

    public static Node2VecStreamConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, @Nullable String relationshipWeightProperty, Optional<Long> randomSeed, int walkLength, int walksPerNode, int walkBufferSize, double inOutFactor, double returnFactor, int windowSize, int negativeSamplingRate, double positiveSamplingFactor, double negativeSamplingExponent, int embeddingDimension, double initialLearningRate, double minLearningRate, int iterations, Iterable<Long> sourceNodes) {
        return ImmutableNode2VecStreamConfig.validate(new ImmutableNode2VecStreamConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, relationshipWeightProperty, randomSeed, walkLength, walksPerNode, walkBufferSize, inOutFactor, returnFactor, windowSize, negativeSamplingRate, positiveSamplingFactor, negativeSamplingExponent, embeddingDimension, initialLearningRate, minLearningRate, iterations, sourceNodes));
    }

    public static Node2VecStreamConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, @Nullable String relationshipWeightProperty, Long randomSeed, int walkLength, int walksPerNode, int walkBufferSize, double inOutFactor, double returnFactor, int windowSize, int negativeSamplingRate, double positiveSamplingFactor, double negativeSamplingExponent, int embeddingDimension, double initialLearningRate, double minLearningRate, int iterations, Iterable<Long> sourceNodes) {
        return ImmutableNode2VecStreamConfig.validate(new ImmutableNode2VecStreamConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, relationshipWeightProperty, randomSeed, walkLength, walksPerNode, walkBufferSize, inOutFactor, returnFactor, windowSize, negativeSamplingRate, positiveSamplingFactor, negativeSamplingExponent, embeddingDimension, initialLearningRate, minLearningRate, iterations, sourceNodes));
    }

    private static ImmutableNode2VecStreamConfig validate(ImmutableNode2VecStreamConfig instance) {
        instance.validateConcurrency();
        return instance;
    }

    public static Node2VecStreamConfig copyOf(Node2VecStreamConfig instance) {
        if (instance instanceof ImmutableNode2VecStreamConfig) {
            return (ImmutableNode2VecStreamConfig)instance;
        }
        return ImmutableNode2VecStreamConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="Node2VecStreamConfig", generator="Immutables")
    public static final class Builder {
        private static final long OPT_BIT_USERNAME_OVERRIDE = 1L;
        private static final long OPT_BIT_SUDO = 2L;
        private static final long OPT_BIT_CONCURRENCY = 4L;
        private static final long OPT_BIT_MIN_BATCH_SIZE = 8L;
        private static final long OPT_BIT_RELATIONSHIP_TYPES = 16L;
        private static final long OPT_BIT_NODE_LABELS = 32L;
        private static final long OPT_BIT_RELATIONSHIP_WEIGHT_PROPERTY = 64L;
        private static final long OPT_BIT_WALK_LENGTH = 128L;
        private static final long OPT_BIT_WALKS_PER_NODE = 256L;
        private static final long OPT_BIT_WALK_BUFFER_SIZE = 512L;
        private static final long OPT_BIT_IN_OUT_FACTOR = 1024L;
        private static final long OPT_BIT_RETURN_FACTOR = 2048L;
        private static final long OPT_BIT_WINDOW_SIZE = 4096L;
        private static final long OPT_BIT_NEGATIVE_SAMPLING_RATE = 8192L;
        private static final long OPT_BIT_POSITIVE_SAMPLING_FACTOR = 16384L;
        private static final long OPT_BIT_NEGATIVE_SAMPLING_EXPONENT = 32768L;
        private static final long OPT_BIT_EMBEDDING_DIMENSION = 65536L;
        private static final long OPT_BIT_INITIAL_LEARNING_RATE = 131072L;
        private static final long OPT_BIT_MIN_LEARNING_RATE = 262144L;
        private static final long OPT_BIT_ITERATIONS = 524288L;
        private static final long OPT_BIT_SOURCE_NODES = 0x100000L;
        private long optBits;
        private String usernameOverride;
        private boolean sudo;
        private Collection<String> configKeys;
        private int concurrency;
        private int minBatchSize;
        private List<String> relationshipTypes = null;
        private List<String> nodeLabels = null;
        private String relationshipWeightProperty;
        private Long randomSeed;
        private int walkLength;
        private int walksPerNode;
        private int walkBufferSize;
        private double inOutFactor;
        private double returnFactor;
        private int windowSize;
        private int negativeSamplingRate;
        private double positiveSamplingFactor;
        private double negativeSamplingExponent;
        private int embeddingDimension;
        private double initialLearningRate;
        private double minLearningRate;
        private int iterations;
        private List<Long> sourceNodes = null;

        private Builder() {
        }

        public final Builder from(RelationshipWeightConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Node2VecBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ConcurrencyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RandomSeedConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RandomWalkBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SourceNodesConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AlgoBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EmbeddingDimensionConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Node2VecStreamConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional randomSeedOptional;
            RelationshipWeightConfig instance;
            String relationshipWeightPropertyValue;
            long bits = 0L;
            if (object instanceof RelationshipWeightConfig && (relationshipWeightPropertyValue = (instance = (RelationshipWeightConfig)object).relationshipWeightProperty()) != null) {
                this.relationshipWeightProperty(relationshipWeightPropertyValue);
            }
            if (object instanceof Node2VecBaseConfig) {
                instance = (Node2VecBaseConfig)object;
                this.negativeSamplingExponent(instance.negativeSamplingExponent());
                this.initialLearningRate(instance.initialLearningRate());
                this.windowSize(instance.windowSize());
                this.negativeSamplingRate(instance.negativeSamplingRate());
                if ((bits & 1L) == 0L) {
                    this.addAllSourceNodes(instance.sourceNodes());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.embeddingDimension(instance.embeddingDimension());
                    bits |= 2L;
                }
                this.positiveSamplingFactor(instance.positiveSamplingFactor());
                this.minLearningRate(instance.minLearningRate());
                this.iterations(instance.iterations());
            }
            if (object instanceof ConcurrencyConfig) {
                instance = (ConcurrencyConfig)object;
                this.minBatchSize(instance.minBatchSize());
                this.concurrency(instance.concurrency());
            }
            if (object instanceof RandomSeedConfig && (randomSeedOptional = (instance = (RandomSeedConfig)object).randomSeed()).isPresent()) {
                this.randomSeed(randomSeedOptional);
            }
            if (object instanceof RandomWalkBaseConfig) {
                instance = (RandomWalkBaseConfig)object;
                this.walkLength(instance.walkLength());
                this.walksPerNode(instance.walksPerNode());
                this.walkBufferSize(instance.walkBufferSize());
                this.returnFactor(instance.returnFactor());
                this.inOutFactor(instance.inOutFactor());
            }
            if (object instanceof SourceNodesConfig) {
                instance = (SourceNodesConfig)object;
                if ((bits & 1L) == 0L) {
                    this.addAllSourceNodes(instance.sourceNodes());
                    bits |= 1L;
                }
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                @Nullable String usernameOverrideValue = instance.usernameOverride();
                if (usernameOverrideValue != null) {
                    this.usernameOverride(usernameOverrideValue);
                }
                this.configKeys(instance.configKeys());
                this.sudo(instance.sudo());
            }
            if (object instanceof AlgoBaseConfig) {
                instance = (AlgoBaseConfig)object;
                this.addAllRelationshipTypes(instance.relationshipTypes());
                this.addAllNodeLabels(instance.nodeLabels());
            }
            if (object instanceof EmbeddingDimensionConfig) {
                instance = (EmbeddingDimensionConfig)object;
                if ((bits & 2L) == 0L) {
                    this.embeddingDimension(instance.embeddingDimension());
                    bits |= 2L;
                }
            }
        }

        public final Builder usernameOverride(@Nullable String usernameOverride) {
            this.usernameOverride = usernameOverride;
            this.optBits |= 1L;
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 2L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 4L;
            return this;
        }

        public final Builder minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.optBits |= 8L;
            return this;
        }

        public final Builder addRelationshipType(String element) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addRelationshipTypes(String ... elements) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder relationshipTypes(Iterable<String> elements) {
            this.relationshipTypes = new ArrayList<String>();
            return this.addAllRelationshipTypes(elements);
        }

        public final Builder addAllRelationshipTypes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "relationshipTypes element");
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addNodeLabel(String element) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder addNodeLabels(String ... elements) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder nodeLabels(Iterable<String> elements) {
            this.nodeLabels = new ArrayList<String>();
            return this.addAllNodeLabels(elements);
        }

        public final Builder addAllNodeLabels(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeLabels element");
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder relationshipWeightProperty(@Nullable String relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder randomSeed(Long randomSeed) {
            this.randomSeed = randomSeed;
            return this;
        }

        public final Builder randomSeed(Optional<Long> randomSeed) {
            this.randomSeed = randomSeed.orElse(null);
            return this;
        }

        public final Builder walkLength(int walkLength) {
            this.walkLength = walkLength;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder walksPerNode(int walksPerNode) {
            this.walksPerNode = walksPerNode;
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder walkBufferSize(int walkBufferSize) {
            this.walkBufferSize = walkBufferSize;
            this.optBits |= 0x200L;
            return this;
        }

        public final Builder inOutFactor(double inOutFactor) {
            this.inOutFactor = inOutFactor;
            this.optBits |= 0x400L;
            return this;
        }

        public final Builder returnFactor(double returnFactor) {
            this.returnFactor = returnFactor;
            this.optBits |= 0x800L;
            return this;
        }

        public final Builder windowSize(int windowSize) {
            this.windowSize = windowSize;
            this.optBits |= 0x1000L;
            return this;
        }

        public final Builder negativeSamplingRate(int negativeSamplingRate) {
            this.negativeSamplingRate = negativeSamplingRate;
            this.optBits |= 0x2000L;
            return this;
        }

        public final Builder positiveSamplingFactor(double positiveSamplingFactor) {
            this.positiveSamplingFactor = positiveSamplingFactor;
            this.optBits |= 0x4000L;
            return this;
        }

        public final Builder negativeSamplingExponent(double negativeSamplingExponent) {
            this.negativeSamplingExponent = negativeSamplingExponent;
            this.optBits |= 0x8000L;
            return this;
        }

        public final Builder embeddingDimension(int embeddingDimension) {
            this.embeddingDimension = embeddingDimension;
            this.optBits |= 0x10000L;
            return this;
        }

        public final Builder initialLearningRate(double initialLearningRate) {
            this.initialLearningRate = initialLearningRate;
            this.optBits |= 0x20000L;
            return this;
        }

        public final Builder minLearningRate(double minLearningRate) {
            this.minLearningRate = minLearningRate;
            this.optBits |= 0x40000L;
            return this;
        }

        public final Builder iterations(int iterations) {
            this.iterations = iterations;
            this.optBits |= 0x80000L;
            return this;
        }

        public final Builder addSourceNode(long element) {
            if (this.sourceNodes == null) {
                this.sourceNodes = new ArrayList<Long>();
            }
            this.sourceNodes.add(element);
            this.optBits |= 0x100000L;
            return this;
        }

        public final Builder addSourceNodes(long ... elements) {
            if (this.sourceNodes == null) {
                this.sourceNodes = new ArrayList<Long>();
            }
            for (long element : elements) {
                this.sourceNodes.add(element);
            }
            this.optBits |= 0x100000L;
            return this;
        }

        public final Builder sourceNodes(Iterable<Long> elements) {
            this.sourceNodes = new ArrayList<Long>();
            return this.addAllSourceNodes(elements);
        }

        public final Builder addAllSourceNodes(Iterable<Long> elements) {
            Objects.requireNonNull(elements, "sourceNodes element");
            if (this.sourceNodes == null) {
                this.sourceNodes = new ArrayList<Long>();
            }
            for (long element : elements) {
                this.sourceNodes.add(Objects.requireNonNull(Long.valueOf(element), "sourceNodes element"));
            }
            this.optBits |= 0x100000L;
            return this;
        }

        public Builder clear() {
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.configKeys = null;
            this.concurrency = 0;
            this.minBatchSize = 0;
            if (this.relationshipTypes != null) {
                this.relationshipTypes.clear();
            }
            if (this.nodeLabels != null) {
                this.nodeLabels.clear();
            }
            this.relationshipWeightProperty = null;
            this.randomSeed = null;
            this.walkLength = 0;
            this.walksPerNode = 0;
            this.walkBufferSize = 0;
            this.inOutFactor = 0.0;
            this.returnFactor = 0.0;
            this.windowSize = 0;
            this.negativeSamplingRate = 0;
            this.positiveSamplingFactor = 0.0;
            this.negativeSamplingExponent = 0.0;
            this.embeddingDimension = 0;
            this.initialLearningRate = 0.0;
            this.minLearningRate = 0.0;
            this.iterations = 0;
            if (this.sourceNodes != null) {
                this.sourceNodes.clear();
            }
            return this;
        }

        public Node2VecStreamConfig build() {
            return ImmutableNode2VecStreamConfig.validate(new ImmutableNode2VecStreamConfig(this));
        }

        private boolean usernameOverrideIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean sudoIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean minBatchSizeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean relationshipTypesIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean nodeLabelsIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean relationshipWeightPropertyIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean walkLengthIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean walksPerNodeIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean walkBufferSizeIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private boolean inOutFactorIsSet() {
            return (this.optBits & 0x400L) != 0L;
        }

        private boolean returnFactorIsSet() {
            return (this.optBits & 0x800L) != 0L;
        }

        private boolean windowSizeIsSet() {
            return (this.optBits & 0x1000L) != 0L;
        }

        private boolean negativeSamplingRateIsSet() {
            return (this.optBits & 0x2000L) != 0L;
        }

        private boolean positiveSamplingFactorIsSet() {
            return (this.optBits & 0x4000L) != 0L;
        }

        private boolean negativeSamplingExponentIsSet() {
            return (this.optBits & 0x8000L) != 0L;
        }

        private boolean embeddingDimensionIsSet() {
            return (this.optBits & 0x10000L) != 0L;
        }

        private boolean initialLearningRateIsSet() {
            return (this.optBits & 0x20000L) != 0L;
        }

        private boolean minLearningRateIsSet() {
            return (this.optBits & 0x40000L) != 0L;
        }

        private boolean iterationsIsSet() {
            return (this.optBits & 0x80000L) != 0L;
        }

        private boolean sourceNodesIsSet() {
            return (this.optBits & 0x100000L) != 0L;
        }
    }

    @Generated(from="Node2VecStreamConfig", generator="Immutables")
    private final class InitShim {
        private byte usernameOverrideBuildStage = 0;
        private String usernameOverride;
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte concurrencyBuildStage = 0;
        private int concurrency;
        private byte minBatchSizeBuildStage = 0;
        private int minBatchSize;
        private byte relationshipTypesBuildStage = 0;
        private List<String> relationshipTypes;
        private byte nodeLabelsBuildStage = 0;
        private List<String> nodeLabels;
        private byte relationshipWeightPropertyBuildStage = 0;
        private String relationshipWeightProperty;
        private byte hasRelationshipWeightPropertyBuildStage = 0;
        private boolean hasRelationshipWeightProperty;
        private byte walkLengthBuildStage = 0;
        private int walkLength;
        private byte walksPerNodeBuildStage = 0;
        private int walksPerNode;
        private byte walkBufferSizeBuildStage = 0;
        private int walkBufferSize;
        private byte inOutFactorBuildStage = 0;
        private double inOutFactor;
        private byte returnFactorBuildStage = 0;
        private double returnFactor;
        private byte windowSizeBuildStage = 0;
        private int windowSize;
        private byte negativeSamplingRateBuildStage = 0;
        private int negativeSamplingRate;
        private byte positiveSamplingFactorBuildStage = 0;
        private double positiveSamplingFactor;
        private byte negativeSamplingExponentBuildStage = 0;
        private double negativeSamplingExponent;
        private byte embeddingDimensionBuildStage = 0;
        private int embeddingDimension;
        private byte initialLearningRateBuildStage = 0;
        private double initialLearningRate;
        private byte minLearningRateBuildStage = 0;
        private double minLearningRate;
        private byte iterationsBuildStage = 0;
        private int iterations;
        private byte sourceNodesBuildStage = 0;
        private List<Long> sourceNodes;

        private InitShim() {
        }

        String usernameOverride() {
            if (this.usernameOverrideBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usernameOverrideBuildStage == 0) {
                this.usernameOverrideBuildStage = (byte)-1;
                this.usernameOverride = ImmutableNode2VecStreamConfig.this.usernameOverrideInitialize();
                this.usernameOverrideBuildStage = 1;
            }
            return this.usernameOverride;
        }

        void usernameOverride(String usernameOverride) {
            this.usernameOverride = usernameOverride;
            this.usernameOverrideBuildStage = 1;
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableNode2VecStreamConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableNode2VecStreamConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableNode2VecStreamConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutableNode2VecStreamConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        int minBatchSize() {
            if (this.minBatchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minBatchSizeBuildStage == 0) {
                this.minBatchSizeBuildStage = (byte)-1;
                this.minBatchSize = ImmutableNode2VecStreamConfig.this.minBatchSizeInitialize();
                this.minBatchSizeBuildStage = 1;
            }
            return this.minBatchSize;
        }

        void minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.minBatchSizeBuildStage = 1;
        }

        List<String> relationshipTypes() {
            if (this.relationshipTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipTypesBuildStage == 0) {
                this.relationshipTypesBuildStage = (byte)-1;
                this.relationshipTypes = ImmutableNode2VecStreamConfig.createUnmodifiableList(false, ImmutableNode2VecStreamConfig.createSafeList(ImmutableNode2VecStreamConfig.this.relationshipTypesInitialize(), true, false));
                this.relationshipTypesBuildStage = 1;
            }
            return this.relationshipTypes;
        }

        void relationshipTypes(List<String> relationshipTypes) {
            this.relationshipTypes = relationshipTypes;
            this.relationshipTypesBuildStage = 1;
        }

        List<String> nodeLabels() {
            if (this.nodeLabelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeLabelsBuildStage == 0) {
                this.nodeLabelsBuildStage = (byte)-1;
                this.nodeLabels = ImmutableNode2VecStreamConfig.createUnmodifiableList(false, ImmutableNode2VecStreamConfig.createSafeList(ImmutableNode2VecStreamConfig.this.nodeLabelsInitialize(), true, false));
                this.nodeLabelsBuildStage = 1;
            }
            return this.nodeLabels;
        }

        void nodeLabels(List<String> nodeLabels) {
            this.nodeLabels = nodeLabels;
            this.nodeLabelsBuildStage = 1;
        }

        String relationshipWeightProperty() {
            if (this.relationshipWeightPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipWeightPropertyBuildStage == 0) {
                this.relationshipWeightPropertyBuildStage = (byte)-1;
                this.relationshipWeightProperty = ImmutableNode2VecStreamConfig.this.relationshipWeightPropertyInitialize();
                this.relationshipWeightPropertyBuildStage = 1;
            }
            return this.relationshipWeightProperty;
        }

        void relationshipWeightProperty(String relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty;
            this.relationshipWeightPropertyBuildStage = 1;
        }

        boolean hasRelationshipWeightProperty() {
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasRelationshipWeightPropertyBuildStage == 0) {
                this.hasRelationshipWeightPropertyBuildStage = (byte)-1;
                this.hasRelationshipWeightProperty = ImmutableNode2VecStreamConfig.this.hasRelationshipWeightPropertyInitialize();
                this.hasRelationshipWeightPropertyBuildStage = 1;
            }
            return this.hasRelationshipWeightProperty;
        }

        int walkLength() {
            if (this.walkLengthBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.walkLengthBuildStage == 0) {
                this.walkLengthBuildStage = (byte)-1;
                this.walkLength = ImmutableNode2VecStreamConfig.this.walkLengthInitialize();
                this.walkLengthBuildStage = 1;
            }
            return this.walkLength;
        }

        void walkLength(int walkLength) {
            this.walkLength = walkLength;
            this.walkLengthBuildStage = 1;
        }

        int walksPerNode() {
            if (this.walksPerNodeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.walksPerNodeBuildStage == 0) {
                this.walksPerNodeBuildStage = (byte)-1;
                this.walksPerNode = ImmutableNode2VecStreamConfig.this.walksPerNodeInitialize();
                this.walksPerNodeBuildStage = 1;
            }
            return this.walksPerNode;
        }

        void walksPerNode(int walksPerNode) {
            this.walksPerNode = walksPerNode;
            this.walksPerNodeBuildStage = 1;
        }

        int walkBufferSize() {
            if (this.walkBufferSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.walkBufferSizeBuildStage == 0) {
                this.walkBufferSizeBuildStage = (byte)-1;
                this.walkBufferSize = ImmutableNode2VecStreamConfig.this.walkBufferSizeInitialize();
                this.walkBufferSizeBuildStage = 1;
            }
            return this.walkBufferSize;
        }

        void walkBufferSize(int walkBufferSize) {
            this.walkBufferSize = walkBufferSize;
            this.walkBufferSizeBuildStage = 1;
        }

        double inOutFactor() {
            if (this.inOutFactorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.inOutFactorBuildStage == 0) {
                this.inOutFactorBuildStage = (byte)-1;
                this.inOutFactor = ImmutableNode2VecStreamConfig.this.inOutFactorInitialize();
                this.inOutFactorBuildStage = 1;
            }
            return this.inOutFactor;
        }

        void inOutFactor(double inOutFactor) {
            this.inOutFactor = inOutFactor;
            this.inOutFactorBuildStage = 1;
        }

        double returnFactor() {
            if (this.returnFactorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.returnFactorBuildStage == 0) {
                this.returnFactorBuildStage = (byte)-1;
                this.returnFactor = ImmutableNode2VecStreamConfig.this.returnFactorInitialize();
                this.returnFactorBuildStage = 1;
            }
            return this.returnFactor;
        }

        void returnFactor(double returnFactor) {
            this.returnFactor = returnFactor;
            this.returnFactorBuildStage = 1;
        }

        int windowSize() {
            if (this.windowSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.windowSizeBuildStage == 0) {
                this.windowSizeBuildStage = (byte)-1;
                this.windowSize = ImmutableNode2VecStreamConfig.this.windowSizeInitialize();
                this.windowSizeBuildStage = 1;
            }
            return this.windowSize;
        }

        void windowSize(int windowSize) {
            this.windowSize = windowSize;
            this.windowSizeBuildStage = 1;
        }

        int negativeSamplingRate() {
            if (this.negativeSamplingRateBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.negativeSamplingRateBuildStage == 0) {
                this.negativeSamplingRateBuildStage = (byte)-1;
                this.negativeSamplingRate = ImmutableNode2VecStreamConfig.this.negativeSamplingRateInitialize();
                this.negativeSamplingRateBuildStage = 1;
            }
            return this.negativeSamplingRate;
        }

        void negativeSamplingRate(int negativeSamplingRate) {
            this.negativeSamplingRate = negativeSamplingRate;
            this.negativeSamplingRateBuildStage = 1;
        }

        double positiveSamplingFactor() {
            if (this.positiveSamplingFactorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.positiveSamplingFactorBuildStage == 0) {
                this.positiveSamplingFactorBuildStage = (byte)-1;
                this.positiveSamplingFactor = ImmutableNode2VecStreamConfig.this.positiveSamplingFactorInitialize();
                this.positiveSamplingFactorBuildStage = 1;
            }
            return this.positiveSamplingFactor;
        }

        void positiveSamplingFactor(double positiveSamplingFactor) {
            this.positiveSamplingFactor = positiveSamplingFactor;
            this.positiveSamplingFactorBuildStage = 1;
        }

        double negativeSamplingExponent() {
            if (this.negativeSamplingExponentBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.negativeSamplingExponentBuildStage == 0) {
                this.negativeSamplingExponentBuildStage = (byte)-1;
                this.negativeSamplingExponent = ImmutableNode2VecStreamConfig.this.negativeSamplingExponentInitialize();
                this.negativeSamplingExponentBuildStage = 1;
            }
            return this.negativeSamplingExponent;
        }

        void negativeSamplingExponent(double negativeSamplingExponent) {
            this.negativeSamplingExponent = negativeSamplingExponent;
            this.negativeSamplingExponentBuildStage = 1;
        }

        int embeddingDimension() {
            if (this.embeddingDimensionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.embeddingDimensionBuildStage == 0) {
                this.embeddingDimensionBuildStage = (byte)-1;
                this.embeddingDimension = ImmutableNode2VecStreamConfig.this.embeddingDimensionInitialize();
                this.embeddingDimensionBuildStage = 1;
            }
            return this.embeddingDimension;
        }

        void embeddingDimension(int embeddingDimension) {
            this.embeddingDimension = embeddingDimension;
            this.embeddingDimensionBuildStage = 1;
        }

        double initialLearningRate() {
            if (this.initialLearningRateBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.initialLearningRateBuildStage == 0) {
                this.initialLearningRateBuildStage = (byte)-1;
                this.initialLearningRate = ImmutableNode2VecStreamConfig.this.initialLearningRateInitialize();
                this.initialLearningRateBuildStage = 1;
            }
            return this.initialLearningRate;
        }

        void initialLearningRate(double initialLearningRate) {
            this.initialLearningRate = initialLearningRate;
            this.initialLearningRateBuildStage = 1;
        }

        double minLearningRate() {
            if (this.minLearningRateBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minLearningRateBuildStage == 0) {
                this.minLearningRateBuildStage = (byte)-1;
                this.minLearningRate = ImmutableNode2VecStreamConfig.this.minLearningRateInitialize();
                this.minLearningRateBuildStage = 1;
            }
            return this.minLearningRate;
        }

        void minLearningRate(double minLearningRate) {
            this.minLearningRate = minLearningRate;
            this.minLearningRateBuildStage = 1;
        }

        int iterations() {
            if (this.iterationsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.iterationsBuildStage == 0) {
                this.iterationsBuildStage = (byte)-1;
                this.iterations = ImmutableNode2VecStreamConfig.this.iterationsInitialize();
                this.iterationsBuildStage = 1;
            }
            return this.iterations;
        }

        void iterations(int iterations) {
            this.iterations = iterations;
            this.iterationsBuildStage = 1;
        }

        List<Long> sourceNodes() {
            if (this.sourceNodesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sourceNodesBuildStage == 0) {
                this.sourceNodesBuildStage = (byte)-1;
                this.sourceNodes = ImmutableNode2VecStreamConfig.createUnmodifiableList(false, ImmutableNode2VecStreamConfig.createSafeList(ImmutableNode2VecStreamConfig.this.sourceNodesInitialize(), true, false));
                this.sourceNodesBuildStage = 1;
            }
            return this.sourceNodes;
        }

        void sourceNodes(List<Long> sourceNodes) {
            this.sourceNodes = sourceNodes;
            this.sourceNodesBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.usernameOverrideBuildStage == -1) {
                attributes.add("usernameOverride");
            }
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.minBatchSizeBuildStage == -1) {
                attributes.add("minBatchSize");
            }
            if (this.relationshipTypesBuildStage == -1) {
                attributes.add("relationshipTypes");
            }
            if (this.nodeLabelsBuildStage == -1) {
                attributes.add("nodeLabels");
            }
            if (this.relationshipWeightPropertyBuildStage == -1) {
                attributes.add("relationshipWeightProperty");
            }
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                attributes.add("hasRelationshipWeightProperty");
            }
            if (this.walkLengthBuildStage == -1) {
                attributes.add("walkLength");
            }
            if (this.walksPerNodeBuildStage == -1) {
                attributes.add("walksPerNode");
            }
            if (this.walkBufferSizeBuildStage == -1) {
                attributes.add("walkBufferSize");
            }
            if (this.inOutFactorBuildStage == -1) {
                attributes.add("inOutFactor");
            }
            if (this.returnFactorBuildStage == -1) {
                attributes.add("returnFactor");
            }
            if (this.windowSizeBuildStage == -1) {
                attributes.add("windowSize");
            }
            if (this.negativeSamplingRateBuildStage == -1) {
                attributes.add("negativeSamplingRate");
            }
            if (this.positiveSamplingFactorBuildStage == -1) {
                attributes.add("positiveSamplingFactor");
            }
            if (this.negativeSamplingExponentBuildStage == -1) {
                attributes.add("negativeSamplingExponent");
            }
            if (this.embeddingDimensionBuildStage == -1) {
                attributes.add("embeddingDimension");
            }
            if (this.initialLearningRateBuildStage == -1) {
                attributes.add("initialLearningRate");
            }
            if (this.minLearningRateBuildStage == -1) {
                attributes.add("minLearningRate");
            }
            if (this.iterationsBuildStage == -1) {
                attributes.add("iterations");
            }
            if (this.sourceNodesBuildStage == -1) {
                attributes.add("sourceNodes");
            }
            return "Cannot build Node2VecStreamConfig, attribute initializers form cycle " + attributes;
        }
    }
}

