/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.node2vec;

import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.embeddings.node2vec.RandomWalkProbabilities;

@Generated(from="RandomWalkProbabilities", generator="Immutables")
public final class ImmutableRandomWalkProbabilities
implements RandomWalkProbabilities {
    private final HugeLongArray nodeFrequencies;
    private final HugeDoubleArray positiveSamplingProbabilities;
    private final HugeLongArray negativeSamplingDistribution;
    private final long sampleCount;

    private ImmutableRandomWalkProbabilities(HugeLongArray nodeFrequencies, HugeDoubleArray positiveSamplingProbabilities, HugeLongArray negativeSamplingDistribution, long sampleCount) {
        this.nodeFrequencies = Objects.requireNonNull(nodeFrequencies, "nodeFrequencies");
        this.positiveSamplingProbabilities = Objects.requireNonNull(positiveSamplingProbabilities, "positiveSamplingProbabilities");
        this.negativeSamplingDistribution = Objects.requireNonNull(negativeSamplingDistribution, "negativeSamplingDistribution");
        this.sampleCount = sampleCount;
    }

    private ImmutableRandomWalkProbabilities(ImmutableRandomWalkProbabilities original, HugeLongArray nodeFrequencies, HugeDoubleArray positiveSamplingProbabilities, HugeLongArray negativeSamplingDistribution, long sampleCount) {
        this.nodeFrequencies = nodeFrequencies;
        this.positiveSamplingProbabilities = positiveSamplingProbabilities;
        this.negativeSamplingDistribution = negativeSamplingDistribution;
        this.sampleCount = sampleCount;
    }

    @Override
    public HugeLongArray nodeFrequencies() {
        return this.nodeFrequencies;
    }

    @Override
    public HugeDoubleArray positiveSamplingProbabilities() {
        return this.positiveSamplingProbabilities;
    }

    @Override
    public HugeLongArray negativeSamplingDistribution() {
        return this.negativeSamplingDistribution;
    }

    @Override
    public long sampleCount() {
        return this.sampleCount;
    }

    public final ImmutableRandomWalkProbabilities withNodeFrequencies(HugeLongArray value) {
        if (this.nodeFrequencies == value) {
            return this;
        }
        HugeLongArray newValue = Objects.requireNonNull(value, "nodeFrequencies");
        return new ImmutableRandomWalkProbabilities(this, newValue, this.positiveSamplingProbabilities, this.negativeSamplingDistribution, this.sampleCount);
    }

    public final ImmutableRandomWalkProbabilities withPositiveSamplingProbabilities(HugeDoubleArray value) {
        if (this.positiveSamplingProbabilities == value) {
            return this;
        }
        HugeDoubleArray newValue = Objects.requireNonNull(value, "positiveSamplingProbabilities");
        return new ImmutableRandomWalkProbabilities(this, this.nodeFrequencies, newValue, this.negativeSamplingDistribution, this.sampleCount);
    }

    public final ImmutableRandomWalkProbabilities withNegativeSamplingDistribution(HugeLongArray value) {
        if (this.negativeSamplingDistribution == value) {
            return this;
        }
        HugeLongArray newValue = Objects.requireNonNull(value, "negativeSamplingDistribution");
        return new ImmutableRandomWalkProbabilities(this, this.nodeFrequencies, this.positiveSamplingProbabilities, newValue, this.sampleCount);
    }

    public final ImmutableRandomWalkProbabilities withSampleCount(long value) {
        if (this.sampleCount == value) {
            return this;
        }
        return new ImmutableRandomWalkProbabilities(this, this.nodeFrequencies, this.positiveSamplingProbabilities, this.negativeSamplingDistribution, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRandomWalkProbabilities && this.equalTo((ImmutableRandomWalkProbabilities)another);
    }

    private boolean equalTo(ImmutableRandomWalkProbabilities another) {
        return this.nodeFrequencies.equals(another.nodeFrequencies) && this.positiveSamplingProbabilities.equals(another.positiveSamplingProbabilities) && this.negativeSamplingDistribution.equals(another.negativeSamplingDistribution) && this.sampleCount == another.sampleCount;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.nodeFrequencies.hashCode();
        h += (h << 5) + this.positiveSamplingProbabilities.hashCode();
        h += (h << 5) + this.negativeSamplingDistribution.hashCode();
        h += (h << 5) + Long.hashCode(this.sampleCount);
        return h;
    }

    public String toString() {
        return "RandomWalkProbabilities{nodeFrequencies=" + this.nodeFrequencies + ", positiveSamplingProbabilities=" + this.positiveSamplingProbabilities + ", negativeSamplingDistribution=" + this.negativeSamplingDistribution + ", sampleCount=" + this.sampleCount + "}";
    }

    public static RandomWalkProbabilities of(HugeLongArray nodeFrequencies, HugeDoubleArray positiveSamplingProbabilities, HugeLongArray negativeSamplingDistribution, long sampleCount) {
        return new ImmutableRandomWalkProbabilities(nodeFrequencies, positiveSamplingProbabilities, negativeSamplingDistribution, sampleCount);
    }

    static RandomWalkProbabilities copyOf(RandomWalkProbabilities instance) {
        if (instance instanceof ImmutableRandomWalkProbabilities) {
            return (ImmutableRandomWalkProbabilities)instance;
        }
        return ImmutableRandomWalkProbabilities.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RandomWalkProbabilities", generator="Immutables")
    static final class Builder {
        private static final long INIT_BIT_NODE_FREQUENCIES = 1L;
        private static final long INIT_BIT_POSITIVE_SAMPLING_PROBABILITIES = 2L;
        private static final long INIT_BIT_NEGATIVE_SAMPLING_DISTRIBUTION = 4L;
        private static final long INIT_BIT_SAMPLE_COUNT = 8L;
        private long initBits = 15L;
        private HugeLongArray nodeFrequencies;
        private HugeDoubleArray positiveSamplingProbabilities;
        private HugeLongArray negativeSamplingDistribution;
        private long sampleCount;

        private Builder() {
        }

        public final Builder from(ImmutableRandomWalkProbabilities instance) {
            return this.from((RandomWalkProbabilities)instance);
        }

        final Builder from(RandomWalkProbabilities instance) {
            Objects.requireNonNull(instance, "instance");
            this.nodeFrequencies(instance.nodeFrequencies());
            this.positiveSamplingProbabilities(instance.positiveSamplingProbabilities());
            this.negativeSamplingDistribution(instance.negativeSamplingDistribution());
            this.sampleCount(instance.sampleCount());
            return this;
        }

        public final Builder nodeFrequencies(HugeLongArray nodeFrequencies) {
            this.nodeFrequencies = Objects.requireNonNull(nodeFrequencies, "nodeFrequencies");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder positiveSamplingProbabilities(HugeDoubleArray positiveSamplingProbabilities) {
            this.positiveSamplingProbabilities = Objects.requireNonNull(positiveSamplingProbabilities, "positiveSamplingProbabilities");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder negativeSamplingDistribution(HugeLongArray negativeSamplingDistribution) {
            this.negativeSamplingDistribution = Objects.requireNonNull(negativeSamplingDistribution, "negativeSamplingDistribution");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder sampleCount(long sampleCount) {
            this.sampleCount = sampleCount;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public Builder clear() {
            this.initBits = 15L;
            this.nodeFrequencies = null;
            this.positiveSamplingProbabilities = null;
            this.negativeSamplingDistribution = null;
            this.sampleCount = 0L;
            return this;
        }

        public RandomWalkProbabilities build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRandomWalkProbabilities(null, this.nodeFrequencies, this.positiveSamplingProbabilities, this.negativeSamplingDistribution, this.sampleCount);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("nodeFrequencies");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("positiveSamplingProbabilities");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("negativeSamplingDistribution");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("sampleCount");
            }
            return "Cannot build RandomWalkProbabilities, some of required attributes are not set " + attributes;
        }
    }
}

