/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.node2vec;

import java.util.List;
import org.immutables.value.Value;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.EmbeddingDimensionConfig;
import org.neo4j.gds.traversal.RandomWalkBaseConfig;

public interface Node2VecBaseConfig
extends AlgoBaseConfig,
EmbeddingDimensionConfig,
RandomWalkBaseConfig {
    @Value.Default
    @Configuration.IntegerRange(min=2)
    default public int windowSize() {
        return 10;
    }

    @Value.Default
    @Configuration.IntegerRange(min=1)
    default public int negativeSamplingRate() {
        return 5;
    }

    @Value.Default
    @Configuration.DoubleRange(min=1.0E-5, minInclusive=false, max=1.0)
    default public double positiveSamplingFactor() {
        return 0.001;
    }

    @Value.Default
    @Configuration.DoubleRange(min=1.0E-5, minInclusive=false, max=1.0)
    default public double negativeSamplingExponent() {
        return 0.75;
    }

    @Value.Default
    @Configuration.IntegerRange(min=1)
    default public int embeddingDimension() {
        return 128;
    }

    @Value.Default
    @Configuration.DoubleRange(min=0.0, minInclusive=false)
    default public double initialLearningRate() {
        return 0.025;
    }

    @Value.Default
    @Configuration.DoubleRange(min=0.0, minInclusive=false)
    default public double minLearningRate() {
        return 1.0E-4;
    }

    @Value.Default
    default public int iterations() {
        return 1;
    }

    @Configuration.Ignore
    @Value.Default
    default public List<Long> sourceNodes() {
        return List.of();
    }
}

