/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.embeddings.node2vec;

import java.util.Iterator;
import java.util.concurrent.ThreadLocalRandom;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.mem.BitUtil;

public class PositiveSampleProducer {
    private static final int FILTERED_NODE_MARKER = -2;
    private final Iterator<long[]> walks;
    private final HugeDoubleArray samplingProbabilities;
    private final int prefixWindowSize;
    private final int postfixWindowSize;
    private final ProgressTracker progressTracker;
    private long[] currentWalk;
    private int centerWordIndex;
    private long currentCenterWord;
    private int contextWordIndex;
    private int currentWindowStart;
    private int currentWindowEnd;

    PositiveSampleProducer(Iterator<long[]> walks, HugeDoubleArray samplingProbabilities, int windowSize, ProgressTracker progressTracker) {
        this.walks = walks;
        this.progressTracker = progressTracker;
        this.samplingProbabilities = samplingProbabilities;
        this.prefixWindowSize = BitUtil.ceilDiv((int)(windowSize - 1), (int)2);
        this.postfixWindowSize = (windowSize - 1) / 2;
        this.currentWalk = new long[0];
        this.centerWordIndex = -1;
        this.contextWordIndex = 1;
    }

    public boolean next(long[] buffer) {
        if (this.nextContextWord()) {
            buffer[0] = this.currentCenterWord;
            buffer[1] = this.currentWalk[this.contextWordIndex];
            return true;
        }
        return false;
    }

    private boolean nextWalk() {
        if (!this.walks.hasNext()) {
            return false;
        }
        long[] walk = this.walks.next();
        this.progressTracker.logProgress();
        int filteredWalkLength = this.filter(walk);
        while (filteredWalkLength < 2 && this.walks.hasNext()) {
            walk = this.walks.next();
            filteredWalkLength = this.filter(walk);
        }
        if (filteredWalkLength >= 2) {
            this.currentWalk = walk;
            this.centerWordIndex = -1;
            return this.nextCenterWord();
        }
        return false;
    }

    private boolean nextCenterWord() {
        ++this.centerWordIndex;
        if (this.centerWordIndex >= this.currentWalk.length || this.currentWalk[this.centerWordIndex] == -1L) {
            return this.nextWalk();
        }
        if (this.currentWalk[this.centerWordIndex] == -2L) {
            return this.nextCenterWord();
        }
        this.currentCenterWord = this.currentWalk[this.centerWordIndex];
        this.setContextBoundaries();
        this.contextWordIndex = this.currentWindowStart - 1;
        return this.nextContextWord();
    }

    private boolean nextContextWord() {
        if (this.currentWalk.length == 0) {
            return this.nextCenterWord();
        }
        ++this.contextWordIndex;
        if (this.contextWordIndex <= this.currentWindowEnd && this.contextWordIndex != this.centerWordIndex && this.currentWalk[this.contextWordIndex] >= 0L) {
            return true;
        }
        if (this.contextWordIndex > this.currentWindowEnd) {
            return this.nextCenterWord();
        }
        return this.nextContextWord();
    }

    private int filter(long[] walk) {
        int filteredWalkLength = 0;
        for (int i = 0; i < walk.length; ++i) {
            if (walk[i] >= 0L && this.shouldPickNode(walk[i])) {
                ++filteredWalkLength;
                continue;
            }
            if (walk[i] < 0L) continue;
            walk[i] = -2L;
        }
        return filteredWalkLength;
    }

    private boolean shouldPickNode(long nodeId) {
        return ThreadLocalRandom.current().nextDouble(0.0, 1.0) < this.samplingProbabilities.get(nodeId);
    }

    private void setContextBoundaries() {
        int currentPrefixSize = this.prefixWindowSize;
        this.currentWindowStart = this.centerWordIndex;
        while (currentPrefixSize > 0 && this.currentWindowStart > 0) {
            --this.currentWindowStart;
            if (this.currentWindowStart < 0 || this.currentWalk[this.currentWindowStart] <= 0L) continue;
            --currentPrefixSize;
        }
        int currentPostfixSize = this.postfixWindowSize;
        this.currentWindowEnd = this.centerWordIndex;
        while (currentPostfixSize > 0 && this.currentWindowEnd < this.currentWalk.length - 1 && this.currentWalk[this.currentWindowEnd] != -1L) {
            ++this.currentWindowEnd;
            if (this.currentWalk[this.currentWindowEnd] <= 0L) continue;
            --currentPostfixSize;
        }
    }
}

