/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.labelpropagation;

import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.api.RelationshipIterator;
import org.neo4j.gds.api.RelationshipWithPropertyConsumer;
import org.neo4j.gds.core.utils.collection.primitive.PrimitiveLongIterable;
import org.neo4j.gds.core.utils.collection.primitive.PrimitiveLongIterator;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.labelpropagation.ComputeStepConsumer;
import org.neo4j.gds.labelpropagation.Step;

final class ComputeStep
implements Step {
    private static final double DEFAULT_WEIGHT = 1.0;
    private final RelationshipIterator localRelationshipIterator;
    private final HugeLongArray existingLabels;
    private final PrimitiveLongIterable nodes;
    private final ProgressTracker progressTracker;
    private final ComputeStepConsumer consumer;
    private final Graph graph;
    private boolean didChange = true;

    ComputeStep(Graph graph, NodeProperties nodeWeights, ProgressTracker progressTracker, HugeLongArray existingLabels, PrimitiveLongIterable nodes) {
        this.existingLabels = existingLabels;
        this.progressTracker = progressTracker;
        this.graph = graph;
        this.localRelationshipIterator = graph.concurrentCopy();
        this.nodes = nodes;
        this.consumer = new ComputeStepConsumer(nodeWeights, existingLabels);
    }

    @Override
    public Step next() {
        return this;
    }

    @Override
    public void run() {
        this.didChange = this.iterateAll(this.nodes.iterator());
    }

    @Override
    public boolean didConverge() {
        return !this.didChange;
    }

    private boolean iterateAll(PrimitiveLongIterator nodeIds) {
        boolean didChange = false;
        while (nodeIds.hasNext()) {
            long nodeId = nodeIds.next();
            didChange = this.compute(nodeId, didChange);
            this.progressTracker.logProgress((long)this.graph.degree(nodeId));
        }
        return didChange;
    }

    private boolean compute(long nodeId, boolean didChange) {
        this.consumer.clearVotes();
        long label = this.existingLabels.get(nodeId);
        this.localRelationshipIterator.forEachRelationship(nodeId, 1.0, (RelationshipWithPropertyConsumer)this.consumer);
        long newLabel = this.consumer.tallyVotes(label);
        if (newLabel != label) {
            this.existingLabels.set(nodeId, newLabel);
            return true;
        }
        return didChange;
    }

    @Override
    public void release() {
        this.consumer.release();
    }
}

