/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.labelpropagation;

import com.carrotsearch.hppc.LongDoubleScatterMap;
import com.carrotsearch.hppc.cursors.LongDoubleCursor;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.api.RelationshipWithPropertyConsumer;
import org.neo4j.gds.core.utils.paged.HugeLongArray;

final class ComputeStepConsumer
implements RelationshipWithPropertyConsumer {
    private final NodeProperties nodeWeights;
    private final HugeLongArray existingLabels;
    private final LongDoubleScatterMap votes;
    private static final long[] EMPTY_LONGS = new long[0];

    ComputeStepConsumer(NodeProperties nodeWeights, HugeLongArray existingLabels) {
        this.existingLabels = existingLabels;
        this.nodeWeights = nodeWeights;
        this.votes = new LongDoubleScatterMap();
    }

    public boolean accept(long sourceNodeId, long targetNodeId, double property) {
        this.castVote(targetNodeId, property);
        return true;
    }

    private void castVote(long candidate, double weight) {
        weight = this.weightOf(candidate, weight);
        long label = this.existingLabels.get(candidate);
        this.votes.addTo(label, weight);
    }

    private double weightOf(long candidate, double relationshipWeight) {
        double nodeWeight = this.nodeWeights.doubleValue(candidate);
        return relationshipWeight * nodeWeight;
    }

    void clearVotes() {
        this.votes.clear();
    }

    long tallyVotes(long label) {
        double weight = Double.NEGATIVE_INFINITY;
        for (LongDoubleCursor vote : this.votes) {
            if (weight < vote.value) {
                weight = vote.value;
                label = vote.key;
                continue;
            }
            if (weight != vote.value || vote.key >= label) continue;
            label = vote.key;
        }
        return label;
    }

    void release() {
        if (this.votes.keys != null) {
            this.votes.keys = EMPTY_LONGS;
            this.votes.clear();
            this.votes.keys = null;
            this.votes.values = null;
        }
    }
}

