/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.labelpropagation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.config.ConsecutiveIdsConfig;
import org.neo4j.gds.config.IterationsConfig;
import org.neo4j.gds.config.MutatePropertyConfig;
import org.neo4j.gds.config.NodeWeightConfig;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.config.SeedConfig;
import org.neo4j.gds.labelpropagation.LabelPropagationBaseConfig;
import org.neo4j.gds.labelpropagation.LabelPropagationMutateConfig;

@Generated(from="LabelPropagationMutateConfig", generator="Immutables")
public final class ImmutableLabelPropagationMutateConfig
implements LabelPropagationMutateConfig {
    @Nullable
    private final String usernameOverride;
    private final boolean sudo;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    private final int concurrency;
    private final int minBatchSize;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    @Nullable
    private final String seedProperty;
    private final boolean consecutiveIds;
    @Nullable
    private final String relationshipWeightProperty;
    private final transient boolean hasRelationshipWeightProperty;
    @Nullable
    private final String nodeWeightProperty;
    private final int maxIterations;
    private final String mutateProperty;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableLabelPropagationMutateConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, @Nullable String seedProperty, boolean consecutiveIds, @Nullable String relationshipWeightProperty, @Nullable String nodeWeightProperty, int maxIterations, String mutateProperty) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableLabelPropagationMutateConfig.createUnmodifiableList(false, ImmutableLabelPropagationMutateConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableLabelPropagationMutateConfig.createUnmodifiableList(false, ImmutableLabelPropagationMutateConfig.createSafeList(nodeLabels, true, false)));
        this.initShim.seedProperty(seedProperty);
        this.initShim.consecutiveIds(consecutiveIds);
        this.initShim.relationshipWeightProperty(relationshipWeightProperty);
        this.initShim.nodeWeightProperty(nodeWeightProperty);
        this.initShim.maxIterations(maxIterations);
        this.mutateProperty = Objects.requireNonNull(mutateProperty, "mutateProperty");
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.seedProperty = this.initShim.seedProperty();
        this.consecutiveIds = this.initShim.consecutiveIds();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.nodeWeightProperty = this.initShim.nodeWeightProperty();
        this.maxIterations = this.initShim.maxIterations();
        this.initShim = null;
    }

    private ImmutableLabelPropagationMutateConfig(Builder builder) {
        this.mutateProperty = builder.mutateProperty;
        if (builder.usernameOverrideIsSet()) {
            this.initShim.usernameOverride(builder.usernameOverride);
        }
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.minBatchSizeIsSet()) {
            this.initShim.minBatchSize(builder.minBatchSize);
        }
        if (builder.relationshipTypesIsSet()) {
            this.initShim.relationshipTypes(builder.relationshipTypes == null ? Collections.emptyList() : ImmutableLabelPropagationMutateConfig.createUnmodifiableList(true, builder.relationshipTypes));
        }
        if (builder.nodeLabelsIsSet()) {
            this.initShim.nodeLabels(builder.nodeLabels == null ? Collections.emptyList() : ImmutableLabelPropagationMutateConfig.createUnmodifiableList(true, builder.nodeLabels));
        }
        if (builder.seedPropertyIsSet()) {
            this.initShim.seedProperty(builder.seedProperty);
        }
        if (builder.consecutiveIdsIsSet()) {
            this.initShim.consecutiveIds(builder.consecutiveIds);
        }
        if (builder.relationshipWeightPropertyIsSet()) {
            this.initShim.relationshipWeightProperty(builder.relationshipWeightProperty);
        }
        if (builder.nodeWeightPropertyIsSet()) {
            this.initShim.nodeWeightProperty(builder.nodeWeightProperty);
        }
        if (builder.maxIterationsIsSet()) {
            this.initShim.maxIterations(builder.maxIterations);
        }
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.seedProperty = this.initShim.seedProperty();
        this.consecutiveIds = this.initShim.consecutiveIds();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.nodeWeightProperty = this.initShim.nodeWeightProperty();
        this.maxIterations = this.initShim.maxIterations();
        this.initShim = null;
    }

    private ImmutableLabelPropagationMutateConfig(@Nullable String usernameOverride, boolean sudo, Collection<String> configKeys, int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, @Nullable String seedProperty, boolean consecutiveIds, @Nullable String relationshipWeightProperty, @Nullable String nodeWeightProperty, int maxIterations, String mutateProperty) {
        this.initShim.usernameOverride(usernameOverride);
        this.initShim.sudo(sudo);
        this.initShim.configKeys(configKeys);
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(relationshipTypes);
        this.initShim.nodeLabels(nodeLabels);
        this.initShim.seedProperty(seedProperty);
        this.initShim.consecutiveIds(consecutiveIds);
        this.initShim.relationshipWeightProperty(relationshipWeightProperty);
        this.initShim.nodeWeightProperty(nodeWeightProperty);
        this.initShim.maxIterations(maxIterations);
        this.mutateProperty = mutateProperty;
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.seedProperty = this.initShim.seedProperty();
        this.consecutiveIds = this.initShim.consecutiveIds();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.nodeWeightProperty = this.initShim.nodeWeightProperty();
        this.maxIterations = this.initShim.maxIterations();
        this.initShim = null;
    }

    @Nullable
    private String usernameOverrideInitialize() {
        return LabelPropagationMutateConfig.super.usernameOverride();
    }

    private boolean sudoInitialize() {
        return LabelPropagationMutateConfig.super.sudo();
    }

    private Collection<String> configKeysInitialize() {
        return LabelPropagationMutateConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return LabelPropagationMutateConfig.super.toMap();
    }

    private int concurrencyInitialize() {
        return LabelPropagationMutateConfig.super.concurrency();
    }

    private int minBatchSizeInitialize() {
        return LabelPropagationMutateConfig.super.minBatchSize();
    }

    private List<String> relationshipTypesInitialize() {
        return LabelPropagationMutateConfig.super.relationshipTypes();
    }

    private List<String> nodeLabelsInitialize() {
        return LabelPropagationMutateConfig.super.nodeLabels();
    }

    @Nullable
    private String seedPropertyInitialize() {
        return LabelPropagationMutateConfig.super.seedProperty();
    }

    private boolean consecutiveIdsInitialize() {
        return LabelPropagationMutateConfig.super.consecutiveIds();
    }

    @Nullable
    private String relationshipWeightPropertyInitialize() {
        return LabelPropagationMutateConfig.super.relationshipWeightProperty();
    }

    private boolean hasRelationshipWeightPropertyInitialize() {
        return LabelPropagationMutateConfig.super.hasRelationshipWeightProperty();
    }

    @Nullable
    private String nodeWeightPropertyInitialize() {
        return LabelPropagationMutateConfig.super.nodeWeightProperty();
    }

    private int maxIterationsInitialize() {
        return LabelPropagationMutateConfig.super.maxIterations();
    }

    @Nullable
    public String usernameOverride() {
        InitShim shim = this.initShim;
        return shim != null ? shim.usernameOverride() : this.usernameOverride;
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    public int minBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minBatchSize() : this.minBatchSize;
    }

    public List<String> relationshipTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipTypes() : this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeLabels() : this.nodeLabels;
    }

    @Nullable
    public String seedProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.seedProperty() : this.seedProperty;
    }

    public boolean consecutiveIds() {
        InitShim shim = this.initShim;
        return shim != null ? shim.consecutiveIds() : this.consecutiveIds;
    }

    @Nullable
    public String relationshipWeightProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipWeightProperty() : this.relationshipWeightProperty;
    }

    public boolean hasRelationshipWeightProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasRelationshipWeightProperty() : this.hasRelationshipWeightProperty;
    }

    @Nullable
    public String nodeWeightProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeWeightProperty() : this.nodeWeightProperty;
    }

    @Override
    public int maxIterations() {
        InitShim shim = this.initShim;
        return shim != null ? shim.maxIterations() : this.maxIterations;
    }

    public String mutateProperty() {
        return this.mutateProperty;
    }

    public final ImmutableLabelPropagationMutateConfig withUsernameOverride(@Nullable String value) {
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return ImmutableLabelPropagationMutateConfig.validate(new ImmutableLabelPropagationMutateConfig(value, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.nodeWeightProperty, this.maxIterations, this.mutateProperty));
    }

    public final ImmutableLabelPropagationMutateConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutableLabelPropagationMutateConfig.validate(new ImmutableLabelPropagationMutateConfig(this.usernameOverride, value, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.nodeWeightProperty, this.maxIterations, this.mutateProperty));
    }

    public final ImmutableLabelPropagationMutateConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutableLabelPropagationMutateConfig.validate(new ImmutableLabelPropagationMutateConfig(this.usernameOverride, this.sudo, newValue, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.nodeWeightProperty, this.maxIterations, this.mutateProperty));
    }

    public final ImmutableLabelPropagationMutateConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutableLabelPropagationMutateConfig.validate(new ImmutableLabelPropagationMutateConfig(this.usernameOverride, this.sudo, this.configKeys, value, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.nodeWeightProperty, this.maxIterations, this.mutateProperty));
    }

    public final ImmutableLabelPropagationMutateConfig withMinBatchSize(int value) {
        if (this.minBatchSize == value) {
            return this;
        }
        return ImmutableLabelPropagationMutateConfig.validate(new ImmutableLabelPropagationMutateConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, value, this.relationshipTypes, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.nodeWeightProperty, this.maxIterations, this.mutateProperty));
    }

    public final ImmutableLabelPropagationMutateConfig withRelationshipTypes(String ... elements) {
        List<String> newValue = ImmutableLabelPropagationMutateConfig.createUnmodifiableList(false, ImmutableLabelPropagationMutateConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableLabelPropagationMutateConfig.validate(new ImmutableLabelPropagationMutateConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.nodeWeightProperty, this.maxIterations, this.mutateProperty));
    }

    public final ImmutableLabelPropagationMutateConfig withRelationshipTypes(Iterable<String> elements) {
        if (this.relationshipTypes == elements) {
            return this;
        }
        List<String> newValue = ImmutableLabelPropagationMutateConfig.createUnmodifiableList(false, ImmutableLabelPropagationMutateConfig.createSafeList(elements, true, false));
        return ImmutableLabelPropagationMutateConfig.validate(new ImmutableLabelPropagationMutateConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.nodeWeightProperty, this.maxIterations, this.mutateProperty));
    }

    public final ImmutableLabelPropagationMutateConfig withNodeLabels(String ... elements) {
        List<String> newValue = ImmutableLabelPropagationMutateConfig.createUnmodifiableList(false, ImmutableLabelPropagationMutateConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableLabelPropagationMutateConfig.validate(new ImmutableLabelPropagationMutateConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, newValue, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.nodeWeightProperty, this.maxIterations, this.mutateProperty));
    }

    public final ImmutableLabelPropagationMutateConfig withNodeLabels(Iterable<String> elements) {
        if (this.nodeLabels == elements) {
            return this;
        }
        List<String> newValue = ImmutableLabelPropagationMutateConfig.createUnmodifiableList(false, ImmutableLabelPropagationMutateConfig.createSafeList(elements, true, false));
        return ImmutableLabelPropagationMutateConfig.validate(new ImmutableLabelPropagationMutateConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, newValue, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.nodeWeightProperty, this.maxIterations, this.mutateProperty));
    }

    public final ImmutableLabelPropagationMutateConfig withSeedProperty(@Nullable String value) {
        if (Objects.equals(this.seedProperty, value)) {
            return this;
        }
        return ImmutableLabelPropagationMutateConfig.validate(new ImmutableLabelPropagationMutateConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, value, this.consecutiveIds, this.relationshipWeightProperty, this.nodeWeightProperty, this.maxIterations, this.mutateProperty));
    }

    public final ImmutableLabelPropagationMutateConfig withConsecutiveIds(boolean value) {
        if (this.consecutiveIds == value) {
            return this;
        }
        return ImmutableLabelPropagationMutateConfig.validate(new ImmutableLabelPropagationMutateConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.seedProperty, value, this.relationshipWeightProperty, this.nodeWeightProperty, this.maxIterations, this.mutateProperty));
    }

    public final ImmutableLabelPropagationMutateConfig withRelationshipWeightProperty(@Nullable String value) {
        if (Objects.equals(this.relationshipWeightProperty, value)) {
            return this;
        }
        return ImmutableLabelPropagationMutateConfig.validate(new ImmutableLabelPropagationMutateConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.seedProperty, this.consecutiveIds, value, this.nodeWeightProperty, this.maxIterations, this.mutateProperty));
    }

    public final ImmutableLabelPropagationMutateConfig withNodeWeightProperty(@Nullable String value) {
        if (Objects.equals(this.nodeWeightProperty, value)) {
            return this;
        }
        return ImmutableLabelPropagationMutateConfig.validate(new ImmutableLabelPropagationMutateConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, value, this.maxIterations, this.mutateProperty));
    }

    public final ImmutableLabelPropagationMutateConfig withMaxIterations(int value) {
        if (this.maxIterations == value) {
            return this;
        }
        return ImmutableLabelPropagationMutateConfig.validate(new ImmutableLabelPropagationMutateConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.nodeWeightProperty, value, this.mutateProperty));
    }

    public final ImmutableLabelPropagationMutateConfig withMutateProperty(String value) {
        String newValue = Objects.requireNonNull(value, "mutateProperty");
        if (this.mutateProperty.equals(newValue)) {
            return this;
        }
        return ImmutableLabelPropagationMutateConfig.validate(new ImmutableLabelPropagationMutateConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.nodeWeightProperty, this.maxIterations, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLabelPropagationMutateConfig && this.equalTo((ImmutableLabelPropagationMutateConfig)another);
    }

    private boolean equalTo(ImmutableLabelPropagationMutateConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && this.concurrency == another.concurrency && this.minBatchSize == another.minBatchSize && this.relationshipTypes.equals(another.relationshipTypes) && this.nodeLabels.equals(another.nodeLabels) && Objects.equals(this.seedProperty, another.seedProperty) && this.consecutiveIds == another.consecutiveIds && Objects.equals(this.relationshipWeightProperty, another.relationshipWeightProperty) && this.hasRelationshipWeightProperty == another.hasRelationshipWeightProperty && Objects.equals(this.nodeWeightProperty, another.nodeWeightProperty) && this.maxIterations == another.maxIterations && this.mutateProperty.equals(another.mutateProperty);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + this.concurrency;
        h += (h << 5) + this.minBatchSize;
        h += (h << 5) + this.relationshipTypes.hashCode();
        h += (h << 5) + this.nodeLabels.hashCode();
        h += (h << 5) + Objects.hashCode(this.seedProperty);
        h += (h << 5) + Boolean.hashCode(this.consecutiveIds);
        h += (h << 5) + Objects.hashCode(this.relationshipWeightProperty);
        h += (h << 5) + Boolean.hashCode(this.hasRelationshipWeightProperty);
        h += (h << 5) + Objects.hashCode(this.nodeWeightProperty);
        h += (h << 5) + this.maxIterations;
        h += (h << 5) + this.mutateProperty.hashCode();
        return h;
    }

    public String toString() {
        return "LabelPropagationMutateConfig{usernameOverride=" + this.usernameOverride + ", sudo=" + this.sudo + ", concurrency=" + this.concurrency + ", minBatchSize=" + this.minBatchSize + ", relationshipTypes=" + this.relationshipTypes + ", nodeLabels=" + this.nodeLabels + ", seedProperty=" + this.seedProperty + ", consecutiveIds=" + this.consecutiveIds + ", relationshipWeightProperty=" + this.relationshipWeightProperty + ", hasRelationshipWeightProperty=" + this.hasRelationshipWeightProperty + ", nodeWeightProperty=" + this.nodeWeightProperty + ", maxIterations=" + this.maxIterations + ", mutateProperty=" + this.mutateProperty + "}";
    }

    public static LabelPropagationMutateConfig of(int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, @Nullable String seedProperty, boolean consecutiveIds, @Nullable String relationshipWeightProperty, @Nullable String nodeWeightProperty, int maxIterations, String mutateProperty) {
        return ImmutableLabelPropagationMutateConfig.of(concurrency, minBatchSize, relationshipTypes, nodeLabels, seedProperty, consecutiveIds, relationshipWeightProperty, nodeWeightProperty, maxIterations, mutateProperty);
    }

    public static LabelPropagationMutateConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, @Nullable String seedProperty, boolean consecutiveIds, @Nullable String relationshipWeightProperty, @Nullable String nodeWeightProperty, int maxIterations, String mutateProperty) {
        return ImmutableLabelPropagationMutateConfig.validate(new ImmutableLabelPropagationMutateConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, seedProperty, consecutiveIds, relationshipWeightProperty, nodeWeightProperty, maxIterations, mutateProperty));
    }

    private static ImmutableLabelPropagationMutateConfig validate(ImmutableLabelPropagationMutateConfig instance) {
        instance.forbidSeedingAndConsecutiveIds();
        instance.validateConcurrency();
        return instance;
    }

    public static LabelPropagationMutateConfig copyOf(LabelPropagationMutateConfig instance) {
        if (instance instanceof ImmutableLabelPropagationMutateConfig) {
            return (ImmutableLabelPropagationMutateConfig)instance;
        }
        return ImmutableLabelPropagationMutateConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="LabelPropagationMutateConfig", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_MUTATE_PROPERTY = 1L;
        private static final long OPT_BIT_USERNAME_OVERRIDE = 1L;
        private static final long OPT_BIT_SUDO = 2L;
        private static final long OPT_BIT_CONCURRENCY = 4L;
        private static final long OPT_BIT_MIN_BATCH_SIZE = 8L;
        private static final long OPT_BIT_RELATIONSHIP_TYPES = 16L;
        private static final long OPT_BIT_NODE_LABELS = 32L;
        private static final long OPT_BIT_SEED_PROPERTY = 64L;
        private static final long OPT_BIT_CONSECUTIVE_IDS = 128L;
        private static final long OPT_BIT_RELATIONSHIP_WEIGHT_PROPERTY = 256L;
        private static final long OPT_BIT_NODE_WEIGHT_PROPERTY = 512L;
        private static final long OPT_BIT_MAX_ITERATIONS = 1024L;
        private long initBits = 1L;
        private long optBits;
        private String usernameOverride;
        private boolean sudo;
        private Collection<String> configKeys;
        private int concurrency;
        private int minBatchSize;
        private List<String> relationshipTypes = null;
        private List<String> nodeLabels = null;
        private String seedProperty;
        private boolean consecutiveIds;
        private String relationshipWeightProperty;
        private String nodeWeightProperty;
        private int maxIterations;
        private String mutateProperty;

        private Builder() {
        }

        public final Builder from(LabelPropagationBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RelationshipWeightConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ConcurrencyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ConsecutiveIdsConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MutatePropertyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AlgoBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(IterationsConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SeedConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(NodeWeightConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(LabelPropagationMutateConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String nodeWeightPropertyValue;
            String seedPropertyValue;
            String relationshipWeightPropertyValue;
            LabelPropagationBaseConfig instance;
            long bits = 0L;
            if (object instanceof LabelPropagationBaseConfig) {
                instance = (LabelPropagationBaseConfig)object;
                if ((bits & 1L) == 0L) {
                    this.maxIterations(instance.maxIterations());
                    bits |= 1L;
                }
            }
            if (object instanceof RelationshipWeightConfig && (relationshipWeightPropertyValue = (instance = (RelationshipWeightConfig)object).relationshipWeightProperty()) != null) {
                this.relationshipWeightProperty(relationshipWeightPropertyValue);
            }
            if (object instanceof ConcurrencyConfig) {
                instance = (ConcurrencyConfig)object;
                this.minBatchSize(instance.minBatchSize());
                this.concurrency(instance.concurrency());
            }
            if (object instanceof ConsecutiveIdsConfig) {
                instance = (ConsecutiveIdsConfig)object;
                this.consecutiveIds(instance.consecutiveIds());
            }
            if (object instanceof MutatePropertyConfig) {
                instance = (MutatePropertyConfig)object;
                this.mutateProperty(instance.mutateProperty());
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                @Nullable String usernameOverrideValue = instance.usernameOverride();
                if (usernameOverrideValue != null) {
                    this.usernameOverride(usernameOverrideValue);
                }
                this.configKeys(instance.configKeys());
                this.sudo(instance.sudo());
            }
            if (object instanceof AlgoBaseConfig) {
                instance = (AlgoBaseConfig)object;
                this.addAllRelationshipTypes(instance.relationshipTypes());
                this.addAllNodeLabels(instance.nodeLabels());
            }
            if (object instanceof IterationsConfig) {
                instance = (IterationsConfig)object;
                if ((bits & 1L) == 0L) {
                    this.maxIterations(instance.maxIterations());
                    bits |= 1L;
                }
            }
            if (object instanceof SeedConfig && (seedPropertyValue = (instance = (SeedConfig)object).seedProperty()) != null) {
                this.seedProperty(seedPropertyValue);
            }
            if (object instanceof NodeWeightConfig && (nodeWeightPropertyValue = (instance = (NodeWeightConfig)object).nodeWeightProperty()) != null) {
                this.nodeWeightProperty(nodeWeightPropertyValue);
            }
        }

        public final Builder usernameOverride(@Nullable String usernameOverride) {
            this.usernameOverride = usernameOverride;
            this.optBits |= 1L;
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 2L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 4L;
            return this;
        }

        public final Builder minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.optBits |= 8L;
            return this;
        }

        public final Builder addRelationshipType(String element) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addRelationshipTypes(String ... elements) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder relationshipTypes(Iterable<String> elements) {
            this.relationshipTypes = new ArrayList<String>();
            return this.addAllRelationshipTypes(elements);
        }

        public final Builder addAllRelationshipTypes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "relationshipTypes element");
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addNodeLabel(String element) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder addNodeLabels(String ... elements) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder nodeLabels(Iterable<String> elements) {
            this.nodeLabels = new ArrayList<String>();
            return this.addAllNodeLabels(elements);
        }

        public final Builder addAllNodeLabels(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeLabels element");
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder seedProperty(@Nullable String seedProperty) {
            this.seedProperty = seedProperty;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder consecutiveIds(boolean consecutiveIds) {
            this.consecutiveIds = consecutiveIds;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder relationshipWeightProperty(@Nullable String relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty;
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder nodeWeightProperty(@Nullable String nodeWeightProperty) {
            this.nodeWeightProperty = nodeWeightProperty;
            this.optBits |= 0x200L;
            return this;
        }

        public final Builder maxIterations(int maxIterations) {
            this.maxIterations = maxIterations;
            this.optBits |= 0x400L;
            return this;
        }

        public final Builder mutateProperty(String mutateProperty) {
            this.mutateProperty = Objects.requireNonNull(mutateProperty, "mutateProperty");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder clear() {
            this.initBits = 1L;
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.configKeys = null;
            this.concurrency = 0;
            this.minBatchSize = 0;
            if (this.relationshipTypes != null) {
                this.relationshipTypes.clear();
            }
            if (this.nodeLabels != null) {
                this.nodeLabels.clear();
            }
            this.seedProperty = null;
            this.consecutiveIds = false;
            this.relationshipWeightProperty = null;
            this.nodeWeightProperty = null;
            this.maxIterations = 0;
            this.mutateProperty = null;
            return this;
        }

        public LabelPropagationMutateConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableLabelPropagationMutateConfig.validate(new ImmutableLabelPropagationMutateConfig(this));
        }

        private boolean usernameOverrideIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean sudoIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean minBatchSizeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean relationshipTypesIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean nodeLabelsIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean seedPropertyIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean consecutiveIdsIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean relationshipWeightPropertyIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean nodeWeightPropertyIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private boolean maxIterationsIsSet() {
            return (this.optBits & 0x400L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("mutateProperty");
            }
            return "Cannot build LabelPropagationMutateConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="LabelPropagationMutateConfig", generator="Immutables")
    private final class InitShim {
        private byte usernameOverrideBuildStage = 0;
        private String usernameOverride;
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte concurrencyBuildStage = 0;
        private int concurrency;
        private byte minBatchSizeBuildStage = 0;
        private int minBatchSize;
        private byte relationshipTypesBuildStage = 0;
        private List<String> relationshipTypes;
        private byte nodeLabelsBuildStage = 0;
        private List<String> nodeLabels;
        private byte seedPropertyBuildStage = 0;
        private String seedProperty;
        private byte consecutiveIdsBuildStage = 0;
        private boolean consecutiveIds;
        private byte relationshipWeightPropertyBuildStage = 0;
        private String relationshipWeightProperty;
        private byte hasRelationshipWeightPropertyBuildStage = 0;
        private boolean hasRelationshipWeightProperty;
        private byte nodeWeightPropertyBuildStage = 0;
        private String nodeWeightProperty;
        private byte maxIterationsBuildStage = 0;
        private int maxIterations;

        private InitShim() {
        }

        String usernameOverride() {
            if (this.usernameOverrideBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usernameOverrideBuildStage == 0) {
                this.usernameOverrideBuildStage = (byte)-1;
                this.usernameOverride = ImmutableLabelPropagationMutateConfig.this.usernameOverrideInitialize();
                this.usernameOverrideBuildStage = 1;
            }
            return this.usernameOverride;
        }

        void usernameOverride(String usernameOverride) {
            this.usernameOverride = usernameOverride;
            this.usernameOverrideBuildStage = 1;
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableLabelPropagationMutateConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableLabelPropagationMutateConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableLabelPropagationMutateConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutableLabelPropagationMutateConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        int minBatchSize() {
            if (this.minBatchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minBatchSizeBuildStage == 0) {
                this.minBatchSizeBuildStage = (byte)-1;
                this.minBatchSize = ImmutableLabelPropagationMutateConfig.this.minBatchSizeInitialize();
                this.minBatchSizeBuildStage = 1;
            }
            return this.minBatchSize;
        }

        void minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.minBatchSizeBuildStage = 1;
        }

        List<String> relationshipTypes() {
            if (this.relationshipTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipTypesBuildStage == 0) {
                this.relationshipTypesBuildStage = (byte)-1;
                this.relationshipTypes = ImmutableLabelPropagationMutateConfig.createUnmodifiableList(false, ImmutableLabelPropagationMutateConfig.createSafeList(ImmutableLabelPropagationMutateConfig.this.relationshipTypesInitialize(), true, false));
                this.relationshipTypesBuildStage = 1;
            }
            return this.relationshipTypes;
        }

        void relationshipTypes(List<String> relationshipTypes) {
            this.relationshipTypes = relationshipTypes;
            this.relationshipTypesBuildStage = 1;
        }

        List<String> nodeLabels() {
            if (this.nodeLabelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeLabelsBuildStage == 0) {
                this.nodeLabelsBuildStage = (byte)-1;
                this.nodeLabels = ImmutableLabelPropagationMutateConfig.createUnmodifiableList(false, ImmutableLabelPropagationMutateConfig.createSafeList(ImmutableLabelPropagationMutateConfig.this.nodeLabelsInitialize(), true, false));
                this.nodeLabelsBuildStage = 1;
            }
            return this.nodeLabels;
        }

        void nodeLabels(List<String> nodeLabels) {
            this.nodeLabels = nodeLabels;
            this.nodeLabelsBuildStage = 1;
        }

        String seedProperty() {
            if (this.seedPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.seedPropertyBuildStage == 0) {
                this.seedPropertyBuildStage = (byte)-1;
                this.seedProperty = ImmutableLabelPropagationMutateConfig.this.seedPropertyInitialize();
                this.seedPropertyBuildStage = 1;
            }
            return this.seedProperty;
        }

        void seedProperty(String seedProperty) {
            this.seedProperty = seedProperty;
            this.seedPropertyBuildStage = 1;
        }

        boolean consecutiveIds() {
            if (this.consecutiveIdsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.consecutiveIdsBuildStage == 0) {
                this.consecutiveIdsBuildStage = (byte)-1;
                this.consecutiveIds = ImmutableLabelPropagationMutateConfig.this.consecutiveIdsInitialize();
                this.consecutiveIdsBuildStage = 1;
            }
            return this.consecutiveIds;
        }

        void consecutiveIds(boolean consecutiveIds) {
            this.consecutiveIds = consecutiveIds;
            this.consecutiveIdsBuildStage = 1;
        }

        String relationshipWeightProperty() {
            if (this.relationshipWeightPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipWeightPropertyBuildStage == 0) {
                this.relationshipWeightPropertyBuildStage = (byte)-1;
                this.relationshipWeightProperty = ImmutableLabelPropagationMutateConfig.this.relationshipWeightPropertyInitialize();
                this.relationshipWeightPropertyBuildStage = 1;
            }
            return this.relationshipWeightProperty;
        }

        void relationshipWeightProperty(String relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty;
            this.relationshipWeightPropertyBuildStage = 1;
        }

        boolean hasRelationshipWeightProperty() {
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasRelationshipWeightPropertyBuildStage == 0) {
                this.hasRelationshipWeightPropertyBuildStage = (byte)-1;
                this.hasRelationshipWeightProperty = ImmutableLabelPropagationMutateConfig.this.hasRelationshipWeightPropertyInitialize();
                this.hasRelationshipWeightPropertyBuildStage = 1;
            }
            return this.hasRelationshipWeightProperty;
        }

        String nodeWeightProperty() {
            if (this.nodeWeightPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeWeightPropertyBuildStage == 0) {
                this.nodeWeightPropertyBuildStage = (byte)-1;
                this.nodeWeightProperty = ImmutableLabelPropagationMutateConfig.this.nodeWeightPropertyInitialize();
                this.nodeWeightPropertyBuildStage = 1;
            }
            return this.nodeWeightProperty;
        }

        void nodeWeightProperty(String nodeWeightProperty) {
            this.nodeWeightProperty = nodeWeightProperty;
            this.nodeWeightPropertyBuildStage = 1;
        }

        int maxIterations() {
            if (this.maxIterationsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.maxIterationsBuildStage == 0) {
                this.maxIterationsBuildStage = (byte)-1;
                this.maxIterations = ImmutableLabelPropagationMutateConfig.this.maxIterationsInitialize();
                this.maxIterationsBuildStage = 1;
            }
            return this.maxIterations;
        }

        void maxIterations(int maxIterations) {
            this.maxIterations = maxIterations;
            this.maxIterationsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.usernameOverrideBuildStage == -1) {
                attributes.add("usernameOverride");
            }
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.minBatchSizeBuildStage == -1) {
                attributes.add("minBatchSize");
            }
            if (this.relationshipTypesBuildStage == -1) {
                attributes.add("relationshipTypes");
            }
            if (this.nodeLabelsBuildStage == -1) {
                attributes.add("nodeLabels");
            }
            if (this.seedPropertyBuildStage == -1) {
                attributes.add("seedProperty");
            }
            if (this.consecutiveIdsBuildStage == -1) {
                attributes.add("consecutiveIds");
            }
            if (this.relationshipWeightPropertyBuildStage == -1) {
                attributes.add("relationshipWeightProperty");
            }
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                attributes.add("hasRelationshipWeightProperty");
            }
            if (this.nodeWeightPropertyBuildStage == -1) {
                attributes.add("nodeWeightProperty");
            }
            if (this.maxIterationsBuildStage == -1) {
                attributes.add("maxIterations");
            }
            return "Cannot build LabelPropagationMutateConfig, attribute initializers form cycle " + attributes;
        }
    }
}

