/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.labelpropagation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.loading.NullPropertyMap;
import org.neo4j.gds.core.utils.LazyBatchCollection;
import org.neo4j.gds.core.utils.TerminationFlag;
import org.neo4j.gds.core.utils.collection.primitive.PrimitiveLongCollections;
import org.neo4j.gds.core.utils.collection.primitive.PrimitiveLongIterable;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.labelpropagation.InitStep;
import org.neo4j.gds.labelpropagation.LabelPropagationBaseConfig;
import org.neo4j.gds.labelpropagation.StepRunner;

public class LabelPropagation
extends Algorithm<LabelPropagation> {
    private final long nodeCount;
    private final NodeProperties nodeProperties;
    private final NodeProperties nodeWeights;
    private final LabelPropagationBaseConfig config;
    private final ExecutorService executor;
    private Graph graph;
    private HugeLongArray labels;
    private final long maxLabelId;
    private long ranIterations;
    private boolean didConverge;
    private int batchSize;

    public LabelPropagation(Graph graph, LabelPropagationBaseConfig config, ExecutorService executor, ProgressTracker progressTracker) {
        super(progressTracker);
        this.graph = graph;
        this.nodeCount = graph.nodeCount();
        this.config = config;
        this.executor = executor;
        this.batchSize = 10000;
        String seedPropertyKey = config.seedProperty();
        Object seedProperty = seedPropertyKey != null && graph.availableNodeProperties().contains(seedPropertyKey) ? graph.nodeProperties(seedPropertyKey) : new NullPropertyMap.LongNullPropertyMap(Long.MIN_VALUE);
        this.nodeProperties = seedProperty;
        String nodeWeightPropertyKey = config.nodeWeightProperty();
        Object nodeWeightProperty = nodeWeightPropertyKey != null && graph.availableNodeProperties().contains(nodeWeightPropertyKey) ? graph.nodeProperties(nodeWeightPropertyKey) : new NullPropertyMap.DoubleNullPropertyMap(1.0);
        this.nodeWeights = nodeWeightProperty;
        this.maxLabelId = seedProperty.getMaxLongPropertyValue().orElse(-1L);
    }

    public void release() {
        this.graph = null;
    }

    public long ranIterations() {
        return this.ranIterations;
    }

    public boolean didConverge() {
        return this.didConverge;
    }

    public HugeLongArray labels() {
        return this.labels;
    }

    public LabelPropagation compute() {
        if ((long)this.config.maxIterations() <= 0L) {
            throw new IllegalArgumentException("Must iterate at least 1 time");
        }
        this.progressTracker.beginSubTask();
        if (this.labels == null || this.labels.size() != this.nodeCount) {
            this.labels = HugeLongArray.newArray((long)this.nodeCount);
        }
        this.ranIterations = 0L;
        this.didConverge = false;
        List<StepRunner> stepRunners = this.stepRunners();
        this.progressTracker.beginSubTask();
        while (this.ranIterations < (long)this.config.maxIterations()) {
            this.progressTracker.beginSubTask();
            ParallelUtil.runWithConcurrency((int)this.config.concurrency(), stepRunners, (long)1L, (TimeUnit)TimeUnit.MICROSECONDS, (TerminationFlag)this.terminationFlag, (ExecutorService)this.executor);
            ++this.ranIterations;
            this.didConverge = stepRunners.stream().allMatch(StepRunner::didConverge);
            this.progressTracker.endSubTask();
            if (!this.didConverge) continue;
        }
        this.progressTracker.endSubTask();
        stepRunners.forEach(StepRunner::release);
        this.progressTracker.endSubTask();
        return this;
    }

    private List<StepRunner> stepRunners() {
        long nodeCount = this.graph.nodeCount();
        long batchSize = ParallelUtil.adjustedBatchSize((long)nodeCount, (long)this.batchSize);
        Collection nodeBatches = LazyBatchCollection.of((long)nodeCount, (long)batchSize, (start, length) -> () -> PrimitiveLongCollections.range((long)start, (long)(start + length - 1L)));
        int threads = nodeBatches.size();
        ArrayList<StepRunner> tasks = new ArrayList<StepRunner>(threads);
        for (PrimitiveLongIterable iter : nodeBatches) {
            InitStep initStep = new InitStep(this.graph, this.nodeProperties, this.nodeWeights, iter, this.labels, this.progressTracker, this.maxLabelId);
            StepRunner task = new StepRunner(initStep);
            tasks.add(task);
        }
        this.progressTracker.beginSubTask();
        ParallelUtil.runWithConcurrency((int)this.config.concurrency(), tasks, (long)1L, (TimeUnit)TimeUnit.MICROSECONDS, (TerminationFlag)this.terminationFlag, (ExecutorService)this.executor);
        this.progressTracker.endSubTask();
        return tasks;
    }

    void withBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }
}

