/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.louvain;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.api.DefaultValue;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.api.PartialIdMap;
import org.neo4j.gds.api.RelationshipIterator;
import org.neo4j.gds.api.Relationships;
import org.neo4j.gds.api.nodeproperties.LongNodeProperties;
import org.neo4j.gds.beta.modularity.ImmutableModularityOptimizationStreamConfig;
import org.neo4j.gds.beta.modularity.ModularityOptimization;
import org.neo4j.gds.beta.modularity.ModularityOptimizationFactory;
import org.neo4j.gds.beta.modularity.ModularityOptimizationStreamConfig;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.loading.construction.GraphFactory;
import org.neo4j.gds.core.loading.construction.NodesBuilder;
import org.neo4j.gds.core.loading.construction.RelationshipsBuilder;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.partition.Partition;
import org.neo4j.gds.core.utils.partition.PartitionUtils;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.louvain.LouvainBaseConfig;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public final class Louvain
extends Algorithm<Louvain> {
    private final Graph rootGraph;
    private final LouvainBaseConfig config;
    private final NodeProperties seedingValues;
    private final ExecutorService executorService;
    private HugeLongArray[] dendrograms;
    private double[] modularities;
    private int ranLevels;

    public Louvain(Graph graph, LouvainBaseConfig config, ExecutorService executorService, ProgressTracker progressTracker) {
        super(progressTracker);
        this.config = config;
        this.rootGraph = graph;
        this.seedingValues = Optional.ofNullable(config.seedProperty()).map(arg_0 -> ((Graph)graph).nodeProperties(arg_0)).orElse(null);
        this.executorService = executorService;
        this.dendrograms = new HugeLongArray[config.maxLevels()];
        this.modularities = new double[config.maxLevels()];
    }

    public Louvain compute() {
        this.progressTracker.beginSubTask();
        Graph workingGraph = this.rootGraph;
        Object nextSeedingValues = this.seedingValues;
        long oldNodeCount = this.rootGraph.nodeCount();
        this.ranLevels = 0;
        while (this.ranLevels < this.config.maxLevels()) {
            this.assertRunning();
            ModularityOptimization modularityOptimization = this.runModularityOptimization(workingGraph, (NodeProperties)nextSeedingValues);
            modularityOptimization.release();
            this.modularities[this.ranLevels] = modularityOptimization.getModularity();
            this.dendrograms[this.ranLevels] = HugeLongArray.newArray((long)this.rootGraph.nodeCount());
            long maxCommunityId = this.buildDendrogram(workingGraph, this.ranLevels, modularityOptimization);
            workingGraph = this.summarizeGraph(workingGraph, modularityOptimization, maxCommunityId);
            nextSeedingValues = new OriginalIdNodeProperties(workingGraph);
            if (workingGraph.nodeCount() == oldNodeCount || workingGraph.nodeCount() == 1L || this.hasConverged()) {
                this.resizeResultArrays();
                break;
            }
            oldNodeCount = workingGraph.nodeCount();
            ++this.ranLevels;
        }
        this.progressTracker.endSubTask();
        return this;
    }

    private void resizeResultArrays() {
        int numLevels = this.levels();
        HugeLongArray[] resizedDendrogram = new HugeLongArray[numLevels];
        double[] resizedModularities = new double[numLevels];
        if (numLevels < this.dendrograms.length) {
            System.arraycopy(this.dendrograms, 0, resizedDendrogram, 0, numLevels);
            System.arraycopy(this.modularities, 0, resizedModularities, 0, numLevels);
        }
        this.dendrograms = resizedDendrogram;
        this.modularities = resizedModularities;
    }

    private long buildDendrogram(Graph workingGraph, int level, ModularityOptimization modularityOptimization) {
        AtomicLong maxCommunityId = new AtomicLong(0L);
        ParallelUtil.parallelForEachNode((Graph)this.rootGraph, (int)this.config.concurrency(), nodeId -> {
            long currentMaxId;
            boolean updatedMaxCurrentId;
            long prevId = level == 0 ? nodeId : workingGraph.toMappedNodeId(this.dendrograms[level - 1].get(nodeId));
            long communityId = modularityOptimization.getCommunityId(prevId);
            while (!(updatedMaxCurrentId = communityId > (currentMaxId = maxCommunityId.get()) ? maxCommunityId.compareAndSet(currentMaxId, communityId) : true)) {
            }
            this.dendrograms[level].set(nodeId, communityId);
        });
        return maxCommunityId.get();
    }

    private ModularityOptimization runModularityOptimization(Graph louvainGraph, NodeProperties seed) {
        ModularityOptimizationStreamConfig modularityOptimizationConfig = ImmutableModularityOptimizationStreamConfig.builder().maxIterations(this.config.maxIterations()).tolerance(this.config.tolerance()).concurrency(this.config.concurrency()).batchSize(10000).build();
        ModularityOptimization modularityOptimization = new ModularityOptimizationFactory<ModularityOptimizationStreamConfig>().build(louvainGraph, modularityOptimizationConfig, seed, this.progressTracker);
        modularityOptimization.setTerminationFlag(this.terminationFlag);
        modularityOptimization.compute();
        return modularityOptimization;
    }

    private Graph summarizeGraph(Graph workingGraph, ModularityOptimization modularityOptimization, long maxCommunityId) {
        NodesBuilder nodesBuilder = GraphFactory.initNodesBuilder().maxOriginalId(maxCommunityId).concurrency(this.config.concurrency()).build();
        this.assertRunning();
        workingGraph.forEachNode(nodeId -> {
            nodesBuilder.addNode(modularityOptimization.getCommunityId(nodeId));
            return true;
        });
        this.assertRunning();
        Orientation orientation = this.rootGraph.isUndirected() ? Orientation.UNDIRECTED : Orientation.NATURAL;
        IdMap idMap = nodesBuilder.build().idMap();
        RelationshipsBuilder relationshipsBuilder = GraphFactory.initRelationshipsBuilder().nodes((PartialIdMap)idMap).orientation(orientation).addPropertyConfig(Aggregation.SUM, DefaultValue.forDouble()).executorService(this.executorService).build();
        List relationshipCreators = PartitionUtils.rangePartition((int)this.config.concurrency(), (long)workingGraph.nodeCount(), partition -> new RelationshipCreator(relationshipsBuilder, modularityOptimization, (RelationshipIterator)workingGraph.concurrentCopy(), (Partition)partition), Optional.empty());
        ParallelUtil.run((Collection)relationshipCreators, (ExecutorService)this.executorService);
        return GraphFactory.create((IdMap)idMap, (Relationships)relationshipsBuilder.build());
    }

    private boolean hasConverged() {
        if (this.ranLevels == 0) {
            return false;
        }
        double currentModularity = this.modularities[this.ranLevels];
        double previousModularity = this.modularities[this.ranLevels - 1];
        return !(currentModularity > previousModularity) || !(Math.abs(currentModularity - previousModularity) > this.config.tolerance());
    }

    public HugeLongArray[] dendrograms() {
        return this.dendrograms;
    }

    public HugeLongArray finalDendrogram() {
        return this.dendrograms[this.levels() - 1];
    }

    public long getCommunity(long nodeId) {
        return this.dendrograms[this.levels() - 1].get(nodeId);
    }

    public long[] getCommunities(long nodeId) {
        long[] communities = new long[this.dendrograms.length];
        for (int i = 0; i < this.dendrograms.length; ++i) {
            communities[i] = this.dendrograms[i].get(nodeId);
        }
        return communities;
    }

    public int levels() {
        return this.ranLevels == 0 ? 1 : this.ranLevels;
    }

    public double[] modularities() {
        return this.modularities;
    }

    public void release() {
        this.rootGraph.releaseTopology();
    }

    static final class RelationshipCreator
    implements Runnable {
        private final RelationshipsBuilder relationshipsBuilder;
        private final ModularityOptimization modularityOptimization;
        private final RelationshipIterator relationshipIterator;
        private final Partition partition;

        private RelationshipCreator(RelationshipsBuilder relationshipsBuilder, ModularityOptimization modularityOptimization, RelationshipIterator relationshipIterator, Partition partition) {
            this.relationshipsBuilder = relationshipsBuilder;
            this.modularityOptimization = modularityOptimization;
            this.relationshipIterator = relationshipIterator;
            this.partition = partition;
        }

        @Override
        public void run() {
            this.partition.consume(nodeId -> {
                long communityId = this.modularityOptimization.getCommunityId(nodeId);
                this.relationshipIterator.forEachRelationship(nodeId, 1.0, (source, target, property) -> {
                    this.relationshipsBuilder.add(communityId, this.modularityOptimization.getCommunityId(target), property);
                    return true;
                });
            });
        }
    }

    static class OriginalIdNodeProperties
    implements LongNodeProperties {
        private final Graph graph;

        public OriginalIdNodeProperties(Graph graph) {
            this.graph = graph;
        }

        public long longValue(long nodeId) {
            return this.graph.toOriginalNodeId(nodeId);
        }

        public Value value(long nodeId) {
            return Values.longValue((long)this.longValue(nodeId));
        }

        public OptionalLong getMaxLongPropertyValue() {
            return OptionalLong.empty();
        }

        public long size() {
            return this.graph.nodeCount();
        }
    }
}

