/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.msbfs;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.RelationshipIterator;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.msbfs.ANPStrategy;
import org.neo4j.gds.msbfs.BfsConsumer;
import org.neo4j.gds.msbfs.BfsSources;
import org.neo4j.gds.msbfs.BfsWithPredecessorConsumer;
import org.neo4j.gds.msbfs.PredecessorStrategy;
import org.neo4j.gds.utils.CloseableThreadLocal;

public final class MultiSourceBFS
implements Runnable {
    public static final int OMEGA = 64;
    private final CloseableThreadLocal<HugeLongArray> visits;
    private final CloseableThreadLocal<HugeLongArray> visitsNext;
    private final CloseableThreadLocal<HugeLongArray> seens;
    private final CloseableThreadLocal<HugeLongArray> seensNext;
    private final long nodeCount;
    private final RelationshipIterator relationships;
    private final ExecutionStrategy strategy;
    private final boolean allowStartNodeTraversal;
    private final long[] sourceNodes;
    private int sourceNodeCount;
    private long nodeOffset;

    public static MultiSourceBFS aggregatedNeighborProcessing(long nodeCount, RelationshipIterator relationships, BfsConsumer perNodeAction, long ... sourceNodes) {
        return new MultiSourceBFS(nodeCount, relationships, new ANPStrategy(perNodeAction), false, false, sourceNodes);
    }

    public static MultiSourceBFS predecessorProcessing(Graph graph, BfsConsumer perNodeAction, BfsWithPredecessorConsumer perNeighborAction, long ... sourceNodes) {
        return new MultiSourceBFS(graph.nodeCount(), (RelationshipIterator)graph, new PredecessorStrategy(perNodeAction, perNeighborAction), true, false, sourceNodes);
    }

    public MultiSourceBFS(long nodeCount, RelationshipIterator relationships, ExecutionStrategy strategy, boolean initSeenNext, boolean allowStartNodeTraversal, long ... sourceNodes) {
        this.relationships = relationships;
        this.strategy = strategy;
        this.allowStartNodeTraversal = allowStartNodeTraversal;
        long[] lArray = this.sourceNodes = sourceNodes != null && sourceNodes.length > 0 ? sourceNodes : null;
        if (this.sourceNodes != null) {
            Arrays.sort(this.sourceNodes);
        }
        this.nodeCount = nodeCount;
        this.visits = new LocalHugeLongArray(nodeCount);
        this.visitsNext = new LocalHugeLongArray(nodeCount);
        this.seens = new LocalHugeLongArray(nodeCount);
        this.seensNext = initSeenNext ? new LocalHugeLongArray(nodeCount) : null;
    }

    private MultiSourceBFS(RelationshipIterator relationships, ExecutionStrategy strategy, long nodeCount, boolean allowStartNodeTraversal, CloseableThreadLocal<HugeLongArray> visits, CloseableThreadLocal<HugeLongArray> visitsNext, CloseableThreadLocal<HugeLongArray> seens, CloseableThreadLocal<HugeLongArray> seensNext, long ... sourceNodes) {
        assert (sourceNodes != null && sourceNodes.length > 0);
        this.relationships = relationships;
        this.strategy = strategy;
        this.sourceNodes = sourceNodes;
        this.nodeCount = nodeCount;
        this.allowStartNodeTraversal = allowStartNodeTraversal;
        this.visits = visits;
        this.visitsNext = visitsNext;
        this.seens = seens;
        this.seensNext = seensNext;
    }

    private MultiSourceBFS(RelationshipIterator relationships, ExecutionStrategy strategy, long nodeCount, long nodeOffset, int sourceNodeCount, boolean allowStartNodeTraversal, CloseableThreadLocal<HugeLongArray> visits, CloseableThreadLocal<HugeLongArray> visitsNext, CloseableThreadLocal<HugeLongArray> seens, CloseableThreadLocal<HugeLongArray> seensNext) {
        this.relationships = relationships;
        this.strategy = strategy;
        this.sourceNodes = null;
        this.nodeCount = nodeCount;
        this.nodeOffset = nodeOffset;
        this.sourceNodeCount = sourceNodeCount;
        this.allowStartNodeTraversal = allowStartNodeTraversal;
        this.visits = visits;
        this.visitsNext = visitsNext;
        this.seens = seens;
        this.seensNext = seensNext;
    }

    public void run(int concurrency, ExecutorService executor) {
        int threads = this.numberOfThreads();
        Collection<MultiSourceBFS> bfss = this.allSourceBfss(threads);
        if (!ParallelUtil.canRunInParallel((ExecutorService)executor)) {
            executor = null;
        }
        ParallelUtil.runWithConcurrency((int)concurrency, bfss, (long)(threads << 2), (long)100L, (TimeUnit)TimeUnit.MICROSECONDS, (ExecutorService)executor);
    }

    @Override
    public void run() {
        assert (this.sourceLength() <= 64L) : "more than 64 sources not supported";
        HugeLongArray visitSet = (HugeLongArray)this.visits.get();
        HugeLongArray visitNextSet = (HugeLongArray)this.visitsNext.get();
        HugeLongArray seenSet = (HugeLongArray)this.seens.get();
        HugeLongArray seenNextSet = this.seensNext != null ? (HugeLongArray)this.seensNext.get() : null;
        SourceNodes sourceNodes = this.sourceNodes == null ? this.prepareOffsetSources(visitSet, seenSet) : this.prepareSpecifiedSources(visitSet, seenSet);
        this.strategy.run(this.relationships, this.nodeCount, sourceNodes, visitSet, visitNextSet, seenSet, seenNextSet);
    }

    private SourceNodes prepareOffsetSources(HugeLongArray visitSet, HugeLongArray seenSet) {
        int localNodeCount = this.sourceNodeCount;
        long nodeOffset = this.nodeOffset;
        for (int i = 0; i < localNodeCount; ++i) {
            seenSet.set(nodeOffset + (long)i, 1L << i);
            visitSet.or(nodeOffset + (long)i, 1L << i);
        }
        return new SourceNodes(nodeOffset, localNodeCount);
    }

    private SourceNodes prepareSpecifiedSources(HugeLongArray visitSet, HugeLongArray seenSet) {
        assert (this.isSorted(this.sourceNodes));
        for (int i = 0; i < this.sourceNodes.length; ++i) {
            long nodeId = this.sourceNodes[i];
            if (!this.allowStartNodeTraversal) {
                seenSet.set(nodeId, 1L << i);
            }
            visitSet.or(nodeId, 1L << i);
        }
        return new SourceNodes(this.sourceNodes);
    }

    private boolean isSorted(long[] nodes) {
        long[] copy = Arrays.copyOf(nodes, nodes.length);
        Arrays.sort(copy);
        return Arrays.equals(copy, nodes);
    }

    private long sourceLength() {
        if (this.sourceNodes != null) {
            return this.sourceNodes.length;
        }
        if (this.sourceNodeCount == 0) {
            return this.nodeCount;
        }
        return this.sourceNodeCount;
    }

    private int numberOfThreads() {
        long sourceLength = this.sourceLength();
        long threads = ParallelUtil.threadCount((long)64L, (long)sourceLength);
        if ((long)((int)threads) != threads) {
            throw new IllegalArgumentException("Unable run MS-BFS on " + sourceLength + " sources.");
        }
        return (int)threads;
    }

    private Collection<MultiSourceBFS> allSourceBfss(int threads) {
        if (this.sourceNodes == null) {
            final long sourceLength = this.nodeCount;
            return new ParallelMultiSources(threads, sourceLength){

                @Override
                MultiSourceBFS next(long from, int length) {
                    return new MultiSourceBFS(MultiSourceBFS.this.relationships.concurrentCopy(), MultiSourceBFS.this.strategy, sourceLength, from, length, MultiSourceBFS.this.allowStartNodeTraversal, MultiSourceBFS.this.visits, MultiSourceBFS.this.visitsNext, MultiSourceBFS.this.seens, MultiSourceBFS.this.seensNext);
                }
            };
        }
        final long[] sourceNodes = this.sourceNodes;
        int sourceLength = sourceNodes.length;
        return new ParallelMultiSources(threads, sourceLength){

            @Override
            MultiSourceBFS next(long from, int length) {
                return new MultiSourceBFS(MultiSourceBFS.this.relationships.concurrentCopy(), MultiSourceBFS.this.strategy, MultiSourceBFS.this.nodeCount, MultiSourceBFS.this.allowStartNodeTraversal, MultiSourceBFS.this.visits, MultiSourceBFS.this.visitsNext, MultiSourceBFS.this.seens, MultiSourceBFS.this.seensNext, Arrays.copyOfRange(sourceNodes, (int)from, (int)(from + (long)length)));
            }
        };
    }

    public String toString() {
        if (this.sourceNodes != null && this.sourceNodes.length > 0) {
            return "MSBFS{" + this.sourceNodes[0] + " .. " + (this.sourceNodes[this.sourceNodes.length - 1] + 1L) + " (" + this.sourceNodes.length + ")}";
        }
        return "MSBFS{" + this.nodeOffset + " .. " + (this.nodeOffset + (long)this.sourceNodeCount) + " (" + this.sourceNodeCount + ")}";
    }

    private static final class LocalHugeLongArray
    extends CloseableThreadLocal<HugeLongArray> {
        private LocalHugeLongArray(long size) {
            super(() -> HugeLongArray.newArray((long)size));
        }

        public HugeLongArray get() {
            HugeLongArray values = (HugeLongArray)super.get();
            values.fill(0L);
            return values;
        }
    }

    private static abstract class ParallelMultiSources
    extends AbstractCollection<MultiSourceBFS>
    implements Iterator<MultiSourceBFS> {
        private final int threads;
        private final long sourceLength;
        private long start = 0L;
        private int i = 0;

        private ParallelMultiSources(int threads, long sourceLength) {
            this.threads = threads;
            this.sourceLength = sourceLength;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.threads;
        }

        @Override
        public int size() {
            return this.threads;
        }

        @Override
        public Iterator<MultiSourceBFS> iterator() {
            this.start = 0L;
            this.i = 0;
            return this;
        }

        @Override
        public MultiSourceBFS next() {
            int len = (int)Math.min(64L, this.sourceLength - this.start);
            MultiSourceBFS bfs = this.next(this.start, len);
            this.start += (long)len;
            ++this.i;
            return bfs;
        }

        abstract MultiSourceBFS next(long var1, int var3);
    }

    static final class SourceNodes
    implements BfsSources {
        private final long[] sourceNodes;
        private final int maxPos;
        private final int startPos;
        private final long offset;
        private long sourceMask;
        private int pos;

        private SourceNodes(long[] sourceNodes) {
            assert (sourceNodes.length <= 64);
            this.sourceNodes = sourceNodes;
            this.maxPos = sourceNodes.length;
            this.offset = 0L;
            this.startPos = -1;
        }

        private SourceNodes(long offset, int length) {
            assert (length <= 64);
            this.sourceNodes = null;
            this.maxPos = length;
            this.offset = offset;
            this.startPos = -1;
        }

        public void reset() {
            this.pos = this.startPos;
            this.fetchNext();
        }

        void reset(long sourceMask) {
            assert (sourceMask != 0L);
            this.sourceMask = sourceMask;
            this.reset();
        }

        public boolean hasNext() {
            return this.pos < this.maxPos;
        }

        public long next() {
            int current = this.pos;
            this.fetchNext();
            return this.sourceNodes != null ? this.sourceNodes[current] : (long)current + this.offset;
        }

        @Override
        public int size() {
            return Long.bitCount(this.sourceMask) + 1;
        }

        private void fetchNext() {
            this.pos = Long.numberOfTrailingZeros(this.sourceMask);
            this.sourceMask ^= Long.lowestOneBit(this.sourceMask);
        }
    }

    static interface ExecutionStrategy {
        public void run(RelationshipIterator var1, long var2, SourceNodes var4, HugeLongArray var5, HugeLongArray var6, HugeLongArray var7, @Nullable HugeLongArray var8);
    }
}

