/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.pagerank;

import com.carrotsearch.hppc.LongSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.LongToDoubleFunction;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.api.nodeproperties.DoubleNodeProperties;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.beta.pregel.Messages;
import org.neo4j.gds.beta.pregel.PregelComputation;
import org.neo4j.gds.beta.pregel.PregelSchema;
import org.neo4j.gds.beta.pregel.Reducer;
import org.neo4j.gds.beta.pregel.context.ComputeContext;
import org.neo4j.gds.beta.pregel.context.InitContext;
import org.neo4j.gds.beta.pregel.context.MasterComputeContext;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.utils.partition.PartitionUtils;
import org.neo4j.gds.pagerank.PageRankConfig;
import org.neo4j.gds.scaling.ScalarScaler;

public final class EigenvectorComputation
implements PregelComputation<PageRankConfig> {
    private static final String RANK = "pagerank";
    private static final String NEXT_RANK = "next_rank";
    private final boolean hasSourceNodes;
    private final LongSet sourceNodes;
    private final LongToDoubleFunction weightDenominator;
    private final double tolerance;
    private final double initialValue;

    EigenvectorComputation(long nodeCount, PageRankConfig config, LongSet sourceNodes, LongToDoubleFunction weightDenominator) {
        this.tolerance = config.tolerance();
        this.sourceNodes = sourceNodes;
        this.hasSourceNodes = !sourceNodes.isEmpty();
        this.initialValue = this.hasSourceNodes ? 1.0 / (double)sourceNodes.size() : 1.0 / (double)nodeCount;
        this.weightDenominator = weightDenominator;
    }

    public PregelSchema schema(PageRankConfig config) {
        return new PregelSchema.Builder().add(RANK, ValueType.DOUBLE).add(NEXT_RANK, ValueType.DOUBLE).build();
    }

    public void init(InitContext<PageRankConfig> context) {
        context.setNodeValue(RANK, this.initialValue(context));
    }

    private double initialValue(InitContext<PageRankConfig> context) {
        if (!this.hasSourceNodes || this.sourceNodes.contains(context.nodeId())) {
            return this.initialValue;
        }
        return 0.0;
    }

    public void compute(ComputeContext<PageRankConfig> context, Messages messages) {
        double nextRank = context.doubleNodeValue(RANK);
        for (Double message : messages) {
            nextRank += message.doubleValue();
        }
        context.sendToNeighbors(nextRank / this.weightDenominator.applyAsDouble(context.nodeId()));
        context.setNodeValue(NEXT_RANK, nextRank);
    }

    public boolean masterCompute(final MasterComputeContext<PageRankConfig> context) {
        int concurrency = ((PageRankConfig)context.config()).concurrency();
        DoubleNodeProperties properties = new DoubleNodeProperties(){

            public long size() {
                return context.nodeCount();
            }

            public double doubleValue(long nodeId) {
                return context.doubleNodeValue(nodeId, EigenvectorComputation.NEXT_RANK);
            }
        };
        ScalarScaler scaler = ScalarScaler.Variant.L2NORM.create((NodeProperties)properties, context.nodeCount(), concurrency, context.executorService());
        MutableBoolean didConverge = new MutableBoolean(true);
        List tasks = PartitionUtils.rangePartition((int)concurrency, (long)context.nodeCount(), partition -> () -> partition.consume(nodeId -> {
            double normalizedCurrRank;
            double normalizedNextRank = scaler.scaleProperty(nodeId);
            if (Math.abs(normalizedNextRank - (normalizedCurrRank = context.doubleNodeValue(nodeId, RANK))) > this.tolerance) {
                didConverge.setFalse();
            }
            context.setNodeValue(nodeId, RANK, normalizedNextRank);
        }), Optional.empty());
        ParallelUtil.runWithConcurrency((int)concurrency, (Iterable)tasks, (ExecutorService)context.executorService());
        return !context.isInitialSuperstep() && didConverge.booleanValue();
    }

    public Optional<Reducer> reducer() {
        return Optional.of(new Reducer.Sum());
    }

    public double applyRelationshipWeight(double nodeValue, double relationshipWeight) {
        return nodeValue * relationshipWeight;
    }
}

