/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.pagerank;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.beta.pregel.Partitioning;
import org.neo4j.gds.beta.pregel.PregelConfig;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.config.IterationsConfig;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.config.SourceNodesConfig;
import org.neo4j.gds.config.ToleranceConfig;
import org.neo4j.gds.pagerank.PageRankConfig;
import org.neo4j.gds.scaling.ScalarScaler;

@Generated(from="PageRankConfig", generator="Immutables")
public final class ImmutablePageRankConfig
implements PageRankConfig {
    @Nullable
    private final String usernameOverride;
    private final boolean sudo;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    private final int concurrency;
    private final int minBatchSize;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    @Nullable
    private final String relationshipWeightProperty;
    private final transient boolean hasRelationshipWeightProperty;
    private final transient boolean useForkJoin;
    private final List<Long> sourceNodes;
    private final double tolerance;
    private final int maxIterations;
    private final double dampingFactor;
    private final ScalarScaler.Variant scaler;
    private final boolean isAsynchronous;
    private final Partitioning partitioning;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePageRankConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, @Nullable String relationshipWeightProperty, Iterable<Long> sourceNodes, double tolerance, int maxIterations, double dampingFactor, ScalarScaler.Variant scaler, boolean isAsynchronous, Partitioning partitioning) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutablePageRankConfig.createUnmodifiableList(false, ImmutablePageRankConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutablePageRankConfig.createUnmodifiableList(false, ImmutablePageRankConfig.createSafeList(nodeLabels, true, false)));
        this.initShim.relationshipWeightProperty(relationshipWeightProperty);
        this.initShim.sourceNodes(ImmutablePageRankConfig.createUnmodifiableList(false, ImmutablePageRankConfig.createSafeList(sourceNodes, true, false)));
        this.initShim.tolerance(tolerance);
        this.initShim.maxIterations(maxIterations);
        this.initShim.dampingFactor(dampingFactor);
        this.initShim.scaler(Objects.requireNonNull(scaler, "scaler"));
        this.initShim.isAsynchronous(isAsynchronous);
        this.initShim.partitioning(Objects.requireNonNull(partitioning, "partitioning"));
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.useForkJoin = this.initShim.useForkJoin();
        this.sourceNodes = this.initShim.sourceNodes();
        this.tolerance = this.initShim.tolerance();
        this.maxIterations = this.initShim.maxIterations();
        this.dampingFactor = this.initShim.dampingFactor();
        this.scaler = this.initShim.scaler();
        this.isAsynchronous = this.initShim.isAsynchronous();
        this.partitioning = this.initShim.partitioning();
        this.initShim = null;
    }

    private ImmutablePageRankConfig(Builder builder) {
        if (builder.usernameOverrideIsSet()) {
            this.initShim.usernameOverride(builder.usernameOverride);
        }
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.minBatchSizeIsSet()) {
            this.initShim.minBatchSize(builder.minBatchSize);
        }
        if (builder.relationshipTypesIsSet()) {
            this.initShim.relationshipTypes(builder.relationshipTypes == null ? Collections.emptyList() : ImmutablePageRankConfig.createUnmodifiableList(true, builder.relationshipTypes));
        }
        if (builder.nodeLabelsIsSet()) {
            this.initShim.nodeLabels(builder.nodeLabels == null ? Collections.emptyList() : ImmutablePageRankConfig.createUnmodifiableList(true, builder.nodeLabels));
        }
        if (builder.relationshipWeightPropertyIsSet()) {
            this.initShim.relationshipWeightProperty(builder.relationshipWeightProperty);
        }
        if (builder.sourceNodesIsSet()) {
            this.initShim.sourceNodes(builder.sourceNodes == null ? Collections.emptyList() : ImmutablePageRankConfig.createUnmodifiableList(true, builder.sourceNodes));
        }
        if (builder.toleranceIsSet()) {
            this.initShim.tolerance(builder.tolerance);
        }
        if (builder.maxIterationsIsSet()) {
            this.initShim.maxIterations(builder.maxIterations);
        }
        if (builder.dampingFactorIsSet()) {
            this.initShim.dampingFactor(builder.dampingFactor);
        }
        if (builder.scaler != null) {
            this.initShim.scaler(builder.scaler);
        }
        if (builder.isAsynchronousIsSet()) {
            this.initShim.isAsynchronous(builder.isAsynchronous);
        }
        if (builder.partitioning != null) {
            this.initShim.partitioning(builder.partitioning);
        }
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.useForkJoin = this.initShim.useForkJoin();
        this.sourceNodes = this.initShim.sourceNodes();
        this.tolerance = this.initShim.tolerance();
        this.maxIterations = this.initShim.maxIterations();
        this.dampingFactor = this.initShim.dampingFactor();
        this.scaler = this.initShim.scaler();
        this.isAsynchronous = this.initShim.isAsynchronous();
        this.partitioning = this.initShim.partitioning();
        this.initShim = null;
    }

    private ImmutablePageRankConfig(@Nullable String usernameOverride, boolean sudo, Collection<String> configKeys, int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, @Nullable String relationshipWeightProperty, List<Long> sourceNodes, double tolerance, int maxIterations, double dampingFactor, ScalarScaler.Variant scaler, boolean isAsynchronous, Partitioning partitioning) {
        this.initShim.usernameOverride(usernameOverride);
        this.initShim.sudo(sudo);
        this.initShim.configKeys(configKeys);
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(relationshipTypes);
        this.initShim.nodeLabels(nodeLabels);
        this.initShim.relationshipWeightProperty(relationshipWeightProperty);
        this.initShim.sourceNodes(sourceNodes);
        this.initShim.tolerance(tolerance);
        this.initShim.maxIterations(maxIterations);
        this.initShim.dampingFactor(dampingFactor);
        this.initShim.scaler(scaler);
        this.initShim.isAsynchronous(isAsynchronous);
        this.initShim.partitioning(partitioning);
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.useForkJoin = this.initShim.useForkJoin();
        this.sourceNodes = this.initShim.sourceNodes();
        this.tolerance = this.initShim.tolerance();
        this.maxIterations = this.initShim.maxIterations();
        this.dampingFactor = this.initShim.dampingFactor();
        this.scaler = this.initShim.scaler();
        this.isAsynchronous = this.initShim.isAsynchronous();
        this.partitioning = this.initShim.partitioning();
        this.initShim = null;
    }

    @Nullable
    private String usernameOverrideInitialize() {
        return PageRankConfig.super.usernameOverride();
    }

    private boolean sudoInitialize() {
        return PageRankConfig.super.sudo();
    }

    private Collection<String> configKeysInitialize() {
        return PageRankConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return PageRankConfig.super.toMap();
    }

    private int concurrencyInitialize() {
        return PageRankConfig.super.concurrency();
    }

    private int minBatchSizeInitialize() {
        return PageRankConfig.super.minBatchSize();
    }

    private List<String> relationshipTypesInitialize() {
        return PageRankConfig.super.relationshipTypes();
    }

    private List<String> nodeLabelsInitialize() {
        return PageRankConfig.super.nodeLabels();
    }

    @Nullable
    private String relationshipWeightPropertyInitialize() {
        return PageRankConfig.super.relationshipWeightProperty();
    }

    private boolean hasRelationshipWeightPropertyInitialize() {
        return PageRankConfig.super.hasRelationshipWeightProperty();
    }

    private boolean useForkJoinInitialize() {
        return PageRankConfig.super.useForkJoin();
    }

    private List<Long> sourceNodesInitialize() {
        return PageRankConfig.super.sourceNodes();
    }

    private double toleranceInitialize() {
        return PageRankConfig.super.tolerance();
    }

    private int maxIterationsInitialize() {
        return PageRankConfig.super.maxIterations();
    }

    private double dampingFactorInitialize() {
        return PageRankConfig.super.dampingFactor();
    }

    private ScalarScaler.Variant scalerInitialize() {
        return PageRankConfig.super.scaler();
    }

    private boolean isAsynchronousInitialize() {
        return PageRankConfig.super.isAsynchronous();
    }

    private Partitioning partitioningInitialize() {
        return PageRankConfig.super.partitioning();
    }

    @Nullable
    public String usernameOverride() {
        InitShim shim = this.initShim;
        return shim != null ? shim.usernameOverride() : this.usernameOverride;
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    public int minBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minBatchSize() : this.minBatchSize;
    }

    public List<String> relationshipTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipTypes() : this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeLabels() : this.nodeLabels;
    }

    @Nullable
    public String relationshipWeightProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipWeightProperty() : this.relationshipWeightProperty;
    }

    public boolean hasRelationshipWeightProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasRelationshipWeightProperty() : this.hasRelationshipWeightProperty;
    }

    public boolean useForkJoin() {
        InitShim shim = this.initShim;
        return shim != null ? shim.useForkJoin() : this.useForkJoin;
    }

    public List<Long> sourceNodes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sourceNodes() : this.sourceNodes;
    }

    @Override
    public double tolerance() {
        InitShim shim = this.initShim;
        return shim != null ? shim.tolerance() : this.tolerance;
    }

    @Override
    public int maxIterations() {
        InitShim shim = this.initShim;
        return shim != null ? shim.maxIterations() : this.maxIterations;
    }

    @Override
    public double dampingFactor() {
        InitShim shim = this.initShim;
        return shim != null ? shim.dampingFactor() : this.dampingFactor;
    }

    @Override
    public ScalarScaler.Variant scaler() {
        InitShim shim = this.initShim;
        return shim != null ? shim.scaler() : this.scaler;
    }

    @Override
    public boolean isAsynchronous() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isAsynchronous() : this.isAsynchronous;
    }

    @Override
    public Partitioning partitioning() {
        InitShim shim = this.initShim;
        return shim != null ? shim.partitioning() : this.partitioning;
    }

    public final ImmutablePageRankConfig withUsernameOverride(@Nullable String value) {
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return ImmutablePageRankConfig.validate(new ImmutablePageRankConfig(value, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning));
    }

    public final ImmutablePageRankConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutablePageRankConfig.validate(new ImmutablePageRankConfig(this.usernameOverride, value, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning));
    }

    public final ImmutablePageRankConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutablePageRankConfig.validate(new ImmutablePageRankConfig(this.usernameOverride, this.sudo, newValue, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning));
    }

    public final ImmutablePageRankConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutablePageRankConfig.validate(new ImmutablePageRankConfig(this.usernameOverride, this.sudo, this.configKeys, value, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning));
    }

    public final ImmutablePageRankConfig withMinBatchSize(int value) {
        if (this.minBatchSize == value) {
            return this;
        }
        return ImmutablePageRankConfig.validate(new ImmutablePageRankConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, value, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning));
    }

    public final ImmutablePageRankConfig withRelationshipTypes(String ... elements) {
        List<String> newValue = ImmutablePageRankConfig.createUnmodifiableList(false, ImmutablePageRankConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutablePageRankConfig.validate(new ImmutablePageRankConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.nodeLabels, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning));
    }

    public final ImmutablePageRankConfig withRelationshipTypes(Iterable<String> elements) {
        if (this.relationshipTypes == elements) {
            return this;
        }
        List<String> newValue = ImmutablePageRankConfig.createUnmodifiableList(false, ImmutablePageRankConfig.createSafeList(elements, true, false));
        return ImmutablePageRankConfig.validate(new ImmutablePageRankConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.nodeLabels, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning));
    }

    public final ImmutablePageRankConfig withNodeLabels(String ... elements) {
        List<String> newValue = ImmutablePageRankConfig.createUnmodifiableList(false, ImmutablePageRankConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutablePageRankConfig.validate(new ImmutablePageRankConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, newValue, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning));
    }

    public final ImmutablePageRankConfig withNodeLabels(Iterable<String> elements) {
        if (this.nodeLabels == elements) {
            return this;
        }
        List<String> newValue = ImmutablePageRankConfig.createUnmodifiableList(false, ImmutablePageRankConfig.createSafeList(elements, true, false));
        return ImmutablePageRankConfig.validate(new ImmutablePageRankConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, newValue, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning));
    }

    public final ImmutablePageRankConfig withRelationshipWeightProperty(@Nullable String value) {
        if (Objects.equals(this.relationshipWeightProperty, value)) {
            return this;
        }
        return ImmutablePageRankConfig.validate(new ImmutablePageRankConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, value, this.sourceNodes, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning));
    }

    public final ImmutablePageRankConfig withSourceNodes(long ... elements) {
        ArrayList<Long> wrappedList = new ArrayList<Long>(elements.length);
        for (long element : elements) {
            wrappedList.add(element);
        }
        List<Long> newValue = ImmutablePageRankConfig.createUnmodifiableList(false, wrappedList);
        return ImmutablePageRankConfig.validate(new ImmutablePageRankConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, newValue, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning));
    }

    public final ImmutablePageRankConfig withSourceNodes(Iterable<Long> elements) {
        if (this.sourceNodes == elements) {
            return this;
        }
        List<Long> newValue = ImmutablePageRankConfig.createUnmodifiableList(false, ImmutablePageRankConfig.createSafeList(elements, true, false));
        return ImmutablePageRankConfig.validate(new ImmutablePageRankConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, newValue, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning));
    }

    public final ImmutablePageRankConfig withTolerance(double value) {
        if (Double.doubleToLongBits(this.tolerance) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutablePageRankConfig.validate(new ImmutablePageRankConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.sourceNodes, value, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning));
    }

    public final ImmutablePageRankConfig withMaxIterations(int value) {
        if (this.maxIterations == value) {
            return this;
        }
        return ImmutablePageRankConfig.validate(new ImmutablePageRankConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, value, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning));
    }

    public final ImmutablePageRankConfig withDampingFactor(double value) {
        if (Double.doubleToLongBits(this.dampingFactor) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutablePageRankConfig.validate(new ImmutablePageRankConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, this.maxIterations, value, this.scaler, this.isAsynchronous, this.partitioning));
    }

    public final ImmutablePageRankConfig withScaler(ScalarScaler.Variant value) {
        if (this.scaler == value) {
            return this;
        }
        ScalarScaler.Variant newValue = Objects.requireNonNull(value, "scaler");
        if (this.scaler.equals((Object)newValue)) {
            return this;
        }
        return ImmutablePageRankConfig.validate(new ImmutablePageRankConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, this.maxIterations, this.dampingFactor, newValue, this.isAsynchronous, this.partitioning));
    }

    public final ImmutablePageRankConfig withIsAsynchronous(boolean value) {
        if (this.isAsynchronous == value) {
            return this;
        }
        return ImmutablePageRankConfig.validate(new ImmutablePageRankConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, value, this.partitioning));
    }

    public final ImmutablePageRankConfig withPartitioning(Partitioning value) {
        if (this.partitioning == value) {
            return this;
        }
        Partitioning newValue = Objects.requireNonNull(value, "partitioning");
        if (this.partitioning.equals((Object)newValue)) {
            return this;
        }
        return ImmutablePageRankConfig.validate(new ImmutablePageRankConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePageRankConfig && this.equalTo((ImmutablePageRankConfig)another);
    }

    private boolean equalTo(ImmutablePageRankConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && this.concurrency == another.concurrency && this.minBatchSize == another.minBatchSize && this.relationshipTypes.equals(another.relationshipTypes) && this.nodeLabels.equals(another.nodeLabels) && Objects.equals(this.relationshipWeightProperty, another.relationshipWeightProperty) && this.hasRelationshipWeightProperty == another.hasRelationshipWeightProperty && this.useForkJoin == another.useForkJoin && this.sourceNodes.equals(another.sourceNodes) && Double.doubleToLongBits(this.tolerance) == Double.doubleToLongBits(another.tolerance) && this.maxIterations == another.maxIterations && Double.doubleToLongBits(this.dampingFactor) == Double.doubleToLongBits(another.dampingFactor) && this.scaler.equals((Object)another.scaler) && this.isAsynchronous == another.isAsynchronous && this.partitioning.equals((Object)another.partitioning);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + this.concurrency;
        h += (h << 5) + this.minBatchSize;
        h += (h << 5) + this.relationshipTypes.hashCode();
        h += (h << 5) + this.nodeLabels.hashCode();
        h += (h << 5) + Objects.hashCode(this.relationshipWeightProperty);
        h += (h << 5) + Boolean.hashCode(this.hasRelationshipWeightProperty);
        h += (h << 5) + Boolean.hashCode(this.useForkJoin);
        h += (h << 5) + this.sourceNodes.hashCode();
        h += (h << 5) + Double.hashCode(this.tolerance);
        h += (h << 5) + this.maxIterations;
        h += (h << 5) + Double.hashCode(this.dampingFactor);
        h += (h << 5) + this.scaler.hashCode();
        h += (h << 5) + Boolean.hashCode(this.isAsynchronous);
        h += (h << 5) + this.partitioning.hashCode();
        return h;
    }

    public String toString() {
        return "PageRankConfig{usernameOverride=" + this.usernameOverride + ", sudo=" + this.sudo + ", concurrency=" + this.concurrency + ", minBatchSize=" + this.minBatchSize + ", relationshipTypes=" + this.relationshipTypes + ", nodeLabels=" + this.nodeLabels + ", relationshipWeightProperty=" + this.relationshipWeightProperty + ", hasRelationshipWeightProperty=" + this.hasRelationshipWeightProperty + ", useForkJoin=" + this.useForkJoin + ", sourceNodes=" + this.sourceNodes + ", tolerance=" + this.tolerance + ", maxIterations=" + this.maxIterations + ", dampingFactor=" + this.dampingFactor + ", scaler=" + this.scaler + ", isAsynchronous=" + this.isAsynchronous + ", partitioning=" + this.partitioning + "}";
    }

    public static PageRankConfig of(int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, @Nullable String relationshipWeightProperty, List<Long> sourceNodes, double tolerance, int maxIterations, double dampingFactor, ScalarScaler.Variant scaler, boolean isAsynchronous, Partitioning partitioning) {
        return ImmutablePageRankConfig.of(concurrency, minBatchSize, relationshipTypes, nodeLabels, relationshipWeightProperty, sourceNodes, tolerance, maxIterations, dampingFactor, scaler, isAsynchronous, partitioning);
    }

    public static PageRankConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, @Nullable String relationshipWeightProperty, Iterable<Long> sourceNodes, double tolerance, int maxIterations, double dampingFactor, ScalarScaler.Variant scaler, boolean isAsynchronous, Partitioning partitioning) {
        return ImmutablePageRankConfig.validate(new ImmutablePageRankConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, relationshipWeightProperty, sourceNodes, tolerance, maxIterations, dampingFactor, scaler, isAsynchronous, partitioning));
    }

    private static ImmutablePageRankConfig validate(ImmutablePageRankConfig instance) {
        instance.validateConcurrency();
        return instance;
    }

    public static PageRankConfig copyOf(PageRankConfig instance) {
        if (instance instanceof ImmutablePageRankConfig) {
            return (ImmutablePageRankConfig)instance;
        }
        return ImmutablePageRankConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="PageRankConfig", generator="Immutables")
    public static final class Builder {
        private static final long OPT_BIT_USERNAME_OVERRIDE = 1L;
        private static final long OPT_BIT_SUDO = 2L;
        private static final long OPT_BIT_CONCURRENCY = 4L;
        private static final long OPT_BIT_MIN_BATCH_SIZE = 8L;
        private static final long OPT_BIT_RELATIONSHIP_TYPES = 16L;
        private static final long OPT_BIT_NODE_LABELS = 32L;
        private static final long OPT_BIT_RELATIONSHIP_WEIGHT_PROPERTY = 64L;
        private static final long OPT_BIT_SOURCE_NODES = 128L;
        private static final long OPT_BIT_TOLERANCE = 256L;
        private static final long OPT_BIT_MAX_ITERATIONS = 512L;
        private static final long OPT_BIT_DAMPING_FACTOR = 1024L;
        private static final long OPT_BIT_IS_ASYNCHRONOUS = 2048L;
        private long optBits;
        private String usernameOverride;
        private boolean sudo;
        private Collection<String> configKeys;
        private int concurrency;
        private int minBatchSize;
        private List<String> relationshipTypes = null;
        private List<String> nodeLabels = null;
        private String relationshipWeightProperty;
        private List<Long> sourceNodes = null;
        private double tolerance;
        private int maxIterations;
        private double dampingFactor;
        private ScalarScaler.Variant scaler;
        private boolean isAsynchronous;
        private Partitioning partitioning;

        private Builder() {
        }

        public final Builder from(RelationshipWeightConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PageRankConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ConcurrencyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ToleranceConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SourceNodesConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PregelConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AlgoBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(IterationsConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            String relationshipWeightPropertyValue;
            long bits = 0L;
            if (object instanceof RelationshipWeightConfig && (relationshipWeightPropertyValue = (instance = (RelationshipWeightConfig)object).relationshipWeightProperty()) != null) {
                this.relationshipWeightProperty(relationshipWeightPropertyValue);
            }
            if (object instanceof PageRankConfig) {
                instance = (PageRankConfig)object;
                if ((bits & 4L) == 0L) {
                    this.partitioning(instance.partitioning());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.maxIterations(instance.maxIterations());
                    bits |= 1L;
                }
                this.dampingFactor(instance.dampingFactor());
                this.scaler(instance.scaler());
                if ((bits & 8L) == 0L) {
                    this.tolerance(instance.tolerance());
                    bits |= 8L;
                }
                if ((bits & 2L) == 0L) {
                    this.isAsynchronous(instance.isAsynchronous());
                    bits |= 2L;
                }
            }
            if (object instanceof ConcurrencyConfig) {
                instance = (ConcurrencyConfig)object;
                this.minBatchSize(instance.minBatchSize());
                this.concurrency(instance.concurrency());
            }
            if (object instanceof ToleranceConfig) {
                instance = (ToleranceConfig)object;
                if ((bits & 8L) == 0L) {
                    this.tolerance(instance.tolerance());
                    bits |= 8L;
                }
            }
            if (object instanceof SourceNodesConfig) {
                instance = (SourceNodesConfig)object;
                this.addAllSourceNodes(instance.sourceNodes());
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                @Nullable String usernameOverrideValue = instance.usernameOverride();
                if (usernameOverrideValue != null) {
                    this.usernameOverride(usernameOverrideValue);
                }
                this.configKeys(instance.configKeys());
                this.sudo(instance.sudo());
            }
            if (object instanceof PregelConfig) {
                instance = (PregelConfig)object;
                if ((bits & 4L) == 0L) {
                    this.partitioning(instance.partitioning());
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    this.isAsynchronous(instance.isAsynchronous());
                    bits |= 2L;
                }
            }
            if (object instanceof AlgoBaseConfig) {
                instance = (AlgoBaseConfig)object;
                this.addAllRelationshipTypes(instance.relationshipTypes());
                this.addAllNodeLabels(instance.nodeLabels());
            }
            if (object instanceof IterationsConfig) {
                instance = (IterationsConfig)object;
                if ((bits & 1L) == 0L) {
                    this.maxIterations(instance.maxIterations());
                    bits |= 1L;
                }
            }
        }

        public final Builder usernameOverride(@Nullable String usernameOverride) {
            this.usernameOverride = usernameOverride;
            this.optBits |= 1L;
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 2L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 4L;
            return this;
        }

        public final Builder minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.optBits |= 8L;
            return this;
        }

        public final Builder addRelationshipType(String element) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addRelationshipTypes(String ... elements) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder relationshipTypes(Iterable<String> elements) {
            this.relationshipTypes = new ArrayList<String>();
            return this.addAllRelationshipTypes(elements);
        }

        public final Builder addAllRelationshipTypes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "relationshipTypes element");
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addNodeLabel(String element) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder addNodeLabels(String ... elements) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder nodeLabels(Iterable<String> elements) {
            this.nodeLabels = new ArrayList<String>();
            return this.addAllNodeLabels(elements);
        }

        public final Builder addAllNodeLabels(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeLabels element");
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder relationshipWeightProperty(@Nullable String relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder addSourceNode(long element) {
            if (this.sourceNodes == null) {
                this.sourceNodes = new ArrayList<Long>();
            }
            this.sourceNodes.add(element);
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder addSourceNodes(long ... elements) {
            if (this.sourceNodes == null) {
                this.sourceNodes = new ArrayList<Long>();
            }
            for (long element : elements) {
                this.sourceNodes.add(element);
            }
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder sourceNodes(Iterable<Long> elements) {
            this.sourceNodes = new ArrayList<Long>();
            return this.addAllSourceNodes(elements);
        }

        public final Builder addAllSourceNodes(Iterable<Long> elements) {
            Objects.requireNonNull(elements, "sourceNodes element");
            if (this.sourceNodes == null) {
                this.sourceNodes = new ArrayList<Long>();
            }
            for (long element : elements) {
                this.sourceNodes.add(Objects.requireNonNull(Long.valueOf(element), "sourceNodes element"));
            }
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder tolerance(double tolerance) {
            this.tolerance = tolerance;
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder maxIterations(int maxIterations) {
            this.maxIterations = maxIterations;
            this.optBits |= 0x200L;
            return this;
        }

        public final Builder dampingFactor(double dampingFactor) {
            this.dampingFactor = dampingFactor;
            this.optBits |= 0x400L;
            return this;
        }

        public final Builder scaler(ScalarScaler.Variant scaler) {
            this.scaler = Objects.requireNonNull(scaler, "scaler");
            return this;
        }

        public final Builder isAsynchronous(boolean isAsynchronous) {
            this.isAsynchronous = isAsynchronous;
            this.optBits |= 0x800L;
            return this;
        }

        public final Builder partitioning(Partitioning partitioning) {
            this.partitioning = Objects.requireNonNull(partitioning, "partitioning");
            return this;
        }

        public Builder clear() {
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.configKeys = null;
            this.concurrency = 0;
            this.minBatchSize = 0;
            if (this.relationshipTypes != null) {
                this.relationshipTypes.clear();
            }
            if (this.nodeLabels != null) {
                this.nodeLabels.clear();
            }
            this.relationshipWeightProperty = null;
            if (this.sourceNodes != null) {
                this.sourceNodes.clear();
            }
            this.tolerance = 0.0;
            this.maxIterations = 0;
            this.dampingFactor = 0.0;
            this.scaler = null;
            this.isAsynchronous = false;
            this.partitioning = null;
            return this;
        }

        public PageRankConfig build() {
            return ImmutablePageRankConfig.validate(new ImmutablePageRankConfig(this));
        }

        private boolean usernameOverrideIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean sudoIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean minBatchSizeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean relationshipTypesIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean nodeLabelsIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean relationshipWeightPropertyIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean sourceNodesIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean toleranceIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean maxIterationsIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private boolean dampingFactorIsSet() {
            return (this.optBits & 0x400L) != 0L;
        }

        private boolean isAsynchronousIsSet() {
            return (this.optBits & 0x800L) != 0L;
        }
    }

    @Generated(from="PageRankConfig", generator="Immutables")
    private final class InitShim {
        private byte usernameOverrideBuildStage = 0;
        private String usernameOverride;
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte concurrencyBuildStage = 0;
        private int concurrency;
        private byte minBatchSizeBuildStage = 0;
        private int minBatchSize;
        private byte relationshipTypesBuildStage = 0;
        private List<String> relationshipTypes;
        private byte nodeLabelsBuildStage = 0;
        private List<String> nodeLabels;
        private byte relationshipWeightPropertyBuildStage = 0;
        private String relationshipWeightProperty;
        private byte hasRelationshipWeightPropertyBuildStage = 0;
        private boolean hasRelationshipWeightProperty;
        private byte useForkJoinBuildStage = 0;
        private boolean useForkJoin;
        private byte sourceNodesBuildStage = 0;
        private List<Long> sourceNodes;
        private byte toleranceBuildStage = 0;
        private double tolerance;
        private byte maxIterationsBuildStage = 0;
        private int maxIterations;
        private byte dampingFactorBuildStage = 0;
        private double dampingFactor;
        private byte scalerBuildStage = 0;
        private ScalarScaler.Variant scaler;
        private byte isAsynchronousBuildStage = 0;
        private boolean isAsynchronous;
        private byte partitioningBuildStage = 0;
        private Partitioning partitioning;

        private InitShim() {
        }

        String usernameOverride() {
            if (this.usernameOverrideBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usernameOverrideBuildStage == 0) {
                this.usernameOverrideBuildStage = (byte)-1;
                this.usernameOverride = ImmutablePageRankConfig.this.usernameOverrideInitialize();
                this.usernameOverrideBuildStage = 1;
            }
            return this.usernameOverride;
        }

        void usernameOverride(String usernameOverride) {
            this.usernameOverride = usernameOverride;
            this.usernameOverrideBuildStage = 1;
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutablePageRankConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutablePageRankConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutablePageRankConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutablePageRankConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        int minBatchSize() {
            if (this.minBatchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minBatchSizeBuildStage == 0) {
                this.minBatchSizeBuildStage = (byte)-1;
                this.minBatchSize = ImmutablePageRankConfig.this.minBatchSizeInitialize();
                this.minBatchSizeBuildStage = 1;
            }
            return this.minBatchSize;
        }

        void minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.minBatchSizeBuildStage = 1;
        }

        List<String> relationshipTypes() {
            if (this.relationshipTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipTypesBuildStage == 0) {
                this.relationshipTypesBuildStage = (byte)-1;
                this.relationshipTypes = ImmutablePageRankConfig.createUnmodifiableList(false, ImmutablePageRankConfig.createSafeList(ImmutablePageRankConfig.this.relationshipTypesInitialize(), true, false));
                this.relationshipTypesBuildStage = 1;
            }
            return this.relationshipTypes;
        }

        void relationshipTypes(List<String> relationshipTypes) {
            this.relationshipTypes = relationshipTypes;
            this.relationshipTypesBuildStage = 1;
        }

        List<String> nodeLabels() {
            if (this.nodeLabelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeLabelsBuildStage == 0) {
                this.nodeLabelsBuildStage = (byte)-1;
                this.nodeLabels = ImmutablePageRankConfig.createUnmodifiableList(false, ImmutablePageRankConfig.createSafeList(ImmutablePageRankConfig.this.nodeLabelsInitialize(), true, false));
                this.nodeLabelsBuildStage = 1;
            }
            return this.nodeLabels;
        }

        void nodeLabels(List<String> nodeLabels) {
            this.nodeLabels = nodeLabels;
            this.nodeLabelsBuildStage = 1;
        }

        String relationshipWeightProperty() {
            if (this.relationshipWeightPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipWeightPropertyBuildStage == 0) {
                this.relationshipWeightPropertyBuildStage = (byte)-1;
                this.relationshipWeightProperty = ImmutablePageRankConfig.this.relationshipWeightPropertyInitialize();
                this.relationshipWeightPropertyBuildStage = 1;
            }
            return this.relationshipWeightProperty;
        }

        void relationshipWeightProperty(String relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty;
            this.relationshipWeightPropertyBuildStage = 1;
        }

        boolean hasRelationshipWeightProperty() {
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasRelationshipWeightPropertyBuildStage == 0) {
                this.hasRelationshipWeightPropertyBuildStage = (byte)-1;
                this.hasRelationshipWeightProperty = ImmutablePageRankConfig.this.hasRelationshipWeightPropertyInitialize();
                this.hasRelationshipWeightPropertyBuildStage = 1;
            }
            return this.hasRelationshipWeightProperty;
        }

        boolean useForkJoin() {
            if (this.useForkJoinBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.useForkJoinBuildStage == 0) {
                this.useForkJoinBuildStage = (byte)-1;
                this.useForkJoin = ImmutablePageRankConfig.this.useForkJoinInitialize();
                this.useForkJoinBuildStage = 1;
            }
            return this.useForkJoin;
        }

        List<Long> sourceNodes() {
            if (this.sourceNodesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sourceNodesBuildStage == 0) {
                this.sourceNodesBuildStage = (byte)-1;
                this.sourceNodes = ImmutablePageRankConfig.createUnmodifiableList(false, ImmutablePageRankConfig.createSafeList(ImmutablePageRankConfig.this.sourceNodesInitialize(), true, false));
                this.sourceNodesBuildStage = 1;
            }
            return this.sourceNodes;
        }

        void sourceNodes(List<Long> sourceNodes) {
            this.sourceNodes = sourceNodes;
            this.sourceNodesBuildStage = 1;
        }

        double tolerance() {
            if (this.toleranceBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toleranceBuildStage == 0) {
                this.toleranceBuildStage = (byte)-1;
                this.tolerance = ImmutablePageRankConfig.this.toleranceInitialize();
                this.toleranceBuildStage = 1;
            }
            return this.tolerance;
        }

        void tolerance(double tolerance) {
            this.tolerance = tolerance;
            this.toleranceBuildStage = 1;
        }

        int maxIterations() {
            if (this.maxIterationsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.maxIterationsBuildStage == 0) {
                this.maxIterationsBuildStage = (byte)-1;
                this.maxIterations = ImmutablePageRankConfig.this.maxIterationsInitialize();
                this.maxIterationsBuildStage = 1;
            }
            return this.maxIterations;
        }

        void maxIterations(int maxIterations) {
            this.maxIterations = maxIterations;
            this.maxIterationsBuildStage = 1;
        }

        double dampingFactor() {
            if (this.dampingFactorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.dampingFactorBuildStage == 0) {
                this.dampingFactorBuildStage = (byte)-1;
                this.dampingFactor = ImmutablePageRankConfig.this.dampingFactorInitialize();
                this.dampingFactorBuildStage = 1;
            }
            return this.dampingFactor;
        }

        void dampingFactor(double dampingFactor) {
            this.dampingFactor = dampingFactor;
            this.dampingFactorBuildStage = 1;
        }

        ScalarScaler.Variant scaler() {
            if (this.scalerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.scalerBuildStage == 0) {
                this.scalerBuildStage = (byte)-1;
                this.scaler = Objects.requireNonNull(ImmutablePageRankConfig.this.scalerInitialize(), "scaler");
                this.scalerBuildStage = 1;
            }
            return this.scaler;
        }

        void scaler(ScalarScaler.Variant scaler) {
            this.scaler = scaler;
            this.scalerBuildStage = 1;
        }

        boolean isAsynchronous() {
            if (this.isAsynchronousBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isAsynchronousBuildStage == 0) {
                this.isAsynchronousBuildStage = (byte)-1;
                this.isAsynchronous = ImmutablePageRankConfig.this.isAsynchronousInitialize();
                this.isAsynchronousBuildStage = 1;
            }
            return this.isAsynchronous;
        }

        void isAsynchronous(boolean isAsynchronous) {
            this.isAsynchronous = isAsynchronous;
            this.isAsynchronousBuildStage = 1;
        }

        Partitioning partitioning() {
            if (this.partitioningBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.partitioningBuildStage == 0) {
                this.partitioningBuildStage = (byte)-1;
                this.partitioning = Objects.requireNonNull(ImmutablePageRankConfig.this.partitioningInitialize(), "partitioning");
                this.partitioningBuildStage = 1;
            }
            return this.partitioning;
        }

        void partitioning(Partitioning partitioning) {
            this.partitioning = partitioning;
            this.partitioningBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.usernameOverrideBuildStage == -1) {
                attributes.add("usernameOverride");
            }
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.minBatchSizeBuildStage == -1) {
                attributes.add("minBatchSize");
            }
            if (this.relationshipTypesBuildStage == -1) {
                attributes.add("relationshipTypes");
            }
            if (this.nodeLabelsBuildStage == -1) {
                attributes.add("nodeLabels");
            }
            if (this.relationshipWeightPropertyBuildStage == -1) {
                attributes.add("relationshipWeightProperty");
            }
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                attributes.add("hasRelationshipWeightProperty");
            }
            if (this.useForkJoinBuildStage == -1) {
                attributes.add("useForkJoin");
            }
            if (this.sourceNodesBuildStage == -1) {
                attributes.add("sourceNodes");
            }
            if (this.toleranceBuildStage == -1) {
                attributes.add("tolerance");
            }
            if (this.maxIterationsBuildStage == -1) {
                attributes.add("maxIterations");
            }
            if (this.dampingFactorBuildStage == -1) {
                attributes.add("dampingFactor");
            }
            if (this.scalerBuildStage == -1) {
                attributes.add("scaler");
            }
            if (this.isAsynchronousBuildStage == -1) {
                attributes.add("isAsynchronous");
            }
            if (this.partitioningBuildStage == -1) {
                attributes.add("partitioning");
            }
            return "Cannot build PageRankConfig, attribute initializers form cycle " + attributes;
        }
    }
}

