/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.pagerank;

import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.pagerank.PageRankResult;

@Generated(from="PageRankResult", generator="Immutables")
public final class ImmutablePageRankResult
implements PageRankResult {
    private final HugeDoubleArray scores;
    private final int iterations;
    private final boolean didConverge;

    private ImmutablePageRankResult(HugeDoubleArray scores, int iterations, boolean didConverge) {
        this.scores = Objects.requireNonNull(scores, "scores");
        this.iterations = iterations;
        this.didConverge = didConverge;
    }

    private ImmutablePageRankResult(ImmutablePageRankResult original, HugeDoubleArray scores, int iterations, boolean didConverge) {
        this.scores = scores;
        this.iterations = iterations;
        this.didConverge = didConverge;
    }

    @Override
    public HugeDoubleArray scores() {
        return this.scores;
    }

    @Override
    public int iterations() {
        return this.iterations;
    }

    @Override
    public boolean didConverge() {
        return this.didConverge;
    }

    public final ImmutablePageRankResult withScores(HugeDoubleArray value) {
        if (this.scores == value) {
            return this;
        }
        HugeDoubleArray newValue = Objects.requireNonNull(value, "scores");
        return new ImmutablePageRankResult(this, newValue, this.iterations, this.didConverge);
    }

    public final ImmutablePageRankResult withIterations(int value) {
        if (this.iterations == value) {
            return this;
        }
        return new ImmutablePageRankResult(this, this.scores, value, this.didConverge);
    }

    public final ImmutablePageRankResult withDidConverge(boolean value) {
        if (this.didConverge == value) {
            return this;
        }
        return new ImmutablePageRankResult(this, this.scores, this.iterations, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePageRankResult && this.equalTo((ImmutablePageRankResult)another);
    }

    private boolean equalTo(ImmutablePageRankResult another) {
        return this.scores.equals(another.scores) && this.iterations == another.iterations && this.didConverge == another.didConverge;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.scores.hashCode();
        h += (h << 5) + this.iterations;
        h += (h << 5) + Boolean.hashCode(this.didConverge);
        return h;
    }

    public String toString() {
        return "PageRankResult{scores=" + this.scores + ", iterations=" + this.iterations + ", didConverge=" + this.didConverge + "}";
    }

    public static PageRankResult of(HugeDoubleArray scores, int iterations, boolean didConverge) {
        return new ImmutablePageRankResult(scores, iterations, didConverge);
    }

    public static PageRankResult copyOf(PageRankResult instance) {
        if (instance instanceof ImmutablePageRankResult) {
            return (ImmutablePageRankResult)instance;
        }
        return ImmutablePageRankResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PageRankResult", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_SCORES = 1L;
        private static final long INIT_BIT_ITERATIONS = 2L;
        private static final long INIT_BIT_DID_CONVERGE = 4L;
        private long initBits = 7L;
        private HugeDoubleArray scores;
        private int iterations;
        private boolean didConverge;

        private Builder() {
        }

        public final Builder from(PageRankResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.scores(instance.scores());
            this.iterations(instance.iterations());
            this.didConverge(instance.didConverge());
            return this;
        }

        public final Builder scores(HugeDoubleArray scores) {
            this.scores = Objects.requireNonNull(scores, "scores");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder iterations(int iterations) {
            this.iterations = iterations;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder didConverge(boolean didConverge) {
            this.didConverge = didConverge;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public Builder clear() {
            this.initBits = 7L;
            this.scores = null;
            this.iterations = 0;
            this.didConverge = false;
            return this;
        }

        public PageRankResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePageRankResult(null, this.scores, this.iterations, this.didConverge);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("scores");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("iterations");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("didConverge");
            }
            return "Cannot build PageRankResult, some of required attributes are not set " + attributes;
        }
    }
}

