/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.pagerank;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.beta.pregel.Partitioning;
import org.neo4j.gds.beta.pregel.PregelConfig;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.config.IterationsConfig;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.config.SourceNodesConfig;
import org.neo4j.gds.config.ToleranceConfig;
import org.neo4j.gds.config.WriteConfig;
import org.neo4j.gds.config.WritePropertyConfig;
import org.neo4j.gds.pagerank.PageRankConfig;
import org.neo4j.gds.pagerank.PageRankWriteConfig;
import org.neo4j.gds.scaling.ScalarScaler;

@Generated(from="PageRankWriteConfig", generator="Immutables")
public final class ImmutablePageRankWriteConfig
implements PageRankWriteConfig {
    @Nullable
    private final String usernameOverride;
    private final boolean sudo;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    private final int concurrency;
    private final int minBatchSize;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    @Nullable
    private final String relationshipWeightProperty;
    private final transient boolean hasRelationshipWeightProperty;
    private final transient boolean useForkJoin;
    private final List<Long> sourceNodes;
    private final double tolerance;
    private final int maxIterations;
    private final double dampingFactor;
    private final ScalarScaler.Variant scaler;
    private final boolean isAsynchronous;
    private final Partitioning partitioning;
    private final int writeConcurrency;
    private final String writeProperty;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePageRankWriteConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, @Nullable String relationshipWeightProperty, Iterable<Long> sourceNodes, double tolerance, int maxIterations, double dampingFactor, ScalarScaler.Variant scaler, boolean isAsynchronous, Partitioning partitioning, int writeConcurrency, String writeProperty) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutablePageRankWriteConfig.createUnmodifiableList(false, ImmutablePageRankWriteConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutablePageRankWriteConfig.createUnmodifiableList(false, ImmutablePageRankWriteConfig.createSafeList(nodeLabels, true, false)));
        this.initShim.relationshipWeightProperty(relationshipWeightProperty);
        this.initShim.sourceNodes(ImmutablePageRankWriteConfig.createUnmodifiableList(false, ImmutablePageRankWriteConfig.createSafeList(sourceNodes, true, false)));
        this.initShim.tolerance(tolerance);
        this.initShim.maxIterations(maxIterations);
        this.initShim.dampingFactor(dampingFactor);
        this.initShim.scaler(Objects.requireNonNull(scaler, "scaler"));
        this.initShim.isAsynchronous(isAsynchronous);
        this.initShim.partitioning(Objects.requireNonNull(partitioning, "partitioning"));
        this.initShim.writeConcurrency(writeConcurrency);
        this.writeProperty = Objects.requireNonNull(writeProperty, "writeProperty");
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.useForkJoin = this.initShim.useForkJoin();
        this.sourceNodes = this.initShim.sourceNodes();
        this.tolerance = this.initShim.tolerance();
        this.maxIterations = this.initShim.maxIterations();
        this.dampingFactor = this.initShim.dampingFactor();
        this.scaler = this.initShim.scaler();
        this.isAsynchronous = this.initShim.isAsynchronous();
        this.partitioning = this.initShim.partitioning();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.initShim = null;
    }

    private ImmutablePageRankWriteConfig(Builder builder) {
        this.writeProperty = builder.writeProperty;
        if (builder.usernameOverrideIsSet()) {
            this.initShim.usernameOverride(builder.usernameOverride);
        }
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.minBatchSizeIsSet()) {
            this.initShim.minBatchSize(builder.minBatchSize);
        }
        if (builder.relationshipTypesIsSet()) {
            this.initShim.relationshipTypes(builder.relationshipTypes == null ? Collections.emptyList() : ImmutablePageRankWriteConfig.createUnmodifiableList(true, builder.relationshipTypes));
        }
        if (builder.nodeLabelsIsSet()) {
            this.initShim.nodeLabels(builder.nodeLabels == null ? Collections.emptyList() : ImmutablePageRankWriteConfig.createUnmodifiableList(true, builder.nodeLabels));
        }
        if (builder.relationshipWeightPropertyIsSet()) {
            this.initShim.relationshipWeightProperty(builder.relationshipWeightProperty);
        }
        if (builder.sourceNodesIsSet()) {
            this.initShim.sourceNodes(builder.sourceNodes == null ? Collections.emptyList() : ImmutablePageRankWriteConfig.createUnmodifiableList(true, builder.sourceNodes));
        }
        if (builder.toleranceIsSet()) {
            this.initShim.tolerance(builder.tolerance);
        }
        if (builder.maxIterationsIsSet()) {
            this.initShim.maxIterations(builder.maxIterations);
        }
        if (builder.dampingFactorIsSet()) {
            this.initShim.dampingFactor(builder.dampingFactor);
        }
        if (builder.scaler != null) {
            this.initShim.scaler(builder.scaler);
        }
        if (builder.isAsynchronousIsSet()) {
            this.initShim.isAsynchronous(builder.isAsynchronous);
        }
        if (builder.partitioning != null) {
            this.initShim.partitioning(builder.partitioning);
        }
        if (builder.writeConcurrencyIsSet()) {
            this.initShim.writeConcurrency(builder.writeConcurrency);
        }
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.useForkJoin = this.initShim.useForkJoin();
        this.sourceNodes = this.initShim.sourceNodes();
        this.tolerance = this.initShim.tolerance();
        this.maxIterations = this.initShim.maxIterations();
        this.dampingFactor = this.initShim.dampingFactor();
        this.scaler = this.initShim.scaler();
        this.isAsynchronous = this.initShim.isAsynchronous();
        this.partitioning = this.initShim.partitioning();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.initShim = null;
    }

    private ImmutablePageRankWriteConfig(@Nullable String usernameOverride, boolean sudo, Collection<String> configKeys, int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, @Nullable String relationshipWeightProperty, List<Long> sourceNodes, double tolerance, int maxIterations, double dampingFactor, ScalarScaler.Variant scaler, boolean isAsynchronous, Partitioning partitioning, int writeConcurrency, String writeProperty) {
        this.initShim.usernameOverride(usernameOverride);
        this.initShim.sudo(sudo);
        this.initShim.configKeys(configKeys);
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(relationshipTypes);
        this.initShim.nodeLabels(nodeLabels);
        this.initShim.relationshipWeightProperty(relationshipWeightProperty);
        this.initShim.sourceNodes(sourceNodes);
        this.initShim.tolerance(tolerance);
        this.initShim.maxIterations(maxIterations);
        this.initShim.dampingFactor(dampingFactor);
        this.initShim.scaler(scaler);
        this.initShim.isAsynchronous(isAsynchronous);
        this.initShim.partitioning(partitioning);
        this.initShim.writeConcurrency(writeConcurrency);
        this.writeProperty = writeProperty;
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.useForkJoin = this.initShim.useForkJoin();
        this.sourceNodes = this.initShim.sourceNodes();
        this.tolerance = this.initShim.tolerance();
        this.maxIterations = this.initShim.maxIterations();
        this.dampingFactor = this.initShim.dampingFactor();
        this.scaler = this.initShim.scaler();
        this.isAsynchronous = this.initShim.isAsynchronous();
        this.partitioning = this.initShim.partitioning();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.initShim = null;
    }

    @Nullable
    private String usernameOverrideInitialize() {
        return PageRankWriteConfig.super.usernameOverride();
    }

    private boolean sudoInitialize() {
        return PageRankWriteConfig.super.sudo();
    }

    private Collection<String> configKeysInitialize() {
        return PageRankWriteConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return PageRankWriteConfig.super.toMap();
    }

    private int concurrencyInitialize() {
        return PageRankWriteConfig.super.concurrency();
    }

    private int minBatchSizeInitialize() {
        return PageRankWriteConfig.super.minBatchSize();
    }

    private List<String> relationshipTypesInitialize() {
        return PageRankWriteConfig.super.relationshipTypes();
    }

    private List<String> nodeLabelsInitialize() {
        return PageRankWriteConfig.super.nodeLabels();
    }

    @Nullable
    private String relationshipWeightPropertyInitialize() {
        return PageRankWriteConfig.super.relationshipWeightProperty();
    }

    private boolean hasRelationshipWeightPropertyInitialize() {
        return PageRankWriteConfig.super.hasRelationshipWeightProperty();
    }

    private boolean useForkJoinInitialize() {
        return PageRankWriteConfig.super.useForkJoin();
    }

    private List<Long> sourceNodesInitialize() {
        return PageRankWriteConfig.super.sourceNodes();
    }

    private double toleranceInitialize() {
        return PageRankWriteConfig.super.tolerance();
    }

    private int maxIterationsInitialize() {
        return PageRankWriteConfig.super.maxIterations();
    }

    private double dampingFactorInitialize() {
        return PageRankWriteConfig.super.dampingFactor();
    }

    private ScalarScaler.Variant scalerInitialize() {
        return PageRankWriteConfig.super.scaler();
    }

    private boolean isAsynchronousInitialize() {
        return PageRankWriteConfig.super.isAsynchronous();
    }

    private Partitioning partitioningInitialize() {
        return PageRankWriteConfig.super.partitioning();
    }

    private int writeConcurrencyInitialize() {
        return PageRankWriteConfig.super.writeConcurrency();
    }

    @Nullable
    public String usernameOverride() {
        InitShim shim = this.initShim;
        return shim != null ? shim.usernameOverride() : this.usernameOverride;
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    public int minBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minBatchSize() : this.minBatchSize;
    }

    public List<String> relationshipTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipTypes() : this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeLabels() : this.nodeLabels;
    }

    @Nullable
    public String relationshipWeightProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipWeightProperty() : this.relationshipWeightProperty;
    }

    public boolean hasRelationshipWeightProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasRelationshipWeightProperty() : this.hasRelationshipWeightProperty;
    }

    public boolean useForkJoin() {
        InitShim shim = this.initShim;
        return shim != null ? shim.useForkJoin() : this.useForkJoin;
    }

    public List<Long> sourceNodes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sourceNodes() : this.sourceNodes;
    }

    @Override
    public double tolerance() {
        InitShim shim = this.initShim;
        return shim != null ? shim.tolerance() : this.tolerance;
    }

    @Override
    public int maxIterations() {
        InitShim shim = this.initShim;
        return shim != null ? shim.maxIterations() : this.maxIterations;
    }

    @Override
    public double dampingFactor() {
        InitShim shim = this.initShim;
        return shim != null ? shim.dampingFactor() : this.dampingFactor;
    }

    @Override
    public ScalarScaler.Variant scaler() {
        InitShim shim = this.initShim;
        return shim != null ? shim.scaler() : this.scaler;
    }

    @Override
    public boolean isAsynchronous() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isAsynchronous() : this.isAsynchronous;
    }

    @Override
    public Partitioning partitioning() {
        InitShim shim = this.initShim;
        return shim != null ? shim.partitioning() : this.partitioning;
    }

    public int writeConcurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.writeConcurrency() : this.writeConcurrency;
    }

    public String writeProperty() {
        return this.writeProperty;
    }

    public final ImmutablePageRankWriteConfig withUsernameOverride(@Nullable String value) {
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return ImmutablePageRankWriteConfig.validate(new ImmutablePageRankWriteConfig(value, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutablePageRankWriteConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutablePageRankWriteConfig.validate(new ImmutablePageRankWriteConfig(this.usernameOverride, value, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutablePageRankWriteConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutablePageRankWriteConfig.validate(new ImmutablePageRankWriteConfig(this.usernameOverride, this.sudo, newValue, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutablePageRankWriteConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutablePageRankWriteConfig.validate(new ImmutablePageRankWriteConfig(this.usernameOverride, this.sudo, this.configKeys, value, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutablePageRankWriteConfig withMinBatchSize(int value) {
        if (this.minBatchSize == value) {
            return this;
        }
        return ImmutablePageRankWriteConfig.validate(new ImmutablePageRankWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, value, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutablePageRankWriteConfig withRelationshipTypes(String ... elements) {
        List<String> newValue = ImmutablePageRankWriteConfig.createUnmodifiableList(false, ImmutablePageRankWriteConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutablePageRankWriteConfig.validate(new ImmutablePageRankWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.nodeLabels, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutablePageRankWriteConfig withRelationshipTypes(Iterable<String> elements) {
        if (this.relationshipTypes == elements) {
            return this;
        }
        List<String> newValue = ImmutablePageRankWriteConfig.createUnmodifiableList(false, ImmutablePageRankWriteConfig.createSafeList(elements, true, false));
        return ImmutablePageRankWriteConfig.validate(new ImmutablePageRankWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.nodeLabels, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutablePageRankWriteConfig withNodeLabels(String ... elements) {
        List<String> newValue = ImmutablePageRankWriteConfig.createUnmodifiableList(false, ImmutablePageRankWriteConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutablePageRankWriteConfig.validate(new ImmutablePageRankWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, newValue, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutablePageRankWriteConfig withNodeLabels(Iterable<String> elements) {
        if (this.nodeLabels == elements) {
            return this;
        }
        List<String> newValue = ImmutablePageRankWriteConfig.createUnmodifiableList(false, ImmutablePageRankWriteConfig.createSafeList(elements, true, false));
        return ImmutablePageRankWriteConfig.validate(new ImmutablePageRankWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, newValue, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutablePageRankWriteConfig withRelationshipWeightProperty(@Nullable String value) {
        if (Objects.equals(this.relationshipWeightProperty, value)) {
            return this;
        }
        return ImmutablePageRankWriteConfig.validate(new ImmutablePageRankWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, value, this.sourceNodes, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutablePageRankWriteConfig withSourceNodes(long ... elements) {
        ArrayList<Long> wrappedList = new ArrayList<Long>(elements.length);
        for (long element : elements) {
            wrappedList.add(element);
        }
        List<Long> newValue = ImmutablePageRankWriteConfig.createUnmodifiableList(false, wrappedList);
        return ImmutablePageRankWriteConfig.validate(new ImmutablePageRankWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, newValue, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutablePageRankWriteConfig withSourceNodes(Iterable<Long> elements) {
        if (this.sourceNodes == elements) {
            return this;
        }
        List<Long> newValue = ImmutablePageRankWriteConfig.createUnmodifiableList(false, ImmutablePageRankWriteConfig.createSafeList(elements, true, false));
        return ImmutablePageRankWriteConfig.validate(new ImmutablePageRankWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, newValue, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutablePageRankWriteConfig withTolerance(double value) {
        if (Double.doubleToLongBits(this.tolerance) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutablePageRankWriteConfig.validate(new ImmutablePageRankWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.sourceNodes, value, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutablePageRankWriteConfig withMaxIterations(int value) {
        if (this.maxIterations == value) {
            return this;
        }
        return ImmutablePageRankWriteConfig.validate(new ImmutablePageRankWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, value, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutablePageRankWriteConfig withDampingFactor(double value) {
        if (Double.doubleToLongBits(this.dampingFactor) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutablePageRankWriteConfig.validate(new ImmutablePageRankWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, this.maxIterations, value, this.scaler, this.isAsynchronous, this.partitioning, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutablePageRankWriteConfig withScaler(ScalarScaler.Variant value) {
        if (this.scaler == value) {
            return this;
        }
        ScalarScaler.Variant newValue = Objects.requireNonNull(value, "scaler");
        if (this.scaler.equals((Object)newValue)) {
            return this;
        }
        return ImmutablePageRankWriteConfig.validate(new ImmutablePageRankWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, this.maxIterations, this.dampingFactor, newValue, this.isAsynchronous, this.partitioning, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutablePageRankWriteConfig withIsAsynchronous(boolean value) {
        if (this.isAsynchronous == value) {
            return this;
        }
        return ImmutablePageRankWriteConfig.validate(new ImmutablePageRankWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, value, this.partitioning, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutablePageRankWriteConfig withPartitioning(Partitioning value) {
        if (this.partitioning == value) {
            return this;
        }
        Partitioning newValue = Objects.requireNonNull(value, "partitioning");
        if (this.partitioning.equals((Object)newValue)) {
            return this;
        }
        return ImmutablePageRankWriteConfig.validate(new ImmutablePageRankWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, newValue, this.writeConcurrency, this.writeProperty));
    }

    public final ImmutablePageRankWriteConfig withWriteConcurrency(int value) {
        if (this.writeConcurrency == value) {
            return this;
        }
        return ImmutablePageRankWriteConfig.validate(new ImmutablePageRankWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning, value, this.writeProperty));
    }

    public final ImmutablePageRankWriteConfig withWriteProperty(String value) {
        String newValue = Objects.requireNonNull(value, "writeProperty");
        if (this.writeProperty.equals(newValue)) {
            return this;
        }
        return ImmutablePageRankWriteConfig.validate(new ImmutablePageRankWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning, this.writeConcurrency, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePageRankWriteConfig && this.equalTo((ImmutablePageRankWriteConfig)another);
    }

    private boolean equalTo(ImmutablePageRankWriteConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && this.concurrency == another.concurrency && this.minBatchSize == another.minBatchSize && this.relationshipTypes.equals(another.relationshipTypes) && this.nodeLabels.equals(another.nodeLabels) && Objects.equals(this.relationshipWeightProperty, another.relationshipWeightProperty) && this.hasRelationshipWeightProperty == another.hasRelationshipWeightProperty && this.useForkJoin == another.useForkJoin && this.sourceNodes.equals(another.sourceNodes) && Double.doubleToLongBits(this.tolerance) == Double.doubleToLongBits(another.tolerance) && this.maxIterations == another.maxIterations && Double.doubleToLongBits(this.dampingFactor) == Double.doubleToLongBits(another.dampingFactor) && this.scaler.equals((Object)another.scaler) && this.isAsynchronous == another.isAsynchronous && this.partitioning.equals((Object)another.partitioning) && this.writeConcurrency == another.writeConcurrency && this.writeProperty.equals(another.writeProperty);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + this.concurrency;
        h += (h << 5) + this.minBatchSize;
        h += (h << 5) + this.relationshipTypes.hashCode();
        h += (h << 5) + this.nodeLabels.hashCode();
        h += (h << 5) + Objects.hashCode(this.relationshipWeightProperty);
        h += (h << 5) + Boolean.hashCode(this.hasRelationshipWeightProperty);
        h += (h << 5) + Boolean.hashCode(this.useForkJoin);
        h += (h << 5) + this.sourceNodes.hashCode();
        h += (h << 5) + Double.hashCode(this.tolerance);
        h += (h << 5) + this.maxIterations;
        h += (h << 5) + Double.hashCode(this.dampingFactor);
        h += (h << 5) + this.scaler.hashCode();
        h += (h << 5) + Boolean.hashCode(this.isAsynchronous);
        h += (h << 5) + this.partitioning.hashCode();
        h += (h << 5) + this.writeConcurrency;
        h += (h << 5) + this.writeProperty.hashCode();
        return h;
    }

    public String toString() {
        return "PageRankWriteConfig{usernameOverride=" + this.usernameOverride + ", sudo=" + this.sudo + ", concurrency=" + this.concurrency + ", minBatchSize=" + this.minBatchSize + ", relationshipTypes=" + this.relationshipTypes + ", nodeLabels=" + this.nodeLabels + ", relationshipWeightProperty=" + this.relationshipWeightProperty + ", hasRelationshipWeightProperty=" + this.hasRelationshipWeightProperty + ", useForkJoin=" + this.useForkJoin + ", sourceNodes=" + this.sourceNodes + ", tolerance=" + this.tolerance + ", maxIterations=" + this.maxIterations + ", dampingFactor=" + this.dampingFactor + ", scaler=" + this.scaler + ", isAsynchronous=" + this.isAsynchronous + ", partitioning=" + this.partitioning + ", writeConcurrency=" + this.writeConcurrency + ", writeProperty=" + this.writeProperty + "}";
    }

    public static PageRankWriteConfig of(int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, @Nullable String relationshipWeightProperty, List<Long> sourceNodes, double tolerance, int maxIterations, double dampingFactor, ScalarScaler.Variant scaler, boolean isAsynchronous, Partitioning partitioning, int writeConcurrency, String writeProperty) {
        return ImmutablePageRankWriteConfig.of(concurrency, minBatchSize, relationshipTypes, nodeLabels, relationshipWeightProperty, sourceNodes, tolerance, maxIterations, dampingFactor, scaler, isAsynchronous, partitioning, writeConcurrency, writeProperty);
    }

    public static PageRankWriteConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, @Nullable String relationshipWeightProperty, Iterable<Long> sourceNodes, double tolerance, int maxIterations, double dampingFactor, ScalarScaler.Variant scaler, boolean isAsynchronous, Partitioning partitioning, int writeConcurrency, String writeProperty) {
        return ImmutablePageRankWriteConfig.validate(new ImmutablePageRankWriteConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, relationshipWeightProperty, sourceNodes, tolerance, maxIterations, dampingFactor, scaler, isAsynchronous, partitioning, writeConcurrency, writeProperty));
    }

    private static ImmutablePageRankWriteConfig validate(ImmutablePageRankWriteConfig instance) {
        instance.validateWriteConcurrency();
        instance.validateConcurrency();
        return instance;
    }

    public static PageRankWriteConfig copyOf(PageRankWriteConfig instance) {
        if (instance instanceof ImmutablePageRankWriteConfig) {
            return (ImmutablePageRankWriteConfig)instance;
        }
        return ImmutablePageRankWriteConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="PageRankWriteConfig", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_WRITE_PROPERTY = 1L;
        private static final long OPT_BIT_USERNAME_OVERRIDE = 1L;
        private static final long OPT_BIT_SUDO = 2L;
        private static final long OPT_BIT_CONCURRENCY = 4L;
        private static final long OPT_BIT_MIN_BATCH_SIZE = 8L;
        private static final long OPT_BIT_RELATIONSHIP_TYPES = 16L;
        private static final long OPT_BIT_NODE_LABELS = 32L;
        private static final long OPT_BIT_RELATIONSHIP_WEIGHT_PROPERTY = 64L;
        private static final long OPT_BIT_SOURCE_NODES = 128L;
        private static final long OPT_BIT_TOLERANCE = 256L;
        private static final long OPT_BIT_MAX_ITERATIONS = 512L;
        private static final long OPT_BIT_DAMPING_FACTOR = 1024L;
        private static final long OPT_BIT_IS_ASYNCHRONOUS = 2048L;
        private static final long OPT_BIT_WRITE_CONCURRENCY = 4096L;
        private long initBits = 1L;
        private long optBits;
        private String usernameOverride;
        private boolean sudo;
        private Collection<String> configKeys;
        private int concurrency;
        private int minBatchSize;
        private List<String> relationshipTypes = null;
        private List<String> nodeLabels = null;
        private String relationshipWeightProperty;
        private List<Long> sourceNodes = null;
        private double tolerance;
        private int maxIterations;
        private double dampingFactor;
        private ScalarScaler.Variant scaler;
        private boolean isAsynchronous;
        private Partitioning partitioning;
        private int writeConcurrency;
        private String writeProperty;

        private Builder() {
        }

        public final Builder from(RelationshipWeightConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(WriteConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(WritePropertyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PageRankConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ConcurrencyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ToleranceConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SourceNodesConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PregelConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AlgoBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(IterationsConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PageRankWriteConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            String relationshipWeightPropertyValue;
            long bits = 0L;
            if (object instanceof RelationshipWeightConfig && (relationshipWeightPropertyValue = (instance = (RelationshipWeightConfig)object).relationshipWeightProperty()) != null) {
                this.relationshipWeightProperty(relationshipWeightPropertyValue);
            }
            if (object instanceof WriteConfig) {
                instance = (WriteConfig)object;
                this.writeConcurrency(instance.writeConcurrency());
            }
            if (object instanceof WritePropertyConfig) {
                instance = (WritePropertyConfig)object;
                this.writeProperty(instance.writeProperty());
            }
            if (object instanceof PageRankConfig) {
                instance = (PageRankConfig)object;
                if ((bits & 4L) == 0L) {
                    this.partitioning(instance.partitioning());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.maxIterations(instance.maxIterations());
                    bits |= 1L;
                }
                this.dampingFactor(instance.dampingFactor());
                this.scaler(instance.scaler());
                if ((bits & 8L) == 0L) {
                    this.tolerance(instance.tolerance());
                    bits |= 8L;
                }
                if ((bits & 2L) == 0L) {
                    this.isAsynchronous(instance.isAsynchronous());
                    bits |= 2L;
                }
            }
            if (object instanceof ConcurrencyConfig) {
                instance = (ConcurrencyConfig)object;
                this.minBatchSize(instance.minBatchSize());
                this.concurrency(instance.concurrency());
            }
            if (object instanceof ToleranceConfig) {
                instance = (ToleranceConfig)object;
                if ((bits & 8L) == 0L) {
                    this.tolerance(instance.tolerance());
                    bits |= 8L;
                }
            }
            if (object instanceof SourceNodesConfig) {
                instance = (SourceNodesConfig)object;
                this.addAllSourceNodes(instance.sourceNodes());
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                @Nullable String usernameOverrideValue = instance.usernameOverride();
                if (usernameOverrideValue != null) {
                    this.usernameOverride(usernameOverrideValue);
                }
                this.configKeys(instance.configKeys());
                this.sudo(instance.sudo());
            }
            if (object instanceof PregelConfig) {
                instance = (PregelConfig)object;
                if ((bits & 4L) == 0L) {
                    this.partitioning(instance.partitioning());
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    this.isAsynchronous(instance.isAsynchronous());
                    bits |= 2L;
                }
            }
            if (object instanceof AlgoBaseConfig) {
                instance = (AlgoBaseConfig)object;
                this.addAllRelationshipTypes(instance.relationshipTypes());
                this.addAllNodeLabels(instance.nodeLabels());
            }
            if (object instanceof IterationsConfig) {
                instance = (IterationsConfig)object;
                if ((bits & 1L) == 0L) {
                    this.maxIterations(instance.maxIterations());
                    bits |= 1L;
                }
            }
        }

        public final Builder usernameOverride(@Nullable String usernameOverride) {
            this.usernameOverride = usernameOverride;
            this.optBits |= 1L;
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 2L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 4L;
            return this;
        }

        public final Builder minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.optBits |= 8L;
            return this;
        }

        public final Builder addRelationshipType(String element) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addRelationshipTypes(String ... elements) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder relationshipTypes(Iterable<String> elements) {
            this.relationshipTypes = new ArrayList<String>();
            return this.addAllRelationshipTypes(elements);
        }

        public final Builder addAllRelationshipTypes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "relationshipTypes element");
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addNodeLabel(String element) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder addNodeLabels(String ... elements) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder nodeLabels(Iterable<String> elements) {
            this.nodeLabels = new ArrayList<String>();
            return this.addAllNodeLabels(elements);
        }

        public final Builder addAllNodeLabels(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeLabels element");
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder relationshipWeightProperty(@Nullable String relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder addSourceNode(long element) {
            if (this.sourceNodes == null) {
                this.sourceNodes = new ArrayList<Long>();
            }
            this.sourceNodes.add(element);
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder addSourceNodes(long ... elements) {
            if (this.sourceNodes == null) {
                this.sourceNodes = new ArrayList<Long>();
            }
            for (long element : elements) {
                this.sourceNodes.add(element);
            }
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder sourceNodes(Iterable<Long> elements) {
            this.sourceNodes = new ArrayList<Long>();
            return this.addAllSourceNodes(elements);
        }

        public final Builder addAllSourceNodes(Iterable<Long> elements) {
            Objects.requireNonNull(elements, "sourceNodes element");
            if (this.sourceNodes == null) {
                this.sourceNodes = new ArrayList<Long>();
            }
            for (long element : elements) {
                this.sourceNodes.add(Objects.requireNonNull(Long.valueOf(element), "sourceNodes element"));
            }
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder tolerance(double tolerance) {
            this.tolerance = tolerance;
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder maxIterations(int maxIterations) {
            this.maxIterations = maxIterations;
            this.optBits |= 0x200L;
            return this;
        }

        public final Builder dampingFactor(double dampingFactor) {
            this.dampingFactor = dampingFactor;
            this.optBits |= 0x400L;
            return this;
        }

        public final Builder scaler(ScalarScaler.Variant scaler) {
            this.scaler = Objects.requireNonNull(scaler, "scaler");
            return this;
        }

        public final Builder isAsynchronous(boolean isAsynchronous) {
            this.isAsynchronous = isAsynchronous;
            this.optBits |= 0x800L;
            return this;
        }

        public final Builder partitioning(Partitioning partitioning) {
            this.partitioning = Objects.requireNonNull(partitioning, "partitioning");
            return this;
        }

        public final Builder writeConcurrency(int writeConcurrency) {
            this.writeConcurrency = writeConcurrency;
            this.optBits |= 0x1000L;
            return this;
        }

        public final Builder writeProperty(String writeProperty) {
            this.writeProperty = Objects.requireNonNull(writeProperty, "writeProperty");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder clear() {
            this.initBits = 1L;
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.configKeys = null;
            this.concurrency = 0;
            this.minBatchSize = 0;
            if (this.relationshipTypes != null) {
                this.relationshipTypes.clear();
            }
            if (this.nodeLabels != null) {
                this.nodeLabels.clear();
            }
            this.relationshipWeightProperty = null;
            if (this.sourceNodes != null) {
                this.sourceNodes.clear();
            }
            this.tolerance = 0.0;
            this.maxIterations = 0;
            this.dampingFactor = 0.0;
            this.scaler = null;
            this.isAsynchronous = false;
            this.partitioning = null;
            this.writeConcurrency = 0;
            this.writeProperty = null;
            return this;
        }

        public PageRankWriteConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutablePageRankWriteConfig.validate(new ImmutablePageRankWriteConfig(this));
        }

        private boolean usernameOverrideIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean sudoIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean minBatchSizeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean relationshipTypesIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean nodeLabelsIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean relationshipWeightPropertyIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean sourceNodesIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean toleranceIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean maxIterationsIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private boolean dampingFactorIsSet() {
            return (this.optBits & 0x400L) != 0L;
        }

        private boolean isAsynchronousIsSet() {
            return (this.optBits & 0x800L) != 0L;
        }

        private boolean writeConcurrencyIsSet() {
            return (this.optBits & 0x1000L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("writeProperty");
            }
            return "Cannot build PageRankWriteConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="PageRankWriteConfig", generator="Immutables")
    private final class InitShim {
        private byte usernameOverrideBuildStage = 0;
        private String usernameOverride;
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte concurrencyBuildStage = 0;
        private int concurrency;
        private byte minBatchSizeBuildStage = 0;
        private int minBatchSize;
        private byte relationshipTypesBuildStage = 0;
        private List<String> relationshipTypes;
        private byte nodeLabelsBuildStage = 0;
        private List<String> nodeLabels;
        private byte relationshipWeightPropertyBuildStage = 0;
        private String relationshipWeightProperty;
        private byte hasRelationshipWeightPropertyBuildStage = 0;
        private boolean hasRelationshipWeightProperty;
        private byte useForkJoinBuildStage = 0;
        private boolean useForkJoin;
        private byte sourceNodesBuildStage = 0;
        private List<Long> sourceNodes;
        private byte toleranceBuildStage = 0;
        private double tolerance;
        private byte maxIterationsBuildStage = 0;
        private int maxIterations;
        private byte dampingFactorBuildStage = 0;
        private double dampingFactor;
        private byte scalerBuildStage = 0;
        private ScalarScaler.Variant scaler;
        private byte isAsynchronousBuildStage = 0;
        private boolean isAsynchronous;
        private byte partitioningBuildStage = 0;
        private Partitioning partitioning;
        private byte writeConcurrencyBuildStage = 0;
        private int writeConcurrency;

        private InitShim() {
        }

        String usernameOverride() {
            if (this.usernameOverrideBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usernameOverrideBuildStage == 0) {
                this.usernameOverrideBuildStage = (byte)-1;
                this.usernameOverride = ImmutablePageRankWriteConfig.this.usernameOverrideInitialize();
                this.usernameOverrideBuildStage = 1;
            }
            return this.usernameOverride;
        }

        void usernameOverride(String usernameOverride) {
            this.usernameOverride = usernameOverride;
            this.usernameOverrideBuildStage = 1;
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutablePageRankWriteConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutablePageRankWriteConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutablePageRankWriteConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutablePageRankWriteConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        int minBatchSize() {
            if (this.minBatchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minBatchSizeBuildStage == 0) {
                this.minBatchSizeBuildStage = (byte)-1;
                this.minBatchSize = ImmutablePageRankWriteConfig.this.minBatchSizeInitialize();
                this.minBatchSizeBuildStage = 1;
            }
            return this.minBatchSize;
        }

        void minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.minBatchSizeBuildStage = 1;
        }

        List<String> relationshipTypes() {
            if (this.relationshipTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipTypesBuildStage == 0) {
                this.relationshipTypesBuildStage = (byte)-1;
                this.relationshipTypes = ImmutablePageRankWriteConfig.createUnmodifiableList(false, ImmutablePageRankWriteConfig.createSafeList(ImmutablePageRankWriteConfig.this.relationshipTypesInitialize(), true, false));
                this.relationshipTypesBuildStage = 1;
            }
            return this.relationshipTypes;
        }

        void relationshipTypes(List<String> relationshipTypes) {
            this.relationshipTypes = relationshipTypes;
            this.relationshipTypesBuildStage = 1;
        }

        List<String> nodeLabels() {
            if (this.nodeLabelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeLabelsBuildStage == 0) {
                this.nodeLabelsBuildStage = (byte)-1;
                this.nodeLabels = ImmutablePageRankWriteConfig.createUnmodifiableList(false, ImmutablePageRankWriteConfig.createSafeList(ImmutablePageRankWriteConfig.this.nodeLabelsInitialize(), true, false));
                this.nodeLabelsBuildStage = 1;
            }
            return this.nodeLabels;
        }

        void nodeLabels(List<String> nodeLabels) {
            this.nodeLabels = nodeLabels;
            this.nodeLabelsBuildStage = 1;
        }

        String relationshipWeightProperty() {
            if (this.relationshipWeightPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipWeightPropertyBuildStage == 0) {
                this.relationshipWeightPropertyBuildStage = (byte)-1;
                this.relationshipWeightProperty = ImmutablePageRankWriteConfig.this.relationshipWeightPropertyInitialize();
                this.relationshipWeightPropertyBuildStage = 1;
            }
            return this.relationshipWeightProperty;
        }

        void relationshipWeightProperty(String relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty;
            this.relationshipWeightPropertyBuildStage = 1;
        }

        boolean hasRelationshipWeightProperty() {
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasRelationshipWeightPropertyBuildStage == 0) {
                this.hasRelationshipWeightPropertyBuildStage = (byte)-1;
                this.hasRelationshipWeightProperty = ImmutablePageRankWriteConfig.this.hasRelationshipWeightPropertyInitialize();
                this.hasRelationshipWeightPropertyBuildStage = 1;
            }
            return this.hasRelationshipWeightProperty;
        }

        boolean useForkJoin() {
            if (this.useForkJoinBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.useForkJoinBuildStage == 0) {
                this.useForkJoinBuildStage = (byte)-1;
                this.useForkJoin = ImmutablePageRankWriteConfig.this.useForkJoinInitialize();
                this.useForkJoinBuildStage = 1;
            }
            return this.useForkJoin;
        }

        List<Long> sourceNodes() {
            if (this.sourceNodesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sourceNodesBuildStage == 0) {
                this.sourceNodesBuildStage = (byte)-1;
                this.sourceNodes = ImmutablePageRankWriteConfig.createUnmodifiableList(false, ImmutablePageRankWriteConfig.createSafeList(ImmutablePageRankWriteConfig.this.sourceNodesInitialize(), true, false));
                this.sourceNodesBuildStage = 1;
            }
            return this.sourceNodes;
        }

        void sourceNodes(List<Long> sourceNodes) {
            this.sourceNodes = sourceNodes;
            this.sourceNodesBuildStage = 1;
        }

        double tolerance() {
            if (this.toleranceBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toleranceBuildStage == 0) {
                this.toleranceBuildStage = (byte)-1;
                this.tolerance = ImmutablePageRankWriteConfig.this.toleranceInitialize();
                this.toleranceBuildStage = 1;
            }
            return this.tolerance;
        }

        void tolerance(double tolerance) {
            this.tolerance = tolerance;
            this.toleranceBuildStage = 1;
        }

        int maxIterations() {
            if (this.maxIterationsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.maxIterationsBuildStage == 0) {
                this.maxIterationsBuildStage = (byte)-1;
                this.maxIterations = ImmutablePageRankWriteConfig.this.maxIterationsInitialize();
                this.maxIterationsBuildStage = 1;
            }
            return this.maxIterations;
        }

        void maxIterations(int maxIterations) {
            this.maxIterations = maxIterations;
            this.maxIterationsBuildStage = 1;
        }

        double dampingFactor() {
            if (this.dampingFactorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.dampingFactorBuildStage == 0) {
                this.dampingFactorBuildStage = (byte)-1;
                this.dampingFactor = ImmutablePageRankWriteConfig.this.dampingFactorInitialize();
                this.dampingFactorBuildStage = 1;
            }
            return this.dampingFactor;
        }

        void dampingFactor(double dampingFactor) {
            this.dampingFactor = dampingFactor;
            this.dampingFactorBuildStage = 1;
        }

        ScalarScaler.Variant scaler() {
            if (this.scalerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.scalerBuildStage == 0) {
                this.scalerBuildStage = (byte)-1;
                this.scaler = Objects.requireNonNull(ImmutablePageRankWriteConfig.this.scalerInitialize(), "scaler");
                this.scalerBuildStage = 1;
            }
            return this.scaler;
        }

        void scaler(ScalarScaler.Variant scaler) {
            this.scaler = scaler;
            this.scalerBuildStage = 1;
        }

        boolean isAsynchronous() {
            if (this.isAsynchronousBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isAsynchronousBuildStage == 0) {
                this.isAsynchronousBuildStage = (byte)-1;
                this.isAsynchronous = ImmutablePageRankWriteConfig.this.isAsynchronousInitialize();
                this.isAsynchronousBuildStage = 1;
            }
            return this.isAsynchronous;
        }

        void isAsynchronous(boolean isAsynchronous) {
            this.isAsynchronous = isAsynchronous;
            this.isAsynchronousBuildStage = 1;
        }

        Partitioning partitioning() {
            if (this.partitioningBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.partitioningBuildStage == 0) {
                this.partitioningBuildStage = (byte)-1;
                this.partitioning = Objects.requireNonNull(ImmutablePageRankWriteConfig.this.partitioningInitialize(), "partitioning");
                this.partitioningBuildStage = 1;
            }
            return this.partitioning;
        }

        void partitioning(Partitioning partitioning) {
            this.partitioning = partitioning;
            this.partitioningBuildStage = 1;
        }

        int writeConcurrency() {
            if (this.writeConcurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.writeConcurrencyBuildStage == 0) {
                this.writeConcurrencyBuildStage = (byte)-1;
                this.writeConcurrency = ImmutablePageRankWriteConfig.this.writeConcurrencyInitialize();
                this.writeConcurrencyBuildStage = 1;
            }
            return this.writeConcurrency;
        }

        void writeConcurrency(int writeConcurrency) {
            this.writeConcurrency = writeConcurrency;
            this.writeConcurrencyBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.usernameOverrideBuildStage == -1) {
                attributes.add("usernameOverride");
            }
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.minBatchSizeBuildStage == -1) {
                attributes.add("minBatchSize");
            }
            if (this.relationshipTypesBuildStage == -1) {
                attributes.add("relationshipTypes");
            }
            if (this.nodeLabelsBuildStage == -1) {
                attributes.add("nodeLabels");
            }
            if (this.relationshipWeightPropertyBuildStage == -1) {
                attributes.add("relationshipWeightProperty");
            }
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                attributes.add("hasRelationshipWeightProperty");
            }
            if (this.useForkJoinBuildStage == -1) {
                attributes.add("useForkJoin");
            }
            if (this.sourceNodesBuildStage == -1) {
                attributes.add("sourceNodes");
            }
            if (this.toleranceBuildStage == -1) {
                attributes.add("tolerance");
            }
            if (this.maxIterationsBuildStage == -1) {
                attributes.add("maxIterations");
            }
            if (this.dampingFactorBuildStage == -1) {
                attributes.add("dampingFactor");
            }
            if (this.scalerBuildStage == -1) {
                attributes.add("scaler");
            }
            if (this.isAsynchronousBuildStage == -1) {
                attributes.add("isAsynchronous");
            }
            if (this.partitioningBuildStage == -1) {
                attributes.add("partitioning");
            }
            if (this.writeConcurrencyBuildStage == -1) {
                attributes.add("writeConcurrency");
            }
            return "Cannot build PageRankWriteConfig, attribute initializers form cycle " + attributes;
        }
    }
}

