/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.pagerank;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.beta.pregel.Pregel;
import org.neo4j.gds.beta.pregel.PregelComputation;
import org.neo4j.gds.beta.pregel.PregelConfig;
import org.neo4j.gds.beta.pregel.PregelResult;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.partition.PartitionUtils;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.pagerank.ImmutablePageRankResult;
import org.neo4j.gds.pagerank.PageRankAlgorithmFactory;
import org.neo4j.gds.pagerank.PageRankConfig;
import org.neo4j.gds.pagerank.PageRankResult;
import org.neo4j.gds.scaling.ScalarScaler;

public class PageRankAlgorithm
extends Algorithm<PageRankResult> {
    private final Pregel<PageRankConfig> pregelJob;
    private final Graph graph;
    private final PageRankAlgorithmFactory.Mode mode;
    private final PageRankConfig config;
    private final ExecutorService executorService;

    PageRankAlgorithm(Graph graph, PageRankConfig config, PregelComputation<PageRankConfig> pregelComputation, PageRankAlgorithmFactory.Mode mode, ExecutorService executorService, ProgressTracker progressTracker) {
        super(progressTracker);
        this.pregelJob = Pregel.create((Graph)graph, (PregelConfig)config, pregelComputation, (ExecutorService)executorService, (ProgressTracker)progressTracker);
        this.mode = mode;
        this.executorService = executorService;
        this.config = config;
        this.graph = graph;
    }

    public PageRankResult compute() {
        PregelResult pregelResult = this.pregelJob.run();
        HugeDoubleArray scores = pregelResult.nodeValues().doubleProperties("pagerank");
        this.scaleScores(scores);
        return ImmutablePageRankResult.builder().scores(scores).iterations(pregelResult.ranIterations()).didConverge(pregelResult.didConverge()).build();
    }

    private void scaleScores(HugeDoubleArray scores) {
        ScalarScaler.Variant variant = this.config.scaler();
        if (variant == ScalarScaler.Variant.NONE || variant == ScalarScaler.Variant.L2NORM && this.mode == PageRankAlgorithmFactory.Mode.EIGENVECTOR) {
            return;
        }
        ScalarScaler scaler = variant.create((NodeProperties)scores.asNodeProperties(), this.graph.nodeCount(), this.config.concurrency(), this.executorService);
        List tasks = PartitionUtils.rangePartition((int)this.config.concurrency(), (long)this.graph.nodeCount(), partition -> () -> partition.consume(nodeId -> scores.set(nodeId, scaler.scaleProperty(nodeId))), Optional.empty());
        ParallelUtil.runWithConcurrency((int)this.config.concurrency(), (Iterable)tasks, (ExecutorService)this.executorService);
    }

    public void release() {
        this.pregelJob.release();
    }
}

