/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.pagerank;

import org.immutables.value.Value;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.beta.pregel.Partitioning;
import org.neo4j.gds.beta.pregel.PregelConfig;
import org.neo4j.gds.config.SourceNodesConfig;
import org.neo4j.gds.config.ToleranceConfig;
import org.neo4j.gds.scaling.ScalarScaler;

@ValueClass
@Configuration(value="PageRankConfigImpl")
public interface PageRankConfig
extends PregelConfig,
ToleranceConfig,
SourceNodesConfig {
    @Value.Default
    @Configuration.DoubleRange(min=0.0)
    default public double tolerance() {
        return 1.0E-7;
    }

    @Configuration.IntegerRange(min=1)
    @Value.Default
    default public int maxIterations() {
        return 20;
    }

    @Value.Default
    @Configuration.DoubleRange(min=0.0, max=1.0, maxInclusive=false)
    default public double dampingFactor() {
        return 0.85;
    }

    @Value.Default
    @Configuration.ConvertWith(value="org.neo4j.gds.scaling.ScalarScaler.Variant#lookup")
    @Configuration.ToMapValue(value="org.neo4j.gds.scaling.ScalarScaler.Variant#toString")
    default public ScalarScaler.Variant scaler() {
        return ScalarScaler.Variant.NONE;
    }

    @Value.Default
    @Configuration.Ignore
    default public boolean isAsynchronous() {
        return false;
    }

    @Value.Default
    @Configuration.Ignore
    default public Partitioning partitioning() {
        return Partitioning.AUTO;
    }
}

