/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.pagerank;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.NodeIdsParser;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.config.WritePropertyConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.pagerank.PageRankWriteConfig;
import org.neo4j.gds.scaling.ScalarScaler;

public final class PageRankWriteConfigImpl
implements PageRankWriteConfig {
    private double tolerance;
    private int maxIterations;
    private double dampingFactor;
    private ScalarScaler.Variant scaler;
    private List<String> relationshipTypes;
    private List<String> nodeLabels;
    @Nullable
    private String usernameOverride;
    private boolean sudo;
    private int concurrency;
    @Nullable
    private String relationshipWeightProperty;
    private List<Long> sourceNodes;
    private String writeProperty;
    private int writeConcurrency;

    public PageRankWriteConfigImpl(@NotNull CypherMapWrapper config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.tolerance = config.getDouble("tolerance", PageRankWriteConfig.super.tolerance());
            CypherMapWrapper.validateDoubleRange((String)"tolerance", (double)this.tolerance, (double)0.0, (double)Double.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.maxIterations = config.getInt("maxIterations", PageRankWriteConfig.super.maxIterations());
            CypherMapWrapper.validateIntegerRange((String)"maxIterations", (int)this.maxIterations, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.dampingFactor = config.getDouble("dampingFactor", PageRankWriteConfig.super.dampingFactor());
            CypherMapWrapper.validateDoubleRange((String)"dampingFactor", (double)this.dampingFactor, (double)0.0, (double)1.0, (boolean)true, (boolean)false);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.scaler = (ScalarScaler.Variant)CypherMapWrapper.failOnNull((String)"scaler", (Object)ScalarScaler.Variant.lookup((Object)config.getChecked("scaler", (Object)PageRankWriteConfig.super.scaler(), Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipTypes = (List)CypherMapWrapper.failOnNull((String)"relationshipTypes", (Object)((List)config.getChecked("relationshipTypes", (Object)PageRankWriteConfig.super.relationshipTypes(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.nodeLabels = (List)CypherMapWrapper.failOnNull((String)"nodeLabels", (Object)((List)config.getChecked("nodeLabels", (Object)PageRankWriteConfig.super.nodeLabels(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.usernameOverride = StringUtils.trimToNull((String)config.getString("username", PageRankWriteConfig.super.usernameOverride()));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sudo = config.getBool("sudo", PageRankWriteConfig.super.sudo());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.concurrency = config.getInt("concurrency", PageRankWriteConfig.super.concurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipWeightProperty = RelationshipWeightConfig.validatePropertyName((String)config.getString("relationshipWeightProperty", PageRankWriteConfig.super.relationshipWeightProperty()));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sourceNodes = (List)CypherMapWrapper.failOnNull((String)"sourceNodes", (Object)NodeIdsParser.parseNodeIds((Object)config.getChecked("sourceNodes", (Object)PageRankWriteConfig.super.sourceNodes(), Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.writeProperty = (String)CypherMapWrapper.failOnNull((String)"writeProperty", (Object)WritePropertyConfig.validatePropertyName((String)config.requireString("writeProperty")));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.writeConcurrency = config.getInt("writeConcurrency", PageRankWriteConfig.super.writeConcurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validateConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.validateWriteConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public double tolerance() {
        return this.tolerance;
    }

    @Override
    public int maxIterations() {
        return this.maxIterations;
    }

    @Override
    public double dampingFactor() {
        return this.dampingFactor;
    }

    @Override
    public ScalarScaler.Variant scaler() {
        return this.scaler;
    }

    public List<String> relationshipTypes() {
        return this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        return this.nodeLabels;
    }

    public void graphStoreValidation(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        this.relationshipWeightValidation(graphStore, selectedLabels, selectedRelationshipTypes);
    }

    @Nullable
    public String usernameOverride() {
        return this.usernameOverride;
    }

    public boolean sudo() {
        return this.sudo;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("tolerance", "maxIterations", "dampingFactor", "scaler", "relationshipTypes", "nodeLabels", "username", "sudo", "concurrency", "relationshipWeightProperty", "sourceNodes", "writeProperty", "writeConcurrency");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("tolerance", this.tolerance());
        map.put("maxIterations", this.maxIterations());
        map.put("dampingFactor", this.dampingFactor());
        map.put("scaler", ScalarScaler.Variant.toString((ScalarScaler.Variant)this.scaler()));
        map.put("relationshipTypes", this.relationshipTypes());
        map.put("nodeLabels", this.nodeLabels());
        map.put("username", this.usernameOverride());
        map.put("sudo", this.sudo());
        map.put("concurrency", this.concurrency());
        map.put("relationshipWeightProperty", this.relationshipWeightProperty());
        map.put("sourceNodes", this.sourceNodes());
        map.put("writeProperty", this.writeProperty());
        map.put("writeConcurrency", this.writeConcurrency());
        return map;
    }

    public int concurrency() {
        return this.concurrency;
    }

    @Nullable
    public String relationshipWeightProperty() {
        return this.relationshipWeightProperty;
    }

    public List<Long> sourceNodes() {
        return this.sourceNodes;
    }

    public String writeProperty() {
        return this.writeProperty;
    }

    public int writeConcurrency() {
        return this.writeConcurrency;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();

        public Builder tolerance(double tolerance) {
            this.config.put("tolerance", tolerance);
            return this;
        }

        public Builder maxIterations(int maxIterations) {
            this.config.put("maxIterations", maxIterations);
            return this;
        }

        public Builder dampingFactor(double dampingFactor) {
            this.config.put("dampingFactor", dampingFactor);
            return this;
        }

        public Builder scaler(Object scaler) {
            this.config.put("scaler", scaler);
            return this;
        }

        public Builder relationshipTypes(List<String> relationshipTypes) {
            this.config.put("relationshipTypes", relationshipTypes);
            return this;
        }

        public Builder nodeLabels(List<String> nodeLabels) {
            this.config.put("nodeLabels", nodeLabels);
            return this;
        }

        public Builder usernameOverride(String usernameOverride) {
            this.config.put("username", usernameOverride);
            return this;
        }

        public Builder sudo(boolean sudo) {
            this.config.put("sudo", sudo);
            return this;
        }

        public Builder concurrency(int concurrency) {
            this.config.put("concurrency", concurrency);
            return this;
        }

        public Builder relationshipWeightProperty(String relationshipWeightProperty) {
            this.config.put("relationshipWeightProperty", relationshipWeightProperty);
            return this;
        }

        public Builder sourceNodes(Object sourceNodes) {
            this.config.put("sourceNodes", sourceNodes);
            return this;
        }

        public Builder writeProperty(String writeProperty) {
            this.config.put("writeProperty", writeProperty);
            return this;
        }

        public Builder writeConcurrency(int writeConcurrency) {
            this.config.put("writeConcurrency", writeConcurrency);
            return this;
        }

        public PageRankWriteConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new PageRankWriteConfigImpl(config);
        }
    }
}

