/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.paths.astar;

import java.util.Optional;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.paged.HugeLongDoubleMap;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.paths.astar.config.ShortestPathAStarBaseConfig;
import org.neo4j.gds.paths.dijkstra.Dijkstra;
import org.neo4j.gds.paths.dijkstra.DijkstraResult;
import org.neo4j.gds.utils.StringFormatting;

public final class AStar
extends Algorithm<DijkstraResult> {
    private final Dijkstra dijkstra;

    private AStar(Dijkstra dijkstra) {
        super(dijkstra.getProgressTracker());
        this.dijkstra = dijkstra;
        this.terminationFlag = dijkstra.getTerminationFlag();
    }

    public static AStar sourceTarget(Graph graph, ShortestPathAStarBaseConfig config, ProgressTracker progressTracker) {
        String latitudeProperty = config.latitudeProperty();
        String longitudeProperty = config.longitudeProperty();
        if (!graph.availableNodeProperties().contains(latitudeProperty)) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"The property `%s` has not been loaded", (Object[])new Object[]{latitudeProperty}));
        }
        if (!graph.availableNodeProperties().contains(longitudeProperty)) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"The property `%s` has not been loaded", (Object[])new Object[]{longitudeProperty}));
        }
        NodeProperties latitudeProperties = graph.nodeProperties(latitudeProperty);
        NodeProperties longitudeProperties = graph.nodeProperties(longitudeProperty);
        long targetNode = graph.toMappedNodeId(config.targetNode());
        HaversineHeuristic heuristic = new HaversineHeuristic(latitudeProperties, longitudeProperties, targetNode);
        Dijkstra dijkstra = Dijkstra.sourceTarget(graph, config, Optional.of(heuristic), progressTracker);
        return new AStar(dijkstra);
    }

    public static MemoryEstimation memoryEstimation() {
        return MemoryEstimations.builder(AStar.class).add("Dijkstra", Dijkstra.memoryEstimation(false)).add("distanceCache", HugeLongDoubleMap.memoryEstimation()).build();
    }

    public DijkstraResult compute() {
        return this.dijkstra.compute();
    }

    public void release() {
        this.dijkstra.release();
    }

    public static class HaversineHeuristic
    implements Dijkstra.HeuristicFunction {
        static final double DEFAULT_DISTANCE = Double.NaN;
        static final double KM_TO_NM = 0.539957;
        static final double EARTH_RADIUS_IN_NM = 3440.0660470000003;
        private final double targetLatitude;
        private final double targetLongitude;
        private final NodeProperties latitudeProperties;
        private final NodeProperties longitudeProperties;
        private final HugeLongDoubleMap distanceCache;

        HaversineHeuristic(NodeProperties latitudeProperties, NodeProperties longitudeProperties, long targetNode) {
            this.latitudeProperties = latitudeProperties;
            this.longitudeProperties = longitudeProperties;
            this.targetLatitude = latitudeProperties.doubleValue(targetNode);
            this.targetLongitude = longitudeProperties.doubleValue(targetNode);
            this.distanceCache = new HugeLongDoubleMap();
        }

        @Override
        public double applyAsDouble(long source) {
            double distance = this.distanceCache.getOrDefault(source, Double.NaN);
            if (Double.isNaN(distance)) {
                double sourceLatitude = this.latitudeProperties.doubleValue(source);
                double sourceLongitude = this.longitudeProperties.doubleValue(source);
                distance = HaversineHeuristic.distance(sourceLatitude, sourceLongitude, this.targetLatitude, this.targetLongitude);
                this.distanceCache.addTo(source, distance);
            }
            return distance;
        }

        public static double distance(double sourceLatitude, double sourceLongitude, double targetLatitude, double targetLongitude) {
            double latitudeDistance = Math.toRadians(targetLatitude - sourceLatitude);
            double longitudeDistance = Math.toRadians(targetLongitude - sourceLongitude);
            double lat1 = Math.toRadians(sourceLatitude);
            double lat2 = Math.toRadians(targetLatitude);
            double a = Math.pow(Math.sin(latitudeDistance / 2.0), 2.0) + Math.pow(Math.sin(longitudeDistance / 2.0), 2.0) * Math.cos(lat1) * Math.cos(lat2);
            double c = 2.0 * Math.asin(Math.sqrt(a));
            return 3440.0660470000003 * c;
        }
    }
}

