/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.paths.astar.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.config.SourceNodeConfig;
import org.neo4j.gds.config.TargetNodeConfig;
import org.neo4j.gds.config.WriteConfig;
import org.neo4j.gds.config.WriteRelationshipConfig;
import org.neo4j.gds.paths.TrackRelationshipsConfig;
import org.neo4j.gds.paths.WritePathOptionsConfig;
import org.neo4j.gds.paths.astar.config.ShortestPathAStarBaseConfig;
import org.neo4j.gds.paths.astar.config.ShortestPathAStarWriteConfig;

@Generated(from="ShortestPathAStarWriteConfig", generator="Immutables")
public final class ImmutableShortestPathAStarWriteConfig
implements ShortestPathAStarWriteConfig {
    @Nullable
    private final String usernameOverride;
    private final boolean sudo;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    private final int concurrency;
    private final int minBatchSize;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    private final long sourceNode;
    private final long targetNode;
    @Nullable
    private final String relationshipWeightProperty;
    private final transient boolean hasRelationshipWeightProperty;
    private final boolean trackRelationships;
    private final String longitudeProperty;
    private final String latitudeProperty;
    private final int writeConcurrency;
    private final String writeRelationshipType;
    private final boolean writeNodeIds;
    private final boolean writeCosts;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableShortestPathAStarWriteConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, long sourceNode, long targetNode, @Nullable String relationshipWeightProperty, boolean trackRelationships, String longitudeProperty, String latitudeProperty, int writeConcurrency, String writeRelationshipType, boolean writeNodeIds, boolean writeCosts) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableShortestPathAStarWriteConfig.createUnmodifiableList(false, ImmutableShortestPathAStarWriteConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableShortestPathAStarWriteConfig.createUnmodifiableList(false, ImmutableShortestPathAStarWriteConfig.createSafeList(nodeLabels, true, false)));
        this.sourceNode = sourceNode;
        this.targetNode = targetNode;
        this.initShim.relationshipWeightProperty(relationshipWeightProperty);
        this.initShim.trackRelationships(trackRelationships);
        this.longitudeProperty = Objects.requireNonNull(longitudeProperty, "longitudeProperty");
        this.latitudeProperty = Objects.requireNonNull(latitudeProperty, "latitudeProperty");
        this.initShim.writeConcurrency(writeConcurrency);
        this.writeRelationshipType = Objects.requireNonNull(writeRelationshipType, "writeRelationshipType");
        this.initShim.writeNodeIds(writeNodeIds);
        this.initShim.writeCosts(writeCosts);
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.trackRelationships = this.initShim.trackRelationships();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.writeNodeIds = this.initShim.writeNodeIds();
        this.writeCosts = this.initShim.writeCosts();
        this.initShim = null;
    }

    private ImmutableShortestPathAStarWriteConfig(Builder builder) {
        this.sourceNode = builder.sourceNode;
        this.targetNode = builder.targetNode;
        this.longitudeProperty = builder.longitudeProperty;
        this.latitudeProperty = builder.latitudeProperty;
        this.writeRelationshipType = builder.writeRelationshipType;
        if (builder.usernameOverrideIsSet()) {
            this.initShim.usernameOverride(builder.usernameOverride);
        }
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.minBatchSizeIsSet()) {
            this.initShim.minBatchSize(builder.minBatchSize);
        }
        if (builder.relationshipTypesIsSet()) {
            this.initShim.relationshipTypes(builder.relationshipTypes == null ? Collections.emptyList() : ImmutableShortestPathAStarWriteConfig.createUnmodifiableList(true, builder.relationshipTypes));
        }
        if (builder.nodeLabelsIsSet()) {
            this.initShim.nodeLabels(builder.nodeLabels == null ? Collections.emptyList() : ImmutableShortestPathAStarWriteConfig.createUnmodifiableList(true, builder.nodeLabels));
        }
        if (builder.relationshipWeightPropertyIsSet()) {
            this.initShim.relationshipWeightProperty(builder.relationshipWeightProperty);
        }
        if (builder.trackRelationshipsIsSet()) {
            this.initShim.trackRelationships(builder.trackRelationships);
        }
        if (builder.writeConcurrencyIsSet()) {
            this.initShim.writeConcurrency(builder.writeConcurrency);
        }
        if (builder.writeNodeIdsIsSet()) {
            this.initShim.writeNodeIds(builder.writeNodeIds);
        }
        if (builder.writeCostsIsSet()) {
            this.initShim.writeCosts(builder.writeCosts);
        }
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.trackRelationships = this.initShim.trackRelationships();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.writeNodeIds = this.initShim.writeNodeIds();
        this.writeCosts = this.initShim.writeCosts();
        this.initShim = null;
    }

    private ImmutableShortestPathAStarWriteConfig(@Nullable String usernameOverride, boolean sudo, Collection<String> configKeys, int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, long sourceNode, long targetNode, @Nullable String relationshipWeightProperty, boolean trackRelationships, String longitudeProperty, String latitudeProperty, int writeConcurrency, String writeRelationshipType, boolean writeNodeIds, boolean writeCosts) {
        this.initShim.usernameOverride(usernameOverride);
        this.initShim.sudo(sudo);
        this.initShim.configKeys(configKeys);
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(relationshipTypes);
        this.initShim.nodeLabels(nodeLabels);
        this.sourceNode = sourceNode;
        this.targetNode = targetNode;
        this.initShim.relationshipWeightProperty(relationshipWeightProperty);
        this.initShim.trackRelationships(trackRelationships);
        this.longitudeProperty = longitudeProperty;
        this.latitudeProperty = latitudeProperty;
        this.initShim.writeConcurrency(writeConcurrency);
        this.writeRelationshipType = writeRelationshipType;
        this.initShim.writeNodeIds(writeNodeIds);
        this.initShim.writeCosts(writeCosts);
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.trackRelationships = this.initShim.trackRelationships();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.writeNodeIds = this.initShim.writeNodeIds();
        this.writeCosts = this.initShim.writeCosts();
        this.initShim = null;
    }

    @Nullable
    private String usernameOverrideInitialize() {
        return ShortestPathAStarWriteConfig.super.usernameOverride();
    }

    private boolean sudoInitialize() {
        return ShortestPathAStarWriteConfig.super.sudo();
    }

    private Collection<String> configKeysInitialize() {
        return ShortestPathAStarWriteConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return ShortestPathAStarWriteConfig.super.toMap();
    }

    private int concurrencyInitialize() {
        return ShortestPathAStarWriteConfig.super.concurrency();
    }

    private int minBatchSizeInitialize() {
        return ShortestPathAStarWriteConfig.super.minBatchSize();
    }

    private List<String> relationshipTypesInitialize() {
        return ShortestPathAStarWriteConfig.super.relationshipTypes();
    }

    private List<String> nodeLabelsInitialize() {
        return ShortestPathAStarWriteConfig.super.nodeLabels();
    }

    @Nullable
    private String relationshipWeightPropertyInitialize() {
        return ShortestPathAStarWriteConfig.super.relationshipWeightProperty();
    }

    private boolean hasRelationshipWeightPropertyInitialize() {
        return ShortestPathAStarWriteConfig.super.hasRelationshipWeightProperty();
    }

    private boolean trackRelationshipsInitialize() {
        return ShortestPathAStarWriteConfig.super.trackRelationships();
    }

    private int writeConcurrencyInitialize() {
        return ShortestPathAStarWriteConfig.super.writeConcurrency();
    }

    private boolean writeNodeIdsInitialize() {
        return ShortestPathAStarWriteConfig.super.writeNodeIds();
    }

    private boolean writeCostsInitialize() {
        return ShortestPathAStarWriteConfig.super.writeCosts();
    }

    @Nullable
    public String usernameOverride() {
        InitShim shim = this.initShim;
        return shim != null ? shim.usernameOverride() : this.usernameOverride;
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    public int minBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minBatchSize() : this.minBatchSize;
    }

    public List<String> relationshipTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipTypes() : this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeLabels() : this.nodeLabels;
    }

    public long sourceNode() {
        return this.sourceNode;
    }

    public long targetNode() {
        return this.targetNode;
    }

    @Nullable
    public String relationshipWeightProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipWeightProperty() : this.relationshipWeightProperty;
    }

    public boolean hasRelationshipWeightProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasRelationshipWeightProperty() : this.hasRelationshipWeightProperty;
    }

    @Override
    public boolean trackRelationships() {
        InitShim shim = this.initShim;
        return shim != null ? shim.trackRelationships() : this.trackRelationships;
    }

    @Override
    public String longitudeProperty() {
        return this.longitudeProperty;
    }

    @Override
    public String latitudeProperty() {
        return this.latitudeProperty;
    }

    public int writeConcurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.writeConcurrency() : this.writeConcurrency;
    }

    public String writeRelationshipType() {
        return this.writeRelationshipType;
    }

    @Override
    public boolean writeNodeIds() {
        InitShim shim = this.initShim;
        return shim != null ? shim.writeNodeIds() : this.writeNodeIds;
    }

    @Override
    public boolean writeCosts() {
        InitShim shim = this.initShim;
        return shim != null ? shim.writeCosts() : this.writeCosts;
    }

    public final ImmutableShortestPathAStarWriteConfig withUsernameOverride(@Nullable String value) {
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return ImmutableShortestPathAStarWriteConfig.validate(new ImmutableShortestPathAStarWriteConfig(value, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.targetNode, this.relationshipWeightProperty, this.trackRelationships, this.longitudeProperty, this.latitudeProperty, this.writeConcurrency, this.writeRelationshipType, this.writeNodeIds, this.writeCosts));
    }

    public final ImmutableShortestPathAStarWriteConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutableShortestPathAStarWriteConfig.validate(new ImmutableShortestPathAStarWriteConfig(this.usernameOverride, value, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.targetNode, this.relationshipWeightProperty, this.trackRelationships, this.longitudeProperty, this.latitudeProperty, this.writeConcurrency, this.writeRelationshipType, this.writeNodeIds, this.writeCosts));
    }

    public final ImmutableShortestPathAStarWriteConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutableShortestPathAStarWriteConfig.validate(new ImmutableShortestPathAStarWriteConfig(this.usernameOverride, this.sudo, newValue, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.targetNode, this.relationshipWeightProperty, this.trackRelationships, this.longitudeProperty, this.latitudeProperty, this.writeConcurrency, this.writeRelationshipType, this.writeNodeIds, this.writeCosts));
    }

    public final ImmutableShortestPathAStarWriteConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutableShortestPathAStarWriteConfig.validate(new ImmutableShortestPathAStarWriteConfig(this.usernameOverride, this.sudo, this.configKeys, value, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.targetNode, this.relationshipWeightProperty, this.trackRelationships, this.longitudeProperty, this.latitudeProperty, this.writeConcurrency, this.writeRelationshipType, this.writeNodeIds, this.writeCosts));
    }

    public final ImmutableShortestPathAStarWriteConfig withMinBatchSize(int value) {
        if (this.minBatchSize == value) {
            return this;
        }
        return ImmutableShortestPathAStarWriteConfig.validate(new ImmutableShortestPathAStarWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, value, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.targetNode, this.relationshipWeightProperty, this.trackRelationships, this.longitudeProperty, this.latitudeProperty, this.writeConcurrency, this.writeRelationshipType, this.writeNodeIds, this.writeCosts));
    }

    public final ImmutableShortestPathAStarWriteConfig withRelationshipTypes(String ... elements) {
        List<String> newValue = ImmutableShortestPathAStarWriteConfig.createUnmodifiableList(false, ImmutableShortestPathAStarWriteConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableShortestPathAStarWriteConfig.validate(new ImmutableShortestPathAStarWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.nodeLabels, this.sourceNode, this.targetNode, this.relationshipWeightProperty, this.trackRelationships, this.longitudeProperty, this.latitudeProperty, this.writeConcurrency, this.writeRelationshipType, this.writeNodeIds, this.writeCosts));
    }

    public final ImmutableShortestPathAStarWriteConfig withRelationshipTypes(Iterable<String> elements) {
        if (this.relationshipTypes == elements) {
            return this;
        }
        List<String> newValue = ImmutableShortestPathAStarWriteConfig.createUnmodifiableList(false, ImmutableShortestPathAStarWriteConfig.createSafeList(elements, true, false));
        return ImmutableShortestPathAStarWriteConfig.validate(new ImmutableShortestPathAStarWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.nodeLabels, this.sourceNode, this.targetNode, this.relationshipWeightProperty, this.trackRelationships, this.longitudeProperty, this.latitudeProperty, this.writeConcurrency, this.writeRelationshipType, this.writeNodeIds, this.writeCosts));
    }

    public final ImmutableShortestPathAStarWriteConfig withNodeLabels(String ... elements) {
        List<String> newValue = ImmutableShortestPathAStarWriteConfig.createUnmodifiableList(false, ImmutableShortestPathAStarWriteConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableShortestPathAStarWriteConfig.validate(new ImmutableShortestPathAStarWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, newValue, this.sourceNode, this.targetNode, this.relationshipWeightProperty, this.trackRelationships, this.longitudeProperty, this.latitudeProperty, this.writeConcurrency, this.writeRelationshipType, this.writeNodeIds, this.writeCosts));
    }

    public final ImmutableShortestPathAStarWriteConfig withNodeLabels(Iterable<String> elements) {
        if (this.nodeLabels == elements) {
            return this;
        }
        List<String> newValue = ImmutableShortestPathAStarWriteConfig.createUnmodifiableList(false, ImmutableShortestPathAStarWriteConfig.createSafeList(elements, true, false));
        return ImmutableShortestPathAStarWriteConfig.validate(new ImmutableShortestPathAStarWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, newValue, this.sourceNode, this.targetNode, this.relationshipWeightProperty, this.trackRelationships, this.longitudeProperty, this.latitudeProperty, this.writeConcurrency, this.writeRelationshipType, this.writeNodeIds, this.writeCosts));
    }

    public final ImmutableShortestPathAStarWriteConfig withSourceNode(long value) {
        if (this.sourceNode == value) {
            return this;
        }
        return ImmutableShortestPathAStarWriteConfig.validate(new ImmutableShortestPathAStarWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, value, this.targetNode, this.relationshipWeightProperty, this.trackRelationships, this.longitudeProperty, this.latitudeProperty, this.writeConcurrency, this.writeRelationshipType, this.writeNodeIds, this.writeCosts));
    }

    public final ImmutableShortestPathAStarWriteConfig withTargetNode(long value) {
        if (this.targetNode == value) {
            return this;
        }
        return ImmutableShortestPathAStarWriteConfig.validate(new ImmutableShortestPathAStarWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.sourceNode, value, this.relationshipWeightProperty, this.trackRelationships, this.longitudeProperty, this.latitudeProperty, this.writeConcurrency, this.writeRelationshipType, this.writeNodeIds, this.writeCosts));
    }

    public final ImmutableShortestPathAStarWriteConfig withRelationshipWeightProperty(@Nullable String value) {
        if (Objects.equals(this.relationshipWeightProperty, value)) {
            return this;
        }
        return ImmutableShortestPathAStarWriteConfig.validate(new ImmutableShortestPathAStarWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.targetNode, value, this.trackRelationships, this.longitudeProperty, this.latitudeProperty, this.writeConcurrency, this.writeRelationshipType, this.writeNodeIds, this.writeCosts));
    }

    public final ImmutableShortestPathAStarWriteConfig withTrackRelationships(boolean value) {
        if (this.trackRelationships == value) {
            return this;
        }
        return ImmutableShortestPathAStarWriteConfig.validate(new ImmutableShortestPathAStarWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.targetNode, this.relationshipWeightProperty, value, this.longitudeProperty, this.latitudeProperty, this.writeConcurrency, this.writeRelationshipType, this.writeNodeIds, this.writeCosts));
    }

    public final ImmutableShortestPathAStarWriteConfig withLongitudeProperty(String value) {
        String newValue = Objects.requireNonNull(value, "longitudeProperty");
        if (this.longitudeProperty.equals(newValue)) {
            return this;
        }
        return ImmutableShortestPathAStarWriteConfig.validate(new ImmutableShortestPathAStarWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.targetNode, this.relationshipWeightProperty, this.trackRelationships, newValue, this.latitudeProperty, this.writeConcurrency, this.writeRelationshipType, this.writeNodeIds, this.writeCosts));
    }

    public final ImmutableShortestPathAStarWriteConfig withLatitudeProperty(String value) {
        String newValue = Objects.requireNonNull(value, "latitudeProperty");
        if (this.latitudeProperty.equals(newValue)) {
            return this;
        }
        return ImmutableShortestPathAStarWriteConfig.validate(new ImmutableShortestPathAStarWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.targetNode, this.relationshipWeightProperty, this.trackRelationships, this.longitudeProperty, newValue, this.writeConcurrency, this.writeRelationshipType, this.writeNodeIds, this.writeCosts));
    }

    public final ImmutableShortestPathAStarWriteConfig withWriteConcurrency(int value) {
        if (this.writeConcurrency == value) {
            return this;
        }
        return ImmutableShortestPathAStarWriteConfig.validate(new ImmutableShortestPathAStarWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.targetNode, this.relationshipWeightProperty, this.trackRelationships, this.longitudeProperty, this.latitudeProperty, value, this.writeRelationshipType, this.writeNodeIds, this.writeCosts));
    }

    public final ImmutableShortestPathAStarWriteConfig withWriteRelationshipType(String value) {
        String newValue = Objects.requireNonNull(value, "writeRelationshipType");
        if (this.writeRelationshipType.equals(newValue)) {
            return this;
        }
        return ImmutableShortestPathAStarWriteConfig.validate(new ImmutableShortestPathAStarWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.targetNode, this.relationshipWeightProperty, this.trackRelationships, this.longitudeProperty, this.latitudeProperty, this.writeConcurrency, newValue, this.writeNodeIds, this.writeCosts));
    }

    public final ImmutableShortestPathAStarWriteConfig withWriteNodeIds(boolean value) {
        if (this.writeNodeIds == value) {
            return this;
        }
        return ImmutableShortestPathAStarWriteConfig.validate(new ImmutableShortestPathAStarWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.targetNode, this.relationshipWeightProperty, this.trackRelationships, this.longitudeProperty, this.latitudeProperty, this.writeConcurrency, this.writeRelationshipType, value, this.writeCosts));
    }

    public final ImmutableShortestPathAStarWriteConfig withWriteCosts(boolean value) {
        if (this.writeCosts == value) {
            return this;
        }
        return ImmutableShortestPathAStarWriteConfig.validate(new ImmutableShortestPathAStarWriteConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.targetNode, this.relationshipWeightProperty, this.trackRelationships, this.longitudeProperty, this.latitudeProperty, this.writeConcurrency, this.writeRelationshipType, this.writeNodeIds, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableShortestPathAStarWriteConfig && this.equalTo((ImmutableShortestPathAStarWriteConfig)another);
    }

    private boolean equalTo(ImmutableShortestPathAStarWriteConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && this.concurrency == another.concurrency && this.minBatchSize == another.minBatchSize && this.relationshipTypes.equals(another.relationshipTypes) && this.nodeLabels.equals(another.nodeLabels) && this.sourceNode == another.sourceNode && this.targetNode == another.targetNode && Objects.equals(this.relationshipWeightProperty, another.relationshipWeightProperty) && this.hasRelationshipWeightProperty == another.hasRelationshipWeightProperty && this.trackRelationships == another.trackRelationships && this.longitudeProperty.equals(another.longitudeProperty) && this.latitudeProperty.equals(another.latitudeProperty) && this.writeConcurrency == another.writeConcurrency && this.writeRelationshipType.equals(another.writeRelationshipType) && this.writeNodeIds == another.writeNodeIds && this.writeCosts == another.writeCosts;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + this.concurrency;
        h += (h << 5) + this.minBatchSize;
        h += (h << 5) + this.relationshipTypes.hashCode();
        h += (h << 5) + this.nodeLabels.hashCode();
        h += (h << 5) + Long.hashCode(this.sourceNode);
        h += (h << 5) + Long.hashCode(this.targetNode);
        h += (h << 5) + Objects.hashCode(this.relationshipWeightProperty);
        h += (h << 5) + Boolean.hashCode(this.hasRelationshipWeightProperty);
        h += (h << 5) + Boolean.hashCode(this.trackRelationships);
        h += (h << 5) + this.longitudeProperty.hashCode();
        h += (h << 5) + this.latitudeProperty.hashCode();
        h += (h << 5) + this.writeConcurrency;
        h += (h << 5) + this.writeRelationshipType.hashCode();
        h += (h << 5) + Boolean.hashCode(this.writeNodeIds);
        h += (h << 5) + Boolean.hashCode(this.writeCosts);
        return h;
    }

    public String toString() {
        return "ShortestPathAStarWriteConfig{usernameOverride=" + this.usernameOverride + ", sudo=" + this.sudo + ", concurrency=" + this.concurrency + ", minBatchSize=" + this.minBatchSize + ", relationshipTypes=" + this.relationshipTypes + ", nodeLabels=" + this.nodeLabels + ", sourceNode=" + this.sourceNode + ", targetNode=" + this.targetNode + ", relationshipWeightProperty=" + this.relationshipWeightProperty + ", hasRelationshipWeightProperty=" + this.hasRelationshipWeightProperty + ", trackRelationships=" + this.trackRelationships + ", longitudeProperty=" + this.longitudeProperty + ", latitudeProperty=" + this.latitudeProperty + ", writeConcurrency=" + this.writeConcurrency + ", writeRelationshipType=" + this.writeRelationshipType + ", writeNodeIds=" + this.writeNodeIds + ", writeCosts=" + this.writeCosts + "}";
    }

    public static ShortestPathAStarWriteConfig of(int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, long sourceNode, long targetNode, @Nullable String relationshipWeightProperty, boolean trackRelationships, String longitudeProperty, String latitudeProperty, int writeConcurrency, String writeRelationshipType, boolean writeNodeIds, boolean writeCosts) {
        return ImmutableShortestPathAStarWriteConfig.of(concurrency, minBatchSize, relationshipTypes, nodeLabels, sourceNode, targetNode, relationshipWeightProperty, trackRelationships, longitudeProperty, latitudeProperty, writeConcurrency, writeRelationshipType, writeNodeIds, writeCosts);
    }

    public static ShortestPathAStarWriteConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, long sourceNode, long targetNode, @Nullable String relationshipWeightProperty, boolean trackRelationships, String longitudeProperty, String latitudeProperty, int writeConcurrency, String writeRelationshipType, boolean writeNodeIds, boolean writeCosts) {
        return ImmutableShortestPathAStarWriteConfig.validate(new ImmutableShortestPathAStarWriteConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, sourceNode, targetNode, relationshipWeightProperty, trackRelationships, longitudeProperty, latitudeProperty, writeConcurrency, writeRelationshipType, writeNodeIds, writeCosts));
    }

    private static ImmutableShortestPathAStarWriteConfig validate(ImmutableShortestPathAStarWriteConfig instance) {
        instance.validateWriteConcurrency();
        instance.validateConcurrency();
        return instance;
    }

    public static ShortestPathAStarWriteConfig copyOf(ShortestPathAStarWriteConfig instance) {
        if (instance instanceof ImmutableShortestPathAStarWriteConfig) {
            return (ImmutableShortestPathAStarWriteConfig)instance;
        }
        return ImmutableShortestPathAStarWriteConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ShortestPathAStarWriteConfig", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_SOURCE_NODE = 1L;
        private static final long INIT_BIT_TARGET_NODE = 2L;
        private static final long INIT_BIT_LONGITUDE_PROPERTY = 4L;
        private static final long INIT_BIT_LATITUDE_PROPERTY = 8L;
        private static final long INIT_BIT_WRITE_RELATIONSHIP_TYPE = 16L;
        private static final long OPT_BIT_USERNAME_OVERRIDE = 1L;
        private static final long OPT_BIT_SUDO = 2L;
        private static final long OPT_BIT_CONCURRENCY = 4L;
        private static final long OPT_BIT_MIN_BATCH_SIZE = 8L;
        private static final long OPT_BIT_RELATIONSHIP_TYPES = 16L;
        private static final long OPT_BIT_NODE_LABELS = 32L;
        private static final long OPT_BIT_RELATIONSHIP_WEIGHT_PROPERTY = 64L;
        private static final long OPT_BIT_TRACK_RELATIONSHIPS = 128L;
        private static final long OPT_BIT_WRITE_CONCURRENCY = 256L;
        private static final long OPT_BIT_WRITE_NODE_IDS = 512L;
        private static final long OPT_BIT_WRITE_COSTS = 1024L;
        private long initBits = 31L;
        private long optBits;
        private String usernameOverride;
        private boolean sudo;
        private Collection<String> configKeys;
        private int concurrency;
        private int minBatchSize;
        private List<String> relationshipTypes = null;
        private List<String> nodeLabels = null;
        private long sourceNode;
        private long targetNode;
        private String relationshipWeightProperty;
        private boolean trackRelationships;
        private String longitudeProperty;
        private String latitudeProperty;
        private int writeConcurrency;
        private String writeRelationshipType;
        private boolean writeNodeIds;
        private boolean writeCosts;

        private Builder() {
        }

        public final Builder from(RelationshipWeightConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(WriteConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(WritePathOptionsConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SourceNodeConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TargetNodeConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ConcurrencyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TrackRelationshipsConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ShortestPathAStarBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(WriteRelationshipConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AlgoBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ShortestPathAStarWriteConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            String relationshipWeightPropertyValue;
            if (object instanceof RelationshipWeightConfig && (relationshipWeightPropertyValue = (instance = (RelationshipWeightConfig)object).relationshipWeightProperty()) != null) {
                this.relationshipWeightProperty(relationshipWeightPropertyValue);
            }
            if (object instanceof WriteConfig) {
                instance = (WriteConfig)object;
                this.writeConcurrency(instance.writeConcurrency());
            }
            if (object instanceof WritePathOptionsConfig) {
                instance = (WritePathOptionsConfig)object;
                this.writeCosts(instance.writeCosts());
                this.writeNodeIds(instance.writeNodeIds());
            }
            if (object instanceof SourceNodeConfig) {
                instance = (SourceNodeConfig)object;
                this.sourceNode(instance.sourceNode());
            }
            if (object instanceof TargetNodeConfig) {
                instance = (TargetNodeConfig)object;
                this.targetNode(instance.targetNode());
            }
            if (object instanceof ConcurrencyConfig) {
                instance = (ConcurrencyConfig)object;
                this.minBatchSize(instance.minBatchSize());
                this.concurrency(instance.concurrency());
            }
            if (object instanceof TrackRelationshipsConfig) {
                instance = (TrackRelationshipsConfig)object;
                this.trackRelationships(instance.trackRelationships());
            }
            if (object instanceof ShortestPathAStarBaseConfig) {
                instance = (ShortestPathAStarBaseConfig)object;
                this.longitudeProperty(instance.longitudeProperty());
                this.latitudeProperty(instance.latitudeProperty());
            }
            if (object instanceof WriteRelationshipConfig) {
                instance = (WriteRelationshipConfig)object;
                this.writeRelationshipType(instance.writeRelationshipType());
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                @Nullable String usernameOverrideValue = instance.usernameOverride();
                if (usernameOverrideValue != null) {
                    this.usernameOverride(usernameOverrideValue);
                }
                this.configKeys(instance.configKeys());
                this.sudo(instance.sudo());
            }
            if (object instanceof AlgoBaseConfig) {
                instance = (AlgoBaseConfig)object;
                this.addAllRelationshipTypes(instance.relationshipTypes());
                this.addAllNodeLabels(instance.nodeLabels());
            }
        }

        public final Builder usernameOverride(@Nullable String usernameOverride) {
            this.usernameOverride = usernameOverride;
            this.optBits |= 1L;
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 2L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 4L;
            return this;
        }

        public final Builder minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.optBits |= 8L;
            return this;
        }

        public final Builder addRelationshipType(String element) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addRelationshipTypes(String ... elements) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder relationshipTypes(Iterable<String> elements) {
            this.relationshipTypes = new ArrayList<String>();
            return this.addAllRelationshipTypes(elements);
        }

        public final Builder addAllRelationshipTypes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "relationshipTypes element");
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addNodeLabel(String element) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder addNodeLabels(String ... elements) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder nodeLabels(Iterable<String> elements) {
            this.nodeLabels = new ArrayList<String>();
            return this.addAllNodeLabels(elements);
        }

        public final Builder addAllNodeLabels(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeLabels element");
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder sourceNode(long sourceNode) {
            this.sourceNode = sourceNode;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder targetNode(long targetNode) {
            this.targetNode = targetNode;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder relationshipWeightProperty(@Nullable String relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder trackRelationships(boolean trackRelationships) {
            this.trackRelationships = trackRelationships;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder longitudeProperty(String longitudeProperty) {
            this.longitudeProperty = Objects.requireNonNull(longitudeProperty, "longitudeProperty");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder latitudeProperty(String latitudeProperty) {
            this.latitudeProperty = Objects.requireNonNull(latitudeProperty, "latitudeProperty");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder writeConcurrency(int writeConcurrency) {
            this.writeConcurrency = writeConcurrency;
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder writeRelationshipType(String writeRelationshipType) {
            this.writeRelationshipType = Objects.requireNonNull(writeRelationshipType, "writeRelationshipType");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder writeNodeIds(boolean writeNodeIds) {
            this.writeNodeIds = writeNodeIds;
            this.optBits |= 0x200L;
            return this;
        }

        public final Builder writeCosts(boolean writeCosts) {
            this.writeCosts = writeCosts;
            this.optBits |= 0x400L;
            return this;
        }

        public Builder clear() {
            this.initBits = 31L;
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.configKeys = null;
            this.concurrency = 0;
            this.minBatchSize = 0;
            if (this.relationshipTypes != null) {
                this.relationshipTypes.clear();
            }
            if (this.nodeLabels != null) {
                this.nodeLabels.clear();
            }
            this.sourceNode = 0L;
            this.targetNode = 0L;
            this.relationshipWeightProperty = null;
            this.trackRelationships = false;
            this.longitudeProperty = null;
            this.latitudeProperty = null;
            this.writeConcurrency = 0;
            this.writeRelationshipType = null;
            this.writeNodeIds = false;
            this.writeCosts = false;
            return this;
        }

        public ShortestPathAStarWriteConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableShortestPathAStarWriteConfig.validate(new ImmutableShortestPathAStarWriteConfig(this));
        }

        private boolean usernameOverrideIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean sudoIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean minBatchSizeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean relationshipTypesIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean nodeLabelsIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean relationshipWeightPropertyIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean trackRelationshipsIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean writeConcurrencyIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean writeNodeIdsIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private boolean writeCostsIsSet() {
            return (this.optBits & 0x400L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sourceNode");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("targetNode");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("longitudeProperty");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("latitudeProperty");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("writeRelationshipType");
            }
            return "Cannot build ShortestPathAStarWriteConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="ShortestPathAStarWriteConfig", generator="Immutables")
    private final class InitShim {
        private byte usernameOverrideBuildStage = 0;
        private String usernameOverride;
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte concurrencyBuildStage = 0;
        private int concurrency;
        private byte minBatchSizeBuildStage = 0;
        private int minBatchSize;
        private byte relationshipTypesBuildStage = 0;
        private List<String> relationshipTypes;
        private byte nodeLabelsBuildStage = 0;
        private List<String> nodeLabels;
        private byte relationshipWeightPropertyBuildStage = 0;
        private String relationshipWeightProperty;
        private byte hasRelationshipWeightPropertyBuildStage = 0;
        private boolean hasRelationshipWeightProperty;
        private byte trackRelationshipsBuildStage = 0;
        private boolean trackRelationships;
        private byte writeConcurrencyBuildStage = 0;
        private int writeConcurrency;
        private byte writeNodeIdsBuildStage = 0;
        private boolean writeNodeIds;
        private byte writeCostsBuildStage = 0;
        private boolean writeCosts;

        private InitShim() {
        }

        String usernameOverride() {
            if (this.usernameOverrideBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usernameOverrideBuildStage == 0) {
                this.usernameOverrideBuildStage = (byte)-1;
                this.usernameOverride = ImmutableShortestPathAStarWriteConfig.this.usernameOverrideInitialize();
                this.usernameOverrideBuildStage = 1;
            }
            return this.usernameOverride;
        }

        void usernameOverride(String usernameOverride) {
            this.usernameOverride = usernameOverride;
            this.usernameOverrideBuildStage = 1;
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableShortestPathAStarWriteConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableShortestPathAStarWriteConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableShortestPathAStarWriteConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutableShortestPathAStarWriteConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        int minBatchSize() {
            if (this.minBatchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minBatchSizeBuildStage == 0) {
                this.minBatchSizeBuildStage = (byte)-1;
                this.minBatchSize = ImmutableShortestPathAStarWriteConfig.this.minBatchSizeInitialize();
                this.minBatchSizeBuildStage = 1;
            }
            return this.minBatchSize;
        }

        void minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.minBatchSizeBuildStage = 1;
        }

        List<String> relationshipTypes() {
            if (this.relationshipTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipTypesBuildStage == 0) {
                this.relationshipTypesBuildStage = (byte)-1;
                this.relationshipTypes = ImmutableShortestPathAStarWriteConfig.createUnmodifiableList(false, ImmutableShortestPathAStarWriteConfig.createSafeList(ImmutableShortestPathAStarWriteConfig.this.relationshipTypesInitialize(), true, false));
                this.relationshipTypesBuildStage = 1;
            }
            return this.relationshipTypes;
        }

        void relationshipTypes(List<String> relationshipTypes) {
            this.relationshipTypes = relationshipTypes;
            this.relationshipTypesBuildStage = 1;
        }

        List<String> nodeLabels() {
            if (this.nodeLabelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeLabelsBuildStage == 0) {
                this.nodeLabelsBuildStage = (byte)-1;
                this.nodeLabels = ImmutableShortestPathAStarWriteConfig.createUnmodifiableList(false, ImmutableShortestPathAStarWriteConfig.createSafeList(ImmutableShortestPathAStarWriteConfig.this.nodeLabelsInitialize(), true, false));
                this.nodeLabelsBuildStage = 1;
            }
            return this.nodeLabels;
        }

        void nodeLabels(List<String> nodeLabels) {
            this.nodeLabels = nodeLabels;
            this.nodeLabelsBuildStage = 1;
        }

        String relationshipWeightProperty() {
            if (this.relationshipWeightPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipWeightPropertyBuildStage == 0) {
                this.relationshipWeightPropertyBuildStage = (byte)-1;
                this.relationshipWeightProperty = ImmutableShortestPathAStarWriteConfig.this.relationshipWeightPropertyInitialize();
                this.relationshipWeightPropertyBuildStage = 1;
            }
            return this.relationshipWeightProperty;
        }

        void relationshipWeightProperty(String relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty;
            this.relationshipWeightPropertyBuildStage = 1;
        }

        boolean hasRelationshipWeightProperty() {
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasRelationshipWeightPropertyBuildStage == 0) {
                this.hasRelationshipWeightPropertyBuildStage = (byte)-1;
                this.hasRelationshipWeightProperty = ImmutableShortestPathAStarWriteConfig.this.hasRelationshipWeightPropertyInitialize();
                this.hasRelationshipWeightPropertyBuildStage = 1;
            }
            return this.hasRelationshipWeightProperty;
        }

        boolean trackRelationships() {
            if (this.trackRelationshipsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.trackRelationshipsBuildStage == 0) {
                this.trackRelationshipsBuildStage = (byte)-1;
                this.trackRelationships = ImmutableShortestPathAStarWriteConfig.this.trackRelationshipsInitialize();
                this.trackRelationshipsBuildStage = 1;
            }
            return this.trackRelationships;
        }

        void trackRelationships(boolean trackRelationships) {
            this.trackRelationships = trackRelationships;
            this.trackRelationshipsBuildStage = 1;
        }

        int writeConcurrency() {
            if (this.writeConcurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.writeConcurrencyBuildStage == 0) {
                this.writeConcurrencyBuildStage = (byte)-1;
                this.writeConcurrency = ImmutableShortestPathAStarWriteConfig.this.writeConcurrencyInitialize();
                this.writeConcurrencyBuildStage = 1;
            }
            return this.writeConcurrency;
        }

        void writeConcurrency(int writeConcurrency) {
            this.writeConcurrency = writeConcurrency;
            this.writeConcurrencyBuildStage = 1;
        }

        boolean writeNodeIds() {
            if (this.writeNodeIdsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.writeNodeIdsBuildStage == 0) {
                this.writeNodeIdsBuildStage = (byte)-1;
                this.writeNodeIds = ImmutableShortestPathAStarWriteConfig.this.writeNodeIdsInitialize();
                this.writeNodeIdsBuildStage = 1;
            }
            return this.writeNodeIds;
        }

        void writeNodeIds(boolean writeNodeIds) {
            this.writeNodeIds = writeNodeIds;
            this.writeNodeIdsBuildStage = 1;
        }

        boolean writeCosts() {
            if (this.writeCostsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.writeCostsBuildStage == 0) {
                this.writeCostsBuildStage = (byte)-1;
                this.writeCosts = ImmutableShortestPathAStarWriteConfig.this.writeCostsInitialize();
                this.writeCostsBuildStage = 1;
            }
            return this.writeCosts;
        }

        void writeCosts(boolean writeCosts) {
            this.writeCosts = writeCosts;
            this.writeCostsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.usernameOverrideBuildStage == -1) {
                attributes.add("usernameOverride");
            }
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.minBatchSizeBuildStage == -1) {
                attributes.add("minBatchSize");
            }
            if (this.relationshipTypesBuildStage == -1) {
                attributes.add("relationshipTypes");
            }
            if (this.nodeLabelsBuildStage == -1) {
                attributes.add("nodeLabels");
            }
            if (this.relationshipWeightPropertyBuildStage == -1) {
                attributes.add("relationshipWeightProperty");
            }
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                attributes.add("hasRelationshipWeightProperty");
            }
            if (this.trackRelationshipsBuildStage == -1) {
                attributes.add("trackRelationships");
            }
            if (this.writeConcurrencyBuildStage == -1) {
                attributes.add("writeConcurrency");
            }
            if (this.writeNodeIdsBuildStage == -1) {
                attributes.add("writeNodeIds");
            }
            if (this.writeCostsBuildStage == -1) {
                attributes.add("writeCosts");
            }
            return "Cannot build ShortestPathAStarWriteConfig, attribute initializers form cycle " + attributes;
        }
    }
}

