/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.paths.astar.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.config.SourceNodeConfig;
import org.neo4j.gds.config.TargetNodeConfig;
import org.neo4j.gds.config.WriteRelationshipConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.paths.astar.config.ShortestPathAStarWriteConfig;

public final class ShortestPathAStarWriteConfigImpl
implements ShortestPathAStarWriteConfig {
    private String longitudeProperty;
    private String latitudeProperty;
    private List<String> relationshipTypes;
    private List<String> nodeLabels;
    @Nullable
    private String usernameOverride;
    private boolean sudo;
    private int concurrency;
    private long sourceNode;
    private long targetNode;
    @Nullable
    private String relationshipWeightProperty;
    private String writeRelationshipType;
    private int writeConcurrency;
    private boolean writeNodeIds;
    private boolean writeCosts;

    public ShortestPathAStarWriteConfigImpl(@NotNull CypherMapWrapper config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.longitudeProperty = (String)CypherMapWrapper.failOnNull((String)"longitudeProperty", (Object)config.requireString("longitudeProperty"));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.latitudeProperty = (String)CypherMapWrapper.failOnNull((String)"latitudeProperty", (Object)config.requireString("latitudeProperty"));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipTypes = (List)CypherMapWrapper.failOnNull((String)"relationshipTypes", (Object)((List)config.getChecked("relationshipTypes", (Object)ShortestPathAStarWriteConfig.super.relationshipTypes(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.nodeLabels = (List)CypherMapWrapper.failOnNull((String)"nodeLabels", (Object)((List)config.getChecked("nodeLabels", (Object)ShortestPathAStarWriteConfig.super.nodeLabels(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.usernameOverride = StringUtils.trimToNull((String)config.getString("username", ShortestPathAStarWriteConfig.super.usernameOverride()));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sudo = config.getBool("sudo", ShortestPathAStarWriteConfig.super.sudo());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.concurrency = config.getInt("concurrency", ShortestPathAStarWriteConfig.super.concurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sourceNode = SourceNodeConfig.parseSourceNodeId((Object)config.requireChecked("sourceNode", Object.class));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.targetNode = TargetNodeConfig.parseTargetNodeId((Object)config.requireChecked("targetNode", Object.class));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipWeightProperty = RelationshipWeightConfig.validatePropertyName((String)config.getString("relationshipWeightProperty", ShortestPathAStarWriteConfig.super.relationshipWeightProperty()));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.writeRelationshipType = (String)CypherMapWrapper.failOnNull((String)"writeRelationshipType", (Object)WriteRelationshipConfig.validatePropertyName((String)config.requireString("writeRelationshipType")));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.writeConcurrency = config.getInt("writeConcurrency", ShortestPathAStarWriteConfig.super.writeConcurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.writeNodeIds = config.getBool("writeNodeIds", ShortestPathAStarWriteConfig.super.writeNodeIds());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.writeCosts = config.getBool("writeCosts", ShortestPathAStarWriteConfig.super.writeCosts());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validateConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.validateWriteConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public String longitudeProperty() {
        return this.longitudeProperty;
    }

    @Override
    public String latitudeProperty() {
        return this.latitudeProperty;
    }

    public List<String> relationshipTypes() {
        return this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        return this.nodeLabels;
    }

    public void graphStoreValidation(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        this.relationshipWeightValidation(graphStore, selectedLabels, selectedRelationshipTypes);
    }

    @Nullable
    public String usernameOverride() {
        return this.usernameOverride;
    }

    public boolean sudo() {
        return this.sudo;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("longitudeProperty", "latitudeProperty", "relationshipTypes", "nodeLabels", "username", "sudo", "concurrency", "sourceNode", "targetNode", "relationshipWeightProperty", "writeRelationshipType", "writeConcurrency", "writeNodeIds", "writeCosts");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("longitudeProperty", this.longitudeProperty());
        map.put("latitudeProperty", this.latitudeProperty());
        map.put("relationshipTypes", this.relationshipTypes());
        map.put("nodeLabels", this.nodeLabels());
        map.put("username", this.usernameOverride());
        map.put("sudo", this.sudo());
        map.put("concurrency", this.concurrency());
        map.put("sourceNode", this.sourceNode());
        map.put("targetNode", this.targetNode());
        map.put("relationshipWeightProperty", this.relationshipWeightProperty());
        map.put("writeRelationshipType", this.writeRelationshipType());
        map.put("writeConcurrency", this.writeConcurrency());
        map.put("writeNodeIds", this.writeNodeIds());
        map.put("writeCosts", this.writeCosts());
        return map;
    }

    public int concurrency() {
        return this.concurrency;
    }

    public long sourceNode() {
        return this.sourceNode;
    }

    public long targetNode() {
        return this.targetNode;
    }

    @Nullable
    public String relationshipWeightProperty() {
        return this.relationshipWeightProperty;
    }

    public String writeRelationshipType() {
        return this.writeRelationshipType;
    }

    public int writeConcurrency() {
        return this.writeConcurrency;
    }

    @Override
    public boolean writeNodeIds() {
        return this.writeNodeIds;
    }

    @Override
    public boolean writeCosts() {
        return this.writeCosts;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();

        public Builder longitudeProperty(String longitudeProperty) {
            this.config.put("longitudeProperty", longitudeProperty);
            return this;
        }

        public Builder latitudeProperty(String latitudeProperty) {
            this.config.put("latitudeProperty", latitudeProperty);
            return this;
        }

        public Builder relationshipTypes(List<String> relationshipTypes) {
            this.config.put("relationshipTypes", relationshipTypes);
            return this;
        }

        public Builder nodeLabels(List<String> nodeLabels) {
            this.config.put("nodeLabels", nodeLabels);
            return this;
        }

        public Builder usernameOverride(String usernameOverride) {
            this.config.put("username", usernameOverride);
            return this;
        }

        public Builder sudo(boolean sudo) {
            this.config.put("sudo", sudo);
            return this;
        }

        public Builder concurrency(int concurrency) {
            this.config.put("concurrency", concurrency);
            return this;
        }

        public Builder sourceNode(Object sourceNode) {
            this.config.put("sourceNode", sourceNode);
            return this;
        }

        public Builder targetNode(Object targetNode) {
            this.config.put("targetNode", targetNode);
            return this;
        }

        public Builder relationshipWeightProperty(String relationshipWeightProperty) {
            this.config.put("relationshipWeightProperty", relationshipWeightProperty);
            return this;
        }

        public Builder writeRelationshipType(String writeRelationshipType) {
            this.config.put("writeRelationshipType", writeRelationshipType);
            return this;
        }

        public Builder writeConcurrency(int writeConcurrency) {
            this.config.put("writeConcurrency", writeConcurrency);
            return this;
        }

        public Builder writeNodeIds(boolean writeNodeIds) {
            this.config.put("writeNodeIds", writeNodeIds);
            return this;
        }

        public Builder writeCosts(boolean writeCosts) {
            this.config.put("writeCosts", writeCosts);
            return this;
        }

        public ShortestPathAStarWriteConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new ShortestPathAStarWriteConfigImpl(config);
        }
    }
}

