/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.paths.delta;

import java.util.Optional;
import org.neo4j.gds.core.utils.paged.DoublePageCreator;
import org.neo4j.gds.core.utils.paged.HugeAtomicDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeAtomicLongArray;
import org.neo4j.gds.core.utils.paged.LongPageCreator;

public interface TentativeDistances {
    public static final double DIST_INF = Double.MAX_VALUE;
    public static final long NO_PREDECESSOR = Long.MAX_VALUE;

    public double distance(long var1);

    public long predecessor(long var1);

    public void set(long var1, long var3, double var5);

    public double compareAndExchange(long var1, double var3, double var5, long var7);

    public HugeAtomicDoubleArray distances();

    public Optional<HugeAtomicLongArray> predecessors();

    public static DistanceOnly distanceOnly(long size, int concurrency) {
        HugeAtomicDoubleArray distances = HugeAtomicDoubleArray.newArray((long)size, (DoublePageCreator)DoublePageCreator.of((int)concurrency, index -> Double.MAX_VALUE));
        return new DistanceOnly(distances);
    }

    public static DistanceAndPredecessor distanceAndPredecessors(long size, int concurrency) {
        HugeAtomicDoubleArray distances = HugeAtomicDoubleArray.newArray((long)size, (DoublePageCreator)DoublePageCreator.of((int)concurrency, index -> Double.MAX_VALUE));
        HugeAtomicLongArray predecessors = HugeAtomicLongArray.newArray((long)size, (LongPageCreator)LongPageCreator.of((int)concurrency, index -> Long.MAX_VALUE));
        return new DistanceAndPredecessor(predecessors, distances);
    }

    public static class DistanceAndPredecessor
    implements TentativeDistances {
        private final HugeAtomicLongArray predecessors;
        private final HugeAtomicDoubleArray distances;

        public DistanceAndPredecessor(HugeAtomicLongArray predecessors, HugeAtomicDoubleArray distances) {
            this.predecessors = predecessors;
            this.distances = distances;
        }

        @Override
        public double distance(long nodeId) {
            return this.distances.get(nodeId);
        }

        @Override
        public long predecessor(long nodeId) {
            return this.predecessors.get(nodeId);
        }

        @Override
        public HugeAtomicDoubleArray distances() {
            return this.distances;
        }

        @Override
        public Optional<HugeAtomicLongArray> predecessors() {
            return Optional.of(this.predecessors);
        }

        @Override
        public void set(long nodeId, long predecessor, double distance) {
            this.distances.set(nodeId, distance);
            this.predecessors.set(nodeId, predecessor);
        }

        @Override
        public double compareAndExchange(long nodeId, double expectedDistance, double newDistance, long predecessor) {
            long currentPredecessor = this.predecessors.get(nodeId);
            if (currentPredecessor < 0L) {
                return this.distances.get(nodeId);
            }
            long witness = this.predecessors.compareAndExchange(nodeId, currentPredecessor, -predecessor - 1L);
            if (witness != currentPredecessor) {
                return this.distances.get(nodeId);
            }
            this.distances.set(nodeId, newDistance);
            this.predecessors.set(nodeId, predecessor);
            return expectedDistance;
        }
    }

    public static class DistanceOnly
    implements TentativeDistances {
        private final HugeAtomicDoubleArray distances;

        public DistanceOnly(HugeAtomicDoubleArray distances) {
            this.distances = distances;
        }

        @Override
        public double distance(long nodeId) {
            return this.distances.get(nodeId);
        }

        @Override
        public long predecessor(long nodeId) {
            return Long.MAX_VALUE;
        }

        @Override
        public void set(long nodeId, long predecessor, double distance) {
            this.distances.set(nodeId, distance);
        }

        @Override
        public double compareAndExchange(long nodeId, double expectedDistance, double newDistance, long predecessor) {
            return this.distances.compareAndExchange(nodeId, expectedDistance, newDistance);
        }

        @Override
        public HugeAtomicDoubleArray distances() {
            return this.distances;
        }

        @Override
        public Optional<HugeAtomicLongArray> predecessors() {
            return Optional.empty();
        }
    }
}

