/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.paths.delta.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.config.SourceNodeConfig;
import org.neo4j.gds.paths.TrackRelationshipsConfig;
import org.neo4j.gds.paths.delta.config.AllShortestPathsDeltaBaseConfig;

@Generated(from="AllShortestPathsDeltaBaseConfig", generator="Immutables")
public final class ImmutableAllShortestPathsDeltaBaseConfig
implements AllShortestPathsDeltaBaseConfig {
    @Nullable
    private final String usernameOverride;
    private final boolean sudo;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    private final int concurrency;
    private final int minBatchSize;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    private final long sourceNode;
    @Nullable
    private final String relationshipWeightProperty;
    private final transient boolean hasRelationshipWeightProperty;
    private final boolean trackRelationships;
    private final double delta;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableAllShortestPathsDeltaBaseConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, long sourceNode, @Nullable String relationshipWeightProperty, boolean trackRelationships, double delta) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableAllShortestPathsDeltaBaseConfig.createUnmodifiableList(false, ImmutableAllShortestPathsDeltaBaseConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableAllShortestPathsDeltaBaseConfig.createUnmodifiableList(false, ImmutableAllShortestPathsDeltaBaseConfig.createSafeList(nodeLabels, true, false)));
        this.sourceNode = sourceNode;
        this.initShim.relationshipWeightProperty(relationshipWeightProperty);
        this.initShim.trackRelationships(trackRelationships);
        this.initShim.delta(delta);
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.trackRelationships = this.initShim.trackRelationships();
        this.delta = this.initShim.delta();
        this.initShim = null;
    }

    private ImmutableAllShortestPathsDeltaBaseConfig(Builder builder) {
        this.sourceNode = builder.sourceNode;
        if (builder.usernameOverrideIsSet()) {
            this.initShim.usernameOverride(builder.usernameOverride);
        }
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.minBatchSizeIsSet()) {
            this.initShim.minBatchSize(builder.minBatchSize);
        }
        if (builder.relationshipTypesIsSet()) {
            this.initShim.relationshipTypes(builder.relationshipTypes == null ? Collections.emptyList() : ImmutableAllShortestPathsDeltaBaseConfig.createUnmodifiableList(true, builder.relationshipTypes));
        }
        if (builder.nodeLabelsIsSet()) {
            this.initShim.nodeLabels(builder.nodeLabels == null ? Collections.emptyList() : ImmutableAllShortestPathsDeltaBaseConfig.createUnmodifiableList(true, builder.nodeLabels));
        }
        if (builder.relationshipWeightPropertyIsSet()) {
            this.initShim.relationshipWeightProperty(builder.relationshipWeightProperty);
        }
        if (builder.trackRelationshipsIsSet()) {
            this.initShim.trackRelationships(builder.trackRelationships);
        }
        if (builder.deltaIsSet()) {
            this.initShim.delta(builder.delta);
        }
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.trackRelationships = this.initShim.trackRelationships();
        this.delta = this.initShim.delta();
        this.initShim = null;
    }

    private ImmutableAllShortestPathsDeltaBaseConfig(@Nullable String usernameOverride, boolean sudo, Collection<String> configKeys, int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, long sourceNode, @Nullable String relationshipWeightProperty, boolean trackRelationships, double delta) {
        this.initShim.usernameOverride(usernameOverride);
        this.initShim.sudo(sudo);
        this.initShim.configKeys(configKeys);
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(relationshipTypes);
        this.initShim.nodeLabels(nodeLabels);
        this.sourceNode = sourceNode;
        this.initShim.relationshipWeightProperty(relationshipWeightProperty);
        this.initShim.trackRelationships(trackRelationships);
        this.initShim.delta(delta);
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.trackRelationships = this.initShim.trackRelationships();
        this.delta = this.initShim.delta();
        this.initShim = null;
    }

    @Nullable
    private String usernameOverrideInitialize() {
        return AllShortestPathsDeltaBaseConfig.super.usernameOverride();
    }

    private boolean sudoInitialize() {
        return AllShortestPathsDeltaBaseConfig.super.sudo();
    }

    private Collection<String> configKeysInitialize() {
        return AllShortestPathsDeltaBaseConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return AllShortestPathsDeltaBaseConfig.super.toMap();
    }

    private int concurrencyInitialize() {
        return AllShortestPathsDeltaBaseConfig.super.concurrency();
    }

    private int minBatchSizeInitialize() {
        return AllShortestPathsDeltaBaseConfig.super.minBatchSize();
    }

    private List<String> relationshipTypesInitialize() {
        return AllShortestPathsDeltaBaseConfig.super.relationshipTypes();
    }

    private List<String> nodeLabelsInitialize() {
        return AllShortestPathsDeltaBaseConfig.super.nodeLabels();
    }

    @Nullable
    private String relationshipWeightPropertyInitialize() {
        return AllShortestPathsDeltaBaseConfig.super.relationshipWeightProperty();
    }

    private boolean hasRelationshipWeightPropertyInitialize() {
        return AllShortestPathsDeltaBaseConfig.super.hasRelationshipWeightProperty();
    }

    private boolean trackRelationshipsInitialize() {
        return AllShortestPathsDeltaBaseConfig.super.trackRelationships();
    }

    private double deltaInitialize() {
        return AllShortestPathsDeltaBaseConfig.super.delta();
    }

    @Nullable
    public String usernameOverride() {
        InitShim shim = this.initShim;
        return shim != null ? shim.usernameOverride() : this.usernameOverride;
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    public int minBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minBatchSize() : this.minBatchSize;
    }

    public List<String> relationshipTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipTypes() : this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeLabels() : this.nodeLabels;
    }

    public long sourceNode() {
        return this.sourceNode;
    }

    @Nullable
    public String relationshipWeightProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipWeightProperty() : this.relationshipWeightProperty;
    }

    public boolean hasRelationshipWeightProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasRelationshipWeightProperty() : this.hasRelationshipWeightProperty;
    }

    @Override
    public boolean trackRelationships() {
        InitShim shim = this.initShim;
        return shim != null ? shim.trackRelationships() : this.trackRelationships;
    }

    @Override
    public double delta() {
        InitShim shim = this.initShim;
        return shim != null ? shim.delta() : this.delta;
    }

    public final ImmutableAllShortestPathsDeltaBaseConfig withUsernameOverride(@Nullable String value) {
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return ImmutableAllShortestPathsDeltaBaseConfig.validate(new ImmutableAllShortestPathsDeltaBaseConfig(value, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.relationshipWeightProperty, this.trackRelationships, this.delta));
    }

    public final ImmutableAllShortestPathsDeltaBaseConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutableAllShortestPathsDeltaBaseConfig.validate(new ImmutableAllShortestPathsDeltaBaseConfig(this.usernameOverride, value, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.relationshipWeightProperty, this.trackRelationships, this.delta));
    }

    public final ImmutableAllShortestPathsDeltaBaseConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutableAllShortestPathsDeltaBaseConfig.validate(new ImmutableAllShortestPathsDeltaBaseConfig(this.usernameOverride, this.sudo, newValue, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.relationshipWeightProperty, this.trackRelationships, this.delta));
    }

    public final ImmutableAllShortestPathsDeltaBaseConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutableAllShortestPathsDeltaBaseConfig.validate(new ImmutableAllShortestPathsDeltaBaseConfig(this.usernameOverride, this.sudo, this.configKeys, value, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.relationshipWeightProperty, this.trackRelationships, this.delta));
    }

    public final ImmutableAllShortestPathsDeltaBaseConfig withMinBatchSize(int value) {
        if (this.minBatchSize == value) {
            return this;
        }
        return ImmutableAllShortestPathsDeltaBaseConfig.validate(new ImmutableAllShortestPathsDeltaBaseConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, value, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.relationshipWeightProperty, this.trackRelationships, this.delta));
    }

    public final ImmutableAllShortestPathsDeltaBaseConfig withRelationshipTypes(String ... elements) {
        List<String> newValue = ImmutableAllShortestPathsDeltaBaseConfig.createUnmodifiableList(false, ImmutableAllShortestPathsDeltaBaseConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableAllShortestPathsDeltaBaseConfig.validate(new ImmutableAllShortestPathsDeltaBaseConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.nodeLabels, this.sourceNode, this.relationshipWeightProperty, this.trackRelationships, this.delta));
    }

    public final ImmutableAllShortestPathsDeltaBaseConfig withRelationshipTypes(Iterable<String> elements) {
        if (this.relationshipTypes == elements) {
            return this;
        }
        List<String> newValue = ImmutableAllShortestPathsDeltaBaseConfig.createUnmodifiableList(false, ImmutableAllShortestPathsDeltaBaseConfig.createSafeList(elements, true, false));
        return ImmutableAllShortestPathsDeltaBaseConfig.validate(new ImmutableAllShortestPathsDeltaBaseConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.nodeLabels, this.sourceNode, this.relationshipWeightProperty, this.trackRelationships, this.delta));
    }

    public final ImmutableAllShortestPathsDeltaBaseConfig withNodeLabels(String ... elements) {
        List<String> newValue = ImmutableAllShortestPathsDeltaBaseConfig.createUnmodifiableList(false, ImmutableAllShortestPathsDeltaBaseConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableAllShortestPathsDeltaBaseConfig.validate(new ImmutableAllShortestPathsDeltaBaseConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, newValue, this.sourceNode, this.relationshipWeightProperty, this.trackRelationships, this.delta));
    }

    public final ImmutableAllShortestPathsDeltaBaseConfig withNodeLabels(Iterable<String> elements) {
        if (this.nodeLabels == elements) {
            return this;
        }
        List<String> newValue = ImmutableAllShortestPathsDeltaBaseConfig.createUnmodifiableList(false, ImmutableAllShortestPathsDeltaBaseConfig.createSafeList(elements, true, false));
        return ImmutableAllShortestPathsDeltaBaseConfig.validate(new ImmutableAllShortestPathsDeltaBaseConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, newValue, this.sourceNode, this.relationshipWeightProperty, this.trackRelationships, this.delta));
    }

    public final ImmutableAllShortestPathsDeltaBaseConfig withSourceNode(long value) {
        if (this.sourceNode == value) {
            return this;
        }
        return ImmutableAllShortestPathsDeltaBaseConfig.validate(new ImmutableAllShortestPathsDeltaBaseConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, value, this.relationshipWeightProperty, this.trackRelationships, this.delta));
    }

    public final ImmutableAllShortestPathsDeltaBaseConfig withRelationshipWeightProperty(@Nullable String value) {
        if (Objects.equals(this.relationshipWeightProperty, value)) {
            return this;
        }
        return ImmutableAllShortestPathsDeltaBaseConfig.validate(new ImmutableAllShortestPathsDeltaBaseConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.sourceNode, value, this.trackRelationships, this.delta));
    }

    public final ImmutableAllShortestPathsDeltaBaseConfig withTrackRelationships(boolean value) {
        if (this.trackRelationships == value) {
            return this;
        }
        return ImmutableAllShortestPathsDeltaBaseConfig.validate(new ImmutableAllShortestPathsDeltaBaseConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.relationshipWeightProperty, value, this.delta));
    }

    public final ImmutableAllShortestPathsDeltaBaseConfig withDelta(double value) {
        if (Double.doubleToLongBits(this.delta) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutableAllShortestPathsDeltaBaseConfig.validate(new ImmutableAllShortestPathsDeltaBaseConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.relationshipWeightProperty, this.trackRelationships, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAllShortestPathsDeltaBaseConfig && this.equalTo((ImmutableAllShortestPathsDeltaBaseConfig)another);
    }

    private boolean equalTo(ImmutableAllShortestPathsDeltaBaseConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && this.concurrency == another.concurrency && this.minBatchSize == another.minBatchSize && this.relationshipTypes.equals(another.relationshipTypes) && this.nodeLabels.equals(another.nodeLabels) && this.sourceNode == another.sourceNode && Objects.equals(this.relationshipWeightProperty, another.relationshipWeightProperty) && this.hasRelationshipWeightProperty == another.hasRelationshipWeightProperty && this.trackRelationships == another.trackRelationships && Double.doubleToLongBits(this.delta) == Double.doubleToLongBits(another.delta);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + this.concurrency;
        h += (h << 5) + this.minBatchSize;
        h += (h << 5) + this.relationshipTypes.hashCode();
        h += (h << 5) + this.nodeLabels.hashCode();
        h += (h << 5) + Long.hashCode(this.sourceNode);
        h += (h << 5) + Objects.hashCode(this.relationshipWeightProperty);
        h += (h << 5) + Boolean.hashCode(this.hasRelationshipWeightProperty);
        h += (h << 5) + Boolean.hashCode(this.trackRelationships);
        h += (h << 5) + Double.hashCode(this.delta);
        return h;
    }

    public String toString() {
        return "AllShortestPathsDeltaBaseConfig{usernameOverride=" + this.usernameOverride + ", sudo=" + this.sudo + ", concurrency=" + this.concurrency + ", minBatchSize=" + this.minBatchSize + ", relationshipTypes=" + this.relationshipTypes + ", nodeLabels=" + this.nodeLabels + ", sourceNode=" + this.sourceNode + ", relationshipWeightProperty=" + this.relationshipWeightProperty + ", hasRelationshipWeightProperty=" + this.hasRelationshipWeightProperty + ", trackRelationships=" + this.trackRelationships + ", delta=" + this.delta + "}";
    }

    public static AllShortestPathsDeltaBaseConfig of(int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, long sourceNode, @Nullable String relationshipWeightProperty, boolean trackRelationships, double delta) {
        return ImmutableAllShortestPathsDeltaBaseConfig.of(concurrency, minBatchSize, relationshipTypes, nodeLabels, sourceNode, relationshipWeightProperty, trackRelationships, delta);
    }

    public static AllShortestPathsDeltaBaseConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, long sourceNode, @Nullable String relationshipWeightProperty, boolean trackRelationships, double delta) {
        return ImmutableAllShortestPathsDeltaBaseConfig.validate(new ImmutableAllShortestPathsDeltaBaseConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, sourceNode, relationshipWeightProperty, trackRelationships, delta));
    }

    private static ImmutableAllShortestPathsDeltaBaseConfig validate(ImmutableAllShortestPathsDeltaBaseConfig instance) {
        instance.validateConcurrency();
        return instance;
    }

    public static AllShortestPathsDeltaBaseConfig copyOf(AllShortestPathsDeltaBaseConfig instance) {
        if (instance instanceof ImmutableAllShortestPathsDeltaBaseConfig) {
            return (ImmutableAllShortestPathsDeltaBaseConfig)instance;
        }
        return ImmutableAllShortestPathsDeltaBaseConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="AllShortestPathsDeltaBaseConfig", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_SOURCE_NODE = 1L;
        private static final long OPT_BIT_USERNAME_OVERRIDE = 1L;
        private static final long OPT_BIT_SUDO = 2L;
        private static final long OPT_BIT_CONCURRENCY = 4L;
        private static final long OPT_BIT_MIN_BATCH_SIZE = 8L;
        private static final long OPT_BIT_RELATIONSHIP_TYPES = 16L;
        private static final long OPT_BIT_NODE_LABELS = 32L;
        private static final long OPT_BIT_RELATIONSHIP_WEIGHT_PROPERTY = 64L;
        private static final long OPT_BIT_TRACK_RELATIONSHIPS = 128L;
        private static final long OPT_BIT_DELTA = 256L;
        private long initBits = 1L;
        private long optBits;
        private String usernameOverride;
        private boolean sudo;
        private Collection<String> configKeys;
        private int concurrency;
        private int minBatchSize;
        private List<String> relationshipTypes = null;
        private List<String> nodeLabels = null;
        private long sourceNode;
        private String relationshipWeightProperty;
        private boolean trackRelationships;
        private double delta;

        private Builder() {
        }

        public final Builder from(RelationshipWeightConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AllShortestPathsDeltaBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SourceNodeConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ConcurrencyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TrackRelationshipsConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AlgoBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            String relationshipWeightPropertyValue;
            if (object instanceof RelationshipWeightConfig && (relationshipWeightPropertyValue = (instance = (RelationshipWeightConfig)object).relationshipWeightProperty()) != null) {
                this.relationshipWeightProperty(relationshipWeightPropertyValue);
            }
            if (object instanceof AllShortestPathsDeltaBaseConfig) {
                instance = (AllShortestPathsDeltaBaseConfig)object;
                this.delta(instance.delta());
            }
            if (object instanceof SourceNodeConfig) {
                instance = (SourceNodeConfig)object;
                this.sourceNode(instance.sourceNode());
            }
            if (object instanceof ConcurrencyConfig) {
                instance = (ConcurrencyConfig)object;
                this.minBatchSize(instance.minBatchSize());
                this.concurrency(instance.concurrency());
            }
            if (object instanceof TrackRelationshipsConfig) {
                instance = (TrackRelationshipsConfig)object;
                this.trackRelationships(instance.trackRelationships());
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                @Nullable String usernameOverrideValue = instance.usernameOverride();
                if (usernameOverrideValue != null) {
                    this.usernameOverride(usernameOverrideValue);
                }
                this.configKeys(instance.configKeys());
                this.sudo(instance.sudo());
            }
            if (object instanceof AlgoBaseConfig) {
                instance = (AlgoBaseConfig)object;
                this.addAllRelationshipTypes(instance.relationshipTypes());
                this.addAllNodeLabels(instance.nodeLabels());
            }
        }

        public final Builder usernameOverride(@Nullable String usernameOverride) {
            this.usernameOverride = usernameOverride;
            this.optBits |= 1L;
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 2L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 4L;
            return this;
        }

        public final Builder minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.optBits |= 8L;
            return this;
        }

        public final Builder addRelationshipType(String element) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addRelationshipTypes(String ... elements) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder relationshipTypes(Iterable<String> elements) {
            this.relationshipTypes = new ArrayList<String>();
            return this.addAllRelationshipTypes(elements);
        }

        public final Builder addAllRelationshipTypes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "relationshipTypes element");
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addNodeLabel(String element) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder addNodeLabels(String ... elements) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder nodeLabels(Iterable<String> elements) {
            this.nodeLabels = new ArrayList<String>();
            return this.addAllNodeLabels(elements);
        }

        public final Builder addAllNodeLabels(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeLabels element");
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder sourceNode(long sourceNode) {
            this.sourceNode = sourceNode;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder relationshipWeightProperty(@Nullable String relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder trackRelationships(boolean trackRelationships) {
            this.trackRelationships = trackRelationships;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder delta(double delta) {
            this.delta = delta;
            this.optBits |= 0x100L;
            return this;
        }

        public Builder clear() {
            this.initBits = 1L;
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.configKeys = null;
            this.concurrency = 0;
            this.minBatchSize = 0;
            if (this.relationshipTypes != null) {
                this.relationshipTypes.clear();
            }
            if (this.nodeLabels != null) {
                this.nodeLabels.clear();
            }
            this.sourceNode = 0L;
            this.relationshipWeightProperty = null;
            this.trackRelationships = false;
            this.delta = 0.0;
            return this;
        }

        public AllShortestPathsDeltaBaseConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableAllShortestPathsDeltaBaseConfig.validate(new ImmutableAllShortestPathsDeltaBaseConfig(this));
        }

        private boolean usernameOverrideIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean sudoIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean minBatchSizeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean relationshipTypesIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean nodeLabelsIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean relationshipWeightPropertyIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean trackRelationshipsIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean deltaIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sourceNode");
            }
            return "Cannot build AllShortestPathsDeltaBaseConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="AllShortestPathsDeltaBaseConfig", generator="Immutables")
    private final class InitShim {
        private byte usernameOverrideBuildStage = 0;
        private String usernameOverride;
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte concurrencyBuildStage = 0;
        private int concurrency;
        private byte minBatchSizeBuildStage = 0;
        private int minBatchSize;
        private byte relationshipTypesBuildStage = 0;
        private List<String> relationshipTypes;
        private byte nodeLabelsBuildStage = 0;
        private List<String> nodeLabels;
        private byte relationshipWeightPropertyBuildStage = 0;
        private String relationshipWeightProperty;
        private byte hasRelationshipWeightPropertyBuildStage = 0;
        private boolean hasRelationshipWeightProperty;
        private byte trackRelationshipsBuildStage = 0;
        private boolean trackRelationships;
        private byte deltaBuildStage = 0;
        private double delta;

        private InitShim() {
        }

        String usernameOverride() {
            if (this.usernameOverrideBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usernameOverrideBuildStage == 0) {
                this.usernameOverrideBuildStage = (byte)-1;
                this.usernameOverride = ImmutableAllShortestPathsDeltaBaseConfig.this.usernameOverrideInitialize();
                this.usernameOverrideBuildStage = 1;
            }
            return this.usernameOverride;
        }

        void usernameOverride(String usernameOverride) {
            this.usernameOverride = usernameOverride;
            this.usernameOverrideBuildStage = 1;
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableAllShortestPathsDeltaBaseConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableAllShortestPathsDeltaBaseConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableAllShortestPathsDeltaBaseConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutableAllShortestPathsDeltaBaseConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        int minBatchSize() {
            if (this.minBatchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minBatchSizeBuildStage == 0) {
                this.minBatchSizeBuildStage = (byte)-1;
                this.minBatchSize = ImmutableAllShortestPathsDeltaBaseConfig.this.minBatchSizeInitialize();
                this.minBatchSizeBuildStage = 1;
            }
            return this.minBatchSize;
        }

        void minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.minBatchSizeBuildStage = 1;
        }

        List<String> relationshipTypes() {
            if (this.relationshipTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipTypesBuildStage == 0) {
                this.relationshipTypesBuildStage = (byte)-1;
                this.relationshipTypes = ImmutableAllShortestPathsDeltaBaseConfig.createUnmodifiableList(false, ImmutableAllShortestPathsDeltaBaseConfig.createSafeList(ImmutableAllShortestPathsDeltaBaseConfig.this.relationshipTypesInitialize(), true, false));
                this.relationshipTypesBuildStage = 1;
            }
            return this.relationshipTypes;
        }

        void relationshipTypes(List<String> relationshipTypes) {
            this.relationshipTypes = relationshipTypes;
            this.relationshipTypesBuildStage = 1;
        }

        List<String> nodeLabels() {
            if (this.nodeLabelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeLabelsBuildStage == 0) {
                this.nodeLabelsBuildStage = (byte)-1;
                this.nodeLabels = ImmutableAllShortestPathsDeltaBaseConfig.createUnmodifiableList(false, ImmutableAllShortestPathsDeltaBaseConfig.createSafeList(ImmutableAllShortestPathsDeltaBaseConfig.this.nodeLabelsInitialize(), true, false));
                this.nodeLabelsBuildStage = 1;
            }
            return this.nodeLabels;
        }

        void nodeLabels(List<String> nodeLabels) {
            this.nodeLabels = nodeLabels;
            this.nodeLabelsBuildStage = 1;
        }

        String relationshipWeightProperty() {
            if (this.relationshipWeightPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipWeightPropertyBuildStage == 0) {
                this.relationshipWeightPropertyBuildStage = (byte)-1;
                this.relationshipWeightProperty = ImmutableAllShortestPathsDeltaBaseConfig.this.relationshipWeightPropertyInitialize();
                this.relationshipWeightPropertyBuildStage = 1;
            }
            return this.relationshipWeightProperty;
        }

        void relationshipWeightProperty(String relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty;
            this.relationshipWeightPropertyBuildStage = 1;
        }

        boolean hasRelationshipWeightProperty() {
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasRelationshipWeightPropertyBuildStage == 0) {
                this.hasRelationshipWeightPropertyBuildStage = (byte)-1;
                this.hasRelationshipWeightProperty = ImmutableAllShortestPathsDeltaBaseConfig.this.hasRelationshipWeightPropertyInitialize();
                this.hasRelationshipWeightPropertyBuildStage = 1;
            }
            return this.hasRelationshipWeightProperty;
        }

        boolean trackRelationships() {
            if (this.trackRelationshipsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.trackRelationshipsBuildStage == 0) {
                this.trackRelationshipsBuildStage = (byte)-1;
                this.trackRelationships = ImmutableAllShortestPathsDeltaBaseConfig.this.trackRelationshipsInitialize();
                this.trackRelationshipsBuildStage = 1;
            }
            return this.trackRelationships;
        }

        void trackRelationships(boolean trackRelationships) {
            this.trackRelationships = trackRelationships;
            this.trackRelationshipsBuildStage = 1;
        }

        double delta() {
            if (this.deltaBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.deltaBuildStage == 0) {
                this.deltaBuildStage = (byte)-1;
                this.delta = ImmutableAllShortestPathsDeltaBaseConfig.this.deltaInitialize();
                this.deltaBuildStage = 1;
            }
            return this.delta;
        }

        void delta(double delta) {
            this.delta = delta;
            this.deltaBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.usernameOverrideBuildStage == -1) {
                attributes.add("usernameOverride");
            }
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.minBatchSizeBuildStage == -1) {
                attributes.add("minBatchSize");
            }
            if (this.relationshipTypesBuildStage == -1) {
                attributes.add("relationshipTypes");
            }
            if (this.nodeLabelsBuildStage == -1) {
                attributes.add("nodeLabels");
            }
            if (this.relationshipWeightPropertyBuildStage == -1) {
                attributes.add("relationshipWeightProperty");
            }
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                attributes.add("hasRelationshipWeightProperty");
            }
            if (this.trackRelationshipsBuildStage == -1) {
                attributes.add("trackRelationships");
            }
            if (this.deltaBuildStage == -1) {
                attributes.add("delta");
            }
            return "Cannot build AllShortestPathsDeltaBaseConfig, attribute initializers form cycle " + attributes;
        }
    }
}

