/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.paths.traverse;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.paged.HugeAtomicBitSet;
import org.neo4j.gds.core.utils.paged.HugeAtomicLongArray;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.paged.LongPageCreator;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.paths.traverse.Aggregator;
import org.neo4j.gds.paths.traverse.BFSTask;
import org.neo4j.gds.paths.traverse.ExitPredicate;

public final class BFS
extends Algorithm<HugeLongArray> {
    private static final int DEFAULT_DELTA = 64;
    public static final int ALL_DEPTHS_ALLOWED = -1;
    private final long sourceNodeId;
    private final ExitPredicate exitPredicate;
    private final Aggregator aggregatorFunction;
    private final Graph graph;
    private final int delta;
    private final long maximumDepth;
    private HugeLongArray traversedNodes;
    private HugeDoubleArray weights;
    private HugeAtomicBitSet visited;
    private final int concurrency;

    public static BFS create(Graph graph, long startNodeId, ExitPredicate exitPredicate, Aggregator aggregatorFunction, int concurrency, ProgressTracker progressTracker, long maximumDepth) {
        return BFS.create(graph, startNodeId, exitPredicate, aggregatorFunction, concurrency, progressTracker, 64, maximumDepth);
    }

    static BFS create(Graph graph, long startNodeId, ExitPredicate exitPredicate, Aggregator aggregatorFunction, int concurrency, ProgressTracker progressTracker, int delta, long maximumDepth) {
        long nodeCount = graph.nodeCount();
        HugeLongArray traversedNodes = HugeLongArray.newArray((long)nodeCount);
        HugeDoubleArray weights = HugeDoubleArray.newArray((long)nodeCount);
        HugeAtomicBitSet visited = HugeAtomicBitSet.create((long)nodeCount);
        return new BFS(graph, startNodeId, traversedNodes, weights, visited, exitPredicate, aggregatorFunction, concurrency, progressTracker, delta, maximumDepth);
    }

    private BFS(Graph graph, long sourceNodeId, HugeLongArray traversedNodes, HugeDoubleArray weights, HugeAtomicBitSet visited, ExitPredicate exitPredicate, Aggregator aggregatorFunction, int concurrency, ProgressTracker progressTracker, int delta, long maximumDepth) {
        super(progressTracker);
        this.graph = graph;
        this.sourceNodeId = sourceNodeId;
        this.exitPredicate = exitPredicate;
        this.aggregatorFunction = aggregatorFunction;
        this.concurrency = concurrency;
        this.delta = delta;
        this.maximumDepth = maximumDepth;
        this.traversedNodes = traversedNodes;
        this.weights = weights;
        this.visited = visited;
    }

    public HugeLongArray compute() {
        this.progressTracker.beginSubTask(this.graph.relationshipCount());
        AtomicLong traversedNodesIndex = new AtomicLong(0L);
        AtomicLong traversedNodesLength = new AtomicLong(1L);
        AtomicLong targetFoundIndex = new AtomicLong(Long.MAX_VALUE);
        HugeAtomicLongArray minimumChunk = HugeAtomicLongArray.newArray((long)this.graph.nodeCount(), (LongPageCreator)LongPageCreator.of((int)this.concurrency, l -> Long.MAX_VALUE));
        this.visited.set(this.sourceNodeId);
        this.traversedNodes.set(0L, this.sourceNodeId);
        this.weights.set(0L, 0.0);
        List<BFSTask> bfsTaskList = this.initializeBfsTasks(traversedNodesIndex, traversedNodesLength, targetFoundIndex, minimumChunk, this.delta);
        int bfsTaskListSize = bfsTaskList.size();
        for (long currentDepth = 0L; this.running() && currentDepth != this.maximumDepth; ++currentDepth) {
            ParallelUtil.run(bfsTaskList, (ExecutorService)Pools.DEFAULT);
            if (targetFoundIndex.get() != Long.MAX_VALUE) break;
            long previousTraversedNodesLength = traversedNodesLength.get();
            int numberOfFinishedTasks = 0;
            int numberOfTasksWithChunks = this.countTasksWithChunks(bfsTaskList);
            while (numberOfFinishedTasks != numberOfTasksWithChunks && this.running()) {
                int minimumTaskIndex = -1;
                for (int bfsTaskIndex = 0; bfsTaskIndex < bfsTaskListSize; ++bfsTaskIndex) {
                    BFSTask currentBfsTask = bfsTaskList.get(bfsTaskIndex);
                    if (!currentBfsTask.hasMoreChunks()) continue;
                    if (minimumTaskIndex == -1) {
                        minimumTaskIndex = bfsTaskIndex;
                        continue;
                    }
                    if (bfsTaskList.get(minimumTaskIndex).currentChunkId() <= currentBfsTask.currentChunkId()) continue;
                    minimumTaskIndex = bfsTaskIndex;
                }
                BFSTask minimumIndexBfsTask = bfsTaskList.get(minimumTaskIndex);
                minimumIndexBfsTask.syncNextChunk();
                if (minimumIndexBfsTask.hasMoreChunks()) continue;
                ++numberOfFinishedTasks;
            }
            if (traversedNodesLength.get() == previousTraversedNodesLength) break;
            traversedNodesIndex.set(previousTraversedNodesLength);
        }
        long nodesLengthToRetain = traversedNodesLength.get();
        if (targetFoundIndex.get() != Long.MAX_VALUE) {
            nodesLengthToRetain = targetFoundIndex.longValue() + 1L;
        }
        HugeLongArray result = this.traversedNodes.copyOf(nodesLengthToRetain);
        this.progressTracker.endSubTask();
        return result;
    }

    private List<BFSTask> initializeBfsTasks(AtomicLong traversedNodesIndex, AtomicLong traversedNodesLength, AtomicLong targetFoundIndex, HugeAtomicLongArray minimumChunk, int delta) {
        ArrayList<BFSTask> bfsTaskList = new ArrayList<BFSTask>(this.concurrency);
        for (int i = 0; i < this.concurrency; ++i) {
            bfsTaskList.add(new BFSTask(this.graph, this.traversedNodes, traversedNodesIndex, traversedNodesLength, this.visited, this.weights, targetFoundIndex, minimumChunk, this.exitPredicate, this.aggregatorFunction, delta, this.sourceNodeId, this.terminationFlag, this.progressTracker));
        }
        return bfsTaskList;
    }

    public void release() {
        this.traversedNodes = null;
        this.weights = null;
        this.visited = null;
    }

    private int countTasksWithChunks(Collection<BFSTask> bfsTaskList) {
        return (int)bfsTaskList.stream().filter(BFSTask::hasMoreChunks).count();
    }
}

