/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.paths.traverse;

import com.carrotsearch.hppc.LongArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.utils.TerminationFlag;
import org.neo4j.gds.core.utils.paged.HugeAtomicBitSet;
import org.neo4j.gds.core.utils.paged.HugeAtomicLongArray;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.paths.traverse.Aggregator;
import org.neo4j.gds.paths.traverse.ExitPredicate;

class BFSTask
implements Runnable {
    private static final int CHUNK_SEPARATOR = -1;
    private final Graph graph;
    private final AtomicLong traversedNodesIndex;
    private final HugeAtomicBitSet visited;
    private final HugeLongArray traversedNodes;
    private final HugeDoubleArray weights;
    private final AtomicLong targetFoundIndex;
    private final AtomicLong traversedNodesLength;
    private final HugeAtomicLongArray minimumChunk;
    private final ExitPredicate exitPredicate;
    private final Aggregator aggregatorFunction;
    private final long sourceNodeId;
    private final LongArrayList localNodes;
    private final LongArrayList chunks;
    private final int delta;
    private final TerminationFlag terminationFlag;
    private int indexOfChunk;
    private int indexOfLocalNodes;
    private final ProgressTracker progressTracker;

    BFSTask(Graph graph, HugeLongArray traversedNodes, AtomicLong traversedNodesIndex, AtomicLong traversedNodesLength, HugeAtomicBitSet visited, HugeDoubleArray weights, AtomicLong targetFoundIndex, HugeAtomicLongArray minimumChunk, ExitPredicate exitPredicate, Aggregator aggregatorFunction, int delta, long sourceNodeId, TerminationFlag terminationFlag, ProgressTracker progressTracker) {
        this.graph = graph.concurrentCopy();
        this.traversedNodesIndex = traversedNodesIndex;
        this.traversedNodesLength = traversedNodesLength;
        this.visited = visited;
        this.traversedNodes = traversedNodes;
        this.weights = weights;
        this.targetFoundIndex = targetFoundIndex;
        this.minimumChunk = minimumChunk;
        this.exitPredicate = exitPredicate;
        this.aggregatorFunction = aggregatorFunction;
        this.delta = delta;
        this.sourceNodeId = sourceNodeId;
        this.terminationFlag = terminationFlag;
        this.progressTracker = progressTracker;
        this.localNodes = new LongArrayList();
        this.chunks = new LongArrayList();
    }

    long currentChunkId() {
        return this.chunks.get(this.indexOfChunk);
    }

    private void moveToNextChunk() {
        ++this.indexOfChunk;
    }

    boolean hasMoreChunks() {
        return this.indexOfChunk < this.chunks.size();
    }

    @Override
    public void run() {
        long offset;
        this.resetChunks();
        long examined = 0L;
        while ((offset = this.traversedNodesIndex.getAndAdd(this.delta)) < this.traversedNodesLength.get()) {
            long chunkLimit = Math.min(offset + (long)this.delta, this.traversedNodesLength.get());
            this.chunks.add(offset);
            for (long idx = offset; idx < chunkLimit; ++idx) {
                long nodeId = this.traversedNodes.get(idx);
                long sourceId = this.sourceNodeId;
                double weight = 0.0;
                if (nodeId != this.sourceNodeId) {
                    long minimumChunkIndex = this.minimumChunk.get(nodeId);
                    sourceId = this.traversedNodes.get(minimumChunkIndex);
                    weight = this.aggregatorFunction.apply(sourceId, nodeId, this.weights.get(minimumChunkIndex));
                    this.weights.set(idx, weight);
                }
                this.relaxNode(idx, nodeId, sourceId, weight);
                ++examined;
            }
            this.localNodes.add(-1L);
        }
        this.progressTracker.logProgress(examined);
    }

    void syncNextChunk() {
        if (!this.localNodes.isEmpty()) {
            int nodesTraversed = 0;
            long index = this.traversedNodesLength.get();
            while (this.localNodes.get(this.indexOfLocalNodes) != -1L) {
                long nodeId = this.localNodes.get(this.indexOfLocalNodes);
                if (!this.visited.getAndSet(nodeId)) {
                    this.traversedNodes.set(index, nodeId);
                    ++index;
                    ++nodesTraversed;
                }
                ++this.indexOfLocalNodes;
            }
            ++this.indexOfLocalNodes;
            this.traversedNodesLength.getAndAdd(nodesTraversed);
            this.moveToNextChunk();
            if (!this.hasMoreChunks()) {
                this.resetLocalState();
            }
        }
    }

    private void relaxNode(long nodeIndex, long nodeId, long sourceNodeId, double weight) {
        ExitPredicate.Result exitPredicateResult = this.exitPredicate.test(sourceNodeId, nodeId, weight);
        if (exitPredicateResult == ExitPredicate.Result.BREAK) {
            this.targetFoundIndex.getAndAccumulate(nodeIndex, Math::min);
            return;
        }
        this.graph.forEachRelationship(nodeId, (s, targetNodeId) -> {
            if (!this.visited.get(targetNodeId)) {
                this.minimumChunk.update(targetNodeId, currentValue -> Math.min(currentValue, nodeIndex));
                if (this.minimumChunk.get(targetNodeId) == nodeIndex) {
                    this.localNodes.add(targetNodeId);
                }
            }
            return this.terminationFlag.running();
        });
    }

    private void resetLocalState() {
        this.localNodes.elementsCount = 0;
        this.indexOfLocalNodes = 0;
    }

    private void resetChunks() {
        this.chunks.elementsCount = 0;
        this.indexOfChunk = 0;
    }
}

