/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.paths.traverse;

import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.mem.MemoryRange;
import org.neo4j.gds.core.utils.paged.HugeAtomicBitSet;
import org.neo4j.gds.core.utils.paged.HugeAtomicLongArray;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.mem.MemoryUsage;
import org.neo4j.gds.paths.traverse.Aggregator;
import org.neo4j.gds.paths.traverse.BFS;
import org.neo4j.gds.paths.traverse.BfsBaseConfig;
import org.neo4j.gds.paths.traverse.ExitPredicate;
import org.neo4j.gds.paths.traverse.MaxDepthExitPredicate;
import org.neo4j.gds.paths.traverse.OneHopAggregator;
import org.neo4j.gds.paths.traverse.TargetExitPredicate;

public class BfsAlgorithmFactory<CONFIG extends BfsBaseConfig>
extends GraphAlgorithmFactory<BFS, CONFIG> {
    public BFS build(Graph graph, CONFIG configuration, ProgressTracker progressTracker) {
        Aggregator aggregatorFunction;
        ExitPredicate exitFunction;
        if (configuration.hasTargetNodes()) {
            List<Long> mappedTargets = configuration.targetNodes().stream().map(arg_0 -> ((Graph)graph).safeToMappedNodeId(arg_0)).collect(Collectors.toList());
            exitFunction = new TargetExitPredicate(mappedTargets);
            aggregatorFunction = Aggregator.NO_AGGREGATION;
        } else if (configuration.hasMaxDepth()) {
            exitFunction = new MaxDepthExitPredicate(configuration.maxDepth());
            aggregatorFunction = new OneHopAggregator();
        } else {
            exitFunction = ExitPredicate.FOLLOW;
            aggregatorFunction = Aggregator.NO_AGGREGATION;
        }
        long mappedStartNodeId = graph.toMappedNodeId(configuration.sourceNode());
        return BFS.create(graph, mappedStartNodeId, exitFunction, aggregatorFunction, configuration.concurrency(), progressTracker, configuration.maxDepth());
    }

    public String taskName() {
        return "BFS";
    }

    public MemoryEstimation memoryEstimation(CONFIG configuration) {
        MemoryEstimations.Builder builder = MemoryEstimations.builder(BFS.class);
        builder.perNode("visited ", HugeAtomicBitSet::memoryEstimation).perNode("traversedNodes", HugeLongArray::memoryEstimation).perNode("weights", HugeDoubleArray::memoryEstimation).perNode("minimumChunk", HugeAtomicLongArray::memoryEstimation);
        builder.rangePerGraphDimension("localNodes", (dimensions, concurrency) -> {
            long lowerBound = MemoryUsage.sizeOfLongArrayList((long)(dimensions.nodeCount() + dimensions.nodeCount() / 64L));
            long maximumTotalSizeOfAggregatedLocalNodes = Math.min(dimensions.relCountUpperBound(), (long)concurrency.intValue() * (dimensions.nodeCount() - 1L));
            long upperBound = MemoryUsage.sizeOfLongArrayList((long)(maximumTotalSizeOfAggregatedLocalNodes + dimensions.nodeCount() / 64L));
            return MemoryRange.of((long)lowerBound, (long)Math.max(lowerBound, upperBound));
        }).perGraphDimension("chunks", (dimensions, concurrency) -> MemoryRange.of((long)(dimensions.nodeCount() / 64L)));
        builder.perNode("resultNodes", HugeLongArray::memoryEstimation);
        return builder.build();
    }
}

