/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.paths.traverse;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.NodeIdsParser;
import org.neo4j.gds.config.SourceNodeConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.paths.traverse.BfsStreamConfig;

public final class BfsStreamConfigImpl
implements BfsStreamConfig {
    private long maxDepth;
    private List<String> relationshipTypes;
    private List<String> nodeLabels;
    @Nullable
    private String usernameOverride;
    private boolean sudo;
    private int concurrency;
    private long sourceNode;
    private List<Long> targetNodes;

    public BfsStreamConfigImpl(@NotNull CypherMapWrapper config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.maxDepth = config.getLong("maxDepth", BfsStreamConfig.super.maxDepth());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipTypes = (List)CypherMapWrapper.failOnNull((String)"relationshipTypes", (Object)((List)config.getChecked("relationshipTypes", (Object)BfsStreamConfig.super.relationshipTypes(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.nodeLabels = (List)CypherMapWrapper.failOnNull((String)"nodeLabels", (Object)((List)config.getChecked("nodeLabels", (Object)BfsStreamConfig.super.nodeLabels(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.usernameOverride = StringUtils.trimToNull((String)config.getString("username", BfsStreamConfig.super.usernameOverride()));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sudo = config.getBool("sudo", BfsStreamConfig.super.sudo());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.concurrency = config.getInt("concurrency", BfsStreamConfig.super.concurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sourceNode = SourceNodeConfig.parseSourceNodeId((Object)config.requireChecked("sourceNode", Object.class));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.targetNodes = (List)CypherMapWrapper.failOnNull((String)"targetNodes", (Object)NodeIdsParser.parseNodeIds((Object)config.getChecked("targetNodes", (Object)BfsStreamConfig.super.targetNodes(), Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validateConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public long maxDepth() {
        return this.maxDepth;
    }

    public List<String> relationshipTypes() {
        return this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        return this.nodeLabels;
    }

    public void graphStoreValidation(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
    }

    @Nullable
    public String usernameOverride() {
        return this.usernameOverride;
    }

    public boolean sudo() {
        return this.sudo;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("maxDepth", "relationshipTypes", "nodeLabels", "username", "sudo", "concurrency", "sourceNode", "targetNodes");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("maxDepth", this.maxDepth());
        map.put("relationshipTypes", this.relationshipTypes());
        map.put("nodeLabels", this.nodeLabels());
        map.put("username", this.usernameOverride());
        map.put("sudo", this.sudo());
        map.put("concurrency", this.concurrency());
        map.put("sourceNode", this.sourceNode());
        map.put("targetNodes", this.targetNodes());
        return map;
    }

    public int concurrency() {
        return this.concurrency;
    }

    public long sourceNode() {
        return this.sourceNode;
    }

    public List<Long> targetNodes() {
        return this.targetNodes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();

        public Builder maxDepth(long maxDepth) {
            this.config.put("maxDepth", maxDepth);
            return this;
        }

        public Builder relationshipTypes(List<String> relationshipTypes) {
            this.config.put("relationshipTypes", relationshipTypes);
            return this;
        }

        public Builder nodeLabels(List<String> nodeLabels) {
            this.config.put("nodeLabels", nodeLabels);
            return this;
        }

        public Builder usernameOverride(String usernameOverride) {
            this.config.put("username", usernameOverride);
            return this;
        }

        public Builder sudo(boolean sudo) {
            this.config.put("sudo", sudo);
            return this;
        }

        public Builder concurrency(int concurrency) {
            this.config.put("concurrency", concurrency);
            return this;
        }

        public Builder sourceNode(Object sourceNode) {
            this.config.put("sourceNode", sourceNode);
            return this;
        }

        public Builder targetNodes(Object targetNodes) {
            this.config.put("targetNodes", targetNodes);
            return this;
        }

        public BfsStreamConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new BfsStreamConfigImpl(config);
        }
    }
}

