/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.paths.traverse;

import com.carrotsearch.hppc.BitSet;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.utils.paged.HugeDoubleArrayStack;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.paged.HugeLongArrayStack;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.paths.traverse.Aggregator;
import org.neo4j.gds.paths.traverse.ExitPredicate;

public class DFS
extends Algorithm<HugeLongArray> {
    private final Graph graph;
    private final long startNodeId;
    private final ExitPredicate exitPredicate;
    private final Aggregator aggregatorFunction;
    private final long nodeCount;

    public DFS(Graph graph, long startNodeId, ExitPredicate exitPredicate, Aggregator aggregatorFunction, ProgressTracker progressTracker) {
        super(progressTracker);
        this.graph = graph;
        this.nodeCount = graph.nodeCount();
        this.startNodeId = startNodeId;
        this.exitPredicate = exitPredicate;
        this.aggregatorFunction = aggregatorFunction;
    }

    public HugeLongArray compute() {
        this.progressTracker.beginSubTask();
        HugeLongArray result = HugeLongArray.newArray((long)this.nodeCount);
        BitSet inResult = new BitSet(this.nodeCount);
        HugeLongArrayStack nodes = HugeLongArrayStack.newStack((long)this.nodeCount);
        HugeLongArrayStack sources = HugeLongArrayStack.newStack((long)this.nodeCount);
        HugeDoubleArrayStack weights = HugeDoubleArrayStack.newStack((long)this.nodeCount);
        BitSet visited = new BitSet(this.nodeCount);
        nodes.push(this.startNodeId);
        sources.push(this.startNodeId);
        weights.push(0.0);
        visited.set(this.startNodeId);
        long resultIndex = 0L;
        while (!nodes.isEmpty() && this.running()) {
            double weight;
            long node;
            long source = sources.pop();
            ExitPredicate.Result exitPredicateResult = this.exitPredicate.test(source, node = nodes.pop(), weight = weights.pop());
            if (exitPredicateResult == ExitPredicate.Result.CONTINUE) continue;
            if (!inResult.getAndSet(node)) {
                result.set(resultIndex, node);
                ++resultIndex;
            }
            if (exitPredicateResult == ExitPredicate.Result.BREAK) break;
            this.progressTracker.logProgress((long)this.graph.degree(node));
            this.graph.forEachRelationship(node, (s, t) -> {
                if (!visited.get(t)) {
                    visited.set(t);
                    sources.push(s);
                    nodes.push(t);
                    weights.push(this.aggregatorFunction.apply(s, t, weight));
                }
                return this.running();
            });
        }
        this.progressTracker.endSubTask();
        return result.copyOf(resultIndex);
    }

    public void release() {
    }
}

