/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.paths.traverse;

import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.mem.MemoryUsage;
import org.neo4j.gds.paths.traverse.Aggregator;
import org.neo4j.gds.paths.traverse.DFS;
import org.neo4j.gds.paths.traverse.DfsBaseConfig;
import org.neo4j.gds.paths.traverse.ExitPredicate;
import org.neo4j.gds.paths.traverse.MaxDepthExitPredicate;
import org.neo4j.gds.paths.traverse.OneHopAggregator;
import org.neo4j.gds.paths.traverse.TargetExitPredicate;

public class DfsAlgorithmFactory<CONFIG extends DfsBaseConfig>
extends GraphAlgorithmFactory<DFS, CONFIG> {
    public DFS build(Graph graph, CONFIG configuration, ProgressTracker progressTracker) {
        Aggregator aggregatorFunction;
        ExitPredicate exitFunction;
        if (configuration.hasTargetNodes()) {
            List<Long> mappedTargets = configuration.targetNodes().stream().map(arg_0 -> ((Graph)graph).safeToMappedNodeId(arg_0)).collect(Collectors.toList());
            exitFunction = new TargetExitPredicate(mappedTargets);
            aggregatorFunction = Aggregator.NO_AGGREGATION;
        } else if (configuration.hasMaxDepth()) {
            exitFunction = new MaxDepthExitPredicate(configuration.maxDepth());
            aggregatorFunction = new OneHopAggregator();
        } else {
            exitFunction = ExitPredicate.FOLLOW;
            aggregatorFunction = Aggregator.NO_AGGREGATION;
        }
        long mappedSourceNodeId = graph.toMappedNodeId(configuration.sourceNode());
        return new DFS(graph, mappedSourceNodeId, exitFunction, aggregatorFunction, progressTracker);
    }

    public String taskName() {
        return "DFS";
    }

    public MemoryEstimation memoryEstimation(CONFIG configuration) {
        MemoryEstimations.Builder builder = MemoryEstimations.builder(DFS.class);
        builder.perNode("visited ", MemoryUsage::sizeOfBitset);
        builder.perNode("nodes", MemoryUsage::sizeOfLongArrayList);
        builder.perNode("sources", MemoryUsage::sizeOfLongArrayList);
        builder.perNode("weights", MemoryUsage::sizeOfDoubleArrayList);
        builder.perNode("resultNodes", MemoryUsage::sizeOfLongArray);
        return builder.build();
    }
}

