/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.paths.traverse;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.config.SourceNodeConfig;
import org.neo4j.gds.config.TargetNodesConfig;
import org.neo4j.gds.paths.traverse.BfsBaseConfig;
import org.neo4j.gds.paths.traverse.BfsStreamConfig;

@Generated(from="BfsStreamConfig", generator="Immutables")
public final class ImmutableBfsStreamConfig
implements BfsStreamConfig {
    @Nullable
    private final String usernameOverride;
    private final boolean sudo;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    private final int concurrency;
    private final int minBatchSize;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    private final long sourceNode;
    private final List<Long> targetNodes;
    private final transient boolean hasTargetNodes;
    private final long maxDepth;
    private final transient boolean hasMaxDepth;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBfsStreamConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, long sourceNode, Iterable<Long> targetNodes, long maxDepth) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableBfsStreamConfig.createUnmodifiableList(false, ImmutableBfsStreamConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableBfsStreamConfig.createUnmodifiableList(false, ImmutableBfsStreamConfig.createSafeList(nodeLabels, true, false)));
        this.sourceNode = sourceNode;
        this.initShim.targetNodes(ImmutableBfsStreamConfig.createUnmodifiableList(false, ImmutableBfsStreamConfig.createSafeList(targetNodes, true, false)));
        this.initShim.maxDepth(maxDepth);
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.targetNodes = this.initShim.targetNodes();
        this.hasTargetNodes = this.initShim.hasTargetNodes();
        this.maxDepth = this.initShim.maxDepth();
        this.hasMaxDepth = this.initShim.hasMaxDepth();
        this.initShim = null;
    }

    private ImmutableBfsStreamConfig(Builder builder) {
        this.sourceNode = builder.sourceNode;
        if (builder.usernameOverrideIsSet()) {
            this.initShim.usernameOverride(builder.usernameOverride);
        }
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.minBatchSizeIsSet()) {
            this.initShim.minBatchSize(builder.minBatchSize);
        }
        if (builder.relationshipTypesIsSet()) {
            this.initShim.relationshipTypes(builder.relationshipTypes == null ? Collections.emptyList() : ImmutableBfsStreamConfig.createUnmodifiableList(true, builder.relationshipTypes));
        }
        if (builder.nodeLabelsIsSet()) {
            this.initShim.nodeLabels(builder.nodeLabels == null ? Collections.emptyList() : ImmutableBfsStreamConfig.createUnmodifiableList(true, builder.nodeLabels));
        }
        if (builder.targetNodesIsSet()) {
            this.initShim.targetNodes(builder.targetNodes == null ? Collections.emptyList() : ImmutableBfsStreamConfig.createUnmodifiableList(true, builder.targetNodes));
        }
        if (builder.maxDepthIsSet()) {
            this.initShim.maxDepth(builder.maxDepth);
        }
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.targetNodes = this.initShim.targetNodes();
        this.hasTargetNodes = this.initShim.hasTargetNodes();
        this.maxDepth = this.initShim.maxDepth();
        this.hasMaxDepth = this.initShim.hasMaxDepth();
        this.initShim = null;
    }

    private ImmutableBfsStreamConfig(@Nullable String usernameOverride, boolean sudo, Collection<String> configKeys, int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, long sourceNode, List<Long> targetNodes, long maxDepth) {
        this.initShim.usernameOverride(usernameOverride);
        this.initShim.sudo(sudo);
        this.initShim.configKeys(configKeys);
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(relationshipTypes);
        this.initShim.nodeLabels(nodeLabels);
        this.sourceNode = sourceNode;
        this.initShim.targetNodes(targetNodes);
        this.initShim.maxDepth(maxDepth);
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.targetNodes = this.initShim.targetNodes();
        this.hasTargetNodes = this.initShim.hasTargetNodes();
        this.maxDepth = this.initShim.maxDepth();
        this.hasMaxDepth = this.initShim.hasMaxDepth();
        this.initShim = null;
    }

    @Nullable
    private String usernameOverrideInitialize() {
        return BfsStreamConfig.super.usernameOverride();
    }

    private boolean sudoInitialize() {
        return BfsStreamConfig.super.sudo();
    }

    private Collection<String> configKeysInitialize() {
        return BfsStreamConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return BfsStreamConfig.super.toMap();
    }

    private int concurrencyInitialize() {
        return BfsStreamConfig.super.concurrency();
    }

    private int minBatchSizeInitialize() {
        return BfsStreamConfig.super.minBatchSize();
    }

    private List<String> relationshipTypesInitialize() {
        return BfsStreamConfig.super.relationshipTypes();
    }

    private List<String> nodeLabelsInitialize() {
        return BfsStreamConfig.super.nodeLabels();
    }

    private List<Long> targetNodesInitialize() {
        return BfsStreamConfig.super.targetNodes();
    }

    private boolean hasTargetNodesInitialize() {
        return BfsStreamConfig.super.hasTargetNodes();
    }

    private long maxDepthInitialize() {
        return BfsStreamConfig.super.maxDepth();
    }

    private boolean hasMaxDepthInitialize() {
        return BfsStreamConfig.super.hasMaxDepth();
    }

    @Nullable
    public String usernameOverride() {
        InitShim shim = this.initShim;
        return shim != null ? shim.usernameOverride() : this.usernameOverride;
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    public int minBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minBatchSize() : this.minBatchSize;
    }

    public List<String> relationshipTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipTypes() : this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeLabels() : this.nodeLabels;
    }

    public long sourceNode() {
        return this.sourceNode;
    }

    public List<Long> targetNodes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.targetNodes() : this.targetNodes;
    }

    public boolean hasTargetNodes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasTargetNodes() : this.hasTargetNodes;
    }

    @Override
    public long maxDepth() {
        InitShim shim = this.initShim;
        return shim != null ? shim.maxDepth() : this.maxDepth;
    }

    @Override
    public boolean hasMaxDepth() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasMaxDepth() : this.hasMaxDepth;
    }

    public final ImmutableBfsStreamConfig withUsernameOverride(@Nullable String value) {
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return ImmutableBfsStreamConfig.validate(new ImmutableBfsStreamConfig(value, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.targetNodes, this.maxDepth));
    }

    public final ImmutableBfsStreamConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutableBfsStreamConfig.validate(new ImmutableBfsStreamConfig(this.usernameOverride, value, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.targetNodes, this.maxDepth));
    }

    public final ImmutableBfsStreamConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutableBfsStreamConfig.validate(new ImmutableBfsStreamConfig(this.usernameOverride, this.sudo, newValue, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.targetNodes, this.maxDepth));
    }

    public final ImmutableBfsStreamConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutableBfsStreamConfig.validate(new ImmutableBfsStreamConfig(this.usernameOverride, this.sudo, this.configKeys, value, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.targetNodes, this.maxDepth));
    }

    public final ImmutableBfsStreamConfig withMinBatchSize(int value) {
        if (this.minBatchSize == value) {
            return this;
        }
        return ImmutableBfsStreamConfig.validate(new ImmutableBfsStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, value, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.targetNodes, this.maxDepth));
    }

    public final ImmutableBfsStreamConfig withRelationshipTypes(String ... elements) {
        List<String> newValue = ImmutableBfsStreamConfig.createUnmodifiableList(false, ImmutableBfsStreamConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableBfsStreamConfig.validate(new ImmutableBfsStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.nodeLabels, this.sourceNode, this.targetNodes, this.maxDepth));
    }

    public final ImmutableBfsStreamConfig withRelationshipTypes(Iterable<String> elements) {
        if (this.relationshipTypes == elements) {
            return this;
        }
        List<String> newValue = ImmutableBfsStreamConfig.createUnmodifiableList(false, ImmutableBfsStreamConfig.createSafeList(elements, true, false));
        return ImmutableBfsStreamConfig.validate(new ImmutableBfsStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.nodeLabels, this.sourceNode, this.targetNodes, this.maxDepth));
    }

    public final ImmutableBfsStreamConfig withNodeLabels(String ... elements) {
        List<String> newValue = ImmutableBfsStreamConfig.createUnmodifiableList(false, ImmutableBfsStreamConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableBfsStreamConfig.validate(new ImmutableBfsStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, newValue, this.sourceNode, this.targetNodes, this.maxDepth));
    }

    public final ImmutableBfsStreamConfig withNodeLabels(Iterable<String> elements) {
        if (this.nodeLabels == elements) {
            return this;
        }
        List<String> newValue = ImmutableBfsStreamConfig.createUnmodifiableList(false, ImmutableBfsStreamConfig.createSafeList(elements, true, false));
        return ImmutableBfsStreamConfig.validate(new ImmutableBfsStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, newValue, this.sourceNode, this.targetNodes, this.maxDepth));
    }

    public final ImmutableBfsStreamConfig withSourceNode(long value) {
        if (this.sourceNode == value) {
            return this;
        }
        return ImmutableBfsStreamConfig.validate(new ImmutableBfsStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, value, this.targetNodes, this.maxDepth));
    }

    public final ImmutableBfsStreamConfig withTargetNodes(long ... elements) {
        ArrayList<Long> wrappedList = new ArrayList<Long>(elements.length);
        for (long element : elements) {
            wrappedList.add(element);
        }
        List<Long> newValue = ImmutableBfsStreamConfig.createUnmodifiableList(false, wrappedList);
        return ImmutableBfsStreamConfig.validate(new ImmutableBfsStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.sourceNode, newValue, this.maxDepth));
    }

    public final ImmutableBfsStreamConfig withTargetNodes(Iterable<Long> elements) {
        if (this.targetNodes == elements) {
            return this;
        }
        List<Long> newValue = ImmutableBfsStreamConfig.createUnmodifiableList(false, ImmutableBfsStreamConfig.createSafeList(elements, true, false));
        return ImmutableBfsStreamConfig.validate(new ImmutableBfsStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.sourceNode, newValue, this.maxDepth));
    }

    public final ImmutableBfsStreamConfig withMaxDepth(long value) {
        if (this.maxDepth == value) {
            return this;
        }
        return ImmutableBfsStreamConfig.validate(new ImmutableBfsStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.relationshipTypes, this.nodeLabels, this.sourceNode, this.targetNodes, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBfsStreamConfig && this.equalTo((ImmutableBfsStreamConfig)another);
    }

    private boolean equalTo(ImmutableBfsStreamConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && this.concurrency == another.concurrency && this.minBatchSize == another.minBatchSize && this.relationshipTypes.equals(another.relationshipTypes) && this.nodeLabels.equals(another.nodeLabels) && this.sourceNode == another.sourceNode && this.targetNodes.equals(another.targetNodes) && this.hasTargetNodes == another.hasTargetNodes && this.maxDepth == another.maxDepth && this.hasMaxDepth == another.hasMaxDepth;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + this.concurrency;
        h += (h << 5) + this.minBatchSize;
        h += (h << 5) + this.relationshipTypes.hashCode();
        h += (h << 5) + this.nodeLabels.hashCode();
        h += (h << 5) + Long.hashCode(this.sourceNode);
        h += (h << 5) + this.targetNodes.hashCode();
        h += (h << 5) + Boolean.hashCode(this.hasTargetNodes);
        h += (h << 5) + Long.hashCode(this.maxDepth);
        h += (h << 5) + Boolean.hashCode(this.hasMaxDepth);
        return h;
    }

    public String toString() {
        return "BfsStreamConfig{usernameOverride=" + this.usernameOverride + ", sudo=" + this.sudo + ", concurrency=" + this.concurrency + ", minBatchSize=" + this.minBatchSize + ", relationshipTypes=" + this.relationshipTypes + ", nodeLabels=" + this.nodeLabels + ", sourceNode=" + this.sourceNode + ", targetNodes=" + this.targetNodes + ", hasTargetNodes=" + this.hasTargetNodes + ", maxDepth=" + this.maxDepth + ", hasMaxDepth=" + this.hasMaxDepth + "}";
    }

    public static BfsStreamConfig of(int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, long sourceNode, List<Long> targetNodes, long maxDepth) {
        return ImmutableBfsStreamConfig.of(concurrency, minBatchSize, relationshipTypes, nodeLabels, sourceNode, targetNodes, maxDepth);
    }

    public static BfsStreamConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, long sourceNode, Iterable<Long> targetNodes, long maxDepth) {
        return ImmutableBfsStreamConfig.validate(new ImmutableBfsStreamConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, sourceNode, targetNodes, maxDepth));
    }

    private static ImmutableBfsStreamConfig validate(ImmutableBfsStreamConfig instance) {
        instance.validateConcurrency();
        return instance;
    }

    public static BfsStreamConfig copyOf(BfsStreamConfig instance) {
        if (instance instanceof ImmutableBfsStreamConfig) {
            return (ImmutableBfsStreamConfig)instance;
        }
        return ImmutableBfsStreamConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="BfsStreamConfig", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_SOURCE_NODE = 1L;
        private static final long OPT_BIT_USERNAME_OVERRIDE = 1L;
        private static final long OPT_BIT_SUDO = 2L;
        private static final long OPT_BIT_CONCURRENCY = 4L;
        private static final long OPT_BIT_MIN_BATCH_SIZE = 8L;
        private static final long OPT_BIT_RELATIONSHIP_TYPES = 16L;
        private static final long OPT_BIT_NODE_LABELS = 32L;
        private static final long OPT_BIT_TARGET_NODES = 64L;
        private static final long OPT_BIT_MAX_DEPTH = 128L;
        private long initBits = 1L;
        private long optBits;
        private String usernameOverride;
        private boolean sudo;
        private Collection<String> configKeys;
        private int concurrency;
        private int minBatchSize;
        private List<String> relationshipTypes = null;
        private List<String> nodeLabels = null;
        private long sourceNode;
        private List<Long> targetNodes = null;
        private long maxDepth;

        private Builder() {
        }

        public final Builder from(TargetNodesConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SourceNodeConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ConcurrencyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AlgoBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BfsBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BfsStreamConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TargetNodesConfig instance;
            if (object instanceof TargetNodesConfig) {
                instance = (TargetNodesConfig)object;
                this.addAllTargetNodes(instance.targetNodes());
            }
            if (object instanceof SourceNodeConfig) {
                instance = (SourceNodeConfig)object;
                this.sourceNode(instance.sourceNode());
            }
            if (object instanceof ConcurrencyConfig) {
                instance = (ConcurrencyConfig)object;
                this.minBatchSize(instance.minBatchSize());
                this.concurrency(instance.concurrency());
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                @Nullable String usernameOverrideValue = instance.usernameOverride();
                if (usernameOverrideValue != null) {
                    this.usernameOverride(usernameOverrideValue);
                }
                this.configKeys(instance.configKeys());
                this.sudo(instance.sudo());
            }
            if (object instanceof AlgoBaseConfig) {
                instance = (AlgoBaseConfig)object;
                this.addAllRelationshipTypes(instance.relationshipTypes());
                this.addAllNodeLabels(instance.nodeLabels());
            }
            if (object instanceof BfsBaseConfig) {
                instance = (BfsBaseConfig)object;
                this.maxDepth(instance.maxDepth());
            }
        }

        public final Builder usernameOverride(@Nullable String usernameOverride) {
            this.usernameOverride = usernameOverride;
            this.optBits |= 1L;
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 2L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 4L;
            return this;
        }

        public final Builder minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.optBits |= 8L;
            return this;
        }

        public final Builder addRelationshipType(String element) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addRelationshipTypes(String ... elements) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder relationshipTypes(Iterable<String> elements) {
            this.relationshipTypes = new ArrayList<String>();
            return this.addAllRelationshipTypes(elements);
        }

        public final Builder addAllRelationshipTypes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "relationshipTypes element");
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addNodeLabel(String element) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder addNodeLabels(String ... elements) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder nodeLabels(Iterable<String> elements) {
            this.nodeLabels = new ArrayList<String>();
            return this.addAllNodeLabels(elements);
        }

        public final Builder addAllNodeLabels(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeLabels element");
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder sourceNode(long sourceNode) {
            this.sourceNode = sourceNode;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addTargetNode(long element) {
            if (this.targetNodes == null) {
                this.targetNodes = new ArrayList<Long>();
            }
            this.targetNodes.add(element);
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder addTargetNodes(long ... elements) {
            if (this.targetNodes == null) {
                this.targetNodes = new ArrayList<Long>();
            }
            for (long element : elements) {
                this.targetNodes.add(element);
            }
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder targetNodes(Iterable<Long> elements) {
            this.targetNodes = new ArrayList<Long>();
            return this.addAllTargetNodes(elements);
        }

        public final Builder addAllTargetNodes(Iterable<Long> elements) {
            Objects.requireNonNull(elements, "targetNodes element");
            if (this.targetNodes == null) {
                this.targetNodes = new ArrayList<Long>();
            }
            for (long element : elements) {
                this.targetNodes.add(Objects.requireNonNull(Long.valueOf(element), "targetNodes element"));
            }
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder maxDepth(long maxDepth) {
            this.maxDepth = maxDepth;
            this.optBits |= 0x80L;
            return this;
        }

        public Builder clear() {
            this.initBits = 1L;
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.configKeys = null;
            this.concurrency = 0;
            this.minBatchSize = 0;
            if (this.relationshipTypes != null) {
                this.relationshipTypes.clear();
            }
            if (this.nodeLabels != null) {
                this.nodeLabels.clear();
            }
            this.sourceNode = 0L;
            if (this.targetNodes != null) {
                this.targetNodes.clear();
            }
            this.maxDepth = 0L;
            return this;
        }

        public BfsStreamConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableBfsStreamConfig.validate(new ImmutableBfsStreamConfig(this));
        }

        private boolean usernameOverrideIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean sudoIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean minBatchSizeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean relationshipTypesIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean nodeLabelsIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean targetNodesIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean maxDepthIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sourceNode");
            }
            return "Cannot build BfsStreamConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="BfsStreamConfig", generator="Immutables")
    private final class InitShim {
        private byte usernameOverrideBuildStage = 0;
        private String usernameOverride;
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte concurrencyBuildStage = 0;
        private int concurrency;
        private byte minBatchSizeBuildStage = 0;
        private int minBatchSize;
        private byte relationshipTypesBuildStage = 0;
        private List<String> relationshipTypes;
        private byte nodeLabelsBuildStage = 0;
        private List<String> nodeLabels;
        private byte targetNodesBuildStage = 0;
        private List<Long> targetNodes;
        private byte hasTargetNodesBuildStage = 0;
        private boolean hasTargetNodes;
        private byte maxDepthBuildStage = 0;
        private long maxDepth;
        private byte hasMaxDepthBuildStage = 0;
        private boolean hasMaxDepth;

        private InitShim() {
        }

        String usernameOverride() {
            if (this.usernameOverrideBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usernameOverrideBuildStage == 0) {
                this.usernameOverrideBuildStage = (byte)-1;
                this.usernameOverride = ImmutableBfsStreamConfig.this.usernameOverrideInitialize();
                this.usernameOverrideBuildStage = 1;
            }
            return this.usernameOverride;
        }

        void usernameOverride(String usernameOverride) {
            this.usernameOverride = usernameOverride;
            this.usernameOverrideBuildStage = 1;
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableBfsStreamConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableBfsStreamConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableBfsStreamConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutableBfsStreamConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        int minBatchSize() {
            if (this.minBatchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minBatchSizeBuildStage == 0) {
                this.minBatchSizeBuildStage = (byte)-1;
                this.minBatchSize = ImmutableBfsStreamConfig.this.minBatchSizeInitialize();
                this.minBatchSizeBuildStage = 1;
            }
            return this.minBatchSize;
        }

        void minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.minBatchSizeBuildStage = 1;
        }

        List<String> relationshipTypes() {
            if (this.relationshipTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipTypesBuildStage == 0) {
                this.relationshipTypesBuildStage = (byte)-1;
                this.relationshipTypes = ImmutableBfsStreamConfig.createUnmodifiableList(false, ImmutableBfsStreamConfig.createSafeList(ImmutableBfsStreamConfig.this.relationshipTypesInitialize(), true, false));
                this.relationshipTypesBuildStage = 1;
            }
            return this.relationshipTypes;
        }

        void relationshipTypes(List<String> relationshipTypes) {
            this.relationshipTypes = relationshipTypes;
            this.relationshipTypesBuildStage = 1;
        }

        List<String> nodeLabels() {
            if (this.nodeLabelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeLabelsBuildStage == 0) {
                this.nodeLabelsBuildStage = (byte)-1;
                this.nodeLabels = ImmutableBfsStreamConfig.createUnmodifiableList(false, ImmutableBfsStreamConfig.createSafeList(ImmutableBfsStreamConfig.this.nodeLabelsInitialize(), true, false));
                this.nodeLabelsBuildStage = 1;
            }
            return this.nodeLabels;
        }

        void nodeLabels(List<String> nodeLabels) {
            this.nodeLabels = nodeLabels;
            this.nodeLabelsBuildStage = 1;
        }

        List<Long> targetNodes() {
            if (this.targetNodesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.targetNodesBuildStage == 0) {
                this.targetNodesBuildStage = (byte)-1;
                this.targetNodes = ImmutableBfsStreamConfig.createUnmodifiableList(false, ImmutableBfsStreamConfig.createSafeList(ImmutableBfsStreamConfig.this.targetNodesInitialize(), true, false));
                this.targetNodesBuildStage = 1;
            }
            return this.targetNodes;
        }

        void targetNodes(List<Long> targetNodes) {
            this.targetNodes = targetNodes;
            this.targetNodesBuildStage = 1;
        }

        boolean hasTargetNodes() {
            if (this.hasTargetNodesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasTargetNodesBuildStage == 0) {
                this.hasTargetNodesBuildStage = (byte)-1;
                this.hasTargetNodes = ImmutableBfsStreamConfig.this.hasTargetNodesInitialize();
                this.hasTargetNodesBuildStage = 1;
            }
            return this.hasTargetNodes;
        }

        long maxDepth() {
            if (this.maxDepthBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.maxDepthBuildStage == 0) {
                this.maxDepthBuildStage = (byte)-1;
                this.maxDepth = ImmutableBfsStreamConfig.this.maxDepthInitialize();
                this.maxDepthBuildStage = 1;
            }
            return this.maxDepth;
        }

        void maxDepth(long maxDepth) {
            this.maxDepth = maxDepth;
            this.maxDepthBuildStage = 1;
        }

        boolean hasMaxDepth() {
            if (this.hasMaxDepthBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasMaxDepthBuildStage == 0) {
                this.hasMaxDepthBuildStage = (byte)-1;
                this.hasMaxDepth = ImmutableBfsStreamConfig.this.hasMaxDepthInitialize();
                this.hasMaxDepthBuildStage = 1;
            }
            return this.hasMaxDepth;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.usernameOverrideBuildStage == -1) {
                attributes.add("usernameOverride");
            }
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.minBatchSizeBuildStage == -1) {
                attributes.add("minBatchSize");
            }
            if (this.relationshipTypesBuildStage == -1) {
                attributes.add("relationshipTypes");
            }
            if (this.nodeLabelsBuildStage == -1) {
                attributes.add("nodeLabels");
            }
            if (this.targetNodesBuildStage == -1) {
                attributes.add("targetNodes");
            }
            if (this.hasTargetNodesBuildStage == -1) {
                attributes.add("hasTargetNodes");
            }
            if (this.maxDepthBuildStage == -1) {
                attributes.add("maxDepth");
            }
            if (this.hasMaxDepthBuildStage == -1) {
                attributes.add("hasMaxDepth");
            }
            return "Cannot build BfsStreamConfig, attribute initializers form cycle " + attributes;
        }
    }
}

