/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.results;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import org.neo4j.gds.core.GraphDimensions;
import org.neo4j.gds.core.utils.mem.MemoryRange;
import org.neo4j.gds.core.utils.mem.MemoryTree;
import org.neo4j.gds.core.utils.mem.MemoryTreeWithDimensions;

public class MemoryEstimateResult {
    public final String requiredMemory;
    public final String treeView;
    public final Map<String, Object> mapView;
    public final long bytesMin;
    public final long bytesMax;
    public long nodeCount;
    public long relationshipCount;
    public final double heapPercentageMin;
    public final double heapPercentageMax;

    public MemoryEstimateResult(MemoryTreeWithDimensions memory) {
        this(memory.memoryTree, memory.graphDimensions);
    }

    private MemoryEstimateResult(MemoryTree memory, GraphDimensions dimensions) {
        this(memory.render(), memory.renderMap(), memory.memoryUsage(), dimensions);
    }

    private MemoryEstimateResult(String treeView, Map<String, Object> mapView, MemoryRange estimateMemoryUsage, GraphDimensions dimensions) {
        long heapSize = Runtime.getRuntime().maxMemory();
        this.requiredMemory = estimateMemoryUsage.toString();
        this.treeView = treeView;
        this.mapView = mapView;
        this.bytesMin = estimateMemoryUsage.min;
        this.bytesMax = estimateMemoryUsage.max;
        this.heapPercentageMin = this.getPercentage(this.bytesMin, heapSize);
        this.heapPercentageMax = this.getPercentage(this.bytesMax, heapSize);
        this.nodeCount = dimensions.nodeCount();
        this.relationshipCount = dimensions.relCountUpperBound();
    }

    private double getPercentage(long requiredBytes, long heapSizeBytes) {
        if (heapSizeBytes == 0L) {
            return Double.NaN;
        }
        return BigDecimal.valueOf(requiredBytes).divide(BigDecimal.valueOf(heapSizeBytes), 1, RoundingMode.UP).doubleValue();
    }
}

