/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity;

import java.util.concurrent.ExecutorService;
import java.util.stream.Stream;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.api.DefaultValue;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.PartialIdMap;
import org.neo4j.gds.api.Relationships;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.compress.AdjacencyListBehavior;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.huge.HugeGraph;
import org.neo4j.gds.core.loading.construction.GraphFactory;
import org.neo4j.gds.core.loading.construction.RelationshipsBuilder;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.similarity.SimilarityResult;

public class SimilarityGraphBuilder {
    private final IdMap idMap;
    private final int concurrency;
    private final ExecutorService executorService;

    public static MemoryEstimation memoryEstimation(int topK, int topN) {
        return MemoryEstimations.setup((String)"", (dimensions, concurrency) -> {
            long maxNodesToCompare = Math.min(dimensions.relCountUpperBound(), dimensions.nodeCount());
            long maxNumberOfSimilarityResults = maxNodesToCompare * (maxNodesToCompare - 1L) / 2L;
            long newNodeCount = maxNodesToCompare;
            long newRelationshipCount = maxNumberOfSimilarityResults;
            if (topN > 0) {
                newRelationshipCount = Math.min(newRelationshipCount, (long)topN);
                newNodeCount = Math.min(maxNodesToCompare, newRelationshipCount * 2L);
            }
            int averageDegree = Math.toIntExact(newRelationshipCount / newNodeCount);
            if (topK > 0) {
                averageDegree = Math.min(Math.toIntExact(2L * newRelationshipCount / newNodeCount), topK);
            }
            return MemoryEstimations.builder(HugeGraph.class).add("adjacency list", AdjacencyListBehavior.adjacencyListEstimation((long)averageDegree, (long)newNodeCount)).build();
        });
    }

    public SimilarityGraphBuilder(IdMap idMap, int concurrency, ExecutorService executorService) {
        this.concurrency = concurrency;
        this.executorService = executorService;
        this.idMap = idMap;
    }

    public Graph build(Stream<SimilarityResult> stream) {
        RelationshipsBuilder relationshipsBuilder = GraphFactory.initRelationshipsBuilder().nodes((PartialIdMap)this.idMap.rootIdMap()).orientation(Orientation.NATURAL).addPropertyConfig(Aggregation.NONE, DefaultValue.forDouble()).concurrency(this.concurrency).executorService(this.executorService).build();
        ParallelUtil.parallelStreamConsume(stream, (int)this.concurrency, similarityStream -> similarityStream.forEach(similarityResult -> relationshipsBuilder.addFromInternal(this.idMap.toRootNodeId(similarityResult.sourceNodeId()), this.idMap.toRootNodeId(similarityResult.targetNodeId()), similarityResult.similarity)));
        return GraphFactory.create((IdMap)this.idMap.rootIdMap(), (Relationships)relationshipsBuilder.build());
    }
}

