/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.knn;

import java.util.SplittableRandom;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.core.utils.partition.Partition;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.similarity.knn.KnnSampler;
import org.neo4j.gds.similarity.knn.NeighborFilter;
import org.neo4j.gds.similarity.knn.NeighborList;
import org.neo4j.gds.similarity.knn.metrics.SimilarityComputer;

final class GenerateRandomNeighbors
implements Runnable {
    private final KnnSampler sampler;
    private final SplittableRandom random;
    private final SimilarityComputer computer;
    private final NeighborFilter neighborFilter;
    private final HugeObjectArray<NeighborList> neighbors;
    private final int k;
    private final int boundedK;
    private final ProgressTracker progressTracker;
    private final Partition partition;
    private long neighborsFound;

    GenerateRandomNeighbors(KnnSampler sampler, SplittableRandom random, SimilarityComputer computer, NeighborFilter neighborFilter, HugeObjectArray<NeighborList> neighbors, int k, int boundedK, Partition partition, ProgressTracker progressTracker) {
        this.sampler = sampler;
        this.random = random;
        this.computer = computer;
        this.neighborFilter = neighborFilter;
        this.neighbors = neighbors;
        this.k = k;
        this.boundedK = boundedK;
        this.progressTracker = progressTracker;
        this.partition = partition;
        this.neighborsFound = 0L;
    }

    @Override
    public void run() {
        SplittableRandom rng = this.random;
        SimilarityComputer computer = this.computer;
        int k = this.k;
        int boundedK = this.boundedK;
        NeighborFilter neighborFilter = this.neighborFilter;
        this.partition.consume(nodeId -> {
            long[] chosen = this.sampler.sample(nodeId, neighborFilter.lowerBoundOfPotentialNeighbours(nodeId), boundedK, l -> neighborFilter.excludeNodePair(nodeId, l));
            NeighborList neighbors = new NeighborList(k);
            for (long candidate : chosen) {
                neighbors.add(candidate, computer.safeSimilarity(nodeId, candidate), rng, 0.0);
            }
            assert ((long)neighbors.size() >= Math.min(neighborFilter.lowerBoundOfPotentialNeighbours(nodeId), (long)boundedK));
            assert (neighbors.size() <= k);
            this.neighbors.set(nodeId, (Object)neighbors);
            this.neighborsFound += (long)neighbors.size();
        });
        this.progressTracker.logProgress(this.partition.nodeCount());
    }

    long neighborsFound() {
        return this.neighborsFound;
    }
}

