/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.knn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.core.StringIdentifierValidations;
import org.neo4j.gds.similarity.knn.KnnNodePropertySpec;
import org.neo4j.gds.similarity.knn.metrics.SimilarityMetric;
import org.neo4j.gds.utils.StringFormatting;

public final class KnnNodePropertySpecParser {
    private KnnNodePropertySpecParser() {
    }

    public static List<KnnNodePropertySpec> parse(@NotNull Object userInput) {
        if (userInput instanceof String) {
            return KnnNodePropertySpecParser.fromMap(Collections.singletonMap((String)userInput, null));
        }
        if (userInput instanceof Iterable) {
            HashMap<String, String> data = new HashMap<String, String>();
            for (Object item : (Iterable)userInput) {
                if (item instanceof String) {
                    data.put((String)item, null);
                    continue;
                }
                if (item instanceof Map) {
                    data.putAll(KnnNodePropertySpecParser.parseMap((Map)item));
                    continue;
                }
                throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Cannot construct KnnNodePropertySpec out of %s", (Object[])new Object[]{item.getClass().getName()}));
            }
            return KnnNodePropertySpecParser.fromMap(data);
        }
        if (userInput instanceof Map) {
            HashMap<String, String> data = KnnNodePropertySpecParser.parseMap((Map)userInput);
            return KnnNodePropertySpecParser.fromMap(data);
        }
        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Cannot parse KnnNodePropertySpecs from %s", (Object[])new Object[]{userInput.getClass().getName()}));
    }

    private static HashMap<String, String> parseMap(Map<?, ?> item) {
        HashMap<String, String> data = new HashMap<String, String>();
        for (Map.Entry<?, ?> mapItem : item.entrySet()) {
            if (mapItem.getKey() instanceof String && mapItem.getValue() instanceof String) {
                data.put((String)mapItem.getKey(), (String)mapItem.getValue());
                continue;
            }
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Cannot construct KnnNodePropertySpec out of %s and %s", (Object[])new Object[]{mapItem.getKey().getClass().getName(), mapItem.getValue().getClass().getName()}));
        }
        return data;
    }

    private static List<KnnNodePropertySpec> fromMap(Map<String, String> userInput) {
        KnnNodePropertySpecParser.validatePropertyNames(userInput.keySet());
        ArrayList<KnnNodePropertySpec> knnNodeProperties = new ArrayList<KnnNodePropertySpec>();
        for (Map.Entry<String, String> entry : userInput.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value != null) {
                try {
                    SimilarityMetric similarityMetric = SimilarityMetric.parse(value);
                    knnNodeProperties.add(new KnnNodePropertySpec(key, similarityMetric));
                    continue;
                }
                catch (IllegalArgumentException ex) {
                    throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"No valid similarity metric for user input %s", (Object[])new Object[]{value}));
                }
            }
            knnNodeProperties.add(new KnnNodePropertySpec(key));
        }
        return knnNodeProperties;
    }

    @Nullable
    static List<String> validatePropertyNames(Collection<String> input) {
        if (input.isEmpty()) {
            throw new IllegalArgumentException("The 'nodeProperties' parameter must not be empty.");
        }
        return input.stream().map(KnnNodePropertySpecParser::validatePropertyName).collect(Collectors.toList());
    }

    private static String validatePropertyName(String input) {
        return StringIdentifierValidations.validateNoWhiteCharacter((String)StringIdentifierValidations.emptyToNull((String)input), (String)"nodeProperties");
    }

    public static Map<String, String> render(List<KnnNodePropertySpec> specs) {
        return specs.stream().collect(Collectors.toMap(KnnNodePropertySpec::name, spec -> spec.metric().name()));
    }
}

